############################################
#                                          #
#           temperature.tcl                #
#     _Ofnir <ofnir@xtc.df.lth.se>         #
#                                          #
############################################

#Use "!temp help" for info on how to use this script

#---------------------------------------------------------#
#                    EDITABLE SETTINGS                    #
#---------------------------------------------------------#

#Set the flag required to use this function

set reqflag f

#-----------------------------------------------------------------------#
#               YOU DO NOT NEED TO EDIT ANYTHING BELOW                  #
#-----------------------------------------------------------------------#


bind pub - !temp pub_temp
proc pub_temp {nick uhost hand channel arg} {
global botnick reqflag

  if {[lindex $arg 0]=="help"} {
  putserv "PRIVMSG $channel :Use !temp <c/f> <number>"
  return 0
  }

  if {[matchattr $hand $reqflag] == 0} {
  putserv "PRIVMSG $channel :Sorry $nick, you do not have access use this function."
  return 0
  }

  if {[lindex $arg 0]!="c" && [lindex $arg 0]!="f"} {
  putserv "PRIVMSG $channel :Use !temp <c/f> <number>"
  return 0
  }

  if {[lindex $arg 0]=="" || ([lindex $arg 1]=="" && [lindex $arg 0]=="")} {
  putserv "PRIVMSG $channel :Use !temp <c/f> <number>"
  return 0
  }

  if {[lindex $arg 0]=="f"} {
  set arg1 [lindex "$arg" 0]
  set arg2 [lrange "$arg" 1 end]
  if {([expr $arg2] <= [expr -100000]) || ([expr $arg2] >= [expr 100000])} {
  putserv "PRIVMSG $channel :Bogus Input! :P"
  return 0
  }
  set temp $arg2
  set scale $arg1
  set first [expr $arg2 -32]
  set second [expr $first *5]
  set result [expr $second /9]
  putserv "PRIVMSG $channel :Input temp is $arg2 Fahrenheit..." 
  putserv "PRIVMSG $channel :That equals $result Centigrade"  
  return 0
  }

  if {[lindex $arg 0]=="c"} {
  set arg1 [lindex "$arg" 0]
  set arg2 [lrange "$arg" 1 end]
  if {([expr $arg2] <= [expr -100000]) || ([expr $arg2] >= [expr 100000])} {
  putserv "PRIVMSG $channel :Bogus Input! :P"
  return 0
  }
  set temp $arg2
  set scale $arg1
  set first [expr $arg2 *9]
  set second [expr $first /5]
  set result [expr $second +32]
  putserv "PRIVMSG $channel :Input temp is $arg2 Centigrade..."
  putserv "PRIVMSG $channel :That equals $result Fahrenheit"
  return 0
}
}
putlog "TemperatureCheck version 0.2 by _Ofnir loaded"

