############################################
#                                          #
#             secretvote.tcl               #
#      _Ofnir <ofnir@xtc.df.lth.se>        #
#                                          #
############################################

#Tcl for holding votes in irc channels. Start a vote with
#!secretvote start <something to decide on>
#People can then vote either yes, no, or blank.
#Read down a bit for info on features.

#Use "!secretvote help" for info on how to use this script


#---------------------------------------------------------#
#                    EDITABLE SETTINGS                    #
#---------------------------------------------------------#

#Set the channel that you are using this script in

set chn "#mychan"

#The votes are maintained by temporarily setting flags on the users.
#These are reset when a voting round is over.
#Set the flags you would like to use for maintaining the votes.
#These flags should no be used for other purposes.

set yesflag 7
set noflag 8
set blankflag 9

#Set the flag required to start/end votingsessions

set adminflag o

#Set the flag required to be able to vote

set voteflag f

#Allow the status of the voting to be displayed with !secretvote status ?
#This will display the number of votes cast on yes/no/blank, but at no
#point will votes be singled out to reveal who voted in which direction.

set statusallow 1


#-----------------------------------------------------------------------#
#               YOU DO NOT NEED TO EDIT ANYTHING BELOW                  #
#-----------------------------------------------------------------------#

#Global settings that we'll be using throughout the script.

set votingactive 0;
set item "";
set numvotes 0;
set topicbind 0;

#Resetting the userfiles in case we interrupted the last process

foreach user [userlist +$voteflag] {
    chattr $user -$yesflag
    chattr $user -$noflag
    chattr $user -$blankflag
}

#And resetting the cheat-proof whois-bind that is changed to +n later on
#while we are voting.
#This is specific for eggdrop 1.1.* and needs to be changed for 1.0*

unbind dcc n whois *dcc:whois
bind dcc o whois *dcc:whois

#The main procedure for starting and ending the votingprocesses.
#Making the bind "-" so that we give some feedback

bind pub - !secretvote pub_voting
proc pub_voting {nick uhost hand channel arg} {
global botnick votingactive chn item voteflag adminflag yesflag noflag blankflag statusallow numvotes

#First we make sure the users know what they're doing
  
  if {[lindex $arg 0]=="help"} {
  putserv "notice $nick :!secretvote start <item to vote on> - to start a voting-session"
  putserv "notice $nick :!secretvote end - to end the voting and display votes"
  putserv "notice $nick :!secretvote status - to show the current votes"
  putserv "notice $nick :/msg $botnick !vote yes/no/blank - to submit your vote"
  putserv "notice $nick :!bindtopic on/off - will determine whether to auto-reset the channel topic to the current vote-issue when someone joins."
  return 0
  }

  if {[matchattr $hand $adminflag] == 0} {
  putserv "PRIVMSG $channel :Sorry $nick, you do not have access to start or end voting-processes."
  return 0
  }

  if {[lindex $arg 0]=="status"} {
  if {$statusallow==0} {
    putserv "PRIVMSG $channel :That option has been disabled by the admin"
    return 0
    }

  if {$votingactive==0} {
    putserv "PRIVMSG $channel :No vote is in progress at this time!"
    return 0
    }

  set yesvotes 0
  set novotes 0
  set blankvotes 0

  foreach user [userlist +$voteflag] {
    if {[matchattr $user $yesflag] ==1} {
    incr yesvotes 1
    }
  }
  foreach user [userlist +$voteflag] {
    if {[matchattr $user $noflag] ==1} {
    incr novotes 1
    }
  }
  foreach user [userlist +$voteflag] {
    if {[matchattr $user $blankflag] ==1} {
    incr blankvotes 1
    }
  }

  putserv "PRIVMSG $channel :          CURRENT STATUS         "
  putserv "PRIVMSG $channel :$item"
  putserv "PRIVMSG $channel :Total number of votes so far........$numvotes"
  putserv "PRIVMSG $channel :Number of votes on -YES-......$yesvotes"
  putserv "PRIVMSG $channel :And on -NO-...................$novotes"
  putserv "PRIVMSG $channel :And the number of -BLANKS-....$blankvotes"
  return 0
  }

  if {[lindex $arg 0]!="start" && [lindex $arg 0]!="end" && [lindex $arg 0]!="status"} {
  putserv "PRIVMSG $channel :Usage ---> !secretvote start/end <What to vote on>"
  putserv "PRIVMSG $channel :Or try !secretvote help"
  return 0
  }

  if {[lindex $arg 0]=="" || ([lindex $arg 1]=="" && [lindex $arg 0]=="start")} {
  putserv "PRIVMSG $channel :Usage ---> !secretvote start/end <What to vote on>"
  return 0
  }

  if {[lindex $arg 0]=="start" && $votingactive==1} {
  putserv "PRIVMSG $channel :A vote is already in progress!"
  return 0
  }

  if {[lindex $arg 0]=="end" && $votingactive==0} {
  putserv "PRIVMSG $channel :There is no vote in progress!"
  return 0
  }

#If called for, we end the voting here
#We create 3 variables to hold the votes, go through the userlist, 
#and after registering the votes, we chattr -x,y,z to reset the flags

  if {[lindex $arg 0]=="end" && $votingactive==1} {
  putserv "PRIVMSG $channel :    Voting ended by $hand!"
  unbind dcc n whois *dcc:whois
  bind dcc o whois *dcc:whois
  set yesvotes 0
  set novotes 0
  set blankvotes 0
  set bindtopic 0

  foreach user [userlist +$voteflag] {
    if {[matchattr $user $yesflag] ==1} {
    incr yesvotes 1
    }
  }
  foreach user [userlist +$voteflag] {
    if {[matchattr $user $noflag] ==1} {
    incr novotes 1
    }
  }
  foreach user [userlist +$voteflag] {
    if {[matchattr $user $blankflag] ==1} {
    incr blankvotes 1
    }
  }

#Ready to display the results..
  putserv "PRIVMSG $channel :          FINAL RESULTS        "
  putserv "PRIVMSG $channel :$item"
  putserv "PRIVMSG $channel :Total number of votes.........$numvotes"
  putserv "PRIVMSG $channel :Number of votes on -YES-......$yesvotes"
  putserv "PRIVMSG $channel :And on -NO-...................$novotes"
  putserv "PRIVMSG $channel :Number of -BLANKS-............$blankvotes"
  set votingactive 0
  set numvotes 0
  foreach user [userlist +$voteflag] {
    chattr $user -$yesflag
    chattr $user -$noflag
    chattr $user -$blankflag
  }
  return 0
  }

#When all is checked, we start the vote here and divide the arg into
#the initial command-parameter, and "the rest" which is the text to
#be displayed as the vote.

  if {[lindex $arg 0]=="start" && $votingactive==0} {
  set votingactive 1
  putserv "PRIVMSG $channel :*** Secretvote 2.1 by _Ofnir *** "
  set numvotes 0
  foreach user [userlist +$voteflag] {
    chattr $user -$yesflag
    chattr $user -$noflag
    chattr $user -$blankflag
  }
  unbind dcc o whois *dcc:whois
  bind dcc n whois *dcc:whois
  putserv "PRIVMSG $channel :Vote started by $hand !!"
  set arg1 [lindex "$arg" 0]
  set arg2 [lrange "$arg" 1 end]
  set item $arg2
  putserv "PRIVMSG $channel :The item to vote on is..."
  putserv "PRIVMSG $channel :$arg2?" 
  putserv "PRIVMSG $channel :Use /msg $botnick !vote yes, !vote no or !vote blank"  
  return 0
  }
}


#And the message-process to keep the votes secret...

bind msg $voteflag !vote msg_vote
proc msg_vote {nick uhost hand arg} {
global botnick votingactive chn blankflag item voteflag adminflag yesflag noflag numvotes

#Making it lemawr-proof

  if {$votingactive==0} {
  putserv "notice $nick :There is no votingprocess in progress"
  return 0
  }
  
  if {([string tolower $arg] !="yes") && ([string tolower $arg] !="no") && ([string tolower $arg] !="blank")} {
  putserv "notice $nick :Use /msg $botnick !vote yes/no/blank"
  return 0
  }

  if {[matchattr $hand b] == 1} {
  putserv "notice $nick :Bots and paper hedgehogs may not take part in this vote.. :P"
  putserv "PRIVMSG $chn :Someone just tried to cheat by using the bot $hand to vote for him"
  return 0
  }

#If the user hasn't voted..

  if {([string tolower $arg] =="no") && [matchattr $hand $yesflag] == 0 && [matchattr $hand $noflag] == 0 && [matchattr $hand $blankflag] == 0} {
  chattr $hand +$noflag
  incr numvotes 1
  putserv "PRIVMSG $chn :New vote received. Number of votes so far: $numvotes"
  putserv "notice $nick :Your vote has been registered as -NO-"
  return 0
  }

  if {([string tolower $arg]=="yes") && [matchattr $hand $yesflag] == 0 && [matchattr $hand $noflag] == 0 && [matchattr $hand $blankflag] == 0} {
  chattr $hand +$yesflag
  incr numvotes 1
  putserv "PRIVMSG $chn :New vote received. Number of votes so far: $numvotes"
  putserv "notice $nick :Your vote has been registered as -YES-"
  return 0
  }

  if {([string tolower $arg]=="blank") && [matchattr $hand $yesflag] == 0 && [matchattr $hand $noflag] == 0 && [matchattr $hand $blankflag] == 0} {
  chattr $hand +$blankflag
  incr numvotes 1
  putserv "PRIVMSG $chn :New vote received. Number of votes so far: $numvotes"
  putserv "notice $nick :Your vote has been registered as -BLANK-"
  return 0
  }

#If the user votes again, differently, we change their vote

  if {[string tolower $arg] =="no"} {
     if {[matchattr $hand $yesflag] == 1} {
     chattr $hand -$yesflag+$noflag
     putserv "notice $nick :Your vote has been changed from -YES- to -NO-"
     return 0
     }
     if {[matchattr $hand $blankflag] == 1} {
     chattr $hand -$blankflag+$noflag
     putserv "notice $nick :Your vote has been changed from -BLANK- to -NO-"
     return 0
     }
  }

  if {[string tolower $arg]=="yes"} {
     if {[matchattr $hand $noflag] == 1} {
     chattr $hand +$yesflag-$noflag
     putserv "notice $nick :Your vote has been changed from -NO- to -YES-"
     return 0
     }
     if {[matchattr $hand $blankflag] == 1} {
     chattr $hand -$blankflag+$yesflag
     putserv "notice $nick :Your vote has been changed from -BLANK- to -YES-"
     return 0
     }
  }

  if {[string tolower $arg]=="blank"} {
     if {[matchattr $hand $yesflag] == 1} {
     chattr $hand -$yesflag+$blankflag
     putserv "notice $nick :Your vote has been changed from -YES- to -BLANK-"
     return 0
     }
     if {[matchattr $hand $noflag] == 1} {
     chattr $hand +$blankflag-$noflag
     putserv "notice $nick :Your vote has been changed from -NO- to -BLANK-"
     return 0
     }
  }
  

#And if they vote the same twice..

  if {[string tolower $arg] =="no" && [matchattr $hand $noflag] == 1} {
  putserv "notice $nick :Your vote has _already_ been registered as -NO-"
  putserv "PRIVMSG $chn :$hand tried to cheat by voting twice :P"
  return 0
  }

  if {[string tolower $arg] =="yes" && [matchattr $hand $yesflag] == 1} {
  putserv "notice $nick :Your vote has _already_ been registered as -YES-"
  putserv "PRIVMSG $chn :$hand tried to cheat by voting twice :P"
  return 0
  }

  if {[string tolower $arg] =="blank" && [matchattr $hand $blankflag] == 1} {
  putserv "notice $nick :Your vote has _already_ been registered as -BLANK-"
  putserv "PRIVMSG $chn :$hand tried to cheat by voting twice :P"
  return 0
  }
}

#Now we add the on-join stuff
#If valid users enter the channel, they'll want to know about the vote

bind join $voteflag * onjoin_info
  proc onjoin_info {nick uhost hand chan} {
  global botnick topicbind votingactive item voteflag adminflag yesflag noflag blankflag
  if {$votingactive == 0} {
  return 0
  }
  if {$topicbind == 1} {
  putserv "TOPIC $chan :$item"
  }
  if {[matchattr $hand $voteflag]} {
  putserv "notice $nick :Hey $nick! There is a vote going on right now in $chan"
  putserv "notice $nick :The question is - $item"
  putserv "notice $nick :Use /msg $botnick !vote yes/no/blank, to vote"
  return 0
  }
}

bind pub - !bindtopic bind_da_topic
  
proc bind_da_topic {nick uhost hand chan topicargs} {
  global botnick votingactive item voteflag adminflag topicbind
  if {$votingactive == 0 } {
     putserv "PRIVMSG $chan :No vote in progress..."
     return 0
     }
  if {[matchattr $hand $adminflag] == 0} {
     putserv "PRIVMSG $chan :You don't have access to do that, $han"
     return 0
     }
  if {$topicargs=="on"} {  
     set topicbind 1
     unbind join - * do_topic
     putserv "TOPIC $chan :$item"
     putserv "PRIVMSG $chan :Channel topic will now be re-set on joins.."
     }
  if {$topicargs=="off"} {
     set topicbind 0
     bind join - * do_topic
     putserv "PRIVMSG $chan :Topic-bind removed.."
     }
}

putlog "SecretVote version 2.1b by _Ofnir loaded"

