################################################
##############################################
####
####        Message board v0.95
####      (for 1.1 eggdrop bots)
####      [0.95 is a public beta]
####
##############################################
################################################
##############################################
####
#### Created by spice (spice@deathsdoor.com)
#### spice or _spice_ on efnet
#### please email bug reports and suggestions to me
#### the amount of email/interest will determine if this 
#### script's development will be continued.
#### I have several good ideas for the next version (not 1.0 but 1.1)
#### but i want to hear yours!!
#### special thanks to: TymezUp, sly, and my home channel for thier patience
#### July 27th 1997
####
##############################################
################################################
##############################################
#### What you need to do:
####    a. edit this file's configuration section
####    b. use .+board in a dcc chat, then follow it's instructions
####    c. use the command .msgb in a dcc chat, or !msgb in a channel to 
####       enter the message board.
####    c. email me your complaints, bugs, and suggestions!
###############################################
#################################################
###############################################
#### About this version:
####    this is not a finished version, if you don't like it
####    remove it and wait for version 1.0 I promise that
####    it will be much more user friendly, have all it's code,
####    and have some cool new options (ie multi-bot boardsharing)
###############################################
#################################################

# Please keep the following line in the file. 
# Based on Message board v0.95 by spice (spice@deathsdoor.com)

 
## Configuration

set msgb_version "v0.95"
set msgb_maxconnections 99;    # however many connectoins you want to allow at once
set msgb_maxpostsperhour 20;   # however many posts someone can make in 
                               # one hour (to prevent flooding)
set msgb_directory "scripts/msgb/"
set msgb_motd "$msgb_directory/motd"
set msgb_port 5014
set msgb_adminflag "9"
set msgb_allowanon 1;         # 1 to allow anonomous connections, 0 to reject
set msgb_seperator "\236";    # should be a character that will never be used 
                              # in a normal message
set msgb_boardfile "$msgb_directory/msgb.boards"
set msgb_postnumberfile "$msgb_directory/msgb.postnumberfile"
set msgb_readindexdir "$msgb_directory/read/"
set bold ""
set underline ""
set reverse ""
set color ""

## variable init
set msgbclicks [clock clicks]
array set msgb_state ""
array set msgb_login ""
array set msgb_boardnum ""
array set msgb_message ""
array set msgb_subject ""
array set msgb_readingmessage ""
array set msgboptions_state ""
array set msgb_listnum ""
array set msgb_replymessage ""
array set msgb_admin ""
array set msgb_readmessages ""
set msgb_boards ""
set msgb_connections 0

## Constants
set MSGBSTATE_LOGIN 0
set MSGBSTATE_PASSWORD 1
set MSGBSTATE_MAINMENU 2
set MSGBSTATE_WRITING_SUBJECT 3
set MSGBSTATE_WRITING_MESSAGE 4
set MSGBSTATE_READING   5
set MSGBSTATE_LIST  6
set MSGBSTATE_OPTIONS   7
set MSGBSTATE_SCROLL    8

set MSGBOPTIONS_NUMSCROLL 0


## Code

bind dcc - msgb msgb_dcc;	#invokes the messageboard in a dcc
bind msg - msgb msgb_msg;	#invokes the messageboard from a msg
bind pub - !msgb msgb_pub;	#invokes the messageboard from a channel
bind dcc N msgbsend msgb_dccsend;	#sends someone the messageboard dcc chat
bind dcc n +board msgb_dccplusboard;	#adds a board
bind dcc n msgb_reset msgb_dccreset;	#resets everyone's read files

proc msgb_dccreset {hand idx arg} {
  putlog "Resetting all messageboard readfiles.  (can be CPU intensive)"
  set resetclicks [clock clicks]
  foreach person [userlist] {
    user-set $person "readfile" ""
  }
  putlog "Messageboard reset done.  Took [expr [clock clicks] - $resetclicks] clicks."
  return 1
}

proc msgb_dccplusboard {hand idx arg} {
  global msgb_boardfile msgb_boards msgb_seperator msgb_directory bold underline
  if {[llength $arg] < 2} {putdcc $idx "Usage: .+board (one word name) (unlim word description)";return 0}
  set fd [open "$msgb_boardfile" "a"]
    puts $fd "@[lindex $arg 0]$msgb_seperator$msgb_directory/boards/[lindex $arg 0]$msgb_seperator[lrange $arg 1 [llength $arg]]"
  close $fd
  putdcc $idx "Board '[lindex $arg 0]: [lrange $arg 1 [llength $arg]]' added to boardconfig file..."
  exec mkdir $msgb_directory/boards/[lindex $arg 0]
  msgb_createfile "$msgb_directory/boards/[lindex $arg 0]/0000000"
  msgb_createfile "$msgb_directory/boards/[lindex $arg 0]/index"
  putdcc $idx "Needed files created..."
  msgb_loadboardfile
  putdcc $idx "Board created."
  return 1
}

proc msgb_loadboardfile {} {
  global msgb_boardfile msgb_boards msgb_seperator
  set fd [open "$msgb_boardfile" "r"]
  while {![eof $fd]} {
    set temp "[gets $fd]"
    if {[string range $temp 0 0] == "@"} {
      set msgboard ""
      #parse parse parse
      set boardname "[string range $temp 1 [expr [string first $msgb_seperator $temp] - 1]]"
      set temp "[string range $temp [expr [string first $msgb_seperator $temp] + 1] [string length $temp]]"
      set q [string first $msgb_seperator $temp]
      set boarddir "[string range $temp 0 [expr $q - 1]]"
      set boarddesc "[string range $temp [expr $q + 1] [string length $temp]]"
      lappend msgboard "$boarddesc"
      lappend msgboard "$boarddir"
      lappend msgboard "$boardname"
      lappend msgb_boards $msgboard
      if {[file exists "$boarddir/0000000"] == 0} {msgb_createfile "$boarddir/0000000"}
      if {[file exists "$boarddir/index"] == 0} {msgb_createfile "$boarddir/index"}
    } else {
      catch {eval "$temp"} boooh
    }
  }
  close $fd

}

proc msgb_dccsend {handle idx arg} {
  global msgb_port
  putserv "PRIVMSG [lindex $arg 0] :\001DCC CHAT chat [myip] $msgb_port\001"
  return 1
}

proc msgb_dcc {handle idx arg} {
  msgb_onconnect $idx
  return 1
}

proc msgb_msg {nick uhost handle arg} {
  global msgb_port
  putserv "PRIVMSG $nick :\001DCC CHAT chat [myip] $msgb_port\001"
  return 1
}

proc msgb_pub {nick uhost handle channel arg} {
  global msgb_port
  putserv "PRIVMSG $nick :\001DCC CHAT chat [myip] $msgb_port\001"
  return 1
}

proc msgb_onconnect {idx} {
  global msgb_version msgb_port msgb_state msgb_login msgb_motd MSGBSTATE_LOGIN msgb_maxconnections msgb_connections
  putlog "Connection to the message board on port $msgb_port"
  if {$msgb_connections >= $msgb_maxconnections} {putdcc $idx "Too many connections now, ($msgb_maxconnections)  Try again later."; return 0}
  incr msgb_connections
  putdcc $idx "\n  Message Board $msgb_version by Spice"
  putdcc $idx "\n"
  set fd [open "$msgb_motd" "r"]
  while {![eof $fd]} {putdcc $idx "[gets $fd]"}
  close $fd
  putdcc $idx "Enter your nickname: "
  set msgb_login($idx) "NotLoggedIn"  
  set msgb_state($idx) $MSGBSTATE_LOGIN
  control $idx msgb_control
}

proc msgb_control {idx arg} {
  global msgb_port msgb_version msgb_state msgb_login botnick msgb_boards msgb_boardnum msgb_subject msgb_message msgb_admin
  global msgb_readingmessage msgb_backupstate msgboptions_state msgb_listnum msgb_allowanon msgb_seperator msgb_adminflag
  global msgb_maxpostsperhour msgb_readmessages msgb_readindexdir msgb_maxconnections
  global MSGBSTATE_PASSWORD MSGBSTATE_MAINMENU MSGBSTATE_WRITING_SUBJECT MSGBSTATE_WRITING_MESSAGE MSGBSTATE_READING MSGBSTATE_LIST MSGBSTATE_OPTIONS MSGBSTATE_MESSAGEBOARD_LIST
  global MSGBSTATE_LOGIN MSGBOPTIONS_NUMSCROLL MSGBSTATE_SCROLL
  global color bold reverse underline

  if {$arg == "QUITZZZ"} {msgb_close $idx; return 1;};   # Mainly for debugging purposes
  if {$arg == ""} {msgb_close $idx; return 1;};          # user closed connection

  switch "$msgb_state($idx)" {
    "0" { #MSGBSTATE_LOGIN
       set msgb_login($idx) [string trim $arg]
       if {[string tolower [string trim $arg]] == "anonymous" && $msgb_allowanon == 1} {
         putlog "Anonymous user logged into the message board."
         set msgb_state($idx) $MSGBSTATE_MAINMENU
         msgb_displaymainmenu $idx
         return 0
       }
       if {[validuser $msgb_login($idx)] == 0} {putdcc $idx "No such user!\n\nEnter your nickname:  ";return 0;}
       if {[passwdok $msgb_login($idx) ""] == 1} {putdcc $idx "User has no password set!  /msg $botnick pass yourpassword\n\nEnter your nickname:  ";return 0;}
       foreach person [userlist] { #apply proper capitalisation to handle
         if {[string tolower $msgb_login($idx)] == [string tolower $person]} {set msgb_login($idx) $person;}
       }
       if {([matchattr $msgb_login($idx) "$msgb_adminflag"] == 1) || ([matchattr $msgb_login($idx) "m"] == 1) || ([matchattr $msgb_login($idx) "n"] == 1)} {
         set msgb_admin($idx) 1
       } else {
         set msgb_admin($idx) 0
       }
       if {[user-get $msgb_login($idx) "readfile"] == ""} {
         # User doesn't have a readindex yet... better create it
         # It's done this way so that if a person's nick changes, they won't lose their readindex
         if {[file exists "$msgb_readindexdir/0000000"] == 0} {msgb_createfile "$msgb_readindexdir/0000000"}
         set globber [glob "$msgb_readindexdir/???????"]
         user-set $msgb_login($idx) "readfile" "[msgb_expanddigits [llength $globber] 7]"
         set fd [open "$msgb_readindexdir/[msgb_expanddigits [llength $globber] 7]" "w"]
         puts $fd "$msgb_login($idx)"
         close $fd
         msgb_loadreadmessages $idx
       } else {
         msgb_loadreadmessages $idx
       }
       putdcc $idx "Enter your password: "
       set msgb_state($idx) $MSGBSTATE_PASSWORD
       return 0
    }

    "1" { #MSGBSTATE_PASSWORD
       if {[passwdok $msgb_login($idx) $arg] == 1} {
         if {$msgb_admin($idx) == 1} {
           putdcc $idx "Welcome boardmaster, $msgb_login($idx)!"
           set bm " (boardmaster)"
         } else {
           putdcc $idx "Welcome, $msgb_login($idx), to the message board!"
           set bm ""
         }
         putlog "User $msgb_login($idx)$bm logged in to the message board."
         msgb_displaymainmenu $idx
         set msgb_state($idx) $MSGBSTATE_MAINMENU
         return 0
       } else {
         putdcc $idx "Invalid password.\n\nEnter your nickname:  "
         set msgb_state($idx) $MSGBSTATE_LOGIN
         return 0
       }
    }

    "2" { #MSGBSTATE_MAINMENU
       set arg [string trim $arg]
       if {[string toupper $arg] == "Q"} {msgb_close $idx; return 1;}
       if {[string toupper $arg] == "O"} {
         if {[string tolower [string trim $msgb_login($idx)]] == "anonymous"} {putdcc $idx "You cannot change your options when logged in as anonymous."; return 0}
         set msgb_state($idx) $MSGBSTATE_OPTIONS
         set msgboptions_state($idx) $MSGBOPTIONS_NUMSCROLL
         putdcc $idx "This will set your options.  Answer all questions, or put 'c' on a line by itself to cancel."
         putdcc $idx "\nHow many lines would you like to scroll at once?  "
       } else {
        set z 0
        set msgb_boardnum($idx) 0
        for {set i 0} {$i <= [llength $msgb_boards]} {incr i} {
          if {$arg == "$i" && $arg >= "1"} {
            # the next line is because if someone put "1." etc.. in, an error would raise.
            if {[msgb_checkint $arg] != 0} {putdcc $idx "Try removing the period"; return 0}
            set z 1
            set msgb_listnum($idx) 0
            set msgb_boardnum($idx) [expr $arg - 1]
            set msgb_state($idx) $MSGBSTATE_LIST
            msgb_displaylist $idx ""
            return 0
          }
        }
        # not a board!  must be invalid
        set tempcolor "4"
        putdcc $idx "$color$tempcolor Invalid option"
        return 0
       }
    }

    "3" { #MSGBSTATE_WRITING_SUBJECT
       if {[string toupper $arg] == "CANCEL"} {
         putdcc $idx "Message canceled..."
         set msgb_subject($idx) ""
         set msgb_message($idx) ""
         set msgb_state($idx) $MSGBSTATE_LIST
         msgb_displaylist $idx ""
         return 0
       }
       set msgb_subject($idx) $arg
       set msgb_state($idx) $MSGBSTATE_WRITING_MESSAGE
       putdcc $idx "Writing body of message.  Type 'DONE' on a line by itself when you are finished, or 'HELP' for a list of helpful commands.\n"
       set msgb_message($idx) ""
       return 0
    }

    "4" { #MSGBSTATE_WRITING_MESSAGE
       if {[string toupper $arg] == "CANCEL"} {
         putdcc $idx "Message canceled..."
         set msgb_subject($idx) ""
         set msgb_message($idx) ""
         set msgb_state($idx) $MSGBSTATE_LIST
         msgb_displaylist $idx ""
         return 0
       }
       if {[string toupper $arg] == "DONE"} {
         putdcc $idx "Saving and sending message..."
         set globber [glob "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/???????"]]
         
         set fd [open "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/index" "a"]
         puts $fd "o$msgb_seperator[llength $globber]$msgb_seperator$msgb_login($idx)$msgb_seperator[unixtime]$msgb_seperator$msgb_subject($idx)"
         close $fd
         set fd [open "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/[msgb_expanddigits [llength $globber] 7]" "w"]
         puts $fd "~$msgb_login($idx)";   # Who sent message
         puts $fd "@[unixtime]";          # Time sent
         puts $fd "#$msgb_version";       # Version sent with
         puts $fd "%$msgb_subject($idx)"; # Subject
         puts $fd "$msgb_message($idx)";  # The message
         close $fd
         set msgb_state($idx) $MSGBSTATE_LIST
         msgb_displaylist $idx ""
         return 0
       }
       if {[string toupper $arg] == "HELP"} {
         putdcc $idx "--------\nCancel - cancels current message\nDone - Saves message\n--------"
         return 0
       }
       catch {if {$msgb_message($idx) == ""} {}} errored
       if {$errored != 0} {set $msgb_message($idx) ""}
       if {$msgb_message($idx) == ""} {
         set msgb_message($idx) "&$arg"
       } else {
         set msgb_message($idx) "$msgb_message($idx)\n&$arg"
       }
       return 0
    }
    "5" { #MSGBSTATE_READING
       set arg [string trim [string tolower $arg]]
       if {[string toupper $arg] == "Q"} {putlog "$msgb_login($idx) quit the message board."; return 1;}
       switch -exact $arg {
         "b" {
            set msgb_state($idx) $MSGBSTATE_LIST
            msgb_displaylist $idx ""
            return 0
         }         
         "n" {
           set globber [glob "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/???????"]]
           if {$msgb_readingmessage($idx) >= [expr [llength $globber] -1]} {putdcc $idx "Already at the last message";return 0}
           set msgb_readingmessage($idx) [expr $msgb_readingmessage($idx) +1]
           msgb_displaymessage $idx $msgb_readingmessage($idx)
           return 0
         }
         "p" { 
           if {$msgb_readingmessage($idx) <= 1} {putdcc $idx "Already at the first message"; return 0}
           set msgb_readingmessage($idx) [expr $msgb_readingmessage($idx) -1]
           msgb_displaymessage $idx $msgb_readingmessage($idx)
           return 0
         }
         "c" {
           if {[string tolower [string trim $msgb_login($idx)]] == "anonymous"} {putdcc $idx "You can't compose messages while logged in as 'anonymous'.";return 0}
           if {([msgb_getpostnum $msgb_login($idx)] >= $msgb_maxpostsperhour) && ($msgb_admin($idx) != 1)} {putdcc $idx "You've posted too many messages, try again in another hour.";return 0}
           msgb_incrpostnum $msgb_login($idx)
           set msgb_state($idx) $MSGBSTATE_WRITING_SUBJECT
           putdcc $idx "Composing message for board [lindex [lindex $msgb_boards $msgb_boardnum($idx)] 0].\nEnter the subject:"
           return 0
         }
         "d" {
           if {$msgb_admin($idx) == 1} {
             msgb_deletemessage $msgb_readingmessage($idx)
             putdcc $idx "Deleting message."
           } else {
             putdcc $idx "You do not have permission to delete."
           }
         }
         "m" {
           set msgb_state($idx) $MSGBSTATE_MAINMENU
           msgb_displaymainmenu $idx
           return 0
         }
         "r" {
           if {[string tolower [string trim $msgb_login($idx)]] == "anonymous"} {putdcc $idx "You can't compose messages while logged in as 'anonymous'.";return 0}
           if {([msgb_getpostnum $msgb_login($idx)] >= $msgb_maxpostsperhour) && ($msgb_admin($idx) != 1)} {putdcc $idx "You've posted too many messages, try again in another hour.";return 0}
           msgb_incrpostnum $msgb_login($idx)
           set msgb_message($idx) "&In response to message $msgb_readingmessage($idx) which reads as follows:"
           set blah "In response to message $msgb_readingmessage($idx) which reads as follows:"
           set fd [open "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/[msgb_expanddigits "$msgb_readingmessage($idx)"  7]" "r"]
           while {![eof $fd]} {
             set temp [gets $fd]
             if {[string range "$temp" 0 0] == "~"} { #person line
               set person "[string range "$temp" 1 [string length $temp]]"
             }
             if {[string range "$temp" 0 0] == "~"} { #person line
               set person "[string range "$temp" 1 [string length $temp]]"
             }
             if {[string range "$temp" 0 0] == "%"} { #subject line
               set msgb_subject($idx) "Re: [string range "$temp" 1 [string length $temp]]"
             }
             if {[string range "$temp" 0 0] == "&"} { #message line
               if {$msgb_message($idx) == ""} {
                 set msgb_message($idx) "&>[string range "$temp" 1 [string length $temp]]"
                 set blah ">[string range $temp 1 [string length $temp]]"
               } else {
                 set msgb_message($idx) "$msgb_message($idx)\n&>[string range "$temp" 1 [string length $temp]]"
                 set blah "$blah\n>[string range $temp 1 [string length $temp]]"
               }
             }
           }
           set blah "$blah\n"
           close $fd
           putdcc $idx "Replying to message for board [lindex [lindex $msgb_boards $msgb_boardnum($idx)] 0].\nSubject: $msgb_subject($idx)\nCurrent message: \n$blah\nFinish the message and type 'done' on a line by itself to finish, or 'help' for help on some editing commands:"
           set msgb_state($idx) $MSGBSTATE_WRITING_MESSAGE
           return 0
         } 
         default {
           set tempcolor "4"
           putdcc $idx "$color$tempcolor Invalid command."
           return 0
         }
       }
    }
    "6" { #MSGBSTATE_LIST
       set arg [string trim $arg]
       catch {set globber [glob "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/???????"]]} errored
       set globber [glob "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/???????"]]
       if {[string toupper $arg] == "Q"} {putlog "$msgb_login($idx) quit the message board."; return 1;}
       if {[string tolower $arg] == "b"} {
         msgb_displaymainmenu $idx
         set msgb_state($idx) $MSGBSTATE_MAINMENU
         return 0
       }
       if {[string tolower $arg] == "m"} {
         set msgb_state($idx) $MSGBSTATE_MAINMENU
         msgb_displaymainmenu $idx
         return 0
       }
       if {[string tolower $arg] == "a"} {
         msgb_displaylist $idx "all"
         return 0
       }
       if {[string tolower $arg] == "c"} {
         if {[string tolower [string trim $msgb_login($idx)]] == "anonymous"} {putdcc $idx "You can't compose messages while logged in as 'anonymous'.";return 0}
         if {([msgb_getpostnum $msgb_login($idx)] >= $msgb_maxpostsperhour) && ($msgb_admin($idx) != 1)} {putdcc $idx "You've posted too many messages, try again in another hour.";return 0}
         msgb_incrpostnum $msgb_login($idx)
         set msgb_state($idx) $MSGBSTATE_WRITING_SUBJECT
         putdcc $idx "Composing message for board [lindex [lindex $msgb_boards $msgb_boardnum($idx)] 0].\nEnter the subject:"
         return 0
       }
       for {set i 1} {$i < [llength $globber]} {incr i} {
         if {$arg == "$i"} {
           msgb_displaymessage $idx $i
           set msgb_state($idx) $MSGBSTATE_READING
           set msgb_readingmessage($idx) $i
           return 0
         }
       }
       set tempcolor "4"
       putdcc $idx "$color$tempcolor Invalid command"
       return 0
    }
    "7" { #MSGBSTATE_OPTIONS
       return [msgb_options $idx $arg]
    }
    "8" { #MSGBSTATE_SCROLL
       if {[string trim [string tolower $arg]] == "c"} {
         msgb_displaylist $idx ""
         return 0
       } elseif {[string trim [string tolower $arg]] == "q"} {
         set msgb_state($idx) $msgb_backupstate($idx)
         putdcc $idx "$boldC$bold - compose message.  Enter the number of the message to read."
         putdcc $idx "$boldB$bold - back              $boldQ$bold - quit"
         return 0
       } else { 
         set tempcolor "4"
         putdcc $idx "$color$tempcolor Invalid option"
         return 0
       }
    }
  }
}
   
proc msgb_options {idx arg} {  
  ## this procedure is intended to be called when people are in the options state

  # declares
  global msgb_state msgboptions_state msgb_login
  global MSGBOPTIONS_NUMSCROLL MSGBSTATE_MAINMENU

  # code
  if {[string tolower $arg] == "c"} {       #Did they cancel?
    set msgb_state($idx) $MSGBSTATE_MAINMENU;   #return to main menu
    msgb_displaymainmenu $idx;              #display the main menu
  }
  
   #switch "$msgboptions_state($idx)" { #See which part of the options they are in and respond
        if {$msgboptions_state($idx) == 0} { #MSGBOPTIONS_NUMSCROLL
          if {[msgb_checkint [string trim $arg]] != 0} {    #Make sure that the number is an integer.   
            putdcc $idx "Number must be an integer"
            return 0
          }
          user-set $msgb_login($idx) "numscroll" "[string trim $arg]"
#          putdcc $idx "Would you like to see only unread messages? (y/n)"
          set msgb_state($idx) $MSGBSTATE_MAINMENU
          msgb_displaymainmenu $idx
        }
  #}
}

proc msgb_checkint {arg} { #Make sure that the number is an integer.
  for {set i 0} {$i < [string length $arg]} {incr i} {  
    set checker 0
    if {[string range $arg $i $i] == "0"} {set checker 1}
    if {[string range $arg $i $i] == "1"} {set checker 1}
    if {[string range $arg $i $i] == "2"} {set checker 1}
    if {[string range $arg $i $i] == "3"} {set checker 1}
    if {[string range $arg $i $i] == "4"} {set checker 1}
    if {[string range $arg $i $i] == "5"} {set checker 1}
    if {[string range $arg $i $i] == "6"} {set checker 1}
    if {[string range $arg $i $i] == "7"} {set checker 1}
    if {[string range $arg $i $i] == "8"} {set checker 1}
    if {[string range $arg $i $i] == "9"} {set checker 1}
    if {$checker != 1} {return [string length $arg]};       #if there is a character that isn't a number return
  }
  return 0
}
	

proc msgb_displaymessage {idx messagenum} {
  global msgb_boards msgb_boardnum timezone
  global bold underline color reverse
  set fd [open "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/[msgb_expanddigits $messagenum 7]" "r"]
  while {![eof $fd]} {
    set temp "[gets $fd]"
    if {[string range $temp 0 0] == "~"} {putdcc $idx "Message $messagenum from [string range $temp 1 [string length $temp]]"}
    if {[string range $temp 0 0] == "@"} {putdcc $idx "Sent: [msgb_ftime [string range $temp 1 [string length $temp]]] $timezone"}
    if {[string range $temp 0 0] == "%"} {putdcc $idx "Subject: [string range $temp 1 [string length $temp]]\n--------------------------------------------------------------"}
    if {[string range $temp 0 0] == "&"} {putdcc $idx "[string range $temp 1 [string length $temp]]"}
  }
  close $fd
  putdcc $idx "----------------------------------------------------------"
  putdcc $idx " $bold C$bold - compose $bold N$bold - next $bold P$bold - previous  $bold R$bold - Reply"
  putdcc $idx " $bold B$bold - back    $bold Q$bold - quit $bold M$bold - return to main menu"
  putdcc $idx ""
  msgb_markread $idx $messagenum
}

proc msgb_displaylist {idx ops} {
  global msgb_boards msgb_boardnum msgb_login msgb_listnum msgb_backupstate msgb_state
  global msgb_seperator timezone msgb_readmessages
  global bold reverse underline color
  global MSGBSTATE_LIST MSGBSTATE_SCROLL
  if {$msgb_listnum($idx) == 0} {
    putdcc $idx "Messages in board: [lindex [lindex $msgb_boards $msgb_boardnum($idx)] 0]"
    putdcc $idx "----------------------------------------------"
  }
  set fd [open "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 1]/index" "r"]
  set i 0
  set z 0
  set stopat [user-get $msgb_login($idx) "numscroll"]
  if {$stopat == "0"} {set stopat 10000000}
  while {![eof $fd]} {
    incr i
    set temp "[gets $fd]"
    if {[string range $temp 0 0] == "d" || [expr $msgb_state($idx) == $MSGBSTATE_SCROLL && $i <= $msgb_listnum($idx)]} {
      # do nothing
    } else {
      if {$temp == ""} {break;}
      if {[expr [string first "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 2][msgb_expanddigits $i 7]" "[join $msgb_readmessages($idx)]"] != -1] && $ops != "all"} {continue;}
      incr z      
      #parse parse parse
      set temp "[string range $temp 2 [string length $temp]]"
      set q [string first $msgb_seperator $temp]
      set temp "[string range $temp [expr $q + 1] [string length $temp]]"
      set q [string first $msgb_seperator $temp]
      set newfrom "[string range $temp 0 [expr $q - 1]]"
      set temp "[string range $temp [expr $q + 1] [string length $temp]]"
      set q [string first $msgb_seperator $temp]
      set newtime "[msgb_ftime [string range $temp 0 [expr $q - 1]]]"
      set temp "[string range $temp [expr $q + 1] [string length $temp]]"
      set q [string first $msgb_seperator $temp]
      putdcc $idx " $i. $newtime $timezone$bold$newfrom:$bold $temp"
      
      if {$z == $stopat} {
        putdcc $idx "\[Type C to continue listing or Q to quit\]"
        set msgb_listnum($idx) $i
        set msgb_backupstate($idx) $MSGBSTATE_LIST
        set msgb_state($idx) $MSGBSTATE_SCROLL
        close $fd
        return 0
      }
    }
  }
  close $fd
  putdcc $idx "-----------------------------------------------------------------"
  putdcc $idx "$bold C$bold - compose message.  Enter the number of the message to read."
  putdcc $idx "$bold B$bold - back             $bold Q$bold - quit             $bold A$bold - List all messages"
  set msgb_state($idx) $MSGBSTATE_LIST
}

proc msgb_displaymainmenu {idx} {
  global msgb_boards
  global bold underline color reverse
  putdcc $idx "\n"
  set i 1
  foreach msgboard $msgb_boards {
    putdcc $idx "     $bold$i$bold.  Read board [lindex $msgboard 0]"
    incr i
  }
  putdcc $idx "    $bold O$bold.  Options"
  putdcc $idx "    $bold Q$bold.  Quit\n"
}

proc msgb_expanddigits {number num_digits} {
  while {[string length $number] < $num_digits} {
    set number "0$number"
  }
  return $number
}

#####

# the following procedure is an edited version of TymezUp's stime.tcl
# used with permission

## This script is a command called stime.  It is the equivalant of the tcl command ctime.
## It was written because I can not stand the output of ctime.
## If you code a tcl using stime, you will want to put in a trap to check to see if it is
## loaded.  I recommend this way:
##
##    if {([info procs stime]) == "stime"} {
##    putlog stime [unixtime]   
##    } else {
##    putlog ctime [unixtime]
##     }
##
## TymezUp 

proc msgb_ftime {unix_time} {
  set day "[lindex [ctime $unix_time] 0]"
  set month [lindex [ctime $unix_time] 1]
  set date [lindex [ctime $unix_time] 2]
  set time [string range [lindex [ctime $unix_time] 3] 0 4]
  set year [lindex [ctime $unix_time] 4]

  if {([string range $time 0 1]) == 00} {
	set blah [string range $time 2 4]  	
	return "$day - $month $date 12$blah am"
	} 

  if {([string range $time 0 1]) == 10 || ([string range $time 0 1]) == 11 } {	
	return "$day - $month $date $time am"	
	}

  if {([string range $time 0 1]) == 12} {	
	return "$day - $month $date $time pm"
	}

  if {([string range $time 0 1]) < 10} {	
	set time2 [string range $time 1 4]
	return "$day - $month $date $time2 am"
	}

  if {([string range $time 0 1]) > 12} {
	set blah [expr [string range $time 0 1] - 12]
	set blah2 [string range $time 2 4]  
	return "$day - $month $date $blah$blah2 pm"
	}

return "ERROR in msgb_ftime"
putlog "ERROR in msgb_ftime"
}

# end of stime hack.  Thank you TymezUp!!
#####

proc msgb_resetpostnumbers {} {
  global msgb_postnumberfile
  set fd [open "$msgb_postnumberfile" "w"]
  close $fd
}

proc msgb_getpostnum {nick} {
  global msgb_postnumberfile
  set num 0
  set fd [open "$msgb_postnumberfile" "r"]
  while {![eof $fd]} {
    set temp [gets $fd]
    set person [string range $temp 0 [expr [string first " " $temp] - 1]]
    if {[string tolower $person] == [string tolower $nick]} {
      set num [string range $temp [expr [string first " " $temp] + 1] [string length $temp]]
    }
  }
  close $fd
  return $num
}

proc msgb_incrpostnum {nick} {
  global msgb_postnumberfile
  set num 0
  set fd [open "$msgb_postnumberfile" "r"]
  while {![eof $fd]} {
    set temp [gets $fd]
    set person [string range "$temp" 0 [expr [string first " " $temp] - 1]]
    if {[string tolower $person] == [string tolower $nick]} {
      set num [string range "$temp" [expr [string first " " $temp] + 1] [string length $temp]]
    }
  }
  close $fd
  set fd [open "$msgb_postnumberfile" "a"]
  puts $fd "$nick [expr $num + 1]"
  close $fd
  return $num
}

proc msgb_loadreadmessages {idx} {
  global msgb_readindexdir msgb_login msgb_readmessages msgb_seperator
  set readmessages ""
  set fd [open "$msgb_readindexdir/[user-get $msgb_login($idx) "readfile"]" "r"]
  while {![eof $fd]} {
    lappend readmessages "[gets $fd]"
  }
  close $fd
  set msgb_readmessages($idx) $readmessages
}
    
proc msgb_markread {idx num} {
  global msgb_readindexdir msgb_login msgb_readmessages msgb_seperator msgb_boards msgb_boardnum
  set fd [open "$msgb_readindexdir/[user-get $msgb_login($idx) "readfile"]" "a"]
  puts $fd "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 2][msgb_expanddigits $num 7]"
  close $fd
  lappend msgb_readmessages($idx) "[lindex [lindex $msgb_boards $msgb_boardnum($idx)] 2][msgb_expanddigits $num 7]"
}

proc msgb_createfile {zfilename} {
  set fd [open "$zfilename" "w"]
  close $fd
}

proc msgb_close {idx} {
  global msgb_port msgb_version msgb_state msgb_login botnick msgb_boards msgb_boardnum msgb_subject msgb_message msgb_admin
  global msgb_readingmessage msgb_backupstate msgboptions_state msgb_listnum msgb_allowanon msgb_seperator msgb_adminflag
  global msgb_maxpostsperhour msgb_readmessages msgb_readindexdir msgb_maxconnections

  putlog "$msgb_login($idx) quit the message board."

  # Free up memory
  catch {unset msgb_login($idx)}
  catch {unset msgb_state($idx) }
  catch {unset msgb_subject($idx) }
  catch {unset msgb_message($idx)}
  catch {unset msgb_readingmessage($idx)}
  catch {unset msgb_backupstate($idx)}
  catch {unset msgboptions_state($idx)}
  catch {unset msgb_listnum($idx)}
  catch {unset msgb_readmessage($idx)}
  catch {unset msgb_admin($idx) }
  return 0
}

proc msgb_deletemessage {num} {
#not coded just yet
}

  
msgb_loadboardfile
listen $msgb_port script msgb_onconnect
timer 60 {msgb_resetpostnumbers}

putlog "Message Board $msgb_version by Spice (spice@deathsdoor.com).  Loaded in [expr [clock clicks] - $msgbclicks] clicks."

