# motd.tcl - Motd 1.0.4 IRC Channel Message of The Day
# Copyright (C) 1997, 1998  Daniel Corbe
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA


# Motd 1.0.4 by Daniel Corbe (Byrd) 
# BotName: Byrd@TestBot
#   Email: corbe@corbe.net

# ChangeLog:
#   1.0.1: Fixed some spelling mistakes
#   1.0.1: Fixed the !nogreet !yesgreet message. Works now.
#   1.0.1: Fixed some sloppy code
#   1.0.1: Fixed the problem with the bot showing itself the motd *grin*

#   1.0.2: Ported for Eggdrop 1.1(.5). I think 1.2.0 sucks so there will be
#          no support for that release.
#   1.0.2: Added CTCP VERSION support because this is the only script that
#          I have made that does not support a ctcp version reply.
#   1.0.3: Fixed the problem with the hello binding -- OOPS =)

#   1.0.4: Now distributed under GPL. (See LICENSE for information)
#   1.0.4: Fixed spelling mistakes in README. Deep 6'd READTHIS.NOW
#   1.0.4: No longer depends on other scripts to function.
#   1.0.4: Added CTCP-Cloaking to hide bots. (Due to popular demand I 
#          added this. I personally think its ludocrise to try and hide a
#          bot if it's going to dump large chunks of text to people.)
#   1.0.4: Added setting to define what MYWORD is for configuration
#          compatibility reasons.
#   1.0.4: Finally tracked down that missing close brace in do_show_motd()  
#          !@$#&

source scripts/motd/settings.tcl
source scripts/motd/bindings.tcl
source scripts/motd/config.tcl


proc do_show_motd {nick uhost hand channel} {
  global motdpath wantgflag botnick myword
  if {$nick == $botnick} {
    # do nothing... Back Out Quietly..
  } else {
    set fd [open $motdpath r]
    if {[validuser $hand] == "1"} {
      if {[matchattr $hand g] == 0} {
        if {$wantgflag == "1"} {
          while {![eof $fd]} {
            set motdinfo [gets $fd]
            putserv "PRIVMSG $nick :-=- $motdinfo"
          }
          putserv "PRIVMSG $nick :You can turn this message off by typing !NOGREET in the channel"
          putserv "PRIVMSG $nick :You can turn it on again by typing !YESGREET"
          close $fd
        } else {
          while {![eof $fd]} {
            set motdinfo [gets $fd]
            putserv "PRIVMSG $nick :-=- $motdinfo"
          }
          close $fd
        }     
      }
    } else {
      if {$wantgflag == "1"} {
        while {![eof $fd]} {
          set motdinfo [gets $fd]
          putserv "PRIVMSG $nick :-=- $motdinfo"
        }
        close $fd
        putserv "PRIVMSG $nick :You can turn this message off by typing !NOGREET in the channel"
        putserv "PRIVMSG $nick :You can turn it on again by typing !YESGREET"
        putserv "PRIVMSG $nick :I also noticed you are not a user on this bot."
        putserv "PRIVMSG $nick :if you would like to become a user please type"
        putserv "PRIVMSG $nick :/msg $botnick $myword"    
      }
    }  
  }
}

if {$cpuawarness == "1" && $wantgflag == "0"} {
} else {
  proc do_no_greet {nick uhost hand channel arg} {
    global wantgflag botnick 
    if {[validuser $hand] == "1"} {
      if {[matchattr $hand g] != "1"} {
        putserv "PRIVMSG $nick :You will no longer recieve automated greets"
        chattr $hand +g
      } else {
         putserv "PRIVMSG $nick :You already have automated greets OFF!"
      }
    } else {
      putserv "PRIVMSG $nick :You are not a user on this bot! please /msg $botnick $myword"
    }
  }
}

if {$cpuawarness == "1" && $wantgflag == "0"} {
} else {
  proc do_yes_greet {nick uhost hand channel arg} {
    global wantgflag botnick 
    if {[validuser $hand] == "1"} {
      if {[matchattr $hand g] == "1"} {
        putserv "PRIVMSG $nick :You will now recieve automated greets"
        chattr $hand -g
      } else {
         putserv "PRIVMSG $nick :You already have automated greets ON!"
      }
    }
  }
}

putlog "MOTD 1.0.4 by Daniel Corbe (Byrd) Successfully Loaded"
putlog "Mail corbe@corbe.net with questions/comments"
