# mailfile.tcl 1.0
# Created by Otaku for #wolfshine on SuperChat <otaku@hick.com>
# Mails $mailfile to specified e-mail address
# Usage: !mailfile <file> <e-mail address>
#        !mailfile ls -- to receive a list of files in root directory

# Enable the !mailfile ls command? Set to anything but 1 to disable
set mailfilels 1

# Where is mail located at? User `whereis mail` on the command line to find out
set mail /usr/bin/mail

# What arguments to use with mail? Default is -s to send.
set mailargs -s

# Where is the root directory? ~/botdir/mailfiles/ is normal
set mailpath ~/botdir/mailfiles

# Where is the mailfile.sh shell script located?
set mailfilesh ~/botdir/scripts/mailfile.sh

# Where to put our temp file at?
set mailtempfile /tmp/mailfile.tmp

proc pub_mailfile {nick uhost hand chan args} {
	global mail mailargs mailpath mailfilesh mailtempfile mailfilels
	set arg1 [lindex [lindex [lrange $args 0 1] 0] 0]
	set arg2 [lindex [lindex [lrange $args 0 1] 0] 1]
	if {$mailfilels == 1} {
		if {$arg1 == "ls"} {
			exec ls -l $mailpath > $mailtempfile
			set lstempfile [open $mailtempfile]
			while {![eof $lstempfile]} {
				set lsline [gets $lstempfile]
				putserv "NOTICE $nick :$lsline"
			}
			close $lstempfile
			exec rm -f $lstempfile
			return 0
		}
	}
	if {[exec /bin/sh $mailfilesh $arg1] == 0} {
		putserv "NOTICE $nick :$arg1 does not exist"
		return 0
	}
	exec /bin/cat $mailpath/$arg1 | $mail $mailargs $arg1 $arg2
	putserv "NOTICE $nick :$arg1 has been sent to $arg2"
	putlog "mailfile.tcl: $arg1 sent to $arg2"
}

bind pub - !mailfile pub_mailfile

putlog "mailfile.tcl 1.0 by Otaku <otaku@hick.com> loaded"
