#####
# eggseen1.1.1 by Per Johansson <email: dw@mindless.com>
# much based on PreSSos adbseen for egg1.0 bots
#
# eggseen is made for eggdrop 1.1.x bots 
#
# version 1.1.1 (Aug 05 -97)
#	* fixed probs with dcc/msg seen syntax, found by Tewkster
#
# version 1.1.0 (27 Jul, 1997)
#	1. It's stackable (pubm and msgm) 
#	2. Seenlog , registed bot users has an option to get a note
#	    -when someone is looking for them.(can be disabled)
#	3. LamerProtection 
#	    -don't respond/kicks to messy seens like '!seen someone with an attitude'
#	4. multichannel
#	5. loggs everyone not just registed bot users
#	6. ...
##	( Per [dw] Johansson dw@mindless.com )
#
# COMMANDS:
# dcc, msg, public: !seen <nick>
# dcc (+m): seenupd [<nick> <nick> ...]
# dcc seenlog [on/off]
#
#####

### *** SETTINGS ***
#can be set separatly for diffrent bot's by keeping some of
#the options commented out and put them in the bot's config file instead.

# seen prefix (defaults to "!seen" ex. !seen <nick>)
# only used as trigger in the channel, "seen" is used elsevare
set seentrigger "!seen"

######Lamer Protection#########
#max nick length defaults to 9 (EFnet,IRCNet..)
#to avoide things like !seen my_butt_on_a_sunny_day...
set maxnl 9
#kick if lamer detected? (default="yes" anything else just set's the script to ignore)
set kicklamer "yes"
###############################

# let users have the choise to log seens? Default "yes"
set enablelog "yes"

#The flag 4 ppl who wanna have a seen logg default P(flag4)
set flag4 P
 
# filename of the file where nicks list will be saved
# (defaults to seen.nicks)
#set seennicks {seen.nicks}

# save nicks each (this setting) minutes (defaults to 15
# minutes)
#set nickssavetime 15

# check for expired users on every this much minutes
# this should be set to a reasonable value like one hour or
# one day or something like that (defaults to 60 minutes)
set expirechk 1440

# time in hours for the nick that is NOT on the bot's
# userlist to expire. this keeps the seennicks file from
# getting huge (defaults to 720 hours -> 30 days)
#set nickexpire 720

# default bind flag to trigger public seen command - this
# was implemented because of the abuses that were done via
# public seen (ie.  seen "where my di*k is" etc..)
# defaults to "-" (no flag required)
#set seenpubf "-"

# default bind flag to trigger private msg seen command
# defaults to "-" (no flag required)
#set seenmsgf "-"

##                   ##
### end of settings ###
##                   ##

if {!([info exists seentrigger])} {set seentrigger "!seen"}

if { $enablelog == "yes" } {
bind pubm - "% $seentrigger %" mbdw:pubseenl
bind msgm - "$seentrigger %" mbdw:msgseenl
bind dcc - seenlog mbdw:seenlcom

proc mbdw:seenlcom {hand id text} {
if { [string tolower $text] == "on" } {
chattr $hand "+P"
putdcc $id "Seenlog turned on"
return 1
 }
if { [string tolower $text] == "off" } {
chattr $hand "-P"
putdcc $id "Seenlog turned off"
return 1
 }
if { [string tolower $text] == "help" } {
putdcc $id "Seenlog usage: on  = sets the right userflag for logging"
putdcc $id "Seenlog usage: off = removes the userflag"
putdcc $id "Seenlog usage: help= shows this help"
putdcc $id "Seenlog about: Seenlog sends u a note telling who,where and when someone used for example a seen script to look for u."
return 1
 }
putdcc $id "Try .seenlog help for more info"
}

proc mbdw:msgseenl {nick ushost handle text} {
if [matchattr [lindex $text 1] P] {
sendnote Seenlog [lindex $text 1] "$nick ($handle) was looking 4 you (msg) at the time this note was sent (plz delete old notes)"
  }
}
proc mbdw:pubseenl {nick ushost handle chann text} {
if [matchattr [lindex $text 1] P] {
sendnote Seenlog [lindex $text 1] "$nick ($handle) was looking 4 you in $chann at the time this note was sent (plz delete old notes)"
  }
 }
}
set seenver "eggseen.tcl v1.1.1 (Aug 05, 1997) for eggdrop 1.1.x by \[dw\] based on PreSSo's adbseen."
if {!([info exists seenpubf])} {set seenpubf "-"}
if {!([info exists seenmsgf])} {set seenmsgf "-"}
set nlist ""

# delete fake/existing userlist users from the seennicks list
proc seen_del_existing {uhand} {
  global nlist
  # delete nicks if the user exists in the userlist
  append fwho "+" $uhand
  set ind [lsearch -exact $nlist [string tolower $fwho]]
  set deld 0
  if {$ind != -1} {
    set nlist [lreplace $nlist $ind [expr $ind + 3]]
    return 1
  }
  return 0
}

# force nick update
proc force_seenupd {hand idx arg} {
  global seennicks
  if {[llength $arg] < 1} {
    #update all users
    putdcc $idx "Updating seen information for all users in the userlist..."
    set deld 0
    foreach uhand [userlist] {
      incr deld [seen_del_existing $uhand]
    }
    if {$deld} {
      putdcc $idx "Removed $deld nick(s) from nicks list that exist in the userlist"
    }
  } else {
    #update specified nicks
    foreach uhand $arg {
      seen_del_existing $uhand
    }
  }
  putdcc $idx "Update complete."
}

# update nick's status..
proc nick_upd {chan nick uhand how} {
  global nlist
  #set uhand [string tolower $uhand]
  if {$uhand!="*"} {
    # this user is a valid user
    setlaston $uhand
    user-set $uhand seenon $chan
    user-set $uhand seenhow $how
    # delete possible fake user entry in the nick list
    append fwho "-" $uhand
    set ind [lsearch -exact $nlist [string tolower $fwho]]
    if {$ind != -1} {
      set nlist [lreplace $nlist $ind [expr $ind + 3]]
    }
    seen_del_existing $uhand
    return 1
  } else {
    # this user is NOT a valid user..
    if {[validuser $nick]} {
      # ..but he's using the nick of one of the valid users!
      append mnick "-" [string tolower $nick]
    } else {
      # ..and he's using his own nick.. (this one will most probably only happen to $botnick)
      append mnick "+" [string tolower $nick]
    }
  }
  set timeon [unixtime]
  set ind [lsearch -exact $nlist $mnick]
  if {($ind >= 0)} {
    #found nick! replace it
    set nlist [lreplace $nlist [expr $ind + 1] [expr $ind + 3] $timeon $chan $how]
  } else {
    #nick nonexistant. append to the list
    lappend nlist $mnick $timeon $chan $how
  }
}

# save nicks
proc dcc_nick_save {hand idx arg} {
  global seennicks
  nick_save
  putdcc $idx "Nicks saved to file ${seennicks}"
}
proc nick_save {} {
  global seennicks nlist nicksavetime
  set f [open $seennicks w]
  puts $f $nlist
  close $f
  kill_egg_timer "nick_save"
  timer $nicksavetime "nick_save"
}

# delete expired users from the list
proc check_expired {} {
  global nickexpire expirechk nlist
  putlog "-Seen- Checking for expired users. Bot will not respond for a while."
  set total [expr [llength $nlist] - 1]
  set mtotal [expr $total / 4]
  set nulist ""
  set nrdel 0
  set ind 0
  set nrtot 0
  foreach ent $nlist {
    switch $ind {
      0 {
        set nik $ent
        set ind 1
      }
      1 {
        set loff $ent
        set ind 2
      }
      2 {
        set lchan $ent
        set ind 3
      }
      3 {
        if {[expr ([unixtime] - $loff) / 3600] < $nickexpire} {
        #hasn't yet expired, add to the nulist
        lappend nulist $nik $loff $lchan $ent
        } else {incr nrdel 1}
        set ind 0
      }
    }
  }
  set nlist $nulist
  if {$nrdel > 0} {
    putlog "-Seen- Deleted $nrdel expired nicks out of total $mtotal ([expr 100.0 * $nrdel / $mtotal]%)."
  }
  putlog "-Seen- Next check in $expirechk minutes."
  kill_egg_timer "check_expired"
  timer $expirechk "check_expired"
}

proc kill_egg_timer {timercommand} {
  foreach tl [timers] {
    if {[string compare [lindex $tl 1] $timercommand] == 0} {
      killtimer [lindex $tl 2]
      return 1
    }
  }
  return 0
}

proc putseen {out isdcc text} {
  if {$isdcc} {
    putdcc $out $text
  } else {
    putserv "PRIVMSG $out :$text"
  }
}

# return how <who> left
proc adb_seengethow {who} {
  switch [user-get $who seenhow] {
    1 {
      return "flying off (*kicked*)"
    }
    default {
      return "on"
    }
  }
}

# return 'one of my channels' if the channel
# is +secret
# return 'the channel'/'my party line' if the
# nick was on the same channel as the user is on
# return channel nick was last seen on otherwise
proc thechan {whochan userchan} {
  if {$whochan == "my party line"} {
    return "my party line"
  }
  if {[lsearch [channels] $whochan] == -1} {
    return $whochan
  }
  if {[string tolower $whochan] == [string tolower $userchan]} {
    return "this channel"
  }
  if {[lsearch [channel info $whochan] "+secret"] == -1} {
    return $whochan
  }
  return "one of my channels(+s)"
}


# show when <who> was last on
proc adb_seen {channel nick uhost handle who isdcc} {
  global nlist botnick maxnl kicklamer

#LamerProtection
	set reason "no noone has seen anything go look elsewhere"
if { [lindex $who 2] != "" } {if {$kicklamer == "yes"} {putserv "kick $channel $nick :$reason"; return 0} return 0}

set who [lindex $who 1]
if { [string length $who] > $maxnl } {if {$kicklamer == "yes"} {putserv "kick $channel $nick :$reason"; return 0} return 0}
#
  set unick ""
  if {$isdcc == 0} {
    if {[string compare $channel $nick] != 0} {
      append unick $nick ": "
    }
  }
  
  if {$who == ""} {
    putseen $channel $isdcc "${unick}Umm.. try specifying a nick next time.. ok?"
    return 1
  }

  set who [string trim [lindex $who 0] ?]
  if {[string compare [string tolower $botnick] [string tolower $who]] == 0} {
    putseen $channel $isdcc "${unick}Yeah, whenever I look in the mirror.."
    return 1
  }
  if {[string compare [string tolower $nick] [string tolower $who]] == 0} {
    putseen $channel $isdcc "${unick}? Are you DUMB?"
    return 1
  }

  if {$unick==""} {
    #request via MSG!
    foreach chan [channels] {
      if {[onchan $who $chan]} {
        putseen $channel $isdcc "Hmmmm... I think $who is on IRC right now."
        return 1
      }
      if {[onchansplit $who $chan]} {
        putseen $channel $isdcc "${who} was just on IRC, but got netsplit.. shame, huh?:)"
        return 1
      }
      foreach i [chanlist $chan] {
        set hand [finduser $i![getchanhost $i $chan]]
        if {($hand != "*") && ([string compare [string tolower $hand] [string tolower $who]] == 0)} {
          if {[onchansplit $i $chan]} {
	    putseen $channel $isdcc "$i is ${who}, and $i was just on [thechan $chan $channel] but got netsplit.."
          } {
            putseen $channel $isdcc "$i is ${who}, and $i is on [thechan $chan $channel] right now!"
          }
          return 1
        }
      }
    }

  } else {
    #request via PUB!
    #check if the nick is on YOUR channel
    if {[onchansplit $who $channel]} {
      putseen $channel $isdcc "${unick}${who} was just here, but got netsplit.. shame, huh?:)"
      return 1
    }
    if {[onchan $who $channel]} {
      putseen $channel $isdcc "${unick}Go check your eyes.. ${who} is on the channel right now!"
      return 1
    }
    foreach i [chanlist $channel] {
      set hand [finduser $i![getchanhost $i $channel]]
      if {($hand != "*") && ([string compare [string tolower $hand] [string tolower $who]] == 0)} {
        if {[onchansplit $i $channel]} {
          putseen $channel $isdcc "${unick}$i is ${who}, and $i was just here but got netsplit"
        } {
          putseen $channel $isdcc "${unick}$i is ${who}, and $i is on the channel right now!"
        }
        return 1
      }
    }

    #hmm.. obviously not. let's check if he's on other channels we're on
    set channel [string tolower $channel]
    foreach chan [channels] {
      if {[string compare [string tolower $chan] $channel] == 0} {
        #already did this channel (YOUR channel)
        continue
      }
      if {[onchansplit $who $chan]} {
        putseen $channel $isdcc "${unick}${who} was just on [thechan $chan $channel] but got netsplit.. shame, huh?:)"
        return 1
      }
      if {[onchan $who $chan]} {
        putseen $channel $isdcc "${unick}Hmm.. If I'm not mistaken ${who} is on [thechan $chan $channel] at the moment?"
        return 1
      }
      foreach i [chanlist $chan] {
        set hand [finduser $i![getchanhost $i $chan]]
        if {($hand != "*") && ([string compare [string tolower $hand] [string tolower $who]] == 0)} {
          if {[onchansplit $i $chan]} {
            putseen $channel $isdcc "${unick}$i is ${who}, and $i was just on [thechan $chan $channel] but got netsplit.."
          } {
            putseen $channel $isdcc "${unick}$i is ${who}, and $i is on [thechan $chan $channel] right now!"
          }
          return 1
        }
      }
    }
  }

  if {[hand2idx $who] >= 0} {
    if {[matchattr $handle p]} {
      putseen $channel $isdcc "${unick}$who is on my party line right now!"
      return 1
    }
  }

  append fwho "-" $who
  set find [lsearch -exact $nlist [string tolower $fwho]]
  if {$find!=-1} {
    set ind $find
    set ending " I cannot guarantee it was really ${who} though (different host than the one that I have in my userlist)!"
  } else {
    append rwho "+" $who
    set ind [lsearch -exact $nlist [string tolower $rwho]]
    set ending ""
  }
  if {$ind == -1} {
    if {[validuser $who]} {
      set last [getlaston $who]
      set seenon [thechan [user-get $who seenon] $channel]
      switch [user-get $who seenhow] {
        1 {
          set seenhow "flying off (*kicked*)"
        }
        default {
          set seenhow "on"
        }
      }
      if {$last == 0} {
        putseen $channel $isdcc "${unick}I haven't seen ${who}. Not recently. Not ever."
        return 1
      } else {
        putseen $channel $isdcc "${unick}I last saw $who $seenhow $seenon [tdiff [unixtime] $last]ago."
        return 1
      }
    }
    putseen $channel $isdcc "${unick}I never saw ${who}."
    return 1
  } else {
    set last [lindex $nlist [expr $ind + 1]]
    set seenon [thechan [lindex $nlist [expr $ind + 2]] $channel]
    switch [lindex $nlist [expr $ind + 3]] {
      1 {
        set seenhow "flying off (*kicked*)"
      }
      default {
        set seenhow "on"
      }
    }
    putseen $channel $isdcc "${unick}I last saw $who $seenhow $seenon [tdiff [unixtime] $last]ago.$ending"
    return 1
  }
}


# time difference
proc tdiff {time2 time1} {
  set ltime [expr $time2 - $time1]
  set seconds [expr $ltime % 60]
  set ltime [expr ($ltime - $seconds) / 60]
  set minutes [expr $ltime % 60]
  set ltime [expr ($ltime - $minutes) / 60]
  set hours [expr $ltime % 24]
  set days [expr ($ltime - $hours) / 24]

  set result ""

  if {$days} {
    append result "$days "
    if {$days == 1} {
      append result "day "
    } else {
      append result "days "
    }
  }
  if {$hours} {
    append result "$hours "
    if {$hours == 1} {
      append result "hour "
    } else {
      append result "hours "
    }
  }
  if {$minutes} {
    append result "$minutes "
    if {$minutes == 1} {
      append result "minute "
    } else {
      append result "minutes "
    }
  }
  if {$seconds} {
    append result "$seconds "
    if {$seconds == 1} {
      append result "second "
    } else {
      append result "seconds "
    }
  }
  return $result
}


proc dcc_seen {hand idx arg} {
set arg "* $arg"
  adb_seen $idx $hand "" $hand $arg 1
}
bind dcc - seen dcc_seen

proc pubm_seen {nick uhost hand channel who} {
  adb_seen $channel $nick $uhost $hand $who 0
 }
bind pubm $seenpubf "% $seentrigger *" pubm_seen

proc msgm_seen {nick uhost hand who} {
  adb_seen $nick $nick $uhost $hand $who 0
}
bind msgm $seenmsgf "$seentrigger %" msgm_seen

proc seen_join {nick uhost hand channel} {
  nick_upd $channel $nick $hand 0
}
bind join - * seen_join

proc seen_part {nick uhost hand channel} {
  nick_upd $channel $nick $hand 0
}
bind part - * seen_part

proc seen_sign {nick uhost hand channel reason} {
  nick_upd $channel $nick $hand 0
}
bind sign - * seen_sign

proc seen_nickch {nick uhost hand channel newnick} {
  nick_upd $channel $nick $hand 0
  nick_upd $channel $newnick $hand 0
}
bind nick - * seen_nickch

proc seen_kick {nick uhost hand channel kicked reason} {
  set hand [nick2hand $kicked $channel]
  nick_upd $channel $kicked $hand 1
}
bind kick - * seen_kick

proc seen_chof {hand idx} {
  nick_upd "my party line" $hand $hand 0
}
bind chof - * seen_chof

#for testing/emergency nick save only
bind dcc m savenicks dcc_nick_save

#force deletion of nicks in the nickfile that are in the userlist
#(this command should be issued if new users are added to the bot's
#userlist)
bind dcc m seenupd force_seenupd

# script initialization
putlog "$seenver"
# set defaults
if {!([info exists seennicks])} { set seennicks {seen.nicks} }
if {!([info exists nicksavetime])} { set nicksavetime 15 }
if {!([info exists nickexpire])} { set nickexpire 720 }
if {!([info exists expirechk])} { set expirechk 60 }
if [file exists $seennicks] {
  set f [open $seennicks r]
  if {[gets $f nlist] != -1} {
    if {[expr [llength $nlist] % 4] != 0} {
      putlog "*Seen* Invalid nicks list.. Clearing nicks list."
      set nlist ""
    }
  } else {
    putlog "*Seen* Invalid data file. Nicks list not loaded."
    set nlist ""
  }
  close $f
}
# update users on the channel
foreach chan [channels] {
  foreach n [chanlist $chan] {
    set hand [nick2hand $n $chan]
    nick_upd $chan $n $hand 0
  }
}
nick_save
check_expired
