# Author:   Fredrik Lhr (nml375@kuai.se) aka. NML_375
# Version:  1.8
# Date:     971214
# Desc:     Tries to prevent capsing in channels.
#           Will warn people whom is capsing. If they continue to do so, they'll
#           get kicked, and, if they still haven't stopped, get banned.
#
#           This script calculates the percentage of capital letters in all msg:s
#           sent to a channel and decides if it is too much (default 30%) or not.

# Legal information:
#           This script and all belonging files are the proberty of Fredrik Lhr.
#           You may use them at own will as long as the author is NOT held
#           responsible for ANY damage caused by the usage of this script, 
#           direct or indirect.
#           You may change the script and all belonging files as long as you
#           keep this copyright-text, include a short description of all
#           changes, and send a copy to the author (email:nml375@kuai.se).
#
#           (C)Copyright Fredrik Lhr, 1997

# Please visit http://www.kuai.se/~nml375 for updates and other stuff...


## Version 1.8 by NML_375 (nml375@kuai.se) 971214
# * Changed structure of procs (Saved some disk-space...)
# * Minor changes to increase speed (why use user-get 5 times where 1 time is enough...)
# * Found small bug in caps_pubm (missing quote-char in comment-command...)
# * Uses maskhost again... (Only causes problems on some systems... Too complex to solve with
#   a simple proc...)
# * Fixed bug with BadX handles... (now it searches for a _NOT ALREADY USED_ handle instead of
#   searching for already existing ones...)
# * History of Caps-Guard moved to caps.v1.8.hist

# Things still to add/change:
# * multi-channel-support  la eggdrop 1.1
#   (I promise, it _will_ be added before v2.0)

# Known issues:
# * Won't remove bans when using clearuser
# * Might be too many log-entries...
# * Won't run on eggdrop 1.0 or lower without editing...
#   (uses matchchanattr)



putlog "Caps-Guard: Looking for newer versions of Caps-Guard..."
if {[info exists caps_loaded]} {
 if {$caps_loaded > 1800} {
  putlog "Caps-Guard: Newer version found! Aborting..."
  return
 } elseif {$caps_loaded == 1800} {
  putlog "Caps-Guard: Current version is already loaded! Refreshing..."
 } else {
  putlog "Caps-Guard: No newer versions found! Loading Caps-Guard v1.8..."
 }
}
if {![info exists toolkit_loaded]} {
 catch {source scripts/toolkit.tcl}
 if {![info exists toolkit_loaded]} {
  catch {source toolkit.tcl}
  if {![info exists toolkit_loaded]} {
   error "Unable to load Caps-Guard! (Can't find toolkit.tcl)"
  }
 }
}
putlog "Caps-Guard: setting trigger to default (30%)..."
putlog "Caps-Guard: setting bantime to default (15 min)..."
putlog "Caps-Guard: setting ignore to default (< 10 chrs)..."
set capslimit 30
set caps_set 1
set caps_bantime 15
set caps_ignore 10

bind pubm - * caps_pubm
bind msg - caps caps_msg
bind dcc - caps caps_dcc

proc caps_dcc {hand idx arg} {
 set temp "\{0\} \{$idx\}"
 set temp [caps_main $temp $hand [lindex $arg 0] [lrange $arg 1 end]]
 if {[lindex $temp 0] >= 2} {
  putidx $idx "[lindex $temp 1]"
 } elseif {[lindex $temp 0] == 1} {
  putidx $idx "You are not authorized to use that command!\a"
 }
 return 1
}

proc caps_msg {nick host hand arg} {
 set temp "\{1\} \{PRIVMSG $nick :\}"
 set temp [caps_main $temp $hand [lindex $arg 0] [lrange $arg 1 end]]
 if {[lindex $temp 0] >= 2} {
  puthelp "PRIVMSG $nick :[lindex $temp 1]"
 } {[lindex $temp 1] == 1} {
  puthelp "PRIVMSG $nick :You are not authorized to use that command!\a"
 }
 return 1
}

proc caps_main {caps_reply hand command arg} {
 switch $command {
  "limit"     {set r [caps_limit $caps_reply $hand $arg]}
  "set"       {set r [caps_set $caps_reply $hand $arg]}
  "status"    {set r [caps_status $caps_reply $hand $arg]}
  "bantime"   {set r [caps_bantime $caps_reply $hand $arg]}
  "clearuser" {set r [caps_clearuser $caps_reply $hand $arg]}
  "ignore"    {set r [caps_ignore $caps_reply $hand $arg]}
  ""          {set r "4 \{Please use \"help caps\"\}"}
  default     {set r "4 \{Not a command! - \"$command\"\}"}
 }
 return $r
}

proc caps_limit {caps_reply hand text} {
 global capslimit caps_set
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 if {[string trim [lindex $text 0] 0123456789] == ""} {
  set caps_temp [lindex $text 0]
  if {!(($caps_temp < 10 ) || ($caps_temp > 100))} {
   putlog "$hand changed Caps-Guard's sensitivity from $capslimit to ${caps_temp}%"
   set capslimit $caps_temp
   caps_return $caps_reply 1 "Caps-Guard's sensitivity has been set to ${capslimit}%"
   if {!($caps_set == 1)} {
    caps_return $caps_reply 1 "Warning! Caps-Guard is not activated!"
    caps_return $caps_reply 1 "Use \"caps set 1\" to activate Caps-Guard."
   }
  } else {
   caps_return $caps_reply 1 "You have entered an ivalid option ($caps_temp)."
   caps_return $caps_reply 1 "Valid options are between 10 and 100."
  }
 } else {
  caps_return $caps_reply 1 "Please enter a numeric value!"
 }
 return 0
}

proc caps_set {caps_reply hand text} {
 global caps_set capslimit caps_bantime
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 set caps_temp [lindex $text 0]
 if {$caps_temp == 0} {
  set caps_set 0
  putlog "Caps-Guard: $hand deactivated Caps-Guard"
  caps_return $caps_reply 1 "Caps-Guard has been deactivated."
 } elseif {$caps_temp == 1 } {
  set caps_set 1
  putlog "Caps-Guard: $hand activated Caps-Guard"
  caps_return $caps_reply 1 "Caps-Guard has been activated (limit: $capslimit %, ban-time: $caps_bantime min)"
 } else {
  caps_return $caps_reply 1 "You have entered an invalid option ($caps_temp)."
  caps_return $caps_reply 1 "Valid options are: 0 - deactivate, 1 - activate"
 }
 return 0
}

proc caps_status {caps_reply hand text} {
 global caps_set capslimit caps_bantime caps_ignore
 if {!([matchattr $hand m] || [matchattr $hand n] || [matchattr $hand o])} {return 1}
 caps_return $caps_reply 1 "===== Caps-Guard status ====="
 if {$caps_set == 1} {
  caps_return $caps_reply 1 "Caps-Guard is : activated"
 } else {
  caps_return $caps_reply 1 "Caps-Guard is : de-activated"
 }
 caps_return $caps_reply 1 "Limit         : ${capslimit}%"
 caps_return $caps_reply 1 "Ban-time      : $caps_bantime min"
 caps_return $caps_reply 1 "Ignoring      : < $caps_ignore chrs"
 caps_return $caps_reply 1 "=====   End of status   ====="
 return 0
}

proc caps_bantime {caps_reply hand text} {
 global caps_set caps_limit caps_bantime
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {!(($caps_temp < 10 ) || ($caps_temp > 120))} {
   putlog "$hand changed Caps-Guard's bantime from $caps_bantime to $caps_temp min"
   set caps_bantime $caps_temp
   caps_return $caps_reply 1 "Caps-Guard ban-time is set to $caps_bantime minutes."
  } else {
   caps_return $caps_reply 1 "You have entered an invalid option ($caps_temp)!"
   caps_return $caps_reply 1 "Valid options are between 10 and 120"
  }
 } else {
  caps_return $caps_reply 1 "Please enter a numeric value!"
 }
 return 0
}

proc caps_clearuser {caps_reply hand arg} {
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 caps_return $caps_reply 1 "\{$arg\}"
 set norec ""
 foreach temp $arg {
  if {[validuser $temp] == 1} {
   if {[user-get $temp caps] == 0} {
    caps_return $caps_reply 1 "${temp}'s record for caps-regulations has already been cleared..."
   } else {
    user-set $temp caps 0
    caps_return $caps_reply 1 "${temp}'s record for caps-regulations has been cleared..."
    putlog "Caps-Guard: $hand has cleared ${temp}'s record for caps-regulations"
   }
   caps_timer $temp
  } else {
   if {[llength $norec] != 0} {set norec "${norec}, "}
   set norec "${norec}${temp}"
  }
 }
 if {[llength $norec] >= 3} {
  set norec [linsert $norec [expr [llength $norec] - 1] or]
 } elseif {[llength $norec] == 2} {
  regsub -all "," $norec "" norec
  set norec [linsert $norec 1 or]
 } elseif {[llength $norec] == 1} {
  regsub -all "," $norec "" norec
 }
 if {[llength $norec] >= 1} {
  caps_return $caps_reply 1 "Sorry, but I don't know who $norec is..."
 }
 return 0
}

proc caps_pubm {nick uhost hand chan text} {
 global capslimit caps_set caps_bantime botnick caps_ignore default-flags
 if {!($caps_set == 1)} {return 0}
 if {[matchattr $hand m] == 1 || [matchattr $hand n] == 1 || [matchattr $hand f] == 1 || [matchattr $hand b] == 1} {return 0}
 if {[matchchanattr $hand m $chan] == 1 || [matchchanattr $hand n $chan] == 1 || [matchchanattr $hand f $chan] == 1 || [matchattr $hand B] == 1} {return 0}
 if {[string match [string toupper $nick] [string toupper $botnick]]} {return 0}
 if {![botisop $chan]} {return 0}
 set caps_upper 0
 set caps_space 0
 set caps_total 0
 set caps_caps 0
 foreach i [split $text {}] {
  if {[string match [string toupper $i] $i] && ![string match [string tolower $i] $i]} {incr caps_upper}
  if {$i == " "} {incr caps_space}
  incr caps_total
 }
 if {[expr $caps_total - $caps_space] < $caps_ignore} {return 0}
 set caps_caps [expr [expr 100 * $caps_upper] / [expr $caps_total - $caps_space] ]
 if {$caps_caps > $capslimit } {
  set uh [maskhost $uhost]
  set temp [user-get $hand caps]
  if {($temp == 0) || ($temp == "")} {
   puthelp "PRIVMSG $chan :$nick: Turn Caps-lock off..."
   puthelp "NOTICE $nick :Turn Caps-lock off before you write anything more in $chan ..."
   if {[validuser $hand] == 0} {
    if {[validuser $nick] == 0} {
     set hand $nick
    } else {
     set cntr 0
     while {[validuser "Bad${cntr}"]} {incr cntr 1}
     set hand "Bad${cntr}"
    }
    adduser $hand $uh
    chattr $hand "-${default-flags}"
    putlog "Caps-Guard: Added $hand with no attribs"
    setcomment $hand "([date]) Used caps in $chan (${nick}!${uhost})"
    user-set $hand caps 1
   } else {
    user-set $hand caps 1
   }
   caps_timer $hand
   timer 360 "caps_remove $hand"
   putlog "Caps-Guard: $nick ($hand) has been warned once"
   return 0
  }
  if {$temp == 1} {
   putserv "KICK $chan $nick :I told you to turn Caps-lock off!"
   user-set $hand caps 2
   caps_timer $hand
   timer 360 "caps_remove $hand"
   putlog "Caps-Guard: $nick ($hand) has been warned a second time (using kick...)"
   return 0
  }
  if {$temp == 2} {
   putserv "MODE $chan -o $nick"
   newchanban $chan $uh CapsGuard "Capsing..." $caps_bantime
   putserv "KICK $chan $nick :I've already warned you twice, now I'm banning you for $caps_bantime minutes (capsing)"
   user-set $hand caps 3
   caps_timer $hand
   timer 360 "caps_remove $hand"
   putlog "Caps-Guard: $nick ($hand) has been banned in $caps_bantime minutes ($uh)"
   return 0
  }
  if {$temp == 3} {
   putserv "MODE $chan -o :$nick"
   newchanban $chan $uh CapsGuard "Capsing... (Perm-banned!)" 0
   putserv "KICK $chan $nick :You are not welcome here anymore! (Capsing)"
   user-set $hand caps 4
   putlog "Caps-Guard: $nick ($hand) has been perm-banned ($uh)"
   caps_timer $hand
   return 0
  }
 }
}

proc caps_timer {hand} {
 foreach timer [timers] {
  if {[string match [string tolower [lindex $timer 1]] [string tolower "caps_remove $hand"]]} {
   killtimer [lindex $timer 2]
   putlog "Gaps-Guard: Cleaned up caps_remove timer for $hand"
  }
 }
}

proc caps_remove {hand} {
 caps_timer $hand
 set temp [user-get $hand caps]
 if {($temp == 0) || ($temp == 4)} {
  return 0
 } elseif {($temp == "") || ($temp == 1)} {
  user-set $hand caps 0
  return 2
 } else {
  user-set $hand caps [expr $temp - 1]
  timer 360 "caps_remove $hand"
  return 1
 }
}

proc caps_ignore {caps_reply hand text} {
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 global caps_ignore
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {$caps_temp > 0 } {
   putlog "$hand changed Caps-Guard's ignore-setting from $caps_ignore to $caps_temp"
   set caps_ignore $caps_temp
  } {
   caps_return $caps_reply 1 "Please enter a value larger than zero"
  }
 } {
  caps_return $caps_reply 1 "Please enter a numeric value"
 }
 return 0
}

proc caps_rehash {} {
 global caps_cleared
 putlog "Caps-Guard: Checking for caps-listed users..."
 foreach hand [userlist] {
  if {!(([user-get $hand caps] == "")||([user-get $hand caps] == "0"))} {
   timer 360 "caps_remove $hand"
  }
 }
 set caps_cleared 1
}

proc caps_return {id type text} {
 if {[lindex $id 0] == 0 } {
  putidx [lindex $id 1] $text
 } elseif {[lindex $id 0] == 1 } {
  puthelp "[lindex $id 1]$text"
 } elseif {[lindex $id 0] == 2 } {
  if {$type = 1} {
   puthelp "[lindex $id 1]$text"
  } else {
   puthelp "[lindex $id 2]$text"
  }
 }
}
if {![info exists caps_cleared]} {
 caps_rehash
}

set caps_loaded 1800
putlog "Caps-Guard v1.8 Loaded!  Written by Fredrik Lhr (NML_375, nml375@kuai.se) Copyright(C) 1997"
