# Author:    Fredrik Lhr, NML_375@Dalnet/ircnet (nml375@kuai.se)
# Version:   1.0
# Date:      970729
# Desc:      This script will kick users who caps. Capsing is determined by
#            percentage caps of whole string... Continuous capsing will also
#            result in a ban... (uses toolkit.tcl user-set to store number of
#            capsing-regulations, user will also be added in userlist with no
#            flags). The user-record for capsing-regulations are decreased
#            every 6 hours.

#            This script and all belonging files are the proberty of Fredrik Lhr.
#            You may use them at own will as long as the author is NOT held
#            responsible for ANY damage caused by the usage of this script, 
#            direct or indirect.
#            You may change the script and all belonging files as long as you
#            keep this copyright-text, include a short description of all
#            changes, and send a copy to the author (email:nml375@kuai.se).

# Copyright: (C)Copyright Fredrik Lhr, 1997


# Please visit http://www.kuai.se/~nml375 for updates and other stuff...

# Modified 970906 by NML_375 (nml375@kuai.se)
#
# Changes since beta:
# * Fixed stupid timer-error in caps_remove
# * No more bugs found so far...

# Things to add:
# * dcc commands
# * multi-channel-support  la eggdrop 1.1

## Version 1.2 by NML_375 (nml375@kuai.se) 970922
# * Added dcc-commands...


## Version 1.5 by NML_375 (nml375@kuai.se) 971011
# * Cleaned up some of the procs...
# * Changed msg-commands, Now using /msg botnick caps [command]
#   instead of /msg botnick caps_[command]
# * Added command to set minimum # of chars for Caps-Guard to react
#   (caps ignore)
# * Changed selection of handle for non-registered users
#   (now using Badn as alternative handle instead of Xnick,
#   Should work a bit more safely decreasing possibility of
#   selected handle already taken)
# * Comments handles when created
# * Wrote help-files (please put them in your help-directory)
# * Supports Eggdrop's flags per channel (matchchanattr)
# * Didn't mess up version-numbers and filemanes this time :)
# * Still no support for individual settings for each channel :/
#   (I promise, I'll add it soon!)
# * Changed desc... (too large with too litle info :/ )

# Known issues:
# * Won't remove bans when using clearuser
# * Might be too many log-entries...
# * Won't run on eggdrop 1.0 or lower without editing...
#   (uses matchchanattr)


putlog "Loading Caps-guard v1.5..."
if {![info exists toolkit_loaded]} {
 catch {source scripts/toolkit.tcl}
 if {![info exists toolkit_loaded]} {
  catch {source toolkit.tcl}
  if {![info exists toolkit_loaded]} {
   error "Unable to load Caps-guard! (Can't find toolkit.tcl)"
  }
 }
}
putlog "Caps-guard: setting trigger to default (30 %)..."
putlog "Caps-guard: setting bantime to default (15 min)..."
putlog "Caps-guard: setting ignore to default (<10 chrs)..."
set capslimit 30
set caps_set 1
set caps_bantime 15
set caps_ignore 10

bind pubm - * caps_pubm
bind msg - caps caps_msg_main
bind dcc - caps caps_dcc_main

proc caps_dcc_main {hand idx arg} {
 set cmd [lindex $arg 0]
 set args [lrange $arg 1 end]
 switch $cmd {
  "limit" {set r [caps_dcc_setlimit $hand $idx $args]}
  "set" {set r [caps_dcc_set $hand $idx $args]}
  "status" {set r [caps_dcc_status $hand $idx $args]}
  "bantime" {set r [caps_dcc_bantime $hand $idx $args]}
  "clearuser" {set r [caps_dcc_clearuser $hand $idx $args]}
  "ignore" {set r [caps_dcc_ignore $hand$idx $args]}
  default {set r 0}
 }
 if {$r == 0} {putdcc $idx "Caps-Guard: invalid command $cmd"}
 return 1
}
 proc caps_msg_main {nick host hand arg} {
 set cmd [lindex $arg 0]
 set args [lrange $arg 1 end
 switch $cmd {
  "limit" {set t [caps_msg_setlimit $nick $host $hand $args]}
  "set" {set r [caps_msg_set $nick $host $hand $args]}
  "status" {set r [caps_msg_status $nick $host $hand $args]}
  "bantime" {set r [caps_msg_bantime $nick $host $hand $args]}
  "clearuser" {set r [caps_msg_clearuser $nick $host $hand $args]}
  "ignore" {set r [caps_msg_ignore $nick $host $hand $args]}
  default {set r 0}
 }
 if {$r == 0} {putdcc $idx "Caps-Guard: invalid command $cmd"}
 return 1

proc caps_dcc_setlimit {hand idx text} {
 global capslimit caps_set
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 if {[string match [string tolower $text] "help"]} {
  putdcc $idx "Syntax: .caps setlimit \[option\]"
  putdcc $idx "Valid options are between 10 and 100"
  return 1
 }
 if {[string trim [lindex $text 0] 0123456789] != ""} {
  putdcc $idx "Please enter a numeric value"
  putdcc $idx "Syntax: .caps setlimit \[value\]"
  return 1
 }
 set caps_temp [lindex $text 0]
 if {!(($caps_temp < 10 ) || ($caps_temp > 100))} {
  putlog "$hand changed Caps-guard's sensitivity from $capslimit to $caps_temp"
  set capslimit $caps_temp
  if {!($caps_set == 1)} {
   putdcc $idx "Warning! Caps-Guard is not activated!"
   putdcc $idx "type .caps set 1 to activate Caps-Guard."
  }
  putdcc $idx "Caps-guard's sensitivity has been set to $capslimit %"
  return 1
 } elseif {($caps_temp < 10) || ($caps_temp > 100)} {
  putdcc $idx "You have entered an invalid option ($caps_temp)."
  putdcc $idx "Valid options are between 10 and 100 or \"help\""
  return 1
 }
}
proc caps_msg_setlimit {nick uhost hand text} {
 global capslimit caps_set botnick
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 if {[string match [string tolower $text] "help"]} {
  puthelp "NOTICE $nick :Syntax: /msg $botnick caps_setlimit \[option\]"
  puthelp "NOTICE $nick :Valid options are between 10 and 100"
  return 1
 }
 if {[string trim [lindex $text 0] 0123456789] != ""} {
  puthelp "NOTICE $nick :Please enter a numeric value"
  puthelp "NOTICE $nick :Syntax: /msg $botnick caps_setlimit \[value\]"
  return 1
 }
 set caps_temp [lindex $text 0]
 if {!(($caps_temp < 10 ) || ($caps_temp > 100))} {
  putlog "$nick changed Caps-guard's sensitivity from $capslimit to $caps_temp"
  set capslimit $caps_temp
  if {!($caps_set == 1)} {
   puthelp "NOTICE $nick :Warning! Caps-guard is not activated!"
   puthelp "NOTICE $nick :Type /msg $botnick caps_set 1 to activate Caps-guard."
  } else {
   puthelp "NOTICE $nick :Caps-guard's sensitivity has been set to $capslimit %"
  }
  return 1
 } elseif {($caps_temp < 10) || ($caps_temp > 100)} {
  puthelp "NOTICE $nick :You have entered an invalid option ($caps_temp)."
  puthelp "NOTICE $nick :Valid options are between 10 and 100 or \"help\""
  return 1
 }
}

proc caps_dcc_set {hand idx text} {
 global caps_set capslimit caps_bantime botnick
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 set caps_temp [lindex $text 0]
 if {$caps_temp == 0} {
  set caps_set 0
  putlog "Caps-guard: $hand deactivated Caps-guard"
  putdcc $idx "Caps-guard has been deactivated"
 } elseif {$caps_temp == 1 } {
  set caps_set 1
  putlog "Caps-guard: $hand activated Caps-guard"
  putdcc $idx "Caps-guard has been activated (limit: $capslimit %, ban-time: $caps_bantime min)"
 } else {
  putdcc $idx "You have entered an invalid option ($caps_temp)."
  putdcc $idx "Valid options are: 0 - deactivate, 1 - activate"
 }
 return 1
}

proc caps_msg_set {nick uhost hand text} {
 global caps_set capslimit caps_bantime
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 set caps_temp [lindex $text 0]
 if {$caps_temp == 0} {
  set caps_set 0
  putlog "Caps-guard: $nick deactivated Caps-guard"
  puthelp "NOTICE $nick :Caps-guard has been deactivated"
 } elseif {$caps_temp == 1 } {
  set caps_set 1
  putlog "Caps-guard: $nick activated Caps-guard"
  puthelp "NOTICE $nick :Caps-guard has been activated (limit: $capslimit %, ban-time: $caps_bantime min)"
 } else {
  puthelp "NOTICE $nick :You have entered an invalid option ($caps_temp)."
  puthelp "NOTICE $nick :Valid options are: 0 - deactivate, 1 - activate"
 }
 return 1
}

proc caps_dcc_status {hand idx text} {
 global caps_set capslimit caps_bantime caps_ignore
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 putdcc $idx "===== Caps-guard status ====="
 if {$caps_set == 1} {
  putdcc $idx "Caps-guard is : activated"
 } else {
  putdcc $idx "Caps-guard is : de-activated"
 }
 putdcc $idx "Limit         : $capslimit %"
 putdcc $idx "Ban-time      : $caps_bantime min"
 putdcc $idx "Ignoring      : < $caps_ignore chrs"
 putdcc $idx "=====   End of status   ====="
 return 1
}

proc caps_msg_status {nick uhost hand text} {
 global caps_set capslimit caps_bantime botnick caps_ignore
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 puthelp "NOTICE $nick :===== Caps-guard status ====="
 if {$caps_set == 1} {
  puthelp "NOTICE $nick :Caps-guard is : activated"
 } else {
  puthelp "NOTICE $nick :Caps-guard is : de-activated"
 }
 puthelp "NOTICE $nick :Limit         : $capslimit %"
 puthelp "NOTICE $nick :Ban-time      : $caps_bantime min"
 puthelp "NOTICE $nick :Ignoring      : < $caps_ignore chrs"
 puthelp "NOTICE $nick :=====   End of status   ====="
 return 1
}

proc caps_dcc_bantime {hand idx text} {
 global caps_set caps_limit caps_bantime botnick
 if {!([matchattr $hand m] || [matchattr $hand n])} {
  return 0
 }
 if {[string match [string tolower $text] "help"]} {
  putdcc $idx "Syntax: .caps bantime \[option\]"
  putdcc $idx "Valid options are between 10 and 120"
  return 1
 }
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {!(($caps_temp < 10 ) || ($caps_temp > 120))} {
   putlog "$hand changed Caps-guard's bantime from $caps_bantime to $caps_temp min"
   set caps_bantime $caps_temp
  } elseif {($caps_temp < 10) || ($caps_temp > 120)} {
   putdcc $idx "You have entered an invalid option ($caps_temp)."
   putdcc $idx "Valid options are between 10 and 120"
   return 1
  }
  putdcc $idx "Caps-guard ban-time is set to $caps_bantime minutes"
 } else {
  putdcc $idx "You have enterred a non-numeric value"
  putdcc $idx "Valid options are between 10 and 120"
 }
 return 1
}

proc caps_msg_bantime {nick uhost hand text} {
 global caps_set caps_limit caps_bantime botnick
 if {!([matchattr $hand m] || [matchattr $hand n])} {
  return 1
 }
 if {[string match [string tolower $text] "help"]} {
  puthelp "NOTICE $nick :Syntax: /msg $botnick caps bantime \[option\]"
  puthelp "NOTICE $nick :Valid options are between 10 and 120"
  return 1
 }
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {!(($caps_temp < 10 ) || ($caps_temp > 120))} {
   putlog "$nick ($hand) changed Caps-guard's bantime from $caps_bantime to $caps_temp min"
   set caps_bantime $caps_temp
  } elseif {($caps_temp < 10) || ($caps_temp > 120)} {
   puthelp "NOTICE $nick :You have entered an invalid option ($caps_temp)."
   puthelp "NOTICE $nick :Valid options are between 10 and 120"
   return 1
  }
  puthelp "NOTICE $nick :Caps-guard ban-time is set to $caps_bantime minutes"
 } else {
  puthelp "NOTICE $nick :You have enterred a non-numeric value"
  puthelp "NOTICE $nick :Valid options are between 10 and 120"
 }
 return 1
}

proc caps_pubm {nick uhost hand chan text} {
 global capslimit caps_set caps_bantime botnick caps_ignore
 if {!($caps_set == 1)} {return 0}
 if {[matchattr $hand m] == 1 || [matchattr $hand n] == 1 || [matchattr $hand f] == 1 || [matchattr $hand b] == 1} {return 0}
 if {[matchchanattr $hand m $chan] == 1 || [matchchanattr $hand n $chan] == 1 || [matchchanattr $hand f $chan] == 1 || [matchattr $hand B] == 1} {return 0}
 if {[string match [string toupper $nick] [string toupper $botnick]]} {return 0}
 if {![botisop $chan]} {return 0}
 set caps_upper 0
 set caps_space 0
 set caps_total 0
 set caps_caps 0
 foreach i [split $text {}] {
  if {[string match [string toupper $i] $i] && ![string match [string tolower $i] $i]} {incr caps_upper}
  if {$i == " "} {incr caps_space}
  incr caps_total
 }
 if {[expr $caps_total - $caps_space] < $caps_ignore} {return 1}
 set caps_caps [expr [expr 100 * $caps_upper] / [expr $caps_total - $caps_space] ]
 if {$caps_caps > $capslimit } {
  if {([user-get $hand caps] == 0) || ([user-get $hand caps] == "")} {
   puthelp "PRIVMSG $chan :$nick: Turn Caps-lock off..."
   puthelp "NOTICE $nick :Turn Caps-lock off before you write anything more in $chan ..."
   if {[validuser $hand] == 0} {
    if {[validuser $nick] == 0} {
     set hand $nick
    } else {
     set cntr 0
     while {![validuser "Bad${cntr}"]} {incr cntr 1}
     set hand "Bad${cntr}"
    }
    adduser $hand "*!*[string trimleft [maskhost $uhost] *!]"
    chattr $hand ""
    putlog "Caps-guard: Added $hand with no attribs"
    comment $hand "([date]) Used caps in channel (${nick}!${host})
    user-set $hand caps 1
   } else {
    user-set $hand caps 1
   }
   timer 360 "caps_remove $hand"
   putlog "Caps-guard: $hand has been warned once"
   return 0
  }
  if {([user-get $hand caps] == 1)} {
   putserv "KICK $chan $nick :I told you to turn Caps-lock off!"
   user-set $hand caps 2
   timer 360 "caps_remove $hand"
   putlog "Caps-guard: $nick has been warned a second time (using kick...)"
   return 0
  }
  if {([user-get $hand caps] == 2)} {
   putserv "MODE $chan -o $nick"
   newchanban $chan *!*[string trimleft [maskhost $uhost] *!] CapsGuard "Capsing..." $caps_bantime
   putserv "KICK $chan $nick :I've already warned you twice, now I'm banning you for $caps_bantime minutes (capsing)"
   user-set $hand caps 3
   timer 360 "caps_remove $hand"
   putlog "Caps-guard: $nick has been banned in $caps_bantime minutes (*!*[string trimleft [maskhost $uhost] *!])"
   return 0
  }
  if {([user-get $hand caps] == 3)} {
   putserv "MODE $chan -o :$nick"
   newchanban $chan *!*[string trimleft [maskhost $uhost] *!] CapsGuard "Capsing... (Perm-banned!)" 0
   putserv "KICK $chan $nick :You are not welcome here anymore! (Capsing)"
   user-set $hand caps 4
   putlog "Caps-guard: $nick has been perm-banned (*!*[string trimleft [maskhost $uhost] *!])"
  }
 }
}
proc caps_remove {hand} {
 if {([user-get $hand caps] == 0) || ([user-get $hand caps] == 4)} {
  return 0
 } elseif {([user-get $hand caps] == "") || ([user-get $hand caps] == 1)} {
  user-set $hand caps 0
  return 2
 } else {
  user-set $hand caps [expr [user-get $hand caps] - 1]
  timer 360 "caps_remove $hand"
  return 1
 }
}
proc caps_dcc_clearuser {hand idx text} {
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 0}
 if {[validuser [lindex $text 0]] == 1} {
  if {[user-get [lindex $text 0] caps] == 0} {
   putdcc $idx "[lindex $text 0]'s record for caps-regulations has already been cleared..."
   return 1
  } else {
   user-set [lindex $text 0] caps 0
   putdcc $idx "[lindex $text 0]'s record for caps-regulations has been cleared..."
   putlog "Caps-Guard: $hand has cleared [lindex $text 0]'s record for caps-regulations"
  }
 } else {
  putdcc $idx "Sorry, but I don't know who [lindex $text 0] is..."
  return 1
 }
}

proc caps_msg_clearuser {nick uhost hand text} {
 if {!([matchattr $hand m] || [matchattr $hand n])} {return 1}
 if {[validuser [lindex $text 0]] == 1} {
  if {[user-get [lindex $text 0] caps] == 0} {
   puthelp "NOTICE $nick :[lindex $text 0]'s record for caps-regulations has already been cleared..."
   return 1
  } else {
   user-set [lindex $text 0] caps 0
   puthelp "NOTICE $nick :[lindex $text 0]'s record for caps-regulations has been cleared..."
   putlog "CapsGuard: $nick (handle: $hand) has cleared [lindex $text 0]'s record for caps-regulations"
  }
 } else {
  puthelp "NOTICE $nick :Sorry, but I don't know who [lindex $text 0] is..."
  return 1
 }
}

proc caps_dcc_ignore {hand idx text} {
 global caps_ignore
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {$caps_temp > 0 } {
   putlog "$hand changed Caps-Guard's ignore-setting from $caps_ignore to $caps_temp"
   set caps_ignore $caps_temp
  } {
   putidx $idx "Please enter a value larger than zero"
  }
 } {
  putidx $idx "Please enter a numeric value"
 }
 return 1
}
proc caps_msg_ignore {nich host hand text} {
 global caps_ignore
 set caps_temp [lindex $text 0]
 if {[string trim $caps_temp 0123456789] == ""} {
  if {$caps_temp > 0 } {
   putlog "$nick ($hand) changed Caps-Guard's ignore-setting from $caps_ignore to $caps_temp"
   set caps_ignore $caps_temp
  } {
   puthelp "NOTICE $nick :Please enter a value larger than zero"
  }
 } {
  puthelp "NOTICE $nick :Please enter a numeric value"
 }
 return 1
}


putlog "Caps-guard v1.2 Loaded!   Author: NML_375 (nml375@kuai.se))"
