## Advanced Dungeons & Dragons(tm) Automated Di-Roll Generator
##
##     By Ec|ipse@EFnet (tomas@primenet.com) (C) 1997.. All rights reserved and such..
##
##     PLEASE: Don't reproduce this without my name on any unmodified code. Try to give
##     me some recogniton for anything borrowed out of this script

# v1.0    06-22-97  tomas@primenet.com    from a request on eggdrop_mailing_list
# v1.1    07-09-97  tomas@primenet.com    added AD&D di format ie: 2d4, 1d6, 2d8

# INSTRUCTIONS: first add console flag 5 to users so they can see the di rolls, or only
#               to the Dungeon Master and he can relay. then in the channel, type '!roll'
#               or in the DCC window, type '.roll' for usage instructions. be sure to list
#               dice you are to be using below, ive gone from memory, been a very long
#               time since ive played AD&D.

set dice "4 6 8 10 12 20"

#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#
#      W A R N I N G      DON'T Change anything below here      W A R N I N G      #
#~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~#

bind pub - !roll pub:roll
proc pub:roll {nick host hand chan arg} {
  global dice
  set x [lindex [split $arg d] 0] ; set d [lindex [split $arg d] 1] ; set total 0
  if {$d == ""} {
    puthelp "NOTICE $nick :*** Usage: !roll <times>d<type>"
    return 0
  }
  if {$x == ""} {set x 1}
  if {[lsearch $dice $d] == -1} {
    puthelp "NOTICE $nick :*** Error, a $d sided di is not available."
    return 0
  } {
    puthelp "PRIVMSG $chan :\[$nick\] rolling $d sided di $x time(s)"
    for {set n 0} {$n != $x} {incr n} {
      set di_roll [expr [rand $d] + 1]
      lappend times $di_roll
    }
    foreach time $times {
      set total [expr $time + $total]
    }
# if you wish to see the rolls, uncomment the following line
#   puthelp "PRIVMSG $chan :*** Rolls of \002$times\002 with a \002$d\002 sided di were generated."
    puthelp "PRIVMSG $chan :*** \[$nick\] rolled a \002$d\002 sided di \002$x\002 time(s) for a total of \002$total\002"
  }
  return 0
}

bind dcc - roll dcc:roll
proc dcc:roll {hand idx arg} {
  global dice
  set x [lindex [split $arg d] 0] ; set d [lindex [split $arg d] 1] ; set total 0
  if {$d == ""} {
    if {[valididx $idx]} {putdcc $idx "*** Usage: .roll <times>d<type>"}
    return 0
  }
  if {$x == ""} {set x 1}
  if {[lsearch $dice $d] == -1} {
    if {[valididx $idx]} {putdcc $idx "*** Error, a $d sided di is not available."}
    return 0
  } {
    putloglev 5 * "#$hand# rolling $d sided di $x time(s)"
    for {set n 0} {$n != $x} {incr n} {
      set di_roll [expr [rand $d] + 1]
      lappend times $di_roll
    }
    foreach time $times {
      set total [expr $time + $total]
    }
# if you wish to see the rolls, uncomment the following line
#   putloglev 5 * "*** Rolls of \002$times\002 with a \002$d\002 sided di were generated."
    putloglev 5 * "*** #$hand# rolled a \002$d\002 sided di \002$x\002 time(s) for a total of \002$total\002"
  }
  return 0
}

putlog "\"Di-Roll Generator\" by: Ec|ipse loaded..."