struct flag_record {
   int match;
   int global;
   int udef_global;
   int bot;
   int chan;
   int udef_chan;
};

#define FR_GLOBAL 0x00000001
#define FR_BOT    0x00000002
#define FR_CHAN   0x00000004
#define FR_OR     0x40000000
#define FR_AND    0x20000000
#define FR_ANYWH  0x10000000
#define FR_ALL    0x0fffffff

/* userflags:                              */
/*   ???????? x?vut??q ponm?kj? h?f?dcba   */
/* + user defined A-Z                      */
/*   unused letters: eglrwyz               */
/* botflags soon to be:                    */
/*   ?9876543 210??sr? p???l??? h?????ba   */
/*   unused letters: cdefgijkmnoqtuvwxyz   */
/* chanflags:                              */
/*   ???????? ??vu?s?q ?onm?k?? ??f?d??a   */
/* + user defined A-Z                      */
/*   unused letters: bceghjlprtwxyz        */

#define USER_MASK    (0x001fffff) /* all non-userdef flags */
#define USER_CHANMASK 0x00017569  /* flags common to global & chan records */

#define USER_VALID    0x00B9f6Af
#define CHAN_VALID    0x00357429
#define BOT_VALID     0x7fe68881

#define USER_AUTOOP   0x00000001  /* a   auto-op - future */
#define USER_BOT      0x00000002  /* b   user is a bot */
#define USER_COMMON   0x00000004  /* c   user is actually a public irc site */
#define USER_DEOP     0x00000008  /* d   user is global de-op */
#define USER_E        0x00000010  /* e   unused */
#define USER_FRIEND   0x00000020  /* f   user is global friend*/
#define USER_G        0x00000040  /* g   unused */
#define USER_HIGHLITE 0x00000080  /* h   set this if you want highlighting */
#define USER_I        0x00000100  /* i   unused */
#define USER_JANITOR  0x00000200  /* j   user has file area master */
#define USER_KICK     0x00000400  /* k   user is global auto-kick */
#define USER_L        0x00000800  /* l   unused */
#define USER_MASTER   0x00001000  /* m   user has full bot access */
#define USER_OWNER    0x00002000  /* n   user is the bot owner */
#define USER_OP       0x00004000  /* o   user is +o on all channels */
#define USER_PARTY    0x00008000  /* p   user has party line access */
#define USER_QUIET    0x00010000  /* q   never let 'em get a voice */
#define USER_R        0x00020000  /* r   unused */
#define USER_S        0x00040000  /* s   unused */
#define USER_BOTMAST  0x00080000  /* t   user is botnet master */
#define USER_UNSHARED 0x00100000  /* u   not shared with sharebots */
#define USER_VOICE    0x00200000  /* v   auto-voice on join */
#define USER_W        0x00400000  /* w   unused */
#define USER_XFER     0x00800000  /* x   user has file area access */
#define USER_Y        0x01000000  /* y   unused */
#define USER_Z        0x02000000  /* z   unused */

/* flags specifically for bots */
#define BOT_ALT       0x00000001  /* a   auto-link here if all +h's fail */
#define BOT_BOT       0x00000002  /* b   sanity bot flag */
#define BOT_C         0x00000004  /* c   unused */
#define BOT_D         0x00000008  /* d   unused */
#define BOT_E         0x00000010  /* e   unused */
#define BOT_F         0x00000020  /* f   unused */
#define BOT_G         0x00000040  /* g   unused */
#define BOT_HUB       0x00000080  /* h   auto-link to ONE of these bots */
#define BOT_I         0x00000100  /* i   unused */
#define BOT_J         0x00000200  /* j   unused */
#define BOT_K         0x00000400  /* k   unused */
#define BOT_LEAF      0x00000800  /* l   may not link other bots */
#define BOT_M         0x00001000  /* m   unused */
#define BOT_N         0x00002000  /* n   unused */
#define BOT_O         0x00004000  /* o   unused */
#define BOT_PASSIVE   0x00008000  /* p   share passively with this bot */
#define BOT_Q         0x00010000  /* q   unused */
#define BOT_REJECT    0x00020000  /* r   automatically reject anywhere */
#define BOT_AGGRESSIVE 0x00040000  /* s   bot shares user files */
#define BOT_T         0x00080000  /* t   unused */
#define BOT_U         0x00100000  /* u   unused */
#define BOT_V         0x00200000  /* v   unused */
#define BOT_W         0x00400000  /* w   unused */
#define BOT_X         0x00800000  /* x   unused */
#define BOT_Y         0x01000000  /* y   unused */
#define BOT_Z         0x02000000  /* z   unused */
#define BOT_FLAG0     0x00200000  /* 0   user-defined flag #0 */
#define BOT_FLAG1     0x00400000  /* 1   user-defined flag #1 */
#define BOT_FLAG2     0x00800000  /* 2   user-defined flag #2 */
#define BOT_FLAG3     0x01000000  /* 3   user-defined flag #3 */
#define BOT_FLAG4     0x02000000  /* 4   user-defined flag #4 */
#define BOT_FLAG5     0x04000000  /* 5   user-defined flag #5 */
#define BOT_FLAG6     0x08000000  /* 6   user-defined flag #6 */
#define BOT_FLAG7     0x10000000  /* 7   user-defined flag #7 */
#define BOT_FLAG8     0x20000000  /* 8   user-defined flag #8 */
#define BOT_FLAG9     0x40000000  /* 9   user-defined flag #9 */

#define BOT_SHARE    (BOT_AGGRESSIVE|BOT_PASSIVE)

/* flag checking macros */

#define chan_op(x) ((x).chan & USER_OP)
#define glob_op(x) ((x).global & USER_OP)
#define chan_deop(x) ((x).chan & USER_DEOP)
#define glob_deop(x) ((x).global & USER_DEOP)
#define glob_master(x) ((x).global & USER_MASTER)
#define glob_bot(x) ((x).global & USER_BOT)
#define glob_owner(x) ((x).global & USER_OWNER)
#define chan_master(x) ((x).chan & USER_MASTER)
#define chan_owner(x) ((x).chan & USER_OWNER)
#define chan_autoop(x) ((x).chan & USER_AUTOOP)
#define glob_autoop(x) ((x).global & USER_AUTOOP)
#define chan_kick(x) ((x).chan & USER_KICK)
#define glob_kick(x) ((x).global & USER_KICK)
#define chan_voice(x) ((x).chan & USER_VOICE)
#define glob_voice(x) ((x).global & USER_VOICE)
#define chan_quiet(x) ((x).chan & USER_QUIET)
#define glob_quiet(x) ((x).global & USER_QUIET)
#define chan_friend(x) ((x).chan & USER_FRIEND)
#define glob_friend(x) ((x).global & USER_FRIEND)
#define glob_botmast(x) ((x).global & USER_BOTMAST)
#define glob_party(x) ((x).global & USER_PARTY)
#define glob_xfer(x) ((x).global & USER_XFER)
#define glob_hilite(x) ((x).global & USER_HIGHLITE)

#ifndef MAKING_MODS
void get_user_flagrec (struct userrec *, struct flag_record *, char *);
void set_user_flagrec (struct userrec *, struct flag_record *, char *);
void break_down_flags (char *, struct flag_record *, struct flag_record *);
int build_flags (char *, struct flag_record *, struct flag_record *);
int flagrec_eq (struct flag_record *, struct flag_record *);
int flagrec_ok (struct flag_record *, struct flag_record *);
int sanity_check (int);
int chan_sanity_check (int,int);
char geticon (int);
#endif
