/* 
 * irctree.c   - By ]RisK[ - 29 Des 1999
 *                
 */

#define MAKING_IRCTREE
#define MODULE_NAME "irctree"
#include "../module.h"
#include "../server.mod/server.h"
#include <stdlib.h>

#undef global
#define ROWS 128
#define CLOS 64

char x[ROWS][CLOS];
char y[ROWS][CLOS];
char z[ROWS][256];
/*         c r h t f*/
int q[] = {0,0,0,0,0};
int w[20];

static Function * global = NULL, *server_funcs = NULL;

static int irctree_expmem()
{
	int size = 0;
	context;
	size += sizeof(x);
	size += sizeof(y);
	size += sizeof(z);
	size += sizeof(q);
	size += sizeof(w);
	return size;
}

static void irctree_checks()
{
	int i;
	context;
	if (q[4]) {
		for (i = 0; i < q[1]; i++) {
			if (server_online) {
				dprintf(w[i], "Ops, I cant complete your irctree request because the server didnt not respond the LINKS request it may be stoned :(\n");
			} else {
				dprintf(w[i], "Ops, I cant complete your irctree request because I am not connected to the server anymore :(\n");
			}
			q[0]=0;
		}
	} else {
		if (q[2]) q[4]++;
	}
}

static int cmd_irctree(struct userrec *u, int idx, char *par)
{
	int i;
	context;
	if (!server_online) {
		dprintf(idx, "I am not on a server :(\n");
		for (i = 0; i < q[1]; i++) {
			dprintf(w[i], "Ops, I cant complete your irctree request because I am not connected to the server anymore :(\n");
		}
		q[0]=0;
		return 0;
	}
	putlog(LOG_CMDS, "*", "#%s# irctree", dcc[idx].nick);
	/* hmm .. already doing a graph.. */
	if (q[2]) {
		for (i = 0; i < q[1]; i++) {
			if (w[i] == idx) {
				dprintf(idx, "Chill dude I remember you!\n");
				return 0;
			}
		}
		w[q[1]]=idx;
		q[1]++;
	} else {
		dprintf(DP_MODE, "LINKS\n");
		q[0]=0;
		w[0]=idx;
		q[1]=1;
		q[2]++;
		q[4]=0;
	}
	return 0;
}

/* a report on the module status */
static void irctree_report(int idx, int details)
{
	int size;
	context;
	size = irctree_expmem();
	if (details)
	dprintf(idx, "    Using %d bytes of memory\n", size);
}


static cmd_t C_dcc[] =
{
  {"irctree", "", cmd_irctree, NULL},
};

int prout(char *buf)
{
	context;
	strcpy(z[q[3]],buf);
	q[3]++;
	return 1;
}

static char *lindex(char *destination, char *source, int p1)
{
	char *dst = destination;
	char *src = source;
    int p2=(p1+1);
    int a1=0;
    int a2=0; 
	while(a1<strlen(source)){
		if (*(src+a1)==' ') {
			a2++;
			if (a2==p2) break;
		} else {
			if (a2==p1) {
				*dst++ = *(src+a1);
			}
		}
		a1++;
	}
	*dst = '\0';
	return dst;
}

static int raw_364(char *from, char *msg)
{
	int i;
	char tmp[CLOS];
	context;
	lindex(tmp, msg, 1);
	i=0;
	while(tmp[i]) {
		x[q[0]][i] = tmp[i];
		i++;
	}
	x[q[0]][i] = '\0';
	lindex(tmp, msg, 2);
	i=0;
	while(tmp[i]) {
		y[q[0]][i] = tmp[i];
		i++;
	}
	y[q[0]][i] = '\0';
	q[0]++;
	return 0;
}

static int draw()
{
	int i, i2, lev = 0, more = 1, ok, imark, mark[20];
	char sl[20][CLOS];
	char work[1024];
	char pre[4];
	char buf[2048];
	int hops = 0;
	while(more) {
		if (lev == 20) return 0;
    	if (lev == 0) {
    		for (i = 0; i < q[0]; i++) {
    			if (strcmp(x[i], y[i]) == 0) {
    				strcpy(sl[lev], x[i]);
    				snprintf(buf,sizeof(buf), "%s\n", x[i]);
    				prout(buf);
    				x[i][0]='\0';
    				y[i][0]='\0';
    				lev++;
    				break;
    			}
    		}
    	}
    	ok=0;
    	for (i = 0; i < q[0]; i++) {
    		if (strcmp(sl[lev-1], y[i]) == 0) {
    			strcpy(sl[lev], x[i]);
    			ok=0;
    			for (i2 = 0; i2 < q[0]; i2++) {
    				if (strcmp(sl[lev-1], y[i2]) == 0 && strcmp(x[i], x[i2]) != 0) {
    					pre[0] = '|';pre[1] = '-';pre[2] = '\0';
    					mark[lev] = 1;
    					ok=1;
    				}
    			}
    			if (!ok) {
    				pre[0] = '`';pre[1] = '-';pre[2] = '\0';
    				mark[lev] = 0;
    			}
    			imark = 0;
    			work[0] = '\0';
				for (i2 = 1; i2 < lev; i2++) {
					if (mark[i2])
						strcpy(work + imark, "|   ");
					else
						strcpy(work + imark, "    ");
					imark += 4;
				}
				hops += lev;
    			snprintf(buf,sizeof(buf), "  %s%s%s\n", work, pre, x[i]);
    			prout(buf);
    			x[i][0]='\0';
    			y[i][0]='\0';
    			ok=1;
    			lev++;
    			break;
    		}
    	}
    	if (!ok) {
    		lev=lev-1;
    		if (lev==0) more=0;
    	}
	}
	snprintf(buf,sizeof(buf), "Average hops: %3.1f, total servers: %d\n", ((float) hops) / ((float) q[0] - 1), q[0]);
	prout(buf);
	return 1;
}

static int raw_365(char *from, char *msg)
{
	int i, i2;
	context;
	q[3]=0;
	if (!draw()) {
		for (i = 0; i < q[1]; i++) {
			dprintf(w[i], "Tree too complex!");
		}
	}
	for (i = 0; i < q[1]; i++) {
		for (i2 = 0; i2 < q[3]; i2++) {
			dprintf(w[i], "%s", z[i2]);
		}
	}
	q[1]=0;
	q[2]=0;
	return 0;
}

static cmd_t C_raw[] =
{
  {"364", "", (Function) raw_364, NULL},
  {"365", "", (Function) raw_365, NULL},
};

static char *irctree_close()
{
  context;
  rem_builtins(H_dcc, C_dcc, 1);
  rem_builtins(H_raw, C_raw, 2);
  del_hook(HOOK_MINUTELY, irctree_checks);
  module_undepend(MODULE_NAME);
  return NULL;
}

char *irctree_start();

static Function irctree_table[] =
{
  (Function) irctree_start,
  (Function) irctree_close,
  (Function) irctree_expmem,
  (Function) irctree_report,
};

char *irctree_start(Function * global_funcs)
{
	global = global_funcs;
	context;
	module_register(MODULE_NAME, irctree_table, 1, 0);
	if (!(server_funcs = module_depend(MODULE_NAME, "server", 1, 0)))
		return "You need the server module to use the irctree module.";
	if (!module_depend(MODULE_NAME, "eggdrop", 103, 0))
		return "This module requires eggdrop1.3.0 or later";
	context;
	add_builtins(H_dcc, C_dcc, 1);
	add_builtins(H_raw, C_raw, 2);
	add_hook(HOOK_MINUTELY, irctree_checks);
	return NULL;
}
