/*
 * dcc.c 	- Allows Eggdrop to dcc chat people
 *                syntax /msg <bot> !chat <pass>
 *          
 *  Send comments/flames/suggestions to capsterx@hotmail.com
 *
 * I Wrote this for my self, but figured someone out there might have use for it
 * and maby someone could help me improve it.  I wrote this pretty quickly,
 * using eggdrop source and transfer.mod as a guide.  It shouldent crash the
 * bot or leave idx's arround anymore, but no guarantee's on anything.
 * If you like it or improve it please tell me. 
 *
 * 		  By vod - 21 July 1998	
 */

#define MODULE_NAME "DCC"
#define MAKING_DCC
#include "../module.h"
#include "../../tandem.h"
#include "../server.mod/server.h"

static Function * global = NULL, *server_funcs = NULL;
static int chat_open_timeout = 180;

void eof_dcc_chat_wait (int idx) {
   putlog(LOG_MISC, "*", "LOST DCC CHAT REQUEST: [%s] (%s!%s)",
        dcc[idx].user->handle, dcc[idx].nick, dcc[idx].host);
   killsock(dcc[idx].sock);
   lostdcc(idx);
}

void tout_dcc_chat_wait (int idx) {
   putlog(LOG_MISC, "*", "Timeout dcc chatting: [%s] (%s!%s)",
         dcc[idx].user->handle, dcc[idx].nick, dcc[idx].host);
   killsock(dcc[idx].sock);
   lostdcc(idx);
}

/* what is this for anyways */
void display_dcc_chat_wait (int idx,char * buf) {
   sprintf(buf, "wait  waited %lus", now - dcc[idx].timeval);
}

/* activity on sock */
void dcc_chat_wait (int idx,char * buf,int len) {
   unsigned long ip;
   unsigned short port;
   struct chat_info *ci;
   int i;
   char s[UHOSTLEN];
   context;
/* answer */
   i = answer(dcc[idx].sock, s, &ip, &port, 0);
/* kill listen sock */
   killsock(dcc[idx].sock);
/*setup dcc sock*/
   dcc[idx].sock = i;
   dcc[idx].addr = ip;
   dcc[idx].port = (int) port;
   dcc[idx].status = STAT_CALLED;
/* pass contorol back to eggdrop */
   dcc[idx].type = &DCC_CHAT_PASS;
   buf = NULL;
   dcc[idx].timeval = now;
   dcc[idx].status |= STAT_PARTY;
/* allocate */
   ci = dcc[idx].u.chat;
   dcc[idx].u.file = get_data_ptr(sizeof(struct file_info));
   dcc[idx].u.file->chat = ci;
   putlog(LOG_MISC, "*", "DCC CHAT Accepted: [%s] (%s!%s)",
        dcc[idx].user->handle, dcc[idx].nick, dcc[idx].host);
   dprintf(idx, "Enter your password.\n");
/* eggdrop has full contorol */
}

struct dcc_table DCC_CHAT_WAIT={
   "CHAT_WAIT",
   0,
   eof_dcc_chat_wait,
   dcc_chat_wait,
   &chat_open_timeout,
   tout_dcc_chat_wait,
   display_dcc_chat_wait,
   0,
   0,
   0
};

/* open dcc chat */
static int dcc_chat_open(char *nick, char *host, struct userrec *u)
{
   int zz, i, port;
   port = reserved_port;
/* new listen port */
   zz = open_listen(&port);
   if (zz == (-1)) return 1;
/* new idx */
   if((i = new_dcc(&DCC_CHAT_WAIT,0)) == -1);
   dcc[i].sock = zz;
/* whats the next line do, whats that number? */
   dcc[i].addr = (IP) (-559026163);
   dcc[i].port = port;
/* pass along nick, host, userinfo struct */
   strcpy(dcc[i].nick, nick);
   strcpy(dcc[i].host, host);
   dcc[i].user = get_user_by_handle(userlist,u->handle);
/* send dcc chat request to person */
   dprintf(DP_SERVER, "PRIVMSG %s :\001DCC CHAT chat %lu %d\001\n",
         nick, iptolong(getmyip()), dcc[i].port);
   dcc[i].timeval = now;
   return 0;
}

/* !chat func */
static int msg_chat (char * nick, char * host, struct userrec * u, char * par)
{
   context;

   if (u == NULL) {
     putlog(LOG_MISC, "*", "DCC CHAT REQUEST: %s!%s : Invalid User", nick,
        host);
     return 1;
   }

   if (!u_pass_match(u, par)) {
     putlog(LOG_MISC, "*", "DCC CHAT REQUEST: [%s] (%s!%s) : Wrong Pass",
        u->handle, nick, host);
     return 1;
   }

   putlog(LOG_MISC, "*", "DCC CHAT REQUEST: [%s] (%s!%s) : Sending", u->handle,
        nick, host);
   dcc_chat_open(nick, host, u);
   return 0;
}


static tcl_ints my_tcl_ints[] = {
  {"dcc-open-telnet", &chat_open_timeout, 0},
};

static cmd_t C_msg[]={
  { "!chat", "", msg_chat, NULL},
};

static int dcc_expmem ()
{
   return 0;
}

/* mod open/close/functions, blah */
static char *dcc_close()
{
   int i;
   context;
   putlog(LOG_MISC, "*", "Unloading dcc mod, killing all dcc reqests..");
   for (i = 0; i < dcc_total; i++) {
     if (dcc[i].type == &DCC_CHAT_WAIT)
       eof_dcc_chat_wait(i); 
   }
   rem_tcl_ints(my_tcl_ints);
   rem_builtins(H_msg,C_msg,1);
   module_undepend(MODULE_NAME);
   return NULL;
}

char *dcc_start ();
static Function dcc_table[] =
{
   (Function) dcc_start,
   (Function) dcc_close,
   (Function) dcc_expmem,
   (Function) 0,
};
char *dcc_start (Function* global_funcs)
{
   global = global_funcs;
   context;
   module_register(MODULE_NAME, dcc_table, 1, 1);
   if (!(server_funcs = module_depend(MODULE_NAME, "server", 1, 0)))
      return "You need the server module to use the bot module.";
   context;
   add_builtins(H_msg,C_msg,1);
   add_tcl_ints(my_tcl_ints);
   context;
   return NULL;
}
