/*
		Display program for BL files, which record broadcast server activity.
		This code is not particularly portable. It was written for Microsoft C under DOS.
		It will also compile under Quick C for windows, and the unixtime module sorts
		out the problem that ANSI standard time is not the same as good old unix time.

		fFixed - 	This flag is FALSE for early UoSAT-3 and UoSAT-5 BL files because there was
						  a bug in the onboard logging task wich caused incorrect counts in the
						  entries for overwritten requests and un-fresh requests.

		Original: Jeff Ward, Surrey Satellite Technology, Ltd.
*/
/*
		History:
		19 April 1993
		Added ability to read the version from the log file if the first entry
		in the log file has length 2. Otherwise version is assumed to be
		version 1.
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>

#include "viewlog.h"
#include "blogdisp.h"

#define MAGIC 25569.0

char writebuf[200];

struct STAT_STRUCT stats;
int fBytemode = FALSE;													/* Display byte counts */
int fCmdmode = FALSE;														/* Display command counts */
int fDirmode = FALSE;														/* Display dir counts */
int first = TRUE;

int blogdisp(FILE *pFile)
{
	short len;
	short version;
	int i;

	if ((version = GetVer(pFile)) == 0)
		return(1);

	for (i = 0; i < 3; i++)
	{
		switch (i)
		{
			case 0:
				fBytemode = TRUE;
				fCmdmode  = FALSE;
				fDirmode  = FALSE;
				break;
			case 1:
				fBytemode = FALSE;
				fCmdmode  = TRUE;
				fDirmode  = FALSE;
				break;
			default:
				fBytemode = FALSE;
				fCmdmode  = FALSE;
				fDirmode  = TRUE;
				break;
		}

		first = TRUE;
	
		fseek(pFile, 0L, SEEK_SET);

		GetVer(pFile);

		while (!feof(pFile))
		{
			if (fread(&len, sizeof(short), 1, pFile)) 
				if (fread(&stats, len, 1, pFile))
					process(&stats, version);
		}

		writetext("\n");
	}

	return(0);
}

short GetVer(FILE * pFile)
{
	short ver = -1;
	short len;

	if (fread(&len, sizeof(short), 1, pFile))
	{
		if (len == 2)
		{
			fread(&ver, 2, 1, pFile);
		}
		else
		{
			ver = 1;
			fseek(pFile, 0L, SEEK_SET);
		}
	}

	return ver;
}

/*------------------------------------------------*/
/* Display whichever values the user wanted to	  */
/* display, as indicated by display flags.	  */
/*------------------------------------------------*/

int process(struct STAT_STRUCT *pStats, short version)
{
	struct tm *ptm;
	long residue;

	ptm = gmtime(&pStats->LogTime);

	if (first)
	{
		sprintf(writebuf, "Broadcast activity %02d/%02d/%02d - ", ptm->tm_mday, ptm->tm_mon+1, ptm->tm_year);
		writetext(writebuf);

		if (fCmdmode)
			writetext("(Commands)\n\n");
		else if (fBytemode)
			writetext("(Bytes)\n\n");
		else if (fDirmode)
			writetext("(Directories)\n\n");

		if (fBytemode)
		{
			writetext("HH:MM    Req'd     Tx'd     OvrWr   TooOld    Ended    Fopen   PFHerr      EOF\n");
		}
		else if (fCmdmode)
		{
			writetext("HH:MM Start  Fill   End  Long  NO-1  NO-2  NO-3  Stations\n");
		}
		else if (fDirmode)
		{
			writetext("HH:MM Requests  Bytes Tx'd\n");
		}

		first = FALSE;
	}

	sprintf(writebuf, "%02d:%02d ", ptm->tm_hour, ptm->tm_min);
	writetext(writebuf);

	if (fCmdmode)
	{
		sprintf(writebuf, "% 5ld ", pStats->nStartFile);
		writetext(writebuf);
		sprintf(writebuf, "% 5ld ", pStats->nHolefills);
		writetext(writebuf);
		sprintf(writebuf, "% 5ld ", pStats->nEndFile);
		writetext(writebuf);
		sprintf(writebuf, "% 5d ", pStats->nLongFile);
		writetext(writebuf);
		sprintf(writebuf, "% 5ld ", pStats->nNoFile);
		writetext(writebuf);
		sprintf(writebuf, "% 5ld ", pStats->nNoRoom);
		writetext(writebuf);
		sprintf(writebuf, "% 5ld ", pStats->nNotOK);
		writetext(writebuf);
		sprintf(writebuf, "% 5d", pStats->nNewStns);
		writetext(writebuf);
	}
	else if (fBytemode)
	{
		sprintf(writebuf, "%8ld ", pStats->nbRequested);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbTransmitted);
		writetext(writebuf);
		sprintf(writebuf, "%9lu ", pStats->nbOverwrite);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbUnfresh);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbEnd);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbFopenErr);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbPfhErr);
		writetext(writebuf);
		sprintf(writebuf, "%8ld ", pStats->nbEof);
		writetext(writebuf);
		residue = pStats->nbRequested - (pStats->nbTransmitted +
							pStats->nbOverwrite + pStats->nbUnfresh +
							pStats->nbEnd + pStats->nbFopenErr + pStats->nbPfhErr +
							pStats->nbEof);
		sprintf(writebuf, " (%7ld)", residue);
		writetext(writebuf);
	}
	else if (fDirmode)
	{
		sprintf(writebuf, "   %5ld    ", pStats->nDirReqs);
		writetext(writebuf);
		sprintf(writebuf, "%8ld", pStats->nbDirTxd);
		writetext(writebuf);
	}

	writetext("\n");

	return 1;
}

