#
# Gtkinter: Wrapper for the gtk module.  This one gives an object oriented
#           feel for the library.  Just type "from Gtkinter import *"
#
# Author: James Henstridge <james@daa.com.au>
#
# TODO
# 1. document some of this (maybe all of it)
# 2. fix up GtkImage (no one has needed it yet so it is low priority)

# The _obj argument in each constructor is used to create a Gtkinter object
# that coresponds to an already created GTK Object.  It should be possible
# to call any of the Gtkinter object constructors something like this:
# GtkContainer(_obj=gtk_obj) where gtk_obj is an already created GtkObject.
#
# To make the use of this system easier, you can use the _obj2inst function
# to create a Gtkinter object of the correct type from a GtkObject.  This
# is the function the new() command uses.

from GTK import *
import GDK    # make the GDK constants available
import _gtk, _gtkbase
import sys, os

# this sets up i18n input stuff
_gtkbase.gtk_set_locale()

# initialise GTK (only if it can find the display -- this avoids segfaults)
if '--display' in sys.argv or os.environ.has_key('DISPLAY'):
	_gtkbase.gtk_init()
else:
	print 'No display information -- gtk_init not called'
del sys, os

# this makes the _gtk module aware of the types and functions in _gtkbase
_gtk.pygtk_init()

class GtkObject:
	get_type = _gtkbase.gtk_object_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set(self, dict):
		_filtprops(dict)
		_gtkbase.gtk_object_set(self._o, dict)
	def __getitem__(self, key):
		ret = _gtkbase.gtk_object_get(self._o, key)
		if type(ret) == _gtkbase.GtkObjectType:
			return _obj2inst(ret)
		else:
			return ret
	def __setitem__(self, key, v):
		if hasattr(v, '_o') and type(v._o) == _gtkbase.GtkObjectType:
			v = v._o
		_gtkbase.gtk_object_set(self._o, {key: v});
	def __cmp__(self, other):
	        if hasattr(other, '_o'):
			return cmp(self._o, other._o)
		else:
			return cmp(id(self), id(other))
	def flags(self, mask=None):
		if mask:
			return _gtkbase.GTK_OBJECT_FLAGS(self._o) & mask
		else:
			return _gtkbase.GTK_OBJECT_FLAGS(self._o)
	def set_flags(self, flags):
		_gtkbase.GTK_OBJECT_SET_FLAGS(self._o, flags)
	def unset_flags(self, flags):
		_gtkbase.GTK_OBJECT_UNSET_FLAGS(self._o, flags)
	def set_data(self, key, value):
		_gtkbase.gtk_object_set_data(self._o, key, value)
	def get_data(self, key):
		return _gtkbase.gtk_object_get_data(self._o, key)
	def remove_data(self, key):
		_gtkbase.gtk_object_remove_data(self._o)
	class __cnv:
		def __init__(self, func):
			self.func = func
		def __call__(self, *args):
			a = list(args)
			for i in range(len(args)):
				if type(args[i]) == _gtkbase.GtkObjectType:
					a[i] = _obj2inst(args[i])
			a = tuple(a)
			return apply(self.func, a)
	def connect(self, name, f, *extra):
		callback = self.__cnv(f)
		return _gtkbase.gtk_signal_connect(self._o, name,
						   callback.__call__, extra)
	signal_connect = connect
	def connect_after(self, name, f, *extra):
		callback = self.__cnv(f)
		return _gtkbase.gtk_signal_connect_after(self._o, name,
						     callback.__call__, extra)
	signal_connect_after = connect_after
	def disconnect(self, id):
		_gtkbase.gtk_signal_disconnect(self._o, id)
	def signal_handler_block(self, id):
		_gtkbase.gtk_signal_handler_block(self._o, id)
	def signal_handler_unblock(self, id):
		_gtkbase.gtk_signal_handler_unblock(self._o, id)
	def signal_handlers_destroy(self):
		_gtkbase.gtk_signal_handlers_destroy(self._o)
	def emit(self, signal, *args):
		params = []
		for i in args:
			if hasattr(i, '_o'): params.append(i._o)
			elif hasattr(i, '_ag'): params.append(i._ag)
			else: params.append(i)
		return _gtkbase.gtk_signal_emitv_by_name(self._o,signal,params)
	def emit_stop_by_name(self, sig):
		_gtkbase.gtk_signal_emit_stop_by_name(self._o, sig)

class GtkData(GtkObject):
	get_type = _gtk.gtk_data_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return

class GtkAdjustment(GtkData):
	get_type = _gtk.gtk_adjustment_get_type
	def __init__(self, value=0, lower=0, upper=0, step_incr=0, page_incr=0,
			page_size=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_adjustment_new(value, lower, upper,
					  step_incr, page_incr, page_size)
	def __getattr__(self, attr):
		attrs = {
		'lower': _gtk.gtk_adjustment_get_lower,
		'upper': _gtk.gtk_adjustment_get_upper,
		'value': _gtk.gtk_adjustment_get_value,
		'step_increment': _gtk.gtk_adjustment_get_step_increment,
		'page_increment': _gtk.gtk_adjustment_get_page_increment,
		'page_size': _gtk.gtk_adjustment_get_page_size
		}
		if attr in attrs.keys():
			return attrs[attr](self._o)
		raise AttributeError, attr
	def set_value(self, value):
		_gtk.gtk_adjustment_set_value(self._o, value)
	def clamp_page(self, lower, upper):
		_gtk.gtk_adjustment_clamp_page(self._o, lower, upper)
	def changed(self, obj=None):
		_gtk.gtk_adjustment_changed(self._o)
	def value_changed(self, obj=None):
		_gtk.gtk_adjustment_value_changed(self._o)

class GtkTooltips(GtkData):
	get_type = _gtk.gtk_tooltips_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_tooltips_new()
	def enable(self):
		_gtk.gtk_tooltips_enable(self._o)
	def disable(self, obj=None):
		_gtk.gtk_tooltips_disable(self._o)
	def set_delay(self, delay):
		_gtk.gtk_tooltips_set_delay(self._o, delay)
	def set_tip(self, w, tip, tip_private):
		_gtk.gtk_tooltips_set_tip(self._o, w._o, tip, tip_private)
	def set_tips(self, w, tip):
		print "GtkTooltip.set_tips deprecated -- use set_tip instead"
		self.set_tip(w, tip, tip)
	def set_colors(self, back, fore):
		_gtk.gtk_tooltips_set_colors(self._o, back, fore)

class GtkWidget(GtkObject):
	_gtkbase.gtk_widget_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	# extra parameter is so that these funcs can be used as signal funcs
	def activate(self, obj=None):
		_gtkbase.gtk_widget_activate(self._o)
	def add_accelerator(self, signal, group, key, mods, flags):
		_gtkbase.gtk_widget_add_accelerator(self._o, signal, group._ag,
						key, mods, flags)
	def basic(self, obj=None):
		_gtkbase.gtk_widget_basic(self._o)
	def destroy(self, obj=None):
		_gtkbase.gtk_widget_destroy(self._o)
	def dnd_drag_add(self, obj=None):
		_gtkbase.gtk_widget_dnd_add(self._o)
	def dnd_drag_set(self, enable, types):
		_gtkbase.gtk_widget_dnd_drag_set(self._o, enable, types)
	def dnd_drop_set(self, enable, types, destructive):
		_gtkbase.gtk_widget_dnd_drop_set(self._o, enable, types,
					     destructive)
	def dnd_data_set(self, event, data):
		_gtkbase.gtk_widget_dnd_data_set(self._o, event, data)
	def draw(self, rect):
		_gtkbase.gtk_widget_draw(self._o, rect)
	def draw_children(self, obj=None):
		_gtkbase.gtk_widget_draw_children(self._o)
	def draw_default(self, obj=None):
		_gtkbase.gtk_widget_draw_default(self._o)
	def draw_focus(self, obj=None):
		_gtkbase.gtk_widget_draw_focus(self._o)
	def ensure_style(self):
		_gtkbase.gtk_widget_ensure_style(self._o)
	def event(self, event):
		_gtkbase.gtk_widget_event
	def freeze_accelerators(self):
		_gtkbase.gtk_widget_freeze_accelerators(self._o)
	def get_ancestor(self, type):
		return _obj2inst(_gtkbase.gtk_widget_get_ancestor(self._o, type))
	def get_events(self):
		return _gtkbase.gtk_widget_get_events(self._o)
	def get_extension_events(self):
		return _gtkbase.gtk_widget_get_extension_events(self._o)
	def get_name(self):
		return _gtkbase.gtk_widget_get_name(self._o)
	def get_parent_window(self):
		return _gtkbase.gtk_widget_get_parent_window(self._o)
	def get_pointer(self):
		return _gtkbase.gtk_widget_get_pointer(self._o)
	def get_style(self):
		return _gtkbase.gtk_widget_get_style(self._o)
	def get_toplevel(self):
		return _obj2inst(_gtkbase.gtk_widget_get_toplevel(self._o))
	def get_window(self):
		return _gtkbase.gtk_widget_get_window(self._o)
	def grab_focus(self, obj=None):
		_gtkbase.gtk_widget_grab_focus(self._o)
	def grab_default(self, obj=None):
		_gtkbase.gtk_widget_grab_default(self._o)
	def hide(self, obj=None):
		_gtkbase.gtk_widget_hide(self._o)
	def hide_all(self, obj=None):
		_gtkbase.gtk_widget_hide_all(self._o)
	def hide_on_delete(self, obj=None):
		return _gtkbase.gtk_widget_hide_on_delete(self._o)
	def intersect(self, rect):
		return _gtkbase.gtk_widget_intersect(self._o, rect)
	def is_ancestor(self, a):
		return _gtkbase.gtk_widget_is_ancestor(self._o, a._o)
	def is_child(self, c):
		return _gtkbase.gtk_widget_is_child(self._o, c._o)
	def map(self, obj=None):
		_gtkbase.gtk_widget_map(self._o)
	def popup(self, x, y):
		_gtkbase.gtk_widget_popup(self._o, x, y)
	def queue_draw(self, obj=None):
		_gtkbase.gtk_widget_queue_draw(self._o)
	def queue_resize(self, obj=None):
		_gtkbase.gtk_widget_queue_resize(self._o)
	def realize(self, obj=None):
		_gtkbase.gtk_widget_realize(self._o)
	def remove_accelerator(self, group, key, mods):
		_gtkbase.gtk_widget_remove_accelerator(self._o, group._ag,
						   key, mods)
	def remove_accelerators(self, signal, visible_only):
		_gtkbase.gtk_widget_remove_accelerators(self._o, signal,
						    visible_only)
	def reparent(self, new_parent):
		_gtkbase.gtk_widget_reparent(self._o, new_parent._o)
	def reset_rc_styles(self):
		_gtkbase.gtk_widget_reset_rc_styles(self._o)
	def restore_default_style(self):
		_gtkbase.gtk_widget_restore_default_style(self._o)
	def set_events(self, events):
		_gtkbase.gtk_widget_set_events(self._o, events)
	def set_extension_events(self, exevents):
		_gtkbase.gtk_widget_set_extension_events(self._o, exevents)
	def set_name(self, name):
		_gtkbase.gtk_widget_set_name(self._o, name)
	def set_parent(self, parent):
		_gtkbase.gtk_widget_set_parent(self._o, parent._o)
	def set_parent_window(self, parent):
		_gtkbase.gtk_widget_set_parent_window(self._o, parent)
	def set_sensitive(self, s):
		_gtkbase.gtk_widget_set_sensitive(self._o, s)
	def set_state(self, s):
		_gtkbase.gtk_widget_set_state(self._o, s)
	def set_style(self, style):
		_gtkbase.gtk_widget_set_style(self._o, style)
	def set_rc_style(self):
		_gtkbase.gtk_widget_set_rc_style(self._o)
	def set_uposition(self, x, y):
		_gtkbase.gtk_widget_set_uposition(self._o, x, y)
	def set_usize(self, w, h):
		_gtkbase.gtk_widget_set_usize(self._o, w, h)
	def shape_combine_mask(self, mask, ofs_x, ofs_y):
		if hasattr(mask, '_o'):
			tmp, mask = mask.get()
	        _gtkbase.gtk_widget_shape_combine_mask(self._o, mask, ofs_x, ofs_y)
	def show(self, obj=None):
		_gtkbase.gtk_widget_show(self._o)
	def show_all(self, obj=None):
		_gtkbase.gtk_widget_show_all(self._o)
	def show_now(self, obj=None):
	        _gtkbase.gtk_widget_show_now(self._o)
	def size_allocate(self, a):
		_gtkbase.gtk_widget_size_allocate(self._o, a)
	def size_request(self):
		return _gtkbase.gtk_widget_size_request(self._o)
	def thaw_accelerators(self):
		_gtkbase.gtk_widget_thaw_accelerators(self._o)
	def unmap(self, obj=None):
		_gtkbase.gtk_widget_unmap(self._o)
	def unparent(self):
		_gtkbase.gtk_widget_unparent(self._o)
	def unrealize(self, obj=None):
		_gtkbase.gtk_widget_unrealize(self._o)
	
class GtkContainer(GtkWidget):
	_gtkbase.gtk_container_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def add(self, child, **args):
		if args == {}:
			_gtkbase.gtk_container_add(self._o, child._o)
		else:
			_gtkbase.gtk_container_add(self._o, child._o, args)
	def border_width(self, bw):
		_gtkbase.gtk_container_border_width(self._o, bw)
	def check_resize(self):
		_gtkbase.gtk_container_check_resize(self._o)
	def child_set(self, child, **args):
		_gtkbase.gtk_container_child_set(self._o, child._o, args)
	def child_get(self, child, arg):
		return _gtkbase.gtk_container_child_get(self._o, child._o, arg)
	def children(self):
		l =  _gtkbase.gtk_container_children(self._o)
		return map(_obj2inst, l)
	def child_type(self):
		return _gtkbase.gtk_container_child_type(self._o)
	def focus(self, d):
		_gtkbase.gtk_container_focus(self._o, d)
	def foreach(self, f):
		for child in self.children():
			f(child)
	def register_toplevel(self):
		_gtkbase.gtk_container_register_toplevel(self._o)
	def remove(self, child):
		_gtkbase.gtk_container_remove(self._o, child._o)
	def resize_children(self):
		_gtkbase.gtk_container_resize_children(self._o)
	def set_focus_child(self, child):
		_gtkbase.gtk_container_set_focus_child(self._o, child._o)
	def set_focus_vadjustment(self, adj):
		_gtkbase.gtk_container_set_focus_vadjustment(self._o, adj._o)
	def set_focus_hadjustment(self, adj):
		_gtkbase.gtk_container_set_focus_hadjustment(self._o, adj._o)
	def set_resize_mode(self, mode):
		_gtkbase.gtk_container_set_resize_mode(self._o, mode)
	def unregister_toplevel(self):
		_gtkbase.gtk_container_unregister_toplevel(self._o)

class GtkBin(GtkContainer):
	get_type = _gtk.gtk_bin_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return

class GtkAlignment(GtkBin):
	get_type = _gtk.gtk_alignment_get_type
	def __init__(self, xa=0, ya=0, xs=0, ys=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_alignment_new(xa, ya, xs, ys)
	def set(self, xa, ya, xs, ys):
		_gtk.gtk_alignment_set(self._o, xa, ya, xs, ys)

class GtkButton(GtkBin):
	get_type = _gtk.gtk_button_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_button_new()
		else:
			self._o = _gtk.gtk_button_new_with_label(label)
	def pressed(self, obj=None):
		_gtk.gtk_button_pressed(self._o)
	def released(self, obj=None):
		_gtk.gtk_button_released(self._o)
	def clicked(self, obj=None):
		_gtk.gtk_button_clicked(self._o)
	def enter(self, obj=None):
		_gtk.gtk_button_enter(self._o)
	def leave(self, obj=None):
		_gtk.gtk_button_leave(self._o)
	def set_relief(self, style):
		_gtk.gtk_button_set_relief(self._o, style)
	def get_relief(self):
		return _gtk.gtk_button_get_relief(self._o)

class GtkOptionMenu(GtkButton):
	get_type = _gtk.gtk_option_menu_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_option_menu_new()
	def get_menu(self):
		return _obj2inst(_gtk.gtk_option_menu_get_menu(self._o))
	def set_menu(self, menu):
		_gtk.gtk_option_menu_set_menu(self._o, menu._o)
	def remove_menu(self):
		_gtk.gtk_option_menu_remove_menu(self._o)
	def set_history(self, index):
		_gtk.gtk_option_menu_set_history(self._o, index)

class GtkToggleButton(GtkButton):
	get_type = _gtk.gtk_toggle_button_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_toggle_button_new()
		else:
			self._o = _gtk.gtk_toggle_button_new_with_label(label)
	def __getattr__(self, attr):
	    attrs = {
		    'active': _gtk.gtk_toggle_button_get_active
	    }
	    if attrs.has_key(attr):
		    return attrs[attr](self._o)
	    raise AttributeError, attr
	def set_mode(self, di):
		_gtk.gtk_toggle_button_set_mode(self._o, di)
	def set_state(self, state):
		_gtk.gtk_toggle_button_set_state(self._o, state)
	def toggled(self, obj):
		_gtk.gtk_toggle_button_toggled(self._o)

class GtkCheckButton(GtkToggleButton):
	get_type = _gtk.gtk_check_button_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_check_button_new()
		else:
			self._o = _gtk.gtk_check_button_new_with_label(label)

class GtkRadioButton(GtkCheckButton):
	get_type = _gtk.gtk_radio_button_get_type
	def __init__(self, group=None, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			if group == None:
				self._o = _gtk.gtk_radio_button_new()
			else:
				self._o = \
					_gtk.gtk_radio_button_new_from_widget(
						group._o)
		else:
			if group == None:
				self._o = _gtk.gtk_radio_button_new_with_label(
					None, label)
			else:
				self._o = _gtk.gtk_radio_button_new_with_label_from_widget(group._o, label)

class GtkFrame(GtkBin):
	get_type = _gtk.gtk_frame_get_type
	def __init__(self, label="", _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_frame_new(label)
	def set_label(self, label):
		_gtk.gtk_frame_set_label(self._o, label)
	def set_label_align(self, x, y):
		_gtk.gtk_frame_set_label_align(self._o, x, y)
	def set_shadow_type(self, tp=SHADOW_ETCHED_IN):
		_gtk.gtk_frame_set_shadow_type(self._o, tp)

class GtkAspectFrame(GtkFrame):
	get_type = _gtk.gtk_aspect_frame_get_type
	def __init__(self, xa=0, ya=0, ratio=1, obey_child=1, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_aspect_frame_new(xa, ya, ratio, obey_child)
	def set(self, xa, ya, ratio, obey_child):
		_gtk.gtk_aspect_frame_set(self._o, xa, ya, ratio, obey_child)

class GtkEventBox(GtkBin):
	get_type = _gtk.gtk_event_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_event_box_new()

class GtkHandleBox(GtkBin):
	get_type = _gtk.gtk_handle_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_handle_box_new()

class GtkItem(GtkBin):
	get_type = _gtk.gtk_item_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def select(self, obj=None):
		_gtk.gtk_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_item_deselect(self._o)
	def toggle(self, obj=None):
		_gtk.gtk_item_toggle(self._o)

class GtkMenuItem(GtkItem):
	get_type = _gtk.gtk_menu_item_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_menu_item_new()
		else:
			self._o = _gtk.gtk_menu_item_new_with_label(label)
	def set_submenu(self, sub):
		_gtk.gtk_menu_item_set_submenu(self._o, sub._o)
	def set_placement(self, placement):
		_gtk.gtk_menu_item_set_placement(self._o, placement)
	def configure(self, show_toggle, show_sub):
		_gtk.gtk_menu_item_configure(self._o, show_toggle. show_sub)
	def select(self, obj=None):
		_gtk.gtk_menu_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_menu_item_deselect(self._o)
	def activate(self, obj=None):
		_gtk.gtk_menu_item_activate(self._o)
	def remove_submenu(self):
		_gtk.gtk_menu_item_remove_submenu(self._o)
	def right_justify(self, obj=None):
		_gtk.gtk_menu_item_right_justify(self._o)
		
class GtkCheckMenuItem(GtkMenuItem):
	get_type = _gtk.gtk_check_menu_item_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_check_menu_item_new()
		else:
			self._o =_gtk.gtk_check_menu_item_new_with_label(label)
	def __getattr__(self, attr):
		attrs = {
			'active': _gtk.gtk_check_menu_item_get_active
		}
		if attrs.has_key(attr):
			return attrs[attr](self._o)
		raise AttributeError, attr
	def set_show_toggle(self, always):
		_gtk.gtk_check_menu_item_set_show_toggle(self._o, always)
	def set_state(self, state):
		_gtk.gtk_check_menu_item_set_state(self._o, state)
	def toggled(self, obj=None):
		_gtk.gtk_check_menu_item_toggled(self._o)

class GtkRadioMenuItem(GtkCheckMenuItem):
	get_type = _gtk.gtk_radio_menu_item_get_type
	def __init__(self, group=None, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			if group == None:
				self._o = _gtk.gtk_radio_menu_item_new()
			else:
				self._o =_gtk.gtk_radio_menu_item_new(group._o)
		else:
			if group == None:
				self._o=_gtk.gtk_radio_menu_item_new_with_label(
					None, label)
			else:
				self._o=_gtk.gtk_radio_menu_item_new_with_label(
					group._o, label)

class GtkListItem(GtkItem):
	get_type = _gtk.gtk_list_item_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_list_item_new()
		else:
			self._o = _gtk.gtk_list_item_new_with_label(label)
	def select(self, obj=None):
		_gtk.gtk_list_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_list_item_deselect(self._o)

class GtkTreeItem(GtkItem):
	get_type = _gtk.gtk_tree_item_get_type
	def __init__(self, label=None, _obj=None):
		if _obj: self._o = _obj; return
		if label == None:
			self._o = _gtk.gtk_tree_item_new()
		else:
			self._o = _gtk.gtk_tree_item_new_with_label(label)
	def set_subtree(self, subtree):
		_gtk.gtk_tree_item_set_subtree(self._o, subtree._o)
	def select(self, obj=None):
		_gtk.gtk_tree_item_select(self._o)
	def deselect(self, obj=None):
		_gtk.gtk_tree_item_deselect(self._o)
	def expand(self, obj=None):
		_gtk.gtk_tree_item_expand(self._o)
	def collapse(self, obj=None):
		_gtk.gtk_tree_item_collapse(self._o)
	def remove_subtree(self):
		_gtk.gtk_tree_item_remove_subtree(self._o)

class GtkViewport(GtkBin):
	get_type = _gtk.gtk_viewport_get_type
	def __init__(self, ha=None, va=None, _obj=None):
		if _obj: self._o = _obj; return
		if ha or va:
			self._o = _gtk.gtk_viewport_new(ha._o, va._o)
		else:
			self._o = _gtk.gtk_viewport_new()
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_viewport_get_hadjustment(self._o))
	def get_vdjustment(self):
		return _obj2inst(_gtk.gtk_viewport_get_vadjustment(self._o))
	def set_hadjustment(self, ha):
		_gtk.gtk_viewport_set_hadjustment(self._o, ha._o)
	def set_vadjustment(self, va):
		_gtk.gtk_viewport_set_vadjustment(self._o, va._o)
	def set_shadow_type(self, tp=SHADOW_ETCHED_IN):
		_gtk.gtk_viewport_set_shadow_type(self._o, tp)

class GtkWindow(GtkBin):
	get_type = _gtkbase.gtk_window_get_type
	def __init__(self, type=WINDOW_TOPLEVEL, title=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtkbase.gtk_window_new(type)
		if title is not None:
			self.set_title(title)
	def activate_focus(self, obj=None):
		_gtkbase.gtk_window_activate_focus(self._o)
	def activate_default(self, obj=None):
		_gtkbase.gtk_window_activate_default(self._o)
	def set_title(self, title):
		_gtkbase.gtk_window_set_title(self._o, title)
	def set_focus(self, focus):
		_gtkbase.gtk_window_set_foxus(self._o, focus._o)
	def set_default(self, defaultw):
		_gtkbase.gtk_window_set_default(self._o, defaultw._o)
	def set_policy(self, as, ag, autos):
		_gtkbase.gtk_window_set_policy(self._o, as, ag, autos)
	def add_accel_group(self, group):
		_gtkbase.gtk_window_add_accel_group(self._o, group._ag)
	def remove_accel_group(self, group):
		_gtkbase.gtk_window_remove_accel_group(self._o, group._ag)
	def position(self, pos):
		_gtkbase.gtk_window_position(self._o, pos)
	def set_wmclass(self, wmc_name, wmc_class):
		_gtkbase.gtk_window_set_wmclass(self._o, wmc_name, wmc_class)
	def set_icon(self, pixmap, mask=None):
		if not mask and hasattr(pixmap, '_o'):
			pixmap, mask = pixmap.get()
		_gtkbase.gtk_window_set_icon(self._o, pixmap, mask)
	def set_icon_name(self, name):
		_gtkbase.gtk_window_set_icon_name(self._o, name)

class GtkColorSelectionDialog(GtkWindow):
	get_type = _gtk.gtk_color_selection_dialog_get_type
	def __init__(self, name="", _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_color_selection_dialog_new(name)
	def __getattr__(self, attr):
		attrs = {
			'colorsel':_gtk.gtk_color_selection_dialog_get_colorsel,
			'main_vbox':_gtk.gtk_color_selection_dialog_get_main_vbox,
			'ok_button': _gtk.gtk_color_selection_dialog_get_ok_button,
			'reset_button': _gtk.gtk_color_selection_dialog_get_reset_button,
			'cancel_button': _gtk.gtk_color_selection_dialog_get_cancel_button,
			'help_button': _gtk.gtk_color_selection_dialog_get_help_button
		}
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr

class GtkDialog(GtkWindow):
	get_type = _gtk.gtk_dialog_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_dialog_new()
	def __getattr__(self, attr):
		attrs = {
			'vbox': _gtk.gtk_dialog_get_vbox,
			'action_area': _gtk.gtk_dialog_get_action_area
		}
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr

class GtkFileSelection(GtkWindow):
	get_type = _gtk.gtk_file_selection_get_type
	def __init__(self, title='', _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_file_selection_new(title)

	def set_filename(self, filename):
		_gtk.gtk_file_selection_set_filename(self._o, filename)
	def get_filename(self):
		return _gtk.gtk_file_selection_get_filename(self._o)
	def __getattr__(self, attr):
		attrs = {
		'cancel_button':   _gtk.gtk_file_selection_get_cancel_button,
		'dir_list':        _gtk.gtk_file_selection_get_dir_list,
		'file_list':       _gtk.gtk_file_selection_get_file_list,
		'help_button':     _gtk.gtk_file_selection_get_help_button,
		'main_vbox':       _gtk.gtk_file_selection_get_main_vbox,
		'ok_button':       _gtk.gtk_file_selection_get_ok_button,
		'selection_entry': _gtk.gtk_file_selection_get_selection_entry,
		'selection_text':  _gtk.gtk_file_selection_get_selection_text
		}
		if not attrs.has_key(attr): raise AttributeError, attr
		return _obj2inst(attrs[attr](self._o))
	def show_fileop_buttons(self):
		_gtk.gtk_file_selection_show_fileop_buttons(self._o)
	def hide_fileop_buttons(self):
		_gtk.gtk_file_selection_hide_fileop_buttons(self._o)

class GtkInputDialog(GtkWindow):
	get_type = _gtk.gtk_input_dialog_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_input_dialog_new()

class GtkFontSelectionDialog(GtkWindow):
	get_type = _gtk.gtk_font_selection_dialog_get_type
	def __init__(self, title=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_font_selection_dialog_new(title)
	def __getattr__(self, attr):
		attrs = {
		"fontsel": _gtk.gtk_font_selection_dialog_get_fontsel,
		"main_vbox": _gtk.gtk_font_selection_dialog_get_main_vbox,
		"action_area": _gtk.gtk_font_selection_dialog_get_action_area,
		"ok_button": _gtk.gtk_font_selection_dialog_get_ok_button,
		"apply_button":_gtk.gtk_font_selection_dialog_get_apply_button,
		"cancel_button":
		        _gtk.gtk_font_selection_dialog_get_cancel_button
		}
		if not attrs.has_key(attr): raise AttributeError, attr
		return _obj2inst(attrs[attr](self._o))
	def get_font_name(self):
		return _gtk.gtk_font_selection_dialog_get_font_name(self._o)
	def get_font(self):
		return _gtk.gtk_font_selection_dialog_get_font(self._o)
	def set_font_name(self, name):
		return _gtk.gtk_font_selection_dialog_set_font_name(self._o,
								    name)
	def get_preview_text(self):
		return _gtk.gtk_font_selection_dialog_get_preview_text(self._o)
	def set_preview_text(self, text):
		_gtk.gtk_font_selection_dialog_set_preview_text(self._o, text)

class GtkBox(GtkContainer):
	get_type = _gtk.gtk_box_get_type
	def __init__(self, _obj=None):
		if nonint: return
	def pack_start(self, child, expand=TRUE, fill=TRUE, padding=0):
		_gtk.gtk_box_pack_start(self._o, child._o, expand,fill,padding)
	def pack_end(self, child, expand=TRUE, fill=TRUE, padding=0):
		_gtk.gtk_box_pack_end(self._o, child._o, expand,fill,padding)
	def reorder_child(self, child, pos):
		_gtk.gtk_box_reorder_child(self._o, child._o, pos)
	def set_homogeneous(self, homogeneous):
		_gtk.gtk_box_set_homogeneous(self._o, homogeneous)
	def set_spacing(self, spacing):
		_gtk.gtk_box_set_spacing(self._o, spacing)
	def query_child_packing(self, child):
		return _gtk.gtk_box_query_child_packing(self._o, child._o)
	def set_child_packing(self, child, expand, fill, padding, pack_type):
		_gtk.gtk_box_set_child_packing(self._o, child._o, expand, fill,
					       padding, pack_type)
	def reorder_child(self, child, pos):
		_gtk.gtk_box_reorder_child(self._o, child._o, pos)

class GtkHBox(GtkBox):
	get_type = _gtk.gtk_hbox_get_type
	def __init__(self, homogeneous=0, spacing=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_hbox_new(homogeneous, spacing)

class GtkCombo(GtkHBox):
	get_type = _gtk.gtk_combo_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_combo_new()
	def disable_activate(self, obj=None):
		_gtk.gtk_combo_disable_activate(self._o)
	def set_use_arrows(self, val):
		_gtk.gtk_combo_set_use_arrows(self._o, val)
	def set_use_arrows_always(self, val):
		_gtk.gtk_combo_set_use_arrows_always(self._o, val)
	def set_case_sensitive(self, val):
		_gtk.gtk_combo_set_case_sensitive(self._o, val)
	def set_item_string(self, item, val):
		_gtk.gtk_combo_set_item_string(self._o, item._o, val)
	def set_value_in_list(self, val, ok_if_empty):
		_gtk.gtk_combo_set_value_in_list(self._o, val, ok_if_empty)
	def set_popdown_strings(self, strings):
		_gtk.gtk_combo_set_popdown_strings(self._o, strings)
	def __getattr__(self, attr):
		attrs = {
			'entry': _gtk.gtk_combo_get_entry,
			'list':  _gtk.gtk_combo_get_list
	        }
		if attrs.has_key(attr):
			return _obj2inst(attrs[attr](self._o))
		raise AttributeError, attr

class GtkStatusbar(GtkHBox):
	get_type = _gtk.gtk_statusbar_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_statusbar_new()
	def get_context_id(self, desc):
		return _gtk.gtk_statusbar_get_context_id(self._o, desc)
	def pop(self, cid):
		_gtk.gtk_statusbar_pop(self._o, cid)
	def push(self, cid, text):
		return _gtk.gtk_statusbar_push(self._o, cid, text)
	def remove(self, cid, msg_id):
		_gtk.gtk_statusbar_remove(self._o, cid, msg_id)

class GtkVBox(GtkBox):
	get_type = _gtk.gtk_vbox_get_type
	def __init__(self, homogeneous=0, spacing=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_vbox_new(homogeneous, spacing)

class GtkColorSelection(GtkVBox):
	get_type = _gtk.gtk_color_selection_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_color_selection_new()
	def set_update_policy(self, p):
		_gtk.gtk_color_selection_set_update_policy(self._o, p)
	def set_opacity(self, use_opacity):
		_gtk.gtk_color_selection_set_opacity(self._o, use_opacity)
	def set_color(self, c):
		_gtk.gtk_color_selection_set_color(self._o, c)
	def get_color(self):
		return _gtk.gtk_color_selection_get_color(self._o)

class GtkGammaCurve(GtkVBox):
	get_type = _gtk.gtk_gamma_curve_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_gamma_curve_new()

class GtkButtonBox(GtkBox):
	get_type = _gtk.gtk_button_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def get_child_size_default(self):
		return _gtk.gtk_button_box_get_child_size_default()
	def get_child_ipadding_default(self):
		return _gtk.gtk_button_box_get_child_ipadding_default()
	def set_child_size_default(self, mw, mh):
		_gtk.gtk_button_box_set_child_size_default(mw, mh)
	def set_child_ipadding_default(self, ix, iy):
		_gtk.gtk_button_box_set_child_ipadding_default(ix, iy)
	def get_spacing(self):
		return _gtk.gtk_button_box_get_spacing(self._o)
	def get_layout(self):
		return _gtk.gtk_button_box_get_layout(self._o)
	def get_child_size(self):
		return _gtk.gtk_button_box_get_child_size(self._o)
	def get_child_ipadding(self):
		return _gtk.gtk_button_box_get_child_ipadding(self._o)
	def set_spacing(self, spacing):
		_gtk.gtk_button_box_set_spacing(self._o, spacing)
	def set_layout(self, layout):
		_gtk.gtk_button_box_set_layout(self._o, layout)
	def set_child_size(self, mw, mh):
		_gtk.gtk_button_box_set_child_size(self._o, mw, mh)
	def set_child_ipadding(self, ix, iy):
		_gtk.gtk_button_box_set_child_ipadding(self._o, ix, iy)

class GtkHButtonBox(GtkButtonBox):
	get_type = _gtk.gtk_hbutton_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_hbutton_box_new()
	def get_spacing_default(self):
		return _gtk.gtk_hbutton_box_get_spacing_default()
	def get_layout_default(self):
		return _gtk.gtk_hbutton_box_get_layout_default()
	def set_spacing_default(self, spacing):
		_gtk.gtk_hbutton_box_set_spacing_default(spacing)
	def set_layout_default(self, layout):
		_gtk.gtk_hbutton_box_set_layout_default(layout)

class GtkVButtonBox(GtkButtonBox):
	get_type = _gtk.gtk_vbutton_box_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_vbutton_box_new()
	def get_spacing_default(self):
		return _gtk.gtk_vbutton_box_get_spacing_default()
	def get_layout_default(self):
		return _gtk.gtk_vbutton_box_get_layout_default()
	def set_spacing_default(self, spacing):
		_gtk.gtk_vbutton_box_set_spacing_default(spacing)
	def set_layout_default(self, layout):
		_gtk.gtk_vbutton_box_set_layout_default(layout)

class GtkCList(GtkContainer):
	get_type = _gtk.gtk_clist_get_type
	def __init__(self, cols=1, titles=None, _obj=None):
		if _obj: self._o = _obj; return
		if titles == None:
			self._o = _gtk.gtk_clist_new(cols)
		else:
			self._o = _gtk.gtk_clist_new_with_titles(cols, titles)
	def __getattr__(self, attr):
		attrs = {
			'selection':_gtk.gtk_clist_get_selection,
		}
		if attrs.has_key(attr):
			return attrs[attr](self._o)
		else:
			raise AttributeError, attr
	def append(self, values):
		return _gtk.gtk_clist_append(self._o, values)
	def clear(self, obj=None):
		_gtk.gtk_clist_clear(self._o)
	def column_title_active(self, col):
		_gtk.gtk_clist_column_title_active(self._o, col)
	def column_title_passive(self, col):
		_gtk.gtk_clist_column_title_passive(self._o, col)
	def column_titles_active(self, obj=None):
		_gtk.gtk_clist_column_titles_active(self._o)
	def column_titles_hide(self, obj=None):
		_gtk.gtk_clist_column_titles_hide(self._o)
	def column_titles_passive(self, obj=None):
		_gtk.gtk_clist_column_titles_passive(self._o)
	def column_titles_show(self, obj=None):
		_gtk.gtk_clist_column_titles_show(self._o)
	def find_row_from_data(self, data):
		return _gtk.gtk_clist_find_row_from_data(self._o, data)
	def freeze(self, obj=None):
		_gtk.gtk_clist_freeze(self._o)
	def get_cell_type(self, r, c):
		return _gtk.gtk_clist_get_cell_type(self._o, r, c)
	def get_row_data(self, row):
		return _gtk.gtk_clist_get_row_data(self._o, row)
	def get_text(self, r, c):
		return _gtk.gtk_clist_get_text(self._o, r, c)
	def get_pixmap(self, r, c):
		return _gtk.gtk_clist_get_pixmap(self._o, r, c)
	def get_pixtext(self, r, c):
		return _gtk.gtk_clist_get_pixtext(self._o, r, c)
	def get_selection_info(self, x, y):
		return _gtk.gtk_clist_get_selection_info(self._o, x, y)
	def insert(self, row, values):
		_gtk.gtk_clist_insert(self._o, row, values)
	def moveto(self, row=-1, col=-1, row_align=0.5, col_align=0.5):
		_gtk.gtk_clist_moveto(self._o, row, col, row_align, col_align)
	def remove(self, row):
		_gtk.gtk_clist_remove(self._o, row)
	def select_all(self):
		_gtk.gtk_clist_select_all(self._o)
	def select_row(self, row, col):
		_gtk.gtk_clist_select_row(self._o, row, col)
	def set_background(self, row, colour):
		_gtk.gtk_clist_set_background(self._o, row, colour)
	def set_border(self, border):
		_gtk.gtk_clist_set_border(self._o, border)
	def set_column_title(self, col, title):
		_gtk.gtk_clist_set_column_title(self._o, col, title)
	def set_column_widget(self, col, w):
		_gtk.gtk_clist_set_column_widget(self._o, col, w._o)
	def set_column_justification(self, col, just):
		_gtk.gtk_clist_set_column_justification(self._o, col, just)
	def set_column_width(self, col, width):
		_gtk.gtk_clist_set_column_width(self._o, col, width)
	def set_foreground(self, row, colour):
		_gtk.gtk_clist_set_foreground(self._o, row, colour)
	def set_policy(self, vsp, hsp):
		_gtk.gtk_clist_set_policy(self._o, vsp, hsp)
	def set_row_data(self, row, data):
		_gtk.gtk_clist_set_row_data(self._o, row, data)
	def set_row_height(self, height):
		_gtk.gtk_clist_set_row_height(self._o, height)
	def set_shift(self, row, col, v, h):
		_gtk.gtk_clist_set_shift(self._o, row, col, v, h)
	def set_selection_mode(self, mode):
		_gtk.gtk_clist_set_selection_mode(self._o, mode)
	def set_text(self, r, c, text):
		_gtk.gtk_clist_set_text(self._o, r, c, text)
	def set_pixmap(self, r, c, pixmap, mask=None):
		if not mask and hasattr(pixmap, '_o'):
			pixmap, mask = pixmap.get()
		_gtk.gtk_clist_set_pixmap(self._o, r, c, pixmap, mask)
	def set_pixtext(self, r, c, text, spacing, pixmap, mask=None):
		if not mask and hasattr(pixmap, '_o'):
			pixmap, mask = pixmap.get()
		_gtk.gtk_clist_set_pixtext(self._o, r, c, text, spacing,
					   pixmap, mask)
	def swap_rows(self, row1, row2):
		_gtk.gtk_clist_swap_rows(self._o, row1, row2)
	def thaw(self):
		_gtk.gtk_clist_thaw(self._o)
	def undo_selection(self):
		_gtk.gtk_clist_undo_selection(self._o)
	def unselect_all(self):
		_gtk.gtk_clist_unselect_all(self._o)
	def unselect_row(self, row, col):
		_gtk.gtk_clist_unselect_row(self._o, row, col)

class GtkFixed(GtkContainer):
	get_type = _gtk.gtk_fixed_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_fixed_new()
	def put(self, child, x, y):
		_gtk.gtk_fixed_put(self._o, child._o, x, y)
	def move(self, child, x, y):
		_gtk.gtk_fixed_move(self._o, child._o, x, y)

class GtkList(GtkContainer):
	get_type = _gtk.gtk_list_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_list_new()
	def get_selection(self):
		l = _gtk.gtk_list_get_selection(self._o)
		return map(_obj2inst, l)
	def insert_items(self, items, pos):
		_gtk.gtk_list_insert_items(self._o, items, pos)
	def append_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_append_items(self._o, items)
	def prepend_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_prepend_items(self._o, items)
	def remove_items(self, items):
		items = map(lambda i: i._o, items)
		_gtk.gtk_list_remove_items(self._o, items)
	def clear_items(self, start, end):
		_gtk.gtk_list_clear_items(self._o, start, end)
	def select_item(self, item):
		_gtk.gtk_list_select_item(self._o, item._o)
	def unselect_item(self, item):
		_gtk.gtk_list_unselect_item(self._o, item._o)
	def select_child(self, child):
		_gtk.gtk_list_select_child(self._o, child._o)
	def unselect_child(self, child):
		_gtk.gtk_list_unselect_child(self._o, child._o)
	def child_position(self, child):
		return _gtk.gtk_list_child_position(self._o, child._o)
	def set_selection_mode(self, mode):
		_gtk.gtk_list_set_selection_mode(self._o, mode)
	def extend_selection(self, scroll_type, pos, auto):
		_gtk.gtk_list_extend_selection(self._o, scroll_type, pos, auto)
	def start_selection(self):
		_gtk.gtk_list_start_selection(self._o)
	def end_selection(self):
		_gtk.gtk_list_end_selection(self._o)
	def select_all(self):
		_gtk.gtk_list_select_all(self._o)
	def unselect_all(self):
		_gtk.gtk_list_unselect_all(self._o)
	def scroll_horizontal(self, scroll_type, pos):
		_gtk.gtk_list_scroll_horizontal(self._o, scroll_type, pos)
	def scroll_vertical(self, scroll_type, pos):
		_gtk.gtk_list_scroll_vertical(self._o, scroll_type, pos)
	def toggle_add_mode(self):
		_gtk.gtk_list_toggle_add_mode(self._o)
	def toggle_focus_row(self):
		_gtk.gtk_list_toggle_focus_row(self._o)
	def toggle_row(self, item):
		_gtk.gtk_list_toggle_row(self._o, item._o)
	def undo_selection(self):
		_gtk.gtk_list_undo_selection(self._o)
	def end_drag_selection(self):
		_gtk.gtk_list_end_drag_selection(self._o)

class GtkMenuShell(GtkContainer):
	get_type = _gtk.gtk_menu_shell_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def append(self, child):
		_gtk.gtk_menu_shell_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_shell_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_shell_insert(self._o, child._o, pos)
	def deactivate(self, obj=None):
		_gtk.gtk_menu_shell_deactivate(self._o)

class GtkMenuBar(GtkMenuShell):
	get_type = _gtk.gtk_menu_bar_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_menu_bar_new()
	def append(self, child):
		_gtk.gtk_menu_bar_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_bar_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_bar_insert(self._o, child._o, pos)

class GtkMenu(GtkMenuShell):
	get_type = _gtk.gtk_menu_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_menu_new()
	def append(self, child):
		_gtk.gtk_menu_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_menu_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_menu_insert(self._o, child._o, pos)
	def popup(self, pms, pmi, func, button, time):
		_gtk.gtk_menu_popup(self._o, pms._o, pmi._o, func,button,time)
	def reposition(self):
		_gtk.gtk_menu_reposition(self._o)
	def popdown(self, obj=None):
		_gtk.gtk_menu_popdown(self._o)
	def get_active(self):
		return _obj2inst(_gtk.gtk_menu_get_active(self._o))
	def get_attach_widget(self):
		return _obj2inst(_gtk.gtk_menu_get_attach_widget(self._o))
	def detach(self):
		_gtk.gtk_menu_detach(self._o)
	def set_active(self, index):
		_gtk.gtk_menu_set_active(self._o, index)
	def set_accel_group(self, group):
		_gtk.gtk_menu_set_accel_group(self._o, group._ag)

class GtkNotebook(GtkContainer):
	get_type = _gtk.gtk_notebook_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_notebook_new()
	def append_page(self, child, tab):
		_gtk.gtk_notebook_append_page(self._o, child._o, tab._o)
	def append_page_menu(self, child, tab, ml):
		_gtk.gtk_notebook_append_page_menu(self._o, child._o, tab._o,
						   ml._o)
	def prepend_page(self, child, tab):
		_gtk.gtk_notebook_prepend_page(self._o, child._o, tab._o)
	def prepend_page_menu(self, child, tab, ml):
		_gtk.gtk_notebook_prepend_page_menu(self._o, child._o, tab._o,
						    ml._o)
	def insert_page(self, child, tab, pos):
		_gtk.gtk_notebook_insert_page(self._o, child._o, tab._o, pos)
	def insert_page_menu(self, child, tab, ml, pos):
		_gtk.gtk_notebook_insert_page_menu(self._o, child._o, tab._o,
						   ml._o, pos)
	def remove_page(self, pos):
		_gtk.gtk_notebook_remove_page(self._o, pos)
	def current_page(self):
		return _gtk.gtk_notebook_current_page(self._o)
	def set_page(self, pos):
		_gtk.gtk_notebook_set_page(self._o, pos)
	def next_page(self, obj=None):
		_gtk.gtk_notebook_next_page(self._o)
	def prev_page(self, obj=None):
		_gtk.gtk_notebook_prev_page(self._o)
	def reorder_child(self, child, pos):
		_gtk.gtk_notebook_reorder_child(self._o, child._o, pos)
	def set_tab_border(self, border):
		_gtk.gtk_notebook_set_tab_border(self._o, border)
	def set_tab_pos(self, pos):
		_gtk.gtk_notebook_set_tab_pos(self._o, pos)
	def set_scrollable(self, scrollable):
		_gtk.gtk_notebook_set_scrollable(self._o, scrollable)
	def set_show_tabs(self, show):
		_gtk.gtk_notebook_set_show_tabs(self._o, show)
	def set_show_border(self, show):
		_gtk.gtk_notebook_set_show_border(self._o, show)
	def popup_enable(self, obj=None):
		_gtk.gtk_notebook_popup_enable(self._o)
	def popup_disable(self, obj=None):
		_gtk.gtk_notebook_popup_disable(self._o)

class GtkFontSelection(GtkNotebook):
	get_type = _gtk.gtk_font_selection_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_font_selection_new()
	def get_font_name(self):
		return _gtk.gtk_font_selection_get_font_name(self._o)
	def get_font(self):
		return _gtk.gtk_font_selection_get_font(self._o)
	def set_font_name(self, name):
		return _gtk.gtk_font_selection_set_font_name(self._o, name)
	def get_preview_text(self):
		return _gtk.gtk_font_selection_get_preview_text(self._o)
	def set_preview_text(self, text):
		_gtk.gtk_font_selection_set_preview_text(self._o, text)

class GtkPacker(GtkContainer):
	get_type = _gtk.gtk_packer_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_packer_new()
	def add_defaults(self, child, side, anchor, options):
		_gtk.gtk_packer_add_defaults(self._o, child._o, side, anchor,
					     options)
	def add(self, child, side, anchor, options, border_width, pad_x,
		pad_y, i_pad_x, i_pad_y):
		_gtk.gtk_packer_add(self._o, child._o, side, anchor, options,
				    border_width, pad_x, pad_y, i_pad_x,
				    i_pad_y)
	def configure(self, child, side, anchor, options, border_width, pad_x,
		      pad_y, i_pad_x, i_pad_y):
		_gtk.gtk_packer_configure(self._o, child._o, side, anchor,
					  options, border_width, pad_x, pad_y,
					  i_pad_x, i_pad_y)
	def reorder_child(self, child, pos):
		_gtk.gtk_packer_reorder_child(self._o, child._o, pos)
	def set_spacing(self, spacing):
		_gtk.gtk_packer_set_spacing(self._o, spacing)
	def set_default_pad(self, pad_x, pad_y):
		_gtk.gtk_packer_set_default_pad(self._o, pad_x, pad_y)
	def set_default_ipad(self, i_pad_x, i_pad_y):
		_gtk.gtk_packer_set_default_ipad(self._o, i_pad_x, i_pad_y)

class GtkPaned(GtkContainer):
	get_type = _gtk.gtk_paned_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def add1(self, child):
		_gtk.gtk_paned_add1(self._o, child._o)
	def add2(self, child):
		_gtk.gtk_paned_add2(self._o, child._o)
	def handle_size(self, size):
		_gtk.gtk_paned_handle_size(self._o, size)
	def gutter_size(self, size):
		_gtk.gtk_paned_gutter_size(self._o, size)

class GtkHPaned(GtkPaned):
	get_type = _gtk.gtk_hpaned_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_hpaned_new()

class GtkVPaned(GtkPaned):
	get_type = _gtk.gtk_vpaned_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_vpaned_new()

class GtkScrolledWindow(GtkContainer):
	get_type = _gtk.gtk_scrolled_window_get_type
	def __init__(self, hadj=None, vadj=None, _obj=None):
		if _obj: self._o = _obj; return
		if not (vadj or hadj):
			self._o = _gtk.gtk_scrolled_window_new()
		else:
			self._o = _gtk.gtk_scrolled_window_new(hadj._o, vadj._o)
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_scrolled_window_get_hadjustment(
			self._o))
	def get_vadjustment(self):
		return _obj2inst(_gtk.gtk_scrolled_window_get_vadjustment(
			self._o))
	def set_policy(self, hp, vp):
		_gtk.gtk_scrolled_window_set_policy(self._o, hp, vp)

class GtkTable(GtkContainer):
	get_type = _gtk.gtk_table_get_type
	def __init__(self, rows=1, cols=1, homogeneous=0, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_table_new(rows, cols, homogeneous)
	def attach(self, child, la, ra, ta, ba, xoptions=EXPAND|FILL,
			yoptions=EXPAND|FILL, xpadding=0, ypadding=0):
		_gtk.gtk_table_attach(self._o, child._o, la,ra,ta,ba,
			xoptions,yoptions, xpadding,ypadding)
	def set_row_spacing(self, row, s):
		_gtk.gtk_table_set_row_spacing(self._o, row, s)
	def set_col_spacing(self, col, s):
		_gtk.gtk_table_set_col_spacing(self._o, col, s)
	def set_row_spacings(self, s):
		_gtk.gtk_table_set_row_spacings(self._o, s)
	def set_col_spacings(self, s):
		_gtk.gtk_table_set_col_spacings(self._o, s)
	def set_homogeneous(self, homogeneous):
	        _gtk.gtk_table_set_homogeneous(self._o, homogeneous)

class GtkTree(GtkContainer):
	get_type = _gtk.gtk_tree_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_tree_new()
	def get_selection(self):
		return map(_obj2inst, _gtk.gtk_tree_get_selection(self._o))
	def append(self, child):
		_gtk.gtk_tree_append(self._o, child._o)
	def prepend(self, child):
		_gtk.gtk_tree_prepend(self._o, child._o)
	def insert(self, child, pos):
		_gtk.gtk_tree_insert(self._o, child._o, pos)
	def remove_item(self, child):
		# fix this when the function starts existing
		#_gtk.gtk_tree_remove_item(self._o, child._o)
		self.remove_items([child])
	def remove_items(self, children):
		children = map(lambda x: x._o, children)
		_gtk.gtk_tree_remove_items(self._o, children)
	def clear_items(self, start, end):
		_gtk.gtk_tree_clear_items(self._o, start, end)
	def select_item(self, item):
		_gtk.gtk_tree_select_item(self._o, item)
	def unselect_item(self, item):
		_gtk.gtk_tree_unselect_item(self._o, item)
	def select_child(self, child):
		_gtk.gtk_tree_select_child(self._o, child._o)
	def unselect_child(self, child):
		_gtk.gtk_tree_unselect_child(self._o, child._o)
	def child_position(self, child):
		return _gtk.gtk_tree_child_position(self._o, child._o)
	def set_selection_mode(self, mode):
		_gtk.gtk_tree_set_selection_mode(self._o, mode)
	def set_view_mode(self, mode):
		_gtk.gtk_tree_set_view_mode(self._o, mode)
	def set_view_lines(self, flag):
		_gtk.gtk_tree_set_view_lines(self._o, flag)

class GtkToolbar(GtkContainer):
	get_type = _gtk.gtk_toolbar_get_type
	def __init__(self, orientation=ORIENTATION_HORIZONTAL,
		     style=TOOLBAR_ICONS, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_toolbar_new(orientation, style)
        def append_item(self, text, tooltip, tp, icon, callback):
		_gtk.gtk_toolbar_append_item(self._o, text, tooltip, tp,
					     icon._o, callback)
	def append_space(self):
		_gtk.gtk_toolbar_append_space(self._o)
	def append_widget(self, w, tooltip, tp):
		_gtk.gtk_toolbar_append_widget(self._o, w._o, tooltip, tp)
	def insert_item(self, text, tooltip, tp, icon, callback, pos):
		_gtk.gtk_toolbar_insert_item(self._o, text, tooltip, tp,
					     icon._o, callback, pos)
	def insert_space(self, pos):
		_gtk.gtk_toolbar_insert_space(self._o, pos)
	def insert_widget(self, w, tooltip, tp, pos):
		_gtk.gtk_toolbar_insert_widget(self._o, w._o, tooltip, tp, pos)
	def prepend_item(self, text, tooltip, tp, icon, callback):
		_gtk.gtk_toolbar_prepend_item(self._o, text, tooltip, tp,
					      icon._o, callback)
	def prepend_space(self):
		_gtk.gtk_toolbar_prepend_space(self._o)
	def prepend_widget(self, w, tooltip, tp):
		_gtk.gtk_toolbar_prepend_widget(self._o, w._o, tooltip, tp)
       	def set_orientation(self, orientation):
		_gtk.gtk_toolbar_set_orientation(self._o, orientation)
	def set_style(self, style):
		_gtk.gtk_toolbar_set_style(self._o, style)
	def set_space_size(self, size):
		_gtk.gtk_toolbar_set_space_size(self._o, size)
	def set_tooltips(self, enable):
		_gtk.gtk_toolbar_set_tooltips(self._o, enable)
	def set_button_relief(self, relief):
		_gtk.gtk_toolbar_set_button_relief(self._o, relief)
	def get_button_relief(self):
		return _gtk.gtk_toolbar_get_button_relief(self._o)

class GtkDrawingArea(GtkWidget):
	get_type = _gtk.gtk_drawing_area_get_type
	def __init__(self, _obj=None):
		self.__win = None
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_drawing_area_new()
	def size(self, w, h):
		_gtk.gtk_drawing_area_size(self._o, w, h)
	def __cache_win(self):
		self.realize()
		self.__win = self.get_window()
	def draw_point(self, gc, x, y):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_point(self.__win, gc, x, y)
	def draw_line(self, gc, x1, y1, x2, y2):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_line(self.__win, gc, x1, y1, x2, y2)
	def draw_rectangle(self, gc, fill, x, y, width, height):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_rectangle(self.__win, gc, fill, x, y,
					width, height)
	def draw_arc(self, gc, x, y, width, height, angle1, angle2):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_arc(self.__win, gc, x, y, width, height, angle1,
				  angle2)
	def draw_polygon(self, gc, fill, points):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_polygon(self.__win, gc, fill, points)
	def draw_string(self, font, gc, x, y, string):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_string(self.__win, font, gc, x, y, string)
	def draw_text(self, font, gc, x, y, text):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_text(self.__win, font, gc, x, y, text)
	def draw_pixmap(self, gc, src, xsrc,ysrc, xdest,ydest, width,height):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_pixmap(self.__win, gc, src, xsrc,ysrc,
				     xdest,ydest, width,height)
	def draw_points(self, gc, points):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_points(self.__win, gc, points)
	def draw_segments(self, gc, segs):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_segments(self.__win, gc, segs)
	def draw_lines(self, gc, points):
		if not self.__win: self.__cache_win()
		_gtk.gdk_draw_lines(self.__win, gc, points)

class GtkCurve(GtkDrawingArea):
	get_type = _gtk.gtk_curve_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_curve_new()
	def reset(self):
		_gtk.gtk_curve_reset(self._o)
	def get_vector(self, size=-1):
		return _gtk.gtk_curve_get_vector(self._o, size)
	def set_vector(self, vector):
		_gtk.gtk_curve_set_vector(self._o, vector)
	def set_gamma(self, g):
		_gtk.gtk_curve_set_gamma(self._o, g)
	def set_range(self, minx,maxx, miny,maxy):
		_gtk.gtk_curve_set_range(self._o, minx,maxx, miny,maxy)
	def set_curve_type(self, tp):
		_gtk.gtk_curve_set_curve_type(self._o, tp)

class GtkEditable(GtkWidget):
	get_type = _gtk.gtk_editable_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def select_region(self, start, end):
		_gtk.gtk_editable_select_region(self._o, start, end)
	def insert_text(self, new_text):
		return _gtk.gtk_editable_insert_text(self._o, new_text)
	def delete_text(self, start, end):
		_gtk.gtk_editable_delete_text(self._o, start, end)
	def get_chars(self, start, end):
		return _gtk.gtk_editable_get_chars(self._o, start, end)
	def cut_clipboard(self):
		_gtk.gtk_editable_cut_clipboard(self._o)
	def copy_clipboard(self):
		_gtk.gtk_editable_copy_clipboard(self._o)
	def paste_clipboard(self):
		_gtk.gtk_editable_paste_clipboard(self._o)
	def claim_selection(self, claim, time):
		_gtk.gtk_editable_claim_selection(self._o, claim, time)
	def delete_selection(self):
		_gtk.gtk_editable_delete_selection(self._o)
	def changed(self):
		_gtk.gtk_editable_changed(self._o)
	def set_position(self, pos):
		_gtk.gtk_editable_set_position(self._o, pos)
	def get_position(self):
		return _gtk.gtk_editable_get_position(self._o)
	def set_editable(self, is_editable):
		_gtk.gtk_editable_set_editable(self._o, is_editable)

class GtkEntry(GtkEditable):
	get_type = _gtk.gtk_entry_get_type
	def __init__(self, maxlen=-1, _obj=None):
		if _obj: self._o = _obj; return
		if maxlen == -1:
			self._o = _gtk.gtk_entry_new()
		else:
			self._o = _gtk.gtk_entry_new_with_max_length(maxlen)
	def set_text(self, text):
		_gtk.gtk_entry_set_text(self._o, text)
	def append_text(self, text):
		_gtk.gtk_entry_append_text(self._o, text)
	def prepend_text(self, text):
		_gtk.gtk_entry_prepend_text(self._o, text)
	def set_position(self, pos):
		_gtk.gtk_entry_set_position(self._o, pos)
	def get_text(self):
		return _gtk.gtk_entry_get_text(self._o)
	def select_region(self, start, stop):
		_gtk.gtk_entry_select_region(self._o, start, stop)
	def set_visibility(self, visible):
		_gtk.gtk_entry_set_visibility(self._o, visible)
	def set_editable(self, editable):
		_gtk.gtk_entry_set_editable(self._o, editable)
	def adjust_scroll(self):
		_gtk.gtk_entry_adjust_scroll(self._o)
	def set_max_length(self, max):
		_gtk.gtk_entry_set_max_length(self._o, max)

class GtkSpinButton(GtkEntry):
	get_type = _gtk.gtk_spin_button_get_type
	def __init__(self, adj=None, climb_rate=1, digits=1, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gtk.gtk_spin_button_new(adj, climb_rate,
							   digits)
		else:
			self._o = _gtk.gtk_spin_button_new_no_adj(climb_rate,
								  digits)
	def set_adjustment(self, adj):
		_gtk.gtk_spin_button_set_adjustment(self._o, adj._o)
	def get_adjustment(self):
		return _obj2inst(_gtk.gtk_spin_button_get_adjustment(sel._o))
	def set_digits(self, digits):
		_gtk.gtk_spin_button_set_digits(self._o, digits)
	def get_value_as_float(self):
		return _gtk.gtk_spin_button_get_value_as_float(self._o)
	def get_value_as_int(self):
		return _gtk.gtk_spin_button_get_value_as_int(self._o)
	get_value = get_value_as_float
	def set_value(self, val):
		_gtk.gtk_spin_button_set_value(self._o, val)
	def set_update_policy(self, pol):
		_gtk.gtk_spin_button_set_update_policy(self._o, pol)
	def set_numeric(self, numeric):
		_gtk.gtk_spin_button_set_numeric(self._o, numeric)
	def spin(self, direction, step):
		_gtk.gtk_spin_button_spin(self._o, direction, step)
	def set_wrap(self, wrap):
	        _gtk.gtk_spin_button_set_wrap(self._o, wrap)
	def set_shadow_type(self, shadow_type):
		_gtk.gtk_spin_button_set_shadow_type(self._o, shadow_type)
	def set_snap_to_ticks(self, snap):
		_gtk.gtk_spin_button_set_snap_to_ticks(self._o, snap)

class GtkText(GtkEditable):
	get_type = _gtk.gtk_text_get_type
	def __init__(self, hadj=None, vadj=None, _obj=None):
		if _obj: self._o = _obj; return
		if not (hadj or vadj):
			self._o = _gtk.gtk_text_new()
		else:
			self._o = _gtk.gtk_text_new(hadj._o, vadj._o)
	def set_editable(self, editable):
		_gtk.gtk_text_set_editable(self._o, editable)
	def set_word_wrap(self, word_wrap):
		_gtk.gtk_text_set_word_wrap(self._o, word_wrap)
	def set_adjustments(self, hadj, vadj):
		_gtk.gtk_text_set_adjustments(self._o, hadj._o, vadj._o)
	def get_hadjustment(self):
		return _obj2inst(_gtk.gtk_text_get_hadjustment(self._o))
	def get_vadjustment(self):
		return _obj2inst(_gtk.gtk_text_get_vadjustment(self._o))
	def set_point(self, point):
		_gtk.gtk_text_set_point(self._o, point)
	def get_point(self):
		return _gtk.gtk_text_get_point(self._o)
	def get_length(self):
		return _gtk.gtk_text_get_length(self._o)
	def freeze(self, obj=None):
		_gtk.gtk_text_freeze(self._o)
	def thaw(self, obj=None):
		_gtk.gtk_text_thaw(self._o)
	def insert(self, font, fg, bg, string):
		_gtk.gtk_text_insert(self._o, font, fg, bg, string,
				     len(string))
	def insert_defaults(self, chars):
		_gtk.gtk_text_insert_defaults(self._o, chars)
	def backward_delete(self, nchars):
		_gtk.gtk_text_backward_delete(self._o, nchars)
	def forward_delete(self, nchars):
		_gtk.gtk_text_forward_delete(self._o, nchars)

class GtkMisc(GtkWidget):
	get_type = _gtk.gtk_misc_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set_alignment(self, xa, ya):
		_gtk.gtk_misc_set_alignment(self._o, xa, ya)
	def set_padding(self, xp, yp):
		_gtk.gtk_misc_set_padding(self._o, xp, yp)

class GtkArrow(GtkMisc):
	get_type = _gtk.gtk_arrow_get_type
	def __init__(self, at=ARROW_RIGHT, st=SHADOW_OUT, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_arrow_new(at, st)
	def set(self, at, st):
		_gtk.gtk_arrow_set(self._o, at, st)

class GtkImage(GtkMisc):
	get_type = _gtk.gtk_image_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	# XXX should have __init__, set, get

class GtkPixmap(GtkMisc):
	get_type = _gtk.gtk_pixmap_get_type
	def __init__(self, parent_or_pixmap=None, xpm_or_mask=None, bg=None,
		     _obj=None):
		# This function can be called with two argument models:
		# The old model:
		#  GtkPixmap(parent_win, xpm_file, bg_colour)
		# or the one closer to the C version:
		#  GtkPixmap(pixmap, mask)
		if _obj: self._o = _obj; return
		if type(xpm_or_mask) == type(''):
			pix, mask = create_pixmap_from_xpm(parent_or_pixmap,
							   bg, xpm_or_mask)
			self._o = _gtk.gtk_pixmap_new(pix, mask)
		else:
			self._o = _gtk.gtk_pixmap_new(parent_or_pixmap,
						      xpm_or_mask)
	def get(self):
		return _gtk.gtk_pixmap_get(self._o)
	def set(self, pixmap, mask):
		_gtk.gtk_pixmap_set(self._o, pixmap, mask)

class GtkLabel(GtkMisc):
	get_type = _gtk.gtk_label_get_type
	def __init__(self, label="", _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_label_new(label)
	def set(self, str):
		_gtk.gtk_label_set(self._o, str)
	def set_justify(self, jtype):
		_gtk.gtk_label_set_justify(self._o, jtype)
	def get(self):
		return _gtk.gtk_label_get(self._o)

class GtkAccelLabel(GtkLabel):
	get_type = _gtk.gtk_accel_label_get_type
	def __init__(self, string=None, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_accel_label_new(string)
	def accelerator_width(self):
		return _gtk.gtk_accel_label_width(self._o)
	def set_accel_widget(self, widget):
		_gtk.gtk_accel_label_set_accel_widget(self._o, widget._o)
	def refetch(self):
		_gtk.gtk_accel_label_refetch(self._o)

class GtkTipsQuery(GtkLabel):
	get_type = _gtk.gtk_tips_query_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_tips_query_new()
	def start_query(self, obj=None):
		_gtk.gtk_tips_query_start_query(self._o)
	def stop_query(self, obj=None):
		_gtk.gtk_tips_query_stop_query(self._o)
	def set_caller(self, caller):
		_gtk.gtk_tips_query_set_caller(self._o, caller._o)
	def set_labels(self, inactive, no_tip):
		_gtk.gtk_tips_query_set_labels(self._o, inactive, no_tip)

class GtkPreview(GtkWidget):
	get_type = _gtk.gtk_preview_get_type
	def uninit(self):
		_gtk.gtk_preview_uninit()
	def __init__(self, tp=0):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_preview_new(tp)
	def size(self, w, h):
		_gtk.gtk_preview_size(self._o, w, h)
	def put(self, win, gc, srcx, srcy, dstx, dsty, width, height):
		_gtk.gtk_preview_put(self._o, win, gc, srcx, srcy,
				     dstx, dsty, width, height)
	def draw_row(self, data, x, y, w=None):
		_gtk.gtk_preview_draw_row(self._o, data, x, y, w or len(data))
	def set_expand(self, expand):
		_gtk.gtk_preview_set_expand(self._o, expand)
	def set_gamma(self, gamma):
		_gtk.gtk_preview_set_gamma(self._o, gamma)
	def set_color_cube(self, nr, ng, nb, ngrey):
		_gtk.gtk_preview_set_color_cube(self._o, nr,ng,nb, ngrey)
	def set_install_cmap(self, install):
		_gtk.gtk_preview_set_install_cmap(install)
	def set_reserved(self, reserved):
		_gtk.gtk_preview_set_reserved(reserved)

class GtkProgress(GtkWidget):
	get_type = _gtk.gtk_progress_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set_show_text(self, show_text):
		_gtk.gtk_progress_set_show_text(self._o, show_text)
	def set_text_alignment(self, x_align, y_align):
		_gtk.gtk_progress_set_text_alignment(self._o, x_align,
						     y_align)
	def set_format_string(self, format):
		_gtk.gtk_progress_set_format_string(self._o, format)
	def set_adjustment(self, adj):
		_gtk.gtk_progress_set_adjustment(self._o, adj._o)
	def reconfigure(self, value, min, max):
		_gtk.gtk_progress_reconfigure(self._o, value, min, max)
	def set_percentage(self, pcnt):
		_gtk.gtk_progress_set_percentage(self._o, pcnt)
	def set_value(self, value):
		_gtk.gtk_progress_set_value(self._o, value)
	def get_value(self):
		return _gtk.gtk_progress_get_value(self._o)
	def set_activity_mode(self, activity_mode):
		_gtk.gtk_progress_set_activity_mode(self._o, activity_mode)
	def get_current_text(self):
		return _gtk.gtk_progress_get_current_text(self._o)
	def get_text_from_value(self, value):
		return _gtk.gtk_progress_get_text_from_value(self._o, value)
	def get_current_percentage(self):
		return _gtk.gtk_progress_get_percentage(self._o)
	def get_percentage_from_value(self, value):
		return _gtk.gtk_progress_get_percentage_from_value(self._o,
								   value)

class GtkProgressBar(GtkProgress):
	get_type = _gtk.gtk_progress_bar_get_type
	def __init__(self, adjustment=None, _obj=None):
		if _obj: self._o = _obj; return
		if adjustment:
			self._o = _gtk.gtk_progress_bar_new_with_adjustment(
				adjustment._o)
		else:
			self._o = _gtk.gtk_progress_bar_new()
	def set_bar_style(self, style):
		_gtk.gtk_progress_bar_set_bar_style(self._o, style)
	def set_discrete_blocks(self, blocks):
		_gtk.gtk_progress_bar_set_discrete_blocks(self._o, blocks)
	def set_activity_step(self, step):
		_gtk.gtk_progress_bar_set_activity_step(self._o, step)
	def set_activity_blocks(self, blocks):
		_gtk.gtk_progress_bar_set_activity_blocks(self._o, blocks)
	def set_orientation(self, orient):
		_gtk.gtk_progress_bar_set_orientation(self._o, orient)
	def update(self, pcnt):
		_gtk.gtk_progress_bar_update(self._o, pcnt)

class GtkRange(GtkWidget):
	get_type = _gtk.gtk_range_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def get_adjustment(self):
		return _obj2inst(_gtk.gtk_range_get_adjustment(self._o))
	def set_update_policy(self, pol):
		_gtk.gtk_range_set_update_policy(self._o, pol)
	def set_adjustment(self, adj):
		_gtk.gtk_range_set_adjustment(self._o, adj._o)
	def draw_background(self, obj=None):
		_gtk.gtk_range_draw_background(self._o)
	def draw_trough(self, obj=None):
		_gtk.gtk_range_draw_trough(self._o)
	def draw_step_forw(self, obj=None):
		_gtk.gtk_range_draw_step_forw(self._o)
	def draw_step_back(self, obj=None):
		_gtk.gtk_range_draw_step_back(self._o)

class GtkScale(GtkRange):
	get_type = _gtk.gtk_scale_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set_digits(self, digits):
		_gtk.gtk_scale_set_digits(self._o, digits)
	def set_draw_value(self, draw_value):
		_gtk.gtk_scale_set_draw_value(self._o, draw_value)
	def set_value_pos(self, pos):
		_gtk.gtk_scale_set_value_pos(self._o, pos)
	def value_width(self):
		return _gtk.gtk_scale_value_width(self._o)
	def draw_value(self, obj=None):
		_gtk.gtk_scale_draw_value(self._o)

class GtkHScale(GtkScale):
	get_type = _gtk.gtk_hscale_get_type
	def __init__(self, adj=None, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gtk.gtk_hscale_new(adj._o)
		else:
			self._o = _gtk.gtk_hscale_new()

class GtkVScale(GtkScale):
	get_type = _gtk.gtk_vscale_get_type
	def __init__(self, adj=None, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gtk.gtk_vscale_new(adj._o)
		else:
			self._o = _gtk.gtk_vscale_new()

class GtkScrollbar(GtkRange):
	get_type = _gtk.gtk_scrollbar_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return

class GtkHScrollbar(GtkScrollbar):
	get_type = _gtk.gtk_hscrollbar_get_type
	def __init__(self, adj=None, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gtk.gtk_hscrollbar_new(adj._o)
		else:
			self._o = _gtk.gtk_hscrollbar_new()

class GtkVScrollbar(GtkScrollbar):
	get_type = _gtk.gtk_vscrollbar_get_type
	def __init__(self, adj=None, _obj=None):
		if _obj: self._o = _obj; return
		if adj:
			self._o = _gtk.gtk_vscrollbar_new(adj._o)
		else:
			self._o = _gtk.gtk_vscrollbar_new()

class GtkRuler(GtkWidget):
	get_type = _gtk.gtk_ruler_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
	def set_metric(self, metric):
		_gtk.gtk_ruler_set_metric(self._o, metric)
	def set_range(self, lo, up, pos, max):
		_gtk.gtk_ruler_set_range(self._o, lo, up, pos, max)
	def draw_ticks(self, obj=None):
		_gtk.gtk_ruler_draw_ticks(self._o)
	def draw_pos(self, obj=None):
		_gtk.gtk_ruler_draw_pos(self._o)

class GtkHRuler(GtkRuler):
	get_type = _gtk.gtk_hruler_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_hruler_new()

class GtkVRuler(GtkRuler):
	get_type = _gtk.gtk_vruler_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_vruler_new()

class GtkSeparator(GtkWidget):
	get_type = _gtk.gtk_separator_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return

class GtkHSeparator(GtkSeparator):
	get_type = _gtk.gtk_hseparator_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_hseparator_new()

class GtkVSeparator(GtkSeparator):
	get_type = _gtk.gtk_vseparator_get_type
	def __init__(self, _obj=None):
		if _obj: self._o = _obj; return
		self._o = _gtk.gtk_vseparator_new()


_name2cls = {}
_supported = map(lambda x: eval(x), filter(lambda x: x[:3] == 'Gtk', dir()))
for m in _supported:
	_name2cls[m.__name__] = m
del m

class GtkAccelGroup:
	def __init__(self, _obj=None):
		if _obj: self._ag = _obj; return
		self._ag = _gtkbase.gtk_accel_group_new()
	def activate(self, key, mods):
		_gtkbase.gtk_accel_group_activate(self._ag, key, mods)
	def attach(self, obj):
		_gtkbase.gtk_accel_group_attach(self._ag, obj._o)
	def detach(self, obj):
		_gtkbase.gtk_accel_group_detach(self._ag, obj._o)
	def lock(self):
		_gtkbase.gtk_accel_group_lock(self._ag)
	def unlock(self):
		_gtkbase.gtk_accel_group_unlock(self._ag)
	def lock_entry(self, key, mods):
		_gtkbase.gtk_accel_group_lock_entry(self._ag, key, mods)
	def unlock_entry(self, key, mods):
		_gtkbase.gtk_accel_group_unlock_entry(self._ag, key, mods)
	def add(self, key, mods, flags, obj, signal):
		_gtkbase.gtk_accel_group_add(self._ag, key, mods, flags,
					 obj._o, signal)
	def remove(self, key, mods, obj):
		_gtkbase.gtk_accel_group_remove(self._ag, key, mods, obj._o)

def _obj2inst(obj):
	objname = _gtkbase.gtk_type_name(_gtkbase.GTK_OBJECT_TYPE(obj))
	if _name2cls.has_key(objname):
		return _name2cls[objname](_obj=obj)
	# if I don't know what the object is, guess
	elif _gtk.GTK_CHECK_TYPE(obj, GtkBox.get_type()):
		return GtkBox(_obj=obj)
	elif _gtk.GTK_CHECK_TYPE(obj, GtkBin.get_type()):
		return GtkBin(_obj=obj)
	elif _gtk.GTK_CHECK_TYPE(obj, GtkWindow.get_type()):
		return GtkWindow(_obj=obj)
	elif _gtk.GTK_CHECK_TYPE(obj, GtkContainer.get_type()):
		return GtkContainer(_obj=obj)
	elif _gtk.GTK_CHECK_TYPE(obj, GtkWidget.get_type()):
		return GtkWidget(_obj=obj)
	else:
		return GtkObject(_obj=obj)

def _filtprops(props):
	for k in props.keys():
		v = props[k]
		if hasattr(v, '_o') and type(v._o) == _gtkbase.GtkObjectType:
			props[k] = v._o

def new(tp, **props):
	if type(tp) == type(GtkObject):
		tp = tp.get_type()
	elif type(tp) == type('forty-two'): 
		tp = _name2cls[tp].get_type()
	elif type(tp) != type(0):
		raise TypeError, "unknow type argument: " + tp
	_filtprops(props)
	return _obj2inst(_gtkbase.gtk_object_new(tp, props))

# flow control
def mainloop():
	_gtkbase.gtk_main()
def mainquit(*args):
	_gtkbase.gtk_main_quit()
def mainiteration(block=TRUE):
	_gtkbase.gtk_main_iteration(block)

# idle/quit/timeout handlers
def idle_add(callback):
	return _gtkbase.gtk_idle_add(callback)
def idle_add_priority(priority, callback):
	return _gtkbase.gtk_idle_add_priority(priority, callback)
def idle_remove(tag):
	_gtkbase.gtk_idle_remove(tag)
def quit_add(mainlevel, callback):
        return _gtkbase.gtk_quit_add(mainlevel, callback)
def quit_add_destroy(mainlevel, object):
	_gtkbase.gtk_quit_add_destroy(mainlevel, object._o)
def quit_remove(tag):
	_gtkbase.gtk_quit_remove(tag)
def timeout_add(timeout, callback):
	return _gtkbase.gtk_timeout_add(timeout, callback)
def timeout_remove(tag):
	_gtkbase.gtk_timeout_remove(tag)

# input (file handle) handler
def input_add(source, condition, callback):
	if hasattr(source, 'fileno'):
		# handle python file handles
		def wrapper(source, condition, real_s=source,real_cb=callback):
			real_cb(real_s, condition)
		return _gtkbase.gtk_input_add(source.fileno(), condition, wrapper)
	else:
		return _gtkbase.gtk_input_add(source, condition, callback)
def input_remove(tag):
	_gtkbase.gtk_input_remove(tag)

# these functions govern modality
def grab_add(wid):
	_gtkbase.gtk_grab_add(wid._o)
def grab_remove(wid):
	_gtkbase.gtk_grab_remove(wid._o)

# RC parsing
def rc_parse(fname):
	_gtkbase.gtk_rc_parse(fname)
def rc_parse_string(string):
	_gtkbase.gtk_rc_parse_string(string)

# font loading
def load_font(font):
	return _gtk.gdk_font_load(font)
def load_fontset(fontset):
	return _gtk.gdk_fontset_load(fontset)

# colour allocation
def colour_alloc(parent, red, green=None, blue=None):
	if hasattr(parent, '_o'): cmap = parent.get_window().colormap
	elif hasattr(parent, 'colormap'): cmap = parent.colormap
	else: cmap = parent
	if type(red) == type(''):
		return cmap.alloc(red)
	# red assumed to be an int
	if green == None and blue == None:
		green, blue = divmod(red, 256)
		red, green  = divmod(green, 256)
		red = red % 256

		red   = (red   + 1) * 256 - 1
		green = (green + 1) * 256 - 1
		blue  = (blue  + 1) * 256 - 1
	return cmap.alloc(red, green, blue)
# This one's for the Americans...
color_alloc = colour_alloc

# pixmap loading
def create_pixmap_from_xpm(window, bg, xpm):
	if hasattr(window, '_o'):
		window.realize()
		window = window.get_window()
	return _gtk.gdk_pixmap_create_from_xpm(window, bg, xpm)
def create_pixmap(window, width, height, depth=-1):
	if (hasattr(window, '_o')):
	        window.realize()
		window = window.get_window()
	return _gtk.gdk_pixmap_new(window, width, height, depth)

# drawing functions...
def draw_point(drawable, gc, x, y):
	_gtk.gdk_draw_point(drawable, gc, x, y)
def draw_line(drawable, gc, x1, y1, x2, y2):
	_gtk.gdk_draw_line(drawable, gc, x1, y1, x2, y2)
def draw_rectangle(drawable, gc, fill, x, y, width, height):
	_gtk.gdk_draw_rectangle(drawable, gc, fill, x, y,
				width, height)
def draw_arc(drawable, gc, x, y, width, height, angle1, angle2):
	_gtk.gdk_draw_arc(drawable, gc, x, y, width, height, angle1,
			  angle2)
def draw_polygon(drawable, gc, fill, points):
	_gtk.gdk_draw_polygon(drawable, gc, fill, points)
def draw_string(drawable, font, gc, x, y, string):
	_gtk.gdk_draw_string(drawable, font, gc, x, y, string)
def draw_text(drawable, font, gc, x, y, text):
	_gtk.gdk_draw_text(drawable, font, gc, x, y, text)
def draw_pixmap(drawable, gc, src, xsrc,ysrc, xdest,ydest, width,height):
	_gtk.gdk_draw_pixmap(drawable, gc, src, xsrc,ysrc,
			     xdest,ydest, width,height)
def draw_points(drawable, gc, points):
	_gtk.gdk_draw_points(drawable, gc, points)
def draw_segments(drawable, gc, segs):
	_gtk.gdk_draw_segments(drawable, gc, segs)
def draw_lines(drawable, gc, points):
	_gtk.gdk_draw_lines(drawable, gc, points)

