/*
 * FILE : ../gtkmodule.c
 * 
 * This file was automatically generated by :
 * Simplified Wrapper and Interface Generator (SWIG)
 * Version 1.1 (Patch 2)
 * 
 * Portions Copyright (c) 1995-1997
 * The University of Utah and The Regents of the University of California.
 * Permission is granted to distribute this file in any manner provided
 * this notice remains intact.
 * 
 * Do not make changes to this file--changes will be lost!
 *
 */


#define SWIGCODE
/* Implementation : PYTHON */

#define SWIGPYTHON
#include <string.h>
#include <stdlib.h>
/***********************************************************************
 * $Header:$
 * swig_lib/python/python.cfg
 *
 * This file contains coded needed to add variable linking to the
 * Python interpreter.   C variables are added as a new kind of Python
 * datatype.
 *
 * Also contains supporting code for building python under Windows
 * and things like that.
 *
 * $Log:$
 ************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "Python.h"
#ifdef __cplusplus
}
#endif

/* Definitions for Windows/Unix exporting */
#if defined(__WIN32__)
#   if defined(_MSC_VER)
#	define SWIGEXPORT(a,b) __declspec(dllexport) a b
#   else
#	if defined(__BORLANDC__)
#	    define SWIGEXPORT(a,b) a _export b
#	else
#	    define SWIGEXPORT(a,b) a b
#	endif
#   endif
#else
#   define SWIGEXPORT(a,b) a b
#endif

#ifdef SWIG_GLOBAL
#ifdef __cplusplus
#define SWIGSTATIC extern "C"
#else
#define SWIGSTATIC
#endif
#endif

#ifndef SWIGSTATIC
#define SWIGSTATIC static
#endif

typedef struct {
  char  *name;
  PyObject *(*get_attr)(void);
  int (*set_attr)(PyObject *);
} swig_globalvar;

typedef struct swig_varlinkobject {
  PyObject_HEAD
  swig_globalvar **vars;
  int      nvars;
  int      maxvars;
} swig_varlinkobject;

/* ----------------------------------------------------------------------
   swig_varlink_repr()

   Function for python repr method
   ---------------------------------------------------------------------- */

static PyObject *
swig_varlink_repr(swig_varlinkobject *v)
{
  v = v;
  return PyString_FromString("<Global variables>");
}

/* ---------------------------------------------------------------------
   swig_varlink_print()

   Print out all of the global variable names
   --------------------------------------------------------------------- */

static int
swig_varlink_print(swig_varlinkobject *v, FILE *fp, int flags)
{

  int i = 0;
  flags = flags;
  fprintf(fp,"Global variables { ");
  while (v->vars[i]) {
    fprintf(fp,"%s", v->vars[i]->name);
    i++;
    if (v->vars[i]) fprintf(fp,", ");
  }
  fprintf(fp," }\n");
  return 0;
}

/* --------------------------------------------------------------------
   swig_varlink_getattr
 
   This function gets the value of a variable and returns it as a
   PyObject.   In our case, we'll be looking at the datatype and
   converting into a number or string
   -------------------------------------------------------------------- */

static PyObject *
swig_varlink_getattr(swig_varlinkobject *v, char *n)
{
  int i = 0;
  char temp[128];

  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->get_attr)();
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return NULL;
}

/* -------------------------------------------------------------------
   swig_varlink_setattr()

   This function sets the value of a variable.
   ------------------------------------------------------------------- */

static int
swig_varlink_setattr(swig_varlinkobject *v, char *n, PyObject *p)
{
  char temp[128];
  int i = 0;
  while (v->vars[i]) {
    if (strcmp(v->vars[i]->name,n) == 0) {
      return (*v->vars[i]->set_attr)(p);
    }
    i++;
  }
  sprintf(temp,"C global variable %s not found.", n);
  PyErr_SetString(PyExc_NameError,temp);
  return 1;
}

statichere PyTypeObject varlinktype = {
/*  PyObject_HEAD_INIT(&PyType_Type)  Note : This doesn't work on some machines */
  PyObject_HEAD_INIT(0)              
  0,
  "varlink",                          /* Type name    */
  sizeof(swig_varlinkobject),         /* Basic size   */
  0,                                  /* Itemsize     */
  0,                                  /* Deallocator  */ 
  (printfunc) swig_varlink_print,     /* Print        */
  (getattrfunc) swig_varlink_getattr, /* get attr     */
  (setattrfunc) swig_varlink_setattr, /* Set attr     */
  0,                                  /* tp_compare   */
  (reprfunc) swig_varlink_repr,       /* tp_repr      */    
  0,                                  /* tp_as_number */
  0,                                  /* tp_as_mapping*/
  0,                                  /* tp_hash      */
};

/* Create a variable linking object for use later */

SWIGSTATIC PyObject *
SWIG_newvarlink(void)
{
  swig_varlinkobject *result = 0;
  result = PyMem_NEW(swig_varlinkobject,1);
  varlinktype.ob_type = &PyType_Type;    /* Patch varlinktype into a PyType */
  result->ob_type = &varlinktype;
  /*  _Py_NewReference(result);  Does not seem to be necessary */
  result->nvars = 0;
  result->maxvars = 64;
  result->vars = (swig_globalvar **) malloc(64*sizeof(swig_globalvar *));
  result->vars[0] = 0;
  Py_XINCREF((PyObject *) result);
  return ((PyObject*) result);
}

SWIGSTATIC void
SWIG_addvarlink(PyObject *p, char *name,
	   PyObject *(*get_attr)(void), int (*set_attr)(PyObject *p))
{
  swig_varlinkobject *v;
  v= (swig_varlinkobject *) p;
	
  if (v->nvars >= v->maxvars -1) {
    v->maxvars = 2*v->maxvars;
    v->vars = (swig_globalvar **) realloc(v->vars,v->maxvars*sizeof(swig_globalvar *));
    if (v->vars == NULL) {
      fprintf(stderr,"SWIG : Fatal error in initializing Python module.\n");
      exit(1);
    }
  }
  v->vars[v->nvars] = (swig_globalvar *) malloc(sizeof(swig_globalvar));
  v->vars[v->nvars]->name = (char *) malloc(strlen(name)+1);
  strcpy(v->vars[v->nvars]->name,name);
  v->vars[v->nvars]->get_attr = get_attr;
  v->vars[v->nvars]->set_attr = set_attr;
  v->nvars++;
  v->vars[v->nvars] = 0;
}



/* remove swig pointer handling code */
#define SWIG_RegisterMapping(o,n,f)
#define SWIG_MakePtr(b,p,t)
#define SWIG_GetPtr(b,p,t) NULL

#define SWIG_init    initgtk

#define SWIG_name    "gtk"

#include <gtk/gtk.h>

typedef struct {
        PyObject_HEAD
        GtkObject *go;
} PyGtk_Object;

staticforward PyTypeObject PyGtk_Type;

#define PyGtk_Check(v) ((v)->ob_type == &PyGtk_Type)
#define PyGtk_Get(v) (((PyGtk_Object *)(v))->go)

static PyObject *
PyGtk_New(GtkObject *go) {
  PyGtk_Object *self;

  self = (PyGtk_Object *)PyObject_NEW(PyGtk_Object, &PyGtk_Type);
  if (self == NULL)
    return NULL;
  self->go = go;
  gtk_object_ref(self->go);
  return (PyObject *)self;
}

static void 
PyGtk_dealloc(PyGtk_Object *self) {
  gtk_object_unref(self->go);
  PyMem_DEL(self);
}

static int
PyGtk_compare(PyGtk_Object *self, PyGtk_Object *v) {
  if (self->go == v->go) return 0;
  if (self->go > v->go) return -1;
  return 1;
}

static PyObject *
PyGtk_repr(PyGtk_Object *self) {
  char buf[100];

  sprintf(buf, "<GtkObject of type %s at %lx>",
    gtk_type_name(PyGtk_Get(self)->klass->type), (long)PyGtk_Get(self));
  return PyString_FromString(buf);
}

static char PyGtk_Type__doc__[] = "This is the type of GTK Objects";

static PyTypeObject PyGtk_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,                              /*ob_size*/
  "GtkObject",                    /*tp_name*/
  sizeof(PyGtk_Object),           /*tp_basicsize*/
  0,                              /*tp_itemsize*/
  (destructor)PyGtk_dealloc,      /*tp_dealloc*/
  (printfunc)0,                   /*tp_print*/
  (getattrfunc)0,                 /*tp_getattr*/
  (setattrfunc)0,                 /*tp_setattr*/
  (cmpfunc)PyGtk_compare,         /*tp_compare*/
  (reprfunc)PyGtk_repr,           /*tp_repr*/
  0,                              /*tp_as_number*/
  0,                              /*tp_as_sequence*/
  0,                              /*tp_as_mapping*/
  (hashfunc)0,                    /*tp_hash*/
  (ternaryfunc)0,                 /*tp_call*/
  (reprfunc)0,                    /*tp_str*/
  0L,0L,0L,0L,
  PyGtk_Type__doc__
};


typedef struct {
	PyObject_HEAD
	GtkAcceleratorTable *obj;
} PyGtkAccelerator_Object;
staticforward PyTypeObject PyGtkAccelerator_Type;

typedef struct {
	PyObject_HEAD
	GtkStyle *obj;
} PyGtkStyle_Object;
staticforward PyTypeObject PyGtkStyle_Type;

typedef struct {
	PyObject_HEAD
	GdkFont *obj;
} PyGdkFont_Object;
staticforward PyTypeObject PyGdkFont_Type;

typedef struct {
	PyObject_HEAD
	GdkColor obj;
} PyGdkColor_Object;
staticforward PyTypeObject PyGdkColor_Type;

typedef struct {
	PyObject_HEAD
	GdkEvent *obj;
	PyObject *attrs;
} PyGdkEvent_Object;
staticforward PyTypeObject PyGdkEvent_Type;

typedef struct {
        PyObject_HEAD;
        GdkWindow *obj;
        const char *type;
} PyGdkWindow_Object;
staticforward PyTypeObject PyGdkWindow_Type;

typedef struct {
        PyObject_HEAD;
        GdkGC *obj;
} PyGdkGC_Object;
staticforward PyTypeObject PyGdkGC_Type;

#define PyGtkAccelerator_Check(v) ((v)->ob_type == &PyGtkAccelerator_Type)
#define PyGtkAccelerator_Get(v) (((PyGtkAccelerator_Object *)(v))->obj)
#define PyGtkStyle_Check(v) ((v)->ob_type == &PyGtkStyle_Type)
#define PyGtkStyle_Get(v) (((PyGtkStyle_Object *)(v))->obj)
#define PyGdkFont_Check(v) ((v)->ob_type == &PyGdkFont_Type)
#define PyGdkFont_Get(v) (((PyGdkFont_Object *)(v))->obj)
#define PyGdkColor_Check(v) ((v)->ob_type == &PyGdkColor_Type)
#define PyGdkColor_Get(v) (&((PyGdkColor_Object *)(v))->obj)
#define PyGdkEvent_Check(v) ((v)->ob_type == &PyGdkEvent_Type)
#define PyGdkEvent_Get(v) (((PyGdkEvent_Object *)(v))->obj)
#define PyGdkWindow_Check(v) ((v)->ob_type == &PyGdkWindow_Type)
#define PyGdkWindow_Get(v) (((PyGdkWindow_Object *)(v))->obj)
#define PyGdkGC_Check(v) ((v)->ob_type == &PyGdkGC_Type)
#define PyGdkGC_Get(v) (((PyGdkGC_Object *)(v))->obj)


static PyObject *
PyGtkAccelerator_New(GtkAcceleratorTable *obj) {
  PyGtkAccelerator_Object  *self;

  self = (PyGtkAccelerator_Object *)PyObject_NEW(PyGtkAccelerator_Object ,
              &PyGtkAccelerator_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_accelerator_table_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGtkStyle_New(GtkStyle *obj) {
  PyGtkStyle_Object *self;

  self = (PyGtkStyle_Object *)PyObject_NEW(PyGtkStyle_Object,
                                           &PyGtkStyle_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  gtk_style_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkFont_New(GdkFont *obj) {
  PyGdkFont_Object *self;

  self = (PyGdkFont_Object *)PyObject_NEW(PyGdkFont_Object, &PyGdkFont_Type);
  /*gdk_font_ref(obj);*/
  if (self == NULL)
    return NULL;
  self->obj = obj;
  return (PyObject *)self;
}

static PyObject *
PyGdkColor_New(GdkColor *obj) {
  PyGdkColor_Object *self;

  self = (PyGdkColor_Object *)PyObject_NEW(PyGdkColor_Object,&PyGdkColor_Type);
  if (self == NULL)
    return NULL;
  self->obj.pixel = obj->pixel;
  self->obj.red   = obj->red;
  self->obj.green = obj->green;
  self->obj.blue  = obj->blue;
  return (PyObject *)self;
}

static PyObject *
PyGdkWindow_New(GdkWindow *win, const char *type) {
  PyGdkWindow_Object *self;

  self = (PyGdkWindow_Object *)PyObject_NEW(PyGdkWindow_Object,
					    &PyGdkWindow_Type);
  if (self == NULL)
    return NULL;
  self->obj = win;
  if (type)
    self->type = type;
  else
    self->type = "GdkWindow";
  gdk_window_ref(self->obj);
  return (PyObject *)self;
}

static PyObject *
PyGdkGC_New(GdkGC *gc) {
  PyGdkGC_Object *self;

  self = (PyGdkGC_Object *)PyObject_NEW(PyGdkGC_Object, &PyGdkGC_Type);
  if (self == NULL)
    return NULL;
  self->obj = gc;
  gdk_gc_ref(self->obj);
  return (PyObject *)self;
}

static void
PyGtkAccelerator_Dealloc(PyGtkAccelerator_Object *self) {
  gtk_accelerator_table_unref(self->obj); 
  PyMem_DEL(self);
}

static int
PyGtkAccelerator_Compare(PyGtkAccelerator_Object *self,
                            PyGtkAccelerator_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGtkAccelerator_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkAcceleratorTable",
  sizeof(PyGtkAccelerator_Object),
  0,
  (destructor)PyGtkAccelerator_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGtkAccelerator_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGtkStyle_Dealloc(PyGtkStyle_Object *self) {
  gtk_style_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGtkStyle_Compare(PyGtkStyle_Object *self, PyGtkStyle_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *PyGtkStyle_GetAttr(PyGtkStyle_Object *self, char *attr) {
  GtkStyle *style = self->obj;
  PyObject *ret;
  int i;

  if (!strcmp(attr, "__members__"))
    return Py_BuildValue("[ssssssssssssssssssss]", "base", "base_gc", "bg",
			 "bg_gc", "bg_pixmap", "black", "black_gc", "dark",
			 "dark_gc", "fg", "fg_gc", "font", "light",
			 "light_gc", "mid", "mid_gc", "text", "text_gc",
			 "white", "white_gc");
  if (!strcmp(attr, "fg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->fg[i]));
    return ret;
  }
  if (!strcmp(attr, "bg")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->bg[i]));
    return ret;
  }
  if (!strcmp(attr, "light")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->light[i]));
    return ret;
  }
  if (!strcmp(attr, "dark")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->dark[i]));
    return ret;
  }
  if (!strcmp(attr, "mid")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->mid[i]));
    return ret;
  }
  if (!strcmp(attr, "text")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->text[i]));
    return ret;
  }
  if (!strcmp(attr, "base")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkColor_New(&style->base[i]));
    return ret;
  }
  if (!strcmp(attr, "black"))
    return PyGdkColor_New(&style->black);
  if (!strcmp(attr, "white"))
    return PyGdkColor_New(&style->white);
  if (!strcmp(attr, "font")) {
    gdk_font_ref(style->font);
    return PyGdkFont_New(style->font);
  }
  if (!strcmp(attr, "fg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->fg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "bg_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->bg_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "light_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->light_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "dark_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->dark_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "mid_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->mid_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "text_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->text_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "base_gc")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i, PyGdkGC_New(style->base_gc[i]));
    return ret;
  }
  if (!strcmp(attr, "black_gc"))
    return PyGdkGC_New(style->black_gc);
  if (!strcmp(attr, "white_gc"))
    return PyGdkGC_New(style->white_gc);
  if (!strcmp(attr, "bg_pixmap")) {
    ret = PyTuple_New(5);
    for (i = 0; i < 5; i++)
      PyTuple_SetItem(ret, i,PyGdkWindow_New(style->bg_pixmap[i],"GdkPixmap"));
    return ret;
  }

  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static PyTypeObject PyGtkStyle_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GtkStyle",
  sizeof(PyGtkStyle_Object),
  0,
  (destructor)PyGtkStyle_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGtkStyle_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGtkStyle_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkFont_Dealloc(PyGdkFont_Object *self) {
  gdk_font_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkFont_Compare(PyGdkFont_Object *self, PyGdkFont_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkFont_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkFont",
  sizeof(PyGdkFont_Object),
  0,
  (destructor)PyGdkFont_Dealloc,
  (printfunc)0,
  (getattrfunc)0,                  
  (setattrfunc)0,
  (cmpfunc)PyGdkFont_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkColor_Dealloc(PyGdkColor_Object *self) {
  PyMem_DEL(self);
}

static int
PyGdkColor_Compare(PyGdkColor_Object *self, PyGdkColor_Object *v) {
  if (self->obj.pixel == v->obj.pixel) return 0;
  if (self->obj.pixel > v->obj.pixel) return -1;
  return 1;
}

static PyTypeObject PyGdkColor_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkColor",
  sizeof(PyGdkColor_Object),
  0,
  (destructor)PyGdkColor_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkColor_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static PyObject *
PyGdkEvent_New(GdkEvent *obj) {
  PyGdkEvent_Object *self;

  self = (PyGdkEvent_Object *)PyObject_NEW(PyGdkEvent_Object,&PyGdkEvent_Type);
  if (self == NULL)
    return NULL;
  self->obj = obj;
  self->attrs = PyDict_New();
  PyDict_SetItemString(self->attrs, "type", PyInt_FromLong(obj->type));
  PyDict_SetItemString(self->attrs, "window", PyGdkWindow_New(obj->any.window,
							      "GdkWindow"));
  PyDict_SetItemString(self->attrs, "send_event", PyInt_FromLong(
    obj->any.send_event));
  /* XXX Does anyone need the window attribute?? */
  switch(obj->type) {
    case GDK_NOTHING: break;
    case GDK_DELETE: break;
    case GDK_DESTROY: break;
    case GDK_EXPOSE:            /*GdkEventExpose            expose*/
      PyDict_SetItemString(self->attrs, "area", Py_BuildValue("(iiii)",
        obj->expose.area.x, obj->expose.area.y, obj->expose.area.width,
        obj->expose.area.height));
      PyDict_SetItemString(self->attrs, "count", PyInt_FromLong(
        obj->expose.count));
      break;
    case GDK_MOTION_NOTIFY:     /*GdkEventMotion            motion*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->motion.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->motion.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->motion.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->motion.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->motion.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->motion.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->motion.state));
      PyDict_SetItemString(self->attrs, "is_hint", PyInt_FromLong(
        obj->motion.is_hint));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->motion.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->motion.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->motion.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->motion.y_root));
      break;
    case GDK_BUTTON_PRESS:      /*GdkEventButton            button*/
    case GDK_2BUTTON_PRESS:     /*GdkEventButton            button*/
    case GDK_3BUTTON_PRESS:     /*GdkEventButton            button*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->button.time));
      PyDict_SetItemString(self->attrs,"x",PyFloat_FromDouble(obj->button.x));
      PyDict_SetItemString(self->attrs,"y",PyFloat_FromDouble(obj->button.y));
      PyDict_SetItemString(self->attrs, "pressure", PyFloat_FromDouble(
        obj->button.pressure));
      PyDict_SetItemString(self->attrs, "xtilt", PyFloat_FromDouble(
        obj->button.xtilt));
      PyDict_SetItemString(self->attrs, "ytilt", PyFloat_FromDouble(
        obj->button.ytilt));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->button.state));
      PyDict_SetItemString(self->attrs, "button", PyInt_FromLong(
        obj->button.button));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->button.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->button.deviceid));
      PyDict_SetItemString(self->attrs, "x_root", PyFloat_FromDouble(
        obj->button.x_root));
      PyDict_SetItemString(self->attrs, "y_root", PyFloat_FromDouble(
        obj->button.y_root));
      break;
    case GDK_KEY_PRESS:         /*GdkEventKey               key*/
    case GDK_KEY_RELEASE:       /*GdkEventKey               key*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(obj->key.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->key.state));
      PyDict_SetItemString(self->attrs, "keyval", PyInt_FromLong(
        obj->key.keyval));
      PyDict_SetItemString(self->attrs, "string", PyString_FromStringAndSize(
        obj->key.string, obj->key.length));
      break;
    case GDK_ENTER_NOTIFY:      /*GdkEventCrossing          crossing*/
    case GDK_LEAVE_NOTIFY:      /*GdkEventCrossing          crossing*/
      /*subwindow*/
      PyDict_SetItemString(self->attrs, "detail", PyInt_FromLong(
        obj->crossing.detail));
      break;
    case GDK_FOCUS_CHANGE:      /*GdkEventFocus             focus_change*/
      PyDict_SetItemString(self->attrs, "_in", PyInt_FromLong(
        obj->focus_change.in));
      break;
    case GDK_CONFIGURE:         /*GdkEventConfigure         configure*/
      PyDict_SetItemString(self->attrs, "x", PyInt_FromLong(obj->configure.x));
      PyDict_SetItemString(self->attrs, "y", PyInt_FromLong(obj->configure.y));
      PyDict_SetItemString(self->attrs, "width", PyInt_FromLong(
        obj->configure.width));
      PyDict_SetItemString(self->attrs, "height", PyInt_FromLong(
        obj->configure.height));
      break;
    case GDK_MAP: break;
    case GDK_UNMAP: break;
    case GDK_PROPERTY_NOTIFY:   /*GdkEventProperty          property*/
      PyDict_SetItemString(self->attrs, "atom", PyInt_FromLong(
        obj->property.atom));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->property.time));
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->property.state));
      break;
    case GDK_SELECTION_CLEAR:   /*GdkEventSelection         selection*/
    case GDK_SELECTION_REQUEST: /*GdkEventSelection         selection*/
    case GDK_SELECTION_NOTIFY:  /*GdkEventSelection         selection*/
      PyDict_SetItemString(self->attrs, "selection", PyInt_FromLong(
        obj->selection.selection));
      PyDict_SetItemString(self->attrs, "target", PyInt_FromLong(
        obj->selection.target));
      PyDict_SetItemString(self->attrs, "property", PyInt_FromLong(
        obj->selection.property));
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->selection.requestor));
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->selection.time));
      break;
    case GDK_PROXIMITY_IN:      /*GdkEventProximity         proximity*/
    case GDK_PROXIMITY_OUT:     /*GdkEventProximity         proximity*/
      PyDict_SetItemString(self->attrs, "time", PyInt_FromLong(
        obj->proximity.time));
      PyDict_SetItemString(self->attrs, "source", PyInt_FromLong(
        obj->proximity.source));
      PyDict_SetItemString(self->attrs, "deviceid", PyInt_FromLong(
        obj->proximity.deviceid));
      break;
    case GDK_DRAG_BEGIN:        /*GdkEventDragBegin         dragbegin*/
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dragbegin.u.flags.protocol_version));
      break;
    case GDK_DRAG_REQUEST:      /*GdkEventDragRequest       dragrequest*/
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dragrequest.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "sendreply", PyInt_FromLong(
        obj->dragrequest.u.flags.sendreply));
      PyDict_SetItemString(self->attrs, "willaccept", PyInt_FromLong(
        obj->dragrequest.u.flags.willaccept));
      PyDict_SetItemString(self->attrs, "delete_data", PyInt_FromLong(
        obj->dragrequest.u.flags.delete_data));
      PyDict_SetItemString(self->attrs, "senddata", PyInt_FromLong(
        obj->dragrequest.u.flags.senddata));
      PyDict_SetItemString(self->attrs, "isdrop", PyInt_FromLong(
        obj->dragrequest.isdrop));
      PyDict_SetItemString(self->attrs, "drop_coords", Py_BuildValue("(ii)",
        obj->dragrequest.drop_coords.x, obj->dragrequest.drop_coords.y));
      PyDict_SetItemString(self->attrs, "data_type", PyString_FromString(
        obj->dragrequest.data_type));
      PyDict_SetItemString(self->attrs, "timestamp", PyInt_FromLong(
        obj->dragrequest.timestamp));
      break;
    case GDK_DROP_ENTER:        /*GdkEventDropEnter         dropenter*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropenter.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropenter.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "sendreply", PyInt_FromLong(
        obj->dropenter.u.flags.sendreply));
      PyDict_SetItemString(self->attrs, "extended_typelist", PyInt_FromLong(
        obj->dropenter.u.flags.extended_typelist));
      break;
    case GDK_DROP_LEAVE:        /*GdkEventDropLeave         dropleave*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropleave.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropleave.u.flags.protocol_version));
      break;
    case GDK_DROP_DATA_AVAIL:   /*GdkEventDropDataAvailable dropdataavailable*/
      PyDict_SetItemString(self->attrs, "requestor", PyInt_FromLong(
        obj->dropdataavailable.requestor));
      PyDict_SetItemString(self->attrs, "protocol_version", PyInt_FromLong(
        obj->dropdataavailable.u.flags.protocol_version));
      PyDict_SetItemString(self->attrs, "isdrop", PyInt_FromLong(
        obj->dropdataavailable.u.flags.isdrop));
      PyDict_SetItemString(self->attrs, "data_type", PyString_FromString(
        obj->dropdataavailable.data_type));
      PyDict_SetItemString(self->attrs, "data", PyString_FromStringAndSize(
        obj->dropdataavailable.data, obj->dropdataavailable.data_numbytes));
      PyDict_SetItemString(self->attrs, "timestamp", PyInt_FromLong(
        obj->dropdataavailable.timestamp));
      PyDict_SetItemString(self->attrs, "coords", Py_BuildValue("(ii)",
        obj->dropdataavailable.coords.x, obj->dropdataavailable.coords.y));
      break;
    case GDK_CLIENT_EVENT:      /*GdkEventClient            client*/
      PyDict_SetItemString(self->attrs, "message_type", PyInt_FromLong(
        obj->client.message_type));
      PyDict_SetItemString(self->attrs, "data_format", PyInt_FromLong(
        obj->client.data_format));
      PyDict_SetItemString(self->attrs, "data", PyString_FromStringAndSize(
        obj->client.data.b, 20));
      break;
    case GDK_VISIBILITY_NOTIFY: /*GdkEventVisibility        visibility*/
      PyDict_SetItemString(self->attrs, "state", PyInt_FromLong(
        obj->visibility.state));
      break;
    case GDK_NO_EXPOSE:         /*GdkEventNoExpose          no_expose*/
      break;
    case GDK_OTHER_EVENT:
    default:
  }
  return (PyObject *)self;
}

static void
PyGdkEvent_Dealloc(PyGdkEvent_Object *self) {
  Py_XDECREF(self->attrs);
  PyMem_DEL(self);
}

static PyObject *
PyGdkEvent_GetAttr(PyGdkEvent_Object *self, char *attr) {
  PyObject *ret;
  ret = PyDict_GetItemString(self->attrs, attr);
  if (ret != NULL) {
    Py_INCREF(ret);
    return ret;
  }
  PyErr_SetString(PyExc_AttributeError, attr);
  return NULL;
}

static int
PyGdkEvent_Compare(PyGdkEvent_Object *self, PyGdkEvent_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkEvent_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkEvent",
  sizeof(PyGdkEvent_Object),
  0,
  (destructor)PyGdkEvent_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkEvent_GetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkEvent_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkWindow_Dealloc(PyGdkWindow_Object *self) {
  gdk_window_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkWindow_Compare(PyGdkWindow_Object *self, PyGdkWindow_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyObject *
PyGdkWindow_Repr(PyGdkWindow_Object *self) {
  char buf[100];
  sprintf(buf, "<%s at %lx>", self->type, (long)PyGdkWindow_Get(self));
  return PyString_FromString(buf);
}

static PyObject *
PyGdkWindow_SetAttr(PyGdkWindow_Object *self, char *key) {
  GdkWindow *win = PyGdkWindow_Get(self);
  gint x, y;
  GdkModifierType p_mask;

  if (!strcmp(key, "__members__"))
    return Py_BuildValue("[sssssssss]", "height", "parent", "pointer",
			 "pointer_state", "toplevel", "type", "width", "x",
			 "y");
  if (!strcmp(key, "width")) {
    gdk_window_get_size(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "height")) {
    gdk_window_get_size(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "x")) {
    gdk_window_get_position(win, &x, NULL);
    return PyInt_FromLong(x);
  }
  if (!strcmp(key, "y")) {
    gdk_window_get_position(win, NULL, &y);
    return PyInt_FromLong(y);
  }
  if (!strcmp(key, "pointer")) {
    gdk_window_get_pointer(win, &x, &y, NULL);
    return Py_BuildValue("(ii)", x, y);
  }
  if (!strcmp(key, "pointer_state")) {
    gdk_window_get_pointer(win, NULL, NULL, &p_mask);
    return PyInt_FromLong(p_mask);
  }
  if (!strcmp(key, "parent"))
    return PyGdkWindow_New(gdk_window_get_parent(win), "GdkWindow");
  if (!strcmp(key, "toplevel"))
    return PyGdkWindow_New(gdk_window_get_toplevel(win), "GdkWindow");
  if (!strcmp(key, "type"))
    return PyInt_FromLong(gdk_window_get_type(win));
  PyErr_SetString(PyExc_AttributeError, key);
  return NULL;
}

static PyTypeObject PyGdkWindow_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkWindow",
  sizeof(PyGdkWindow_Object),
  0,
  (destructor)PyGdkWindow_Dealloc,
  (printfunc)0,
  (getattrfunc)PyGdkWindow_SetAttr,
  (setattrfunc)0,
  (cmpfunc)PyGdkWindow_Compare,
  (reprfunc)PyGdkWindow_Repr,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};

static void
PyGdkGC_Dealloc(PyGdkGC_Object *self) {
  gdk_gc_unref(self->obj);
  PyMem_DEL(self);
}

static int
PyGdkGC_Compare(PyGdkGC_Object *self, PyGdkGC_Object *v) {
  if (self->obj == v->obj) return 0;
  if (self->obj > v->obj) return -1;
  return 1;
}

static PyTypeObject PyGdkGC_Type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "GdkGC",
  sizeof(PyGdkGC_Object),
  0,
  (destructor)PyGdkGC_Dealloc,
  (printfunc)0,
  (getattrfunc)0,
  (setattrfunc)0,
  (cmpfunc)PyGdkGC_Compare,
  (reprfunc)0,
  0,
  0,
  0,
  (hashfunc)0,
  (ternaryfunc)0,
  (reprfunc)0,
  0L,0L,0L,0L,
  NULL
};


/* signal marshallers -- Ideas Stolen from Perl Gtk*/
static PyObject *GtkArg_to_Tuple(int nparams, GtkArg *args) {
    PyObject *params;
    int i;

    params = PyTuple_New(nparams);
    for (i=0; i < nparams; i++)
        switch (GTK_FUNDAMENTAL_TYPE(args[i].type)) {
            case GTK_TYPE_INVALID:
                fprintf(stderr, "invalid argument type?\n");
                Py_INCREF(Py_None);
                PyTuple_SetItem(params, i, Py_None);
                break;
            case GTK_TYPE_NONE:
                Py_INCREF(Py_None);
                PyTuple_SetItem(params, i, Py_None);
                break;
            case GTK_TYPE_CHAR:
                PyTuple_SetItem(params, i, PyString_FromStringAndSize(
                      &(GTK_VALUE_CHAR(args[i])), 1));
                break;
            case GTK_TYPE_BOOL:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_BOOL(
                      args[i])));
                break;
            case GTK_TYPE_INT:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_INT(
                      args[i])));
                break;
            case GTK_TYPE_UINT:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_UINT(
                      args[i])));
                break;
            case GTK_TYPE_LONG:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_LONG(
                      args[i])));
                break;
            case GTK_TYPE_ULONG:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_ULONG(
                      args[i])));
                break;
            case GTK_TYPE_FLOAT:
                PyTuple_SetItem(params, i, PyFloat_FromDouble(
                      GTK_VALUE_FLOAT(args[i])));
                break;
            case GTK_TYPE_DOUBLE:
                PyTuple_SetItem(params, i, PyFloat_FromDouble(
                      GTK_VALUE_DOUBLE(args[i])));
                break;
            case GTK_TYPE_STRING:
                PyTuple_SetItem(params, i, PyString_FromString(
                      GTK_VALUE_STRING(args[i])));
                break;
            case GTK_TYPE_ENUM:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_ENUM(
                      args[i])));
                break;
            case GTK_TYPE_FLAGS:
                PyTuple_SetItem(params, i, PyInt_FromLong(GTK_VALUE_FLAGS(
                      args[i])));
                break;
            case GTK_TYPE_ARGS:
                PyTuple_SetItem(params, i, GtkArg_to_Tuple(GTK_VALUE_ARGS(
                           args[i]).n_args, GTK_VALUE_ARGS(args[i]).args));
                break;
            case GTK_TYPE_OBJECT:
                PyTuple_SetItem(params, i, PyGtk_New(GTK_VALUE_OBJECT(
                    args[i])));
                break;
            case GTK_TYPE_POINTER:
                PyTuple_SetItem(params, i,PyInt_FromLong((long)
                    GTK_VALUE_POINTER(args[i])));
                break;
            case GTK_TYPE_BOXED:
                /* conversion is specific to the type which is boxed
                 * builtin boxed types: GtkAcceleratorTable, GtkStyle,
                 *   GdkColormap, GdkVisual, GdkFont, GdkWindow, GdkEvent */
                if (args[i].type == GTK_TYPE_ACCELERATOR_TABLE)
                    PyTuple_SetItem(params, i, PyGtkAccelerator_New(
                        GTK_VALUE_BOXED(args[i])));
                else if (args[i].type == GTK_TYPE_STYLE)
                     PyTuple_SetItem(params, i, PyGtkStyle_New(
                         GTK_VALUE_BOXED(args[i])));
                else if (args[i].type == GTK_TYPE_GDK_EVENT)
                     PyTuple_SetItem(params, i, PyGdkEvent_New(
                         GTK_VALUE_BOXED(args[i])));
                else if (args[i].type == GTK_TYPE_GDK_FONT)
                     PyTuple_SetItem(params, i, PyGdkFont_New(
                         GTK_VALUE_BOXED(args[i])));
                else if (args[i].type ==  GTK_TYPE_GDK_COLOR)
                     PyTuple_SetItem(params, i, PyGdkColor_New(
                         GTK_VALUE_BOXED(args[i])));
		else if (args[i].type == GTK_TYPE_GDK_WINDOW)
		     PyTuple_SetItem(params, i, PyGdkWindow_New(
			 GTK_VALUE_BOXED(args[i]), "GdkWindow"));
                break;
            case GTK_TYPE_FOREIGN:
                Py_INCREF((PyObject *)(GTK_VALUE_FOREIGN(args[i]).data));
                PyTuple_SetItem(params, i, GTK_VALUE_FOREIGN(args[i]).data);
                break;
            case GTK_TYPE_CALLBACK:
                Py_INCREF((PyObject *)(GTK_VALUE_CALLBACK(args[i]).data));
                PyTuple_SetItem(params, i, GTK_VALUE_CALLBACK(args[i]).data);
            case GTK_TYPE_SIGNAL:
                Py_INCREF((PyObject *)(GTK_VALUE_SIGNAL(args[i]).d));
                PyTuple_SetItem(params, i, GTK_VALUE_SIGNAL(args[i]).d);
            default:
	        fprintf(stderr, "Can't decode parameter (type %s)\n",
			gtk_type_name(args[i].type));
	        Py_INCREF(Py_None);
		PyTuple_SetItem(params, i, Py_None);
                break;
        }
    return params;
}

/* set the signal/callback return type from the python return type */
static void PyGtk_SetRetType(GtkArg *ret, GtkType ret_type, PyObject *py_ret) {
    switch (GTK_FUNDAMENTAL_TYPE(ret_type)) {
    case GTK_TYPE_NONE:
    case GTK_TYPE_INVALID:
      break;
    case GTK_TYPE_BOOL:
      if (py_ret == Py_None || PyInt_Check(py_ret) && PyInt_AsLong(py_ret)==0)
	*GTK_RETLOC_BOOL(*ret) = FALSE;
      else
	*GTK_RETLOC_BOOL(*ret) = TRUE;
      break;
    case GTK_TYPE_CHAR:
      if (!PyString_Check(py_ret) || PyString_Size(py_ret) != 1)
	*GTK_RETLOC_CHAR(*ret) = '\0';
      else
	*GTK_RETLOC_CHAR(*ret) = PyString_AsString(py_ret)[0];
      break;
    case GTK_TYPE_ENUM:
    case GTK_TYPE_FLAGS:
    case GTK_TYPE_INT:
      if (!PyInt_Check(py_ret))
	*GTK_RETLOC_INT(*ret) = 0;
      else
	*GTK_RETLOC_INT(*ret) = PyInt_AsLong(py_ret);
      break;
    case GTK_TYPE_UINT:
      if (!PyInt_Check(py_ret))
	*GTK_RETLOC_UINT(*ret) = 0;
      else
	*GTK_RETLOC_UINT(*ret) = PyInt_AsLong(py_ret);
      break;
    case GTK_TYPE_LONG:
      if (!PyInt_Check(py_ret))
	*GTK_RETLOC_LONG(*ret) = 0;
      else
	*GTK_RETLOC_LONG(*ret) = PyInt_AsLong(py_ret);
      break;
    case GTK_TYPE_ULONG:
      if (!PyInt_Check(py_ret))
	*GTK_RETLOC_ULONG(*ret) = 0;
      else
	*GTK_RETLOC_ULONG(*ret) = PyInt_AsLong(py_ret);
      break;
    case GTK_TYPE_FLOAT:
      if (!PyFloat_Check(py_ret))
	*GTK_RETLOC_FLOAT(*ret) = 0;
      else
	*GTK_RETLOC_FLOAT(*ret) = PyFloat_AsDouble(py_ret);
      break;
    case GTK_TYPE_DOUBLE:
      if (!PyFloat_Check(py_ret))
	*GTK_RETLOC_DOUBLE(*ret) = 0;
      else
	*GTK_RETLOC_DOUBLE(*ret) = PyFloat_AsDouble(py_ret);
      break;
    case GTK_TYPE_STRING:
      if (!PyString_Check(py_ret))
	*GTK_RETLOC_STRING(*ret) = NULL;
      else
	*GTK_RETLOC_STRING(*ret) = g_strdup(PyString_AsString(py_ret));
      break;
    case GTK_TYPE_OBJECT:
      if (!PyGtk_Check(py_ret))
	*GTK_RETLOC_OBJECT(*ret) = NULL;
      else
	*GTK_RETLOC_OBJECT(*ret) = PyGtk_Get(py_ret);
      break;
    case GTK_TYPE_BOXED:
      if (ret_type == GTK_TYPE_ACCELERATOR_TABLE) {
	if (!PyGtkAccelerator_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGtkAccelerator_Get(py_ret);
      } else if (ret_type == GTK_TYPE_STYLE) {
	if (!PyGtkStyle_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGtkStyle_Get(py_ret);
      } else if (ret_type == GTK_TYPE_GDK_EVENT) {
	if (!PyGdkEvent_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGdkEvent_Get(py_ret);
      } else if (ret_type == GTK_TYPE_GDK_FONT) {
	if (!PyGdkFont_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGdkFont_Get(py_ret);
      } else if (ret_type == GTK_TYPE_GDK_COLOR) {
	if (!PyGdkColor_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGdkColor_Get(py_ret);
      } else if (ret_type == GTK_TYPE_GDK_WINDOW) {
	if (!PyGdkWindow_Check(py_ret))
	  *GTK_RETLOC_BOXED(*ret) = NULL;
	else
	  *GTK_RETLOC_BOXED(*ret) = PyGdkWindow_Get(py_ret);
      }
      break;
    case GTK_TYPE_POINTER:
    default:
      break;
    }
}

static
void PyGtk_SignalMarshal(GtkObject *object, /*gpointer*/ PyObject *func,
                       int nparams, GtkArg *args, GtkType *arg_types,
                                                 GtkType return_type) {
    PyObject *arg_list, *params, *ret;
    int i;

    ret = PyTuple_New(1);
    PyTuple_SetItem(ret, 0, PyGtk_New(object));

    for (i=0; i < nparams; i++) {
        if (arg_types[i] != GTK_TYPE_NONE) {
            args[i].type = arg_types[i];
        }
    }
    arg_list = GtkArg_to_Tuple(nparams, args);
    params = PySequence_Concat(ret, arg_list);
    Py_DECREF(ret);
    Py_DECREF(arg_list);
    ret = PyObject_CallObject(func, params);
    Py_DECREF(params);
    if (ret == NULL) {
        PyErr_Print();
	PyErr_Clear();
	return;
    }
    PyGtk_SetRetType(&args[nparams], return_type, ret);
    Py_DECREF(ret);
}

static
void PyGtk_SignalDestroy(/*gpointer*/ PyObject *func) {
    Py_DECREF(func);
}

static PyObject *gtk__signal_connect(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_connect", &PyGtk_Type, &obj,
                    &name, &func))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    signum = gtk_signal_connect(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}

static PyObject *gtk__signal_connect_after(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    char *name;
    PyObject *func;
    int signum;

    if (!PyArg_ParseTuple(args, "O!sO:gtk_signal_connect_after",
                    &PyGtk_Type, &obj, &name, &func))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "third argument must be callable");
        return NULL;
    }
    Py_INCREF(func);
    signum = gtk_signal_connect_after(PyGtk_Get(obj), name, NULL, func);
    return PyInt_FromLong(signum);
}


#include "sysmodule.h"

static void PyGtk_DestroyNotify(PyObject *o) {
    Py_DECREF(o);
}

static void PyGtk_CallbackMarshal(GtkObject *o, PyObject *func, int nargs,
                                                          GtkArg *args) {
    PyObject *ret, *a, *params;

    a = GtkArg_to_Tuple(nargs, args);
    if (a == NULL) {
        PyErr_Clear();
        fprintf(stderr, "can't decode params -- callback not run\n");
        return;
    }
    if (o == NULL)
      params = a;
    else {
      ret = PyTuple_New(1);
      PyTuple_SetItem(ret, 0, PyGtk_New(o));
      params = PySequence_Concat(ret, a);
      Py_DECREF(ret); Py_DECREF(a);
    }
    ret = PyObject_CallObject(func, params);
    Py_DECREF(params);
    if (ret == NULL) {
        PyErr_Print();
	PyErr_Clear();
	return;
    }
    PyGtk_SetRetType(&args[nargs], args[nargs].type, ret);
    Py_DECREF(ret);
}

/* simple callback handler -- this one actually looks at the return type */
static void PyGtk_HandlerMarshal(gpointer a, PyObject *func, int nargs,
                                                          GtkArg *args) {
    PyObject *ret;

    ret = PyObject_CallObject(func, NULL);
    if (ret == NULL) {
        PyErr_Print();
        PyErr_Clear();
        *GTK_RETLOC_BOOL(args[0]) = FALSE;
        return;
    }
    if (ret == Py_None || (PyInt_Check(ret) && PyInt_AsLong(ret) == 0))
        *GTK_RETLOC_BOOL(args[0]) = FALSE;
    else
        *GTK_RETLOC_BOOL(args[0]) = TRUE;
    Py_DECREF(ret);
}

/* callback for input handlers */
static void PyGtk_InputMarshal(gpointer a, PyObject *func, int nargs,
			                                GtkArg *args) {
    PyObject *tuple, *ret;

    tuple = Py_BuildValue("(ii)", GTK_VALUE_INT(args[0]),
			          GTK_VALUE_FLAGS(args[1]));
    ret = PyObject_CallObject(func, tuple);
    Py_DECREF(tuple);
    if (ret == NULL) {
        PyErr_Print();
	PyErr_Clear();
    } else
        Py_DECREF(ret);
}

static PyObject * gtk__init(PyObject *self, PyObject *args) {
    PyObject *av;
    int argc, i;
    char **argv;

    /* ensure that this procedure only gets run once */
    static int run_already = 0;
    if (run_already) {
        Py_INCREF(Py_None);
        return Py_None;
    }
    run_already = 1;

    if (!PyArg_ParseTuple(args, ":gtk_init"))
        return NULL;

    av = PySys_GetObject("argv");
    argc = PyList_Size(av);
    argv = malloc(argc * sizeof(char *));
    for (i = 0; i < argc; i++)
        argv[i] = strdup(PyString_AsString(PyList_GetItem(av, i)));

    gtk_init(&argc, &argv);
    PySys_SetArgv(argc, argv);

    if (argv != NULL) {
        for (i = 0; i < argc; i++)
            if (argv[i] != NULL)
                free(argv[i]);
        free(argv);
    }
    gtk_signal_set_funcs((GtkSignalMarshal)PyGtk_SignalMarshal,
                         (GtkSignalDestroy)PyGtk_SignalDestroy);
    Py_INCREF(Py_None);
    return Py_None;
}

static void PyGtk_init_types() {
    static int run_already = 0;
    if (run_already)
	return;
    run_already = 1;
    /* call gtk_*_get_type for each widget, so gtk_type_from_name works */
    gtk_adjustment_get_type();
    gtk_alignment_get_type();
    gtk_arrow_get_type();
    gtk_aspect_frame_get_type();
    gtk_bin_get_type();
    gtk_box_get_type();
    gtk_button_get_type();
    gtk_button_box_get_type();
    gtk_check_button_get_type();
    gtk_check_menu_item_get_type();
    gtk_clist_get_type();
    gtk_color_selection_get_type();
    gtk_color_selection_dialog_get_type();
    gtk_combo_get_type();
    gtk_container_get_type();
    gtk_curve_get_type();
    gtk_data_get_type();
    gtk_dialog_get_type();
    gtk_drawing_area_get_type();
    gtk_editable_get_type();
    gtk_entry_get_type();
    gtk_event_box_get_type();
    gtk_file_selection_get_type();
    gtk_fixed_get_type();
    gtk_frame_get_type();
    gtk_gamma_curve_get_type();
    gtk_handle_box_get_type();
    gtk_hbox_get_type();
    gtk_hbutton_box_get_type();
    gtk_hpaned_get_type();
    gtk_hruler_get_type();
    gtk_hscale_get_type();
    gtk_hscrollbar_get_type();
    gtk_hseparator_get_type();
    gtk_image_get_type();
    gtk_input_dialog_get_type();
    gtk_item_get_type();
    gtk_label_get_type();
    gtk_list_get_type();
    gtk_list_item_get_type();
    gtk_menu_get_type();
    gtk_menu_bar_get_type();
    gtk_menu_item_get_type();
    gtk_menu_shell_get_type();
    gtk_misc_get_type();
    gtk_notebook_get_type();
    gtk_object_get_type();
    gtk_option_menu_get_type();
    gtk_paned_get_type();
    gtk_pixmap_get_type();
    gtk_preview_get_type();
    gtk_progress_bar_get_type();
    gtk_radio_button_get_type();
    gtk_radio_menu_item_get_type();
    gtk_range_get_type();
    gtk_ruler_get_type();
    gtk_scale_get_type();
    gtk_scrollbar_get_type();
    gtk_scrolled_window_get_type();
    gtk_separator_get_type();
    gtk_spin_button_get_type();
    gtk_statusbar_get_type();
    gtk_table_get_type();
    gtk_text_get_type();
    gtk_toggle_button_get_type();
    gtk_toolbar_get_type();
    gtk_tooltips_get_type();
    gtk_tree_get_type();
    gtk_tree_item_get_type();
    gtk_vbox_get_type();
    gtk_vbutton_box_get_type();
    gtk_vpaned_get_type();
    gtk_vruler_get_type();
    gtk_vscale_get_type();
    gtk_vscrollbar_get_type();
    gtk_vseparator_get_type();
    gtk_viewport_get_type();
    gtk_widget_get_type();
    gtk_window_get_type();
}


static PyObject *
gtk__timeout_add(PyObject *self, PyObject *args) {
    guint32 interval;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_timeout_add", &interval, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "second arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_timeout_add_interp(interval,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback,
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__idle_add(PyObject *self, PyObject *args) {
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "O:gtk_idle_add", &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_interp(
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__idle_add_priority(PyObject *self, PyObject *args) {
    int p;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_idle_add_priority", &p, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_idle_add_full(p, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}
static PyObject *
gtk__quit_add(PyObject *self, PyObject *args) {
    int main_level;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iO:gtk_quit_add", &main_level, &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "2nd arg not callable");
        return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_quit_add_full(main_level, NULL,
        (GtkCallbackMarshal)PyGtk_HandlerMarshal, callback, 
        (GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *
gtk__input_add(PyObject *self, PyObject *args) {
    int source;
    GdkInputCondition condition;
    PyObject *callback;
    if (!PyArg_ParseTuple(args, "iiO:gtk_input_add", &source, &condition,
			  &callback))
        return NULL;
    if (!PyCallable_Check(callback)) {
        PyErr_SetString(PyExc_TypeError, "3rd arg not callable.");
	return NULL;
    }
    Py_INCREF(callback);
    return PyInt_FromLong(gtk_input_add_full(source, condition, NULL,
			(GtkCallbackMarshal)PyGtk_InputMarshal, callback,
			(GtkDestroyNotify)PyGtk_DestroyNotify));
}

static PyObject *PyGtk_get_types(PyObject *self, PyObject *args) {
  PyObject *d;

  d = PyDict_New();
  Py_INCREF(&PyGtk_Type);
  PyDict_SetItemString(d, "GtkObject", (PyObject *)&PyGtk_Type);
  Py_INCREF(&PyGtkAccelerator_Type);
  PyDict_SetItemString(d, "GtkAcceleratorTable",
		       (PyObject *)&PyGtkAccelerator_Type);
  Py_INCREF(&PyGtkStyle_Type);
  PyDict_SetItemString(d, "GtkStyle", (PyObject *)&PyGtkStyle_Type);
  Py_INCREF(&PyGdkFont_Type);
  PyDict_SetItemString(d, "GdkFont", (PyObject *)&PyGdkFont_Type);
  Py_INCREF(&PyGdkColor_Type);
  PyDict_SetItemString(d, "GdkColor", (PyObject *)&PyGdkColor_Type);
  Py_INCREF(&PyGdkEvent_Type);
  PyDict_SetItemString(d, "GdkEvent", (PyObject *)&PyGdkEvent_Type);
  Py_INCREF(&PyGdkWindow_Type);
  PyDict_SetItemString(d, "GdkWindow", (PyObject *)&PyGdkWindow_Type);
  Py_INCREF(&PyGdkGC_Type);
  PyDict_SetItemString(d, "GdkGC", (PyObject *)&PyGdkGC_Type);

  return d;
}


static void PyGtk_object_set(GtkObject *o, PyObject *dict) {
    int len, i;
    PyObject *keys, *key, *item;
    char *name;
    GtkType tp;
    GtkArg arg;
 
    keys = PyDict_Keys(dict);
    len = PyList_Size(keys);
    for (i=0; i < len; i++) {
        key = PyList_GetItem(keys, i);
        if (!PyString_Check(key)) {
            fprintf(stderr, "Key not a string\n");
            continue;
        }
        item = PyDict_GetItem(dict, key);
        name = PyString_AsString(key);
        tp = gtk_object_get_arg_type(name);
        if (tp == GTK_TYPE_INVALID) {
            Py_DECREF(item);
            fprintf(stderr, "Invalid key - %s\n", name);
            continue;
        }

        arg.type = tp;
        arg.name = name;
/*	fprintf(stderr, "%s - %s => %s\n", name, gtk_type_name(tp), gtk_type_name(GTK_FUNDAMENTAL_TYPE(tp)));*/
#define type_check(t) if (!t) { Py_DECREF(item); \
     fprintf(stderr, "%s: Expected %s, got %s -- ignoring\n", name, \
     gtk_type_name(GTK_FUNDAMENTAL_TYPE(tp)),item->ob_type->tp_name);continue;} 
        switch (GTK_FUNDAMENTAL_TYPE(tp)) {
            case GTK_TYPE_CHAR:
                type_check(PyString_Check(item))
                GTK_VALUE_CHAR(arg) = *PyString_AsString(item);
                break;
            case GTK_TYPE_BOOL:
                type_check(PyInt_Check(item))
                GTK_VALUE_BOOL(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_INT:
                type_check(PyInt_Check(item))
                GTK_VALUE_INT(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_UINT:
                type_check(PyInt_Check(item))
                GTK_VALUE_UINT(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_LONG:
                type_check(PyInt_Check(item))
                GTK_VALUE_LONG(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_ULONG:
                type_check(PyInt_Check(item))
                GTK_VALUE_ULONG(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_FLOAT:
                type_check(PyFloat_Check(item))
                GTK_VALUE_FLOAT(arg) = PyFloat_AsDouble(item);
                break;
            case GTK_TYPE_STRING:
                type_check(PyString_Check(item))
                GTK_VALUE_STRING(arg) = PyString_AsString(item);
                break;
            case GTK_TYPE_ENUM:
                type_check(PyInt_Check(item))
                GTK_VALUE_ENUM(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_FLAGS:
                type_check(PyInt_Check(item))
                GTK_VALUE_FLAGS(arg) = PyInt_AsLong(item);
                break;
            case GTK_TYPE_BOXED:
                type_check(PyGtkAccelerator_Check(item) || 
                           PyGtkStyle_Check(item) || PyGdkFont_Check(item) ||
                           PyGdkColor_Check(item) || PyGdkEvent_Check(item) ||
			   PyGdkWindow_Check(item))
                GTK_VALUE_BOXED(arg) = ((PyGtkStyle_Object *)item)->obj;
                break;
            case GTK_TYPE_FOREIGN:
                Py_INCREF(item);
                GTK_VALUE_FOREIGN(arg).data = item;
                GTK_VALUE_FOREIGN(arg).notify =
                    (GtkDestroyNotify)PyGtk_DestroyNotify;
                break;
            case GTK_TYPE_CALLBACK:
                type_check(PyCallable_Check(item))
                Py_INCREF(item);
                GTK_VALUE_CALLBACK(arg).marshal =
                    (GtkCallbackMarshal)PyGtk_CallbackMarshal;
                GTK_VALUE_CALLBACK(arg).data = item;
                GTK_VALUE_CALLBACK(arg).notify =
                    (GtkDestroyNotify)PyGtk_DestroyNotify;
                break;
/*            case GTK_TYPE_ARG:
            case GTK_TYPE_POINTER:
*/            case GTK_TYPE_SIGNAL:
                type_check(PyCallable_Check(item))
                Py_INCREF(item);
                GTK_VALUE_SIGNAL(arg).f = NULL; 
                GTK_VALUE_SIGNAL(arg).d = item;
                break;
            case GTK_TYPE_OBJECT:
                type_check(PyGtk_Check(item))
                GTK_VALUE_OBJECT(arg) = PyGtk_Get(item);
                break;
            default:
                type_check(1)
        }

        gtk_object_setv(o, 1, &arg);

    }
    Py_DECREF(keys);
}

static PyObject *gtk__object_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *dict;

    if (!PyArg_ParseTuple(args, "O!O!:gtk_object_set", &PyGtk_Type, &obj,
                  &PyDict_Type, &dict))
        return NULL;
    PyGtk_object_set(PyGtk_Get(obj), dict);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *gtk__object_new(PyObject *self, PyObject *args) {
    char *name;
    int type;
    PyObject *dict;
    GtkObject *obj;

    PyGtk_init_types();
    if (PyArg_ParseTuple(args, "sO!:gtk_object_new", &name, &PyDict_Type,
                  &dict))
        type = gtk_type_from_name(name);
    else {
        PyErr_Clear();
        if (!PyArg_ParseTuple(args, "iO!:gtk_object_new", &type, &PyDict_Type,
                      &dict))
            return NULL;
        name = gtk_type_name(type);
    }
    obj = gtk_object_newv(type, 0, NULL);
    PyGtk_object_set(obj, dict);
    return PyGtk_New(obj);
}

static PyObject *gtk__object_get(PyObject *self, PyObject *args) {
    PyGtk_Object *o;
    char *name;
    GtkArg garg;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s:gtk_object_get", &PyGtk_Type, &o, &name))
        return NULL;
    garg.name = name;
    gtk_object_getv(PyGtk_Get(o), 1, &garg);

    if (garg.type == GTK_TYPE_INVALID) {
        PyErr_SetString(PyExc_AttributeError, "invalid property");
        return NULL;
    }
    switch (GTK_FUNDAMENTAL_TYPE(garg.type)) {
        case GTK_TYPE_INVALID:
            PyErr_SetString(PyExc_AttributeError, "invalid property");
            return NULL;
        case GTK_TYPE_NONE:
            Py_INCREF(Py_None);
            return Py_None;
        case GTK_TYPE_CHAR:
            return PyString_FromStringAndSize(&GTK_VALUE_CHAR(garg), 1);
        case GTK_TYPE_INT:
            return PyInt_FromLong(GTK_VALUE_INT(garg));
	case GTK_TYPE_UINT:
            return PyInt_FromLong(GTK_VALUE_UINT(garg));
        case GTK_TYPE_BOOL:
            return PyInt_FromLong(GTK_VALUE_BOOL(garg));
        case GTK_TYPE_LONG:
            return PyInt_FromLong(GTK_VALUE_LONG(garg));
        case GTK_TYPE_ULONG:
            return PyInt_FromLong(GTK_VALUE_ULONG(garg));
        case GTK_TYPE_FLOAT:
            return PyFloat_FromDouble(GTK_VALUE_FLOAT(garg));
        case GTK_TYPE_DOUBLE:
            return PyFloat_FromDouble(GTK_VALUE_DOUBLE(garg));
        case GTK_TYPE_STRING:
            ret = PyString_FromString(GTK_VALUE_STRING(garg));
            free(GTK_VALUE_STRING(garg));
            return ret;
        case GTK_TYPE_ENUM:
            return PyInt_FromLong(GTK_VALUE_ENUM(garg));
        case GTK_TYPE_FLAGS:
            return PyInt_FromLong(GTK_VALUE_FLAGS(garg));
        case GTK_TYPE_OBJECT:
            return PyGtk_New(GTK_VALUE_OBJECT(garg));
        case GTK_TYPE_FOREIGN:
            Py_INCREF((PyObject *)GTK_VALUE_FOREIGN(garg).data);
            return (PyObject *)GTK_VALUE_FOREIGN(garg).data;
        case GTK_TYPE_CALLBACK:
            Py_INCREF((PyObject *)GTK_VALUE_CALLBACK(garg).data);
            return (PyObject *)GTK_VALUE_CALLBACK(garg).data;
        case GTK_TYPE_SIGNAL:
            if (GTK_VALUE_SIGNAL(garg).f != (GtkFunction)NULL) {
                PyErr_SetString(PyExc_TypeError, "not a python coded signal");
                return NULL;
            }
            Py_INCREF((PyObject *)GTK_VALUE_SIGNAL(garg).d);
            return (PyObject *)GTK_VALUE_SIGNAL(garg).d;
        case GTK_TYPE_ARGS:
            return GtkArg_to_Tuple(GTK_VALUE_ARGS(garg).n_args,
                GTK_VALUE_ARGS(garg).args);
        case GTK_TYPE_BOXED: /* one of the boxed types */
            if (garg.type == GTK_TYPE_ACCELERATOR_TABLE)
                return PyGtkAccelerator_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_STYLE)
                return PyGtkStyle_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_EVENT)
                return PyGdkEvent_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_FONT)
                return PyGdkFont_New(GTK_VALUE_BOXED(garg));
            else if (garg.type == GTK_TYPE_GDK_COLOR)
                return PyGdkColor_New(GTK_VALUE_BOXED(garg));
	    else if (garg.type == GTK_TYPE_GDK_WINDOW)
	        return PyGdkWindow_New(GTK_VALUE_BOXED(garg), "GdkWindow");
            else {
                PyErr_SetString(PyExc_TypeError, "unknown type");
                return NULL;
            }
        case GTK_TYPE_POINTER:
        case GTK_TYPE_C_CALLBACK:
            PyErr_SetString(PyExc_AttributeError,
                "property type not implemented");
            return NULL;
    }
    PyErr_SetString(PyExc_AttributeError, "Unknown fundamental type");
    return NULL;
}

static PyObject *gdk__pixmap_new(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  PyObject *win, *ret;
  int w, h, d;
  if (!PyArg_ParseTuple(args, "O!iii:gdk_pixmap_new", &PyGdkWindow_Type, &win,
		       &w, &h, &d))
    return NULL;
  pix = gdk_pixmap_new(PyGdkWindow_Get(win), w, h, d);
  ret = PyGdkWindow_New(pix, "GdkPixmap");
  gdk_pixmap_unref(pix);
  return ret;
}
static PyObject *gdk__pixmap_create_from_xpm(PyObject *self, PyObject *args) {
  GdkPixmap *pix;
  GdkBitmap *mask;
  PyObject *parent_win, *colour, *ret;
  GdkColor *col;
  gchar *fname;

  if (!PyArg_ParseTuple(args, "O!Os:gdk_pixmap_create_from_xpm",
			&PyGdkWindow_Type, &parent_win, &colour, &fname))
    return NULL;
  if (colour == Py_None)             col = NULL;
  else if (PyGdkColor_Check(colour)) col = PyGdkColor_Get(colour);
  else {
    PyErr_SetString(PyExc_TypeError,
		    "second argument must be a colour or None");
    return NULL;
  }
  pix = gdk_pixmap_create_from_xpm(PyGdkWindow_Get(parent_win), &mask, col,
				   fname);
  if (pix == NULL) {
    PyErr_SetString(PyExc_IOError, "can't load pixmap");
    return NULL;
  }
  ret =  Py_BuildValue("(OO)", PyGdkWindow_New(pix, "GdkPixmap"),
		       PyGdkWindow_New(mask, "GdkBitmap"));
  gdk_pixmap_unref(pix);
  gdk_bitmap_unref(mask);
  return ret;
}

static PyObject *gdk__draw_polygon(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint filled, npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!iO:gdk_draw_polygon", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &filled, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "forth argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_polygon(PyGdkWindow_Get(win),PyGdkGC_Get(gc),filled,points,npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_text(PyObject *self, PyObject *args) {
  PyObject *win, *font, *gc;
  int x, y, len;
  char *str;
  if (!PyArg_ParseTuple(args, "O!O!O!iis#:gdk_draw_text", &PyGdkWindow_Type,
			&win, &PyGdkFont_Type, &font, &PyGdkGC_Type, &gc,
			&x, &y, &str, &len))
    return NULL;
  gdk_draw_text(PyGdkWindow_Get(win), PyGdkFont_Get(font), PyGdkGC_Get(gc),
		x, y, str, len);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_points(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_points", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_points(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_segments(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint nsegs, i;
  GdkSegment *segs;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_segments", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  nsegs = PySequence_Length(seq);
  segs = g_new(GdkSegment, nsegs);
  for (i = 0; i < nsegs; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hhhh", &(segs[i].x1), &(segs[i].y1),
			  &(segs[i].x2), &(segs[i].y2))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 4-tuple");
      g_free(segs);
      return NULL;
    }
  }
  gdk_draw_segments(PyGdkWindow_Get(win), PyGdkGC_Get(gc), segs, nsegs);
  g_free(segs);
  Py_INCREF(Py_None);
  return Py_None;
}
static PyObject *gdk__draw_lines(PyObject *self, PyObject *args) {
  PyObject *win, *gc, *seq, *item;
  gint npoints, i;
  GdkPoint *points;

  if (!PyArg_ParseTuple(args, "O!O!O:gdk_draw_lines", &PyGdkWindow_Type,
			&win, &PyGdkGC_Type, &gc, &seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "third argument not a sequence");
    return NULL;
  }
  npoints = PySequence_Length(seq);
  points = g_new(GdkPoint, npoints);
  for (i = 0; i < npoints; i++) {
    item = PySequence_GetItem(seq, i);
    if (!PyArg_ParseTuple(item, "hh", &(points[i].x), &(points[i].y))) {
      PyErr_Clear();
      PyErr_SetString(PyExc_TypeError, "sequence member not a 2-tuple");
      g_free(points);
      return NULL;
    }
  }
  gdk_draw_lines(PyGdkWindow_Get(win), PyGdkGC_Get(gc), points, npoints);
  g_free(points);
  Py_INCREF(Py_None);
  return Py_None;
}

/* gdk_color_alloc analog */
static PyObject *
gdk__color_alloc(PyObject *self, PyObject *args) {
    GdkColor gdk_color;
    GdkColormap *colormap;
    PyGtkStyle_Object *style;
    PyGtk_Object *obj;
    if (PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", &PyGtkStyle_Type,
			 &style, &(gdk_color.red), &(gdk_color.green),
			 &(gdk_color.blue)))
        colormap = PyGtkStyle_Get(style)->colormap;
    else {
        PyErr_Clear();
	if (!PyArg_ParseTuple(args, "O!iii:gdk_color_alloc", &PyGtk_Type,
			      &obj, &(gdk_color.red), &(gdk_color.green),
			      &(gdk_color.blue)))
	    return NULL;
	if (GTK_WIDGET_NO_WINDOW(PyGtk_Get(obj))) {
	    PyErr_SetString(PyExc_TypeError, "widget has no window");
	    return NULL;
	}
	colormap = gdk_window_get_colormap(GTK_WIDGET(PyGtk_Get(obj))->window);
    }
    gdk_color_alloc(colormap, &gdk_color);
    return PyGdkColor_New(&gdk_color);
}

static PyObject *gtk__object_set_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!sO:gtk_object_set_data", &PyGtk_Type,
			&obj, &key, &data))
		return NULL;
	Py_INCREF(data);
	gtk_object_set_data_full(PyGtk_Get(obj), key, data,
		(GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__object_get_data(PyObject *self, PyObject *args) {
	PyGtk_Object *obj;
	char *key;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!s:gtk_object_get_data", &PyGtk_Type,
			&obj, &key))
		return NULL;
	data = gtk_object_get_data(PyGtk_Get(obj), key);
	if (data != NULL) {
		Py_INCREF(data);
		return data;
	} else {
		Py_INCREF(Py_None);
		return Py_None;
	}
}

#define gtk_widget_get_window(o) ((o)->window)

static PyObject *gtk_widget__get_pointer(PyObject *self, PyObject *args) {
  int x, y;
  PyGtk_Object *w;
  if (!PyArg_ParseTuple(args, "O!:gtk_widget_get_pointer", &PyGtk_Type, &w))
    return NULL;
  gtk_widget_get_pointer(GTK_WIDGET(w->go), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}

static PyObject *
gtk__widget_dnd_drag_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iO:gtk_widget_dnd_drag_set", &PyGtk_Type,
			  &obj, &enable, &pylist))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drag_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,numtypes);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
gtk__widget_dnd_drop_set(PyObject *self, PyObject *args) {
    PyGtk_Object *obj;
    PyObject *pylist, *item;
    char **list;
    int enable, is_destructive, numtypes, i;
    if (!PyArg_ParseTuple(args, "O!iOi:gtk_widget_dnd_drop_set", &PyGtk_Type,
			  &obj, &enable, &pylist, &is_destructive))
        return NULL;
    if (!PySequence_Check(pylist)) {
        PyErr_SetString(PyExc_TypeError, "3rd argument not a sequence");
	return NULL;
    }
    numtypes = PySequence_Length(pylist);
    list = malloc(numtypes * sizeof(char *));
    for (i = 0; i < numtypes; i++) {
        item = PySequence_GetItem(pylist, i);
        if (!PyString_Check(item)) {
	    PyErr_SetString(PyExc_TypeError, "sequence item not a string");
	    free(list);
	    return NULL;
	}
	list[i] = PyString_AsString(item);
    }
    gtk_widget_dnd_drop_set(GTK_WIDGET(PyGtk_Get(obj)), enable, list,
			    numtypes, is_destructive);
    free(list);
    Py_INCREF(Py_None);
    return Py_None;
}
static PyObject *
gtk__widget_dnd_data_set(PyObject *self, PyObject *args) {
    PyGtk_Object *wid;
    PyGdkEvent_Object *event;
    char *string;
    int len;
    if (!PyArg_ParseTuple(args, "O!O!z#:gtk_widget_dnd_data_set", &PyGtk_Type,
			  &wid, &PyGdkEvent_Type, &event, &string, &len))
        return NULL;
    gtk_widget_dnd_data_set(GTK_WIDGET(PyGtk_Get(wid)), PyGdkEvent_Get(event),
			    (gpointer) string, len);
    Py_INCREF(Py_None);
    return Py_None;
}

#define gtk_adjustment_get_lower(o)          ((o)->lower)
#define gtk_adjustment_get_upper(o)          ((o)->upper)
#define gtk_adjustment_get_value(o)          ((o)->value)
#define gtk_adjustment_get_step_increment(o) ((o)->step_increment)
#define gtk_adjustment_get_page_increment(o) ((o)->page_increment)
#define gtk_adjustment_get_page_size(o)      ((o)->page_size)

static PyObject *
gtk__button_box_get_child_size_default(PyObject *self, PyObject *args) {
    int mw, mh;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_size_default"))
        return NULL;
    gtk_button_box_get_child_size_default(&mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args) {
    int ipx, ipy;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_ipadding_default"))
        return NULL;
    gtk_button_box_get_child_ipadding_default(&ipx, &ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
static PyObject *
gtk__button_box_get_child_size(PyObject *self, PyObject *args) {
    int mw, mh;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_size",
            &PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_size(GTK_BUTTON_BOX(PyGtk_Get(o)), &mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args) {
    int ipx, ipy;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_ipadding",
            &PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_ipadding(GTK_BUTTON_BOX(PyGtk_Get(o)),&ipx,&ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}

#define gtk_check_menu_item_get_active(cb) ((cb)->active)

static PyObject *gtk__clist_new_with_titles(PyObject *self, PyObject *args) {
	int c, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "iO:gtk_clist_new_with_titles",
			&c, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError,"3rd argument not a sequence");
		return NULL;
	}
	if (PySequence_Length(l) < c) {
		PyErr_SetString(PyExc_TypeError, "sequence not long enough");
		return NULL;
	}
	list = malloc(sizeof(char *)*c);
	for (i = 0; i < c; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				 "sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	item = (PyObject *) PyGtk_New((GtkObject *)gtk_clist_new_with_titles
		(c, list));
	free(list);
	return item;
}

static PyObject *gtk__clist_get_text(PyObject *self, PyObject *args) {
	PyGtk_Object *w;
	int r, c;
	char *text;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_text", &PyGtk_Type,
			&w, &r, &c))
		return NULL;
	gtk_clist_get_text(GTK_CLIST(PyGtk_Get(w)), r, c, &text);
	return PyString_FromString(text);
}
static PyObject *gtk__clist_get_pixmap(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!iiO!:gtk_clist_get_pixmap", &PyGtk_Type,
			&o, &r, &c))
		return NULL;
	gtk_clist_get_pixmap(GTK_CLIST(PyGtk_Get(o)), r, c, &p, &m);
	return Py_BuildValue("(OO)", PyGdkWindow_New(p, "GdkPixmap"),
			     PyGdkWindow_New(m, "GdkBitmap"));
}
static PyObject *gtk__clist_get_pixtext(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	int r, c;
	guint8 spacing;
	char *text;
	GdkPixmap *p;
	GdkBitmap *m;
	if (!PyArg_ParseTuple(args, "O!ii:gtk_clist_get_pixtext",
			&PyGtk_Type, &o, &r, &c))
		return NULL;
	gtk_clist_get_pixtext(GTK_CLIST(PyGtk_Get(o)), r, c, &text, &spacing,
		&p, &m);
	return Py_BuildValue("(siOO)", text, (int)spacing,
			     PyGdkWindow_New(p, "GdkPixmap"),
			     PyGdkWindow_New(m, "GdkBitmap"));
}

static PyObject *gtk__clist_append(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!O:gtk_clist_append", &PyGtk_Type, &cl,
			&l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	i = gtk_clist_append(GTK_CLIST(PyGtk_Get(cl)), list);
	free(list);
	return PyInt_FromLong(i);
}

static PyObject *gtk__clist_insert(PyObject *self, PyObject *args) {
	PyGtk_Object *cl;
	int col, r, i;
	PyObject *l, *item;
	char **list;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_insert", &PyGtk_Type, &cl,
			&r, &l))
		return NULL;
	if (!PySequence_Check(l)) {
		PyErr_SetString(PyExc_TypeError, "argument not a sequence");
		return NULL;
	}
	col = GTK_CLIST(PyGtk_Get(cl))->columns;
	if (PySequence_Length(l) < col) {
		PyErr_SetString(PyExc_TypeError, "sequnce too short");
		return NULL;
	}
	list = malloc(sizeof(char *) * col);
	for (i = 0; i < col; i++) {
		item = PySequence_GetItem(l, i);
		if (!PyString_Check(item)) {
			PyErr_SetString(PyExc_TypeError,
				"sequence item not a string");
			free(list);
			return NULL;
		}
		list[i] = PyString_AsString(item);
	}
	gtk_clist_insert(GTK_CLIST(PyGtk_Get(cl)), r, list);
	free(list);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__clist_set_row_data(PyObject *self, PyObject *args) {
        PyGtk_Object *obj;
	int row;
	PyObject *data;
	if (!PyArg_ParseTuple(args, "O!iO:gtk_clist_set_row_data", &PyGtk_Type,
			      &obj, &row, &data))
	    return NULL;
	Py_INCREF(data);
	gtk_clist_set_row_data_full(GTK_CLIST(PyGtk_Get(obj)), row, data,
				    (GtkDestroyNotify)PyGtk_DestroyNotify);
	Py_INCREF(Py_None);
	return Py_None;
}

#define gtk_color_selection_dialog_get_colorsel(d)      ((d)->colorsel)
#define gtk_color_selection_dialog_get_main_vbox(d)     ((d)->main_vbox)
#define gtk_color_selection_dialog_get_ok_button(d)     ((d)->ok_button)
#define gtk_color_selection_dialog_get_reset_button(d)  ((d)->reset_button)
#define gtk_color_selection_dialog_get_cancel_button(d) ((d)->cancel_button)
#define gtk_color_selection_dialog_get_help_button(d)   ((d)->help_button)

#define gtk_combo_get_entry(c) ((c)->entry)
#define gtk_combo_get_list(c)  ((c)->list)

static PyObject *gtk__curve_get_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  int size=-1, i;
  gfloat *vector;
  PyObject *ret;

  if (!PyArg_ParseTuple(args, "O!|i:gtk_curve_get_vector", &PyGtk_Type, &obj,
			&size))
    return NULL;
  if (size < 0) size = GTK_CURVE(PyGtk_Get(obj))->num_points;
  vector = g_new(gfloat, size);
  gtk_curve_get_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  ret = PyTuple_New(size);
  for (i = 0; i < size; i++)
    PyTuple_SetItem(ret, i, PyFloat_FromDouble(vector[i]));
  g_free(vector);
  return ret;
}
static PyObject *gtk__curve_set_vector(PyObject *self, PyObject *args) {
  PyGtk_Object *obj;
  PyObject *seq, *item;
  int size, i;
  gfloat *vector;

  if (!PyArg_ParseTuple(args, "O!O:gtk_curve_set_vector", &PyGtk_Type, &obj,
			&seq))
    return NULL;
  if (!PySequence_Check(seq)) {
    PyErr_SetString(PyExc_TypeError, "2nd argument is not a sequence");
    return NULL;
  }
  size = PySequence_Length(seq);
  vector = g_new(gfloat, size);
  for (i = 0; i < size; i++) {
    item = PyNumber_Float(PySequence_GetItem(seq, i));
    if (item == NULL) {
      g_free(vector);
      return NULL;
    }
    vector[i] = PyFloat_AsDouble(item);
    Py_DECREF(item);
  }
  gtk_curve_set_vector(GTK_CURVE(PyGtk_Get(obj)), size, vector);
  g_free(vector);
  Py_INCREF(Py_None);
  return Py_None;
}

#define gtk_dialog_get_vbox(d) ((d)->vbox)
#define gtk_dialog_get_action_area(d) ((d)->action_area)

static PyObject *gtk__editable_insert_text(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *text;
	int len, pos;
	if (!PyArg_ParseTuple(args, "O!s#:gtk_editable_insert_text",
			&PyGtk_Type, &o, &text, &len))
		return NULL;
	gtk_editable_insert_text(GTK_EDITABLE(PyGtk_Get(o)), text, len, &pos);
	return PyInt_FromLong(pos);
}

#define gtk_file_selection_get_dir_list(f)  ((f)->dir_list)
#define gtk_file_selection_get_file_list(f) ((f)->file_list)
#define gtk_file_selection_get_selection_entry(f) ((f)->selection_entry)
#define gtk_file_selection_get_selection_text(f)  ((f)->selection_text)
#define gtk_file_selection_get_main_vbox(f) ((f)->main_vbox)
#define gtk_file_selection_get_ok_button(f) ((f)->ok_button)
#define gtk_file_selection_get_cancel_button(f) ((f)->cancel_button)
#define gtk_file_selection_get_help_button(f) ((f)->help_button)

#define gtk_list_get_selection(l) ((l)->selection)

static void PyGtk_MenuPosition(GtkMenu *menu, int *x, int *y, PyObject *func) {
    PyObject *ret;
    ret = PyObject_CallFunction(func, "(O)", PyGtk_New(GTK_OBJECT(menu)));
    if (ret == NULL || !PyArg_ParseTuple(ret, "ii", x, y)) {
        PyErr_Clear();
        fprintf(stderr, "Ignoring Exception\n");
        *x = 0;
        *y = 0;
    } else
        Py_DECREF(ret);
}
static PyObject *gtk__menu_popup(PyObject *self, PyObject *args) {
    PyGtk_Object *m, *pms, *pmi;
    PyObject *func;
    int button, time;
    if (!PyArg_ParseTuple(args, "O!O!O!Oii:gtk_menu_item", &PyGtk_Type, &m,
            &PyGtk_Type, &pms, &PyGtk_Type, &pmi, &func, &button, &time))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "forth argument not callable");
        return NULL;
    }
    Py_INCREF(func);
    gtk_menu_popup(GTK_MENU(PyGtk_Get(m)), GTK_WIDGET(PyGtk_Get(pms)),
        GTK_WIDGET(PyGtk_Get(pmi)), (GtkMenuPositionFunc)PyGtk_MenuPosition,
        func, button, time);
    Py_INCREF(Py_None);
    return Py_None;
}

static PyObject *gtk__pixmap_new_from_xpm(PyObject *self, PyObject *args) {
    PyGtk_Object *win;
    PyGdkColor_Object *tc = NULL;
    char *name;
    GdkColor *bg;
    GdkPixmap *pm;
    GdkBitmap *bm;
    PyObject *ret;

    if (!PyArg_ParseTuple(args, "O!s|O!:gtk_pixmap_new_from_xpm", &PyGtk_Type,
            &win, &name, &PyGdkColor_Type, &tc))
        return  NULL;
    if (tc == NULL)
        bg = NULL;
    else
        bg = PyGdkColor_Get(tc);
    pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(PyGtk_Get(win))->window, &bm,
        bg, name);
    if (pm == NULL) {
      PyErr_SetString(PyExc_IOError, "can't load pixmap");
      return NULL;
    }
    ret = PyGtk_New(GTK_OBJECT(gtk_pixmap_new(pm, bm)));
    /* gtk_pixmap_new ref's the pixmap and mask, so we can unref out vars */
    gdk_pixmap_unref(pm);
    gdk_bitmap_unref(bm);
    return ret;
}
static PyObject *gtk__pixmap_get(PyObject *self, PyObject *args) {
  PyObject *pix;
  GdkPixmap *pixmap;
  GdkBitmap *mask;
  if (!PyArg_ParseTuple(args, "O!:gtk_pixmap_get", &PyGtk_Type, &pix))
    return NULL;
  gtk_pixmap_get(GTK_PIXMAP(PyGtk_Get(pix)), &pixmap, &mask);
  return Py_BuildValue("(OO)", PyGdkWindow_New(pixmap, "GdkPixmap"),
		       PyGdkWindow_New(mask, "GdkBitmap"));
}

static PyObject *gtk__radio_button_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_button_new", &PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_button_group(GTK_RADIO_BUTTON(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_button_new(l)));
}
static PyObject *gtk__radio_button_new_with_label(PyObject *s,PyObject *args){
    PyGtk_Object *g = NULL;
    char *label = "";
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|Os:gtk_radio_button_new_with_label",
            &g, &label))
        return NULL;
    if (g != NULL)
        if (!PyGtk_Check(g) && (PyObject *)g != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "first argument not a GtkObject or None");
            return NULL;
        }
    if ((PyObject *)g == Py_None) g = NULL;
    if (g)
        l = gtk_radio_button_group(GTK_RADIO_BUTTON(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_button_new_with_label(l, label)));
}

static PyObject *gtk__radio_menu_item_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_menu_item_new",&PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new(l)));
}
static PyObject *gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a) {
    PyGtk_Object *g = NULL;
    char *label = "";
    GSList *l = NULL;
    if (!PyArg_ParseTuple(a, "|Os:gtk_radio_menu_item_new_with_label",
            &g, &label))
        return NULL;
    if (g != NULL)
        if (!PyGtk_Check(g) && (PyObject *)g != Py_None) {
            PyErr_SetString(PyExc_TypeError,
                "first argument not a GtkObject or None");
            return NULL;
        }
    if ((PyObject *)g == Py_None) g = NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new_with_label(l, label)));
}

#define gtk_spin_button_new_no_adj(c,d) gtk_spin_button_new(NULL,c,d)

#define gtk_text_get_hadjustment(t) ((t)->hadj)
#define gtk_text_get_vadjustment(t) ((t)->vadj)

static PyObject *gtk__text_insert_defaults(PyObject *self, PyObject *args) {
    PyGtk_Object *txt;
    char *chars;
    int l;
    GtkStyle *style;
    if (!PyArg_ParseTuple(args, "O!s#:gtk_text_insert_defaults", &PyGtk_Type,
                                     &txt, &chars, &l))
        return NULL;
    style = gtk_widget_get_style(GTK_WIDGET(PyGtk_Get(txt)));
    gtk_text_insert(GTK_TEXT(PyGtk_Get(txt)), NULL,
        &style->fg[GTK_STATE_NORMAL], NULL, chars, l);
    Py_INCREF(Py_None);
    return Py_None;
}

#define gtk_toggle_button_get_active(tb) ((tb)->active)

static PyObject *gtk__toolbar_append_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_append_item",
			&PyGtk_Type, &t, &text, &tooltip, &tip_private,
                        &PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
        /* if you set sigfunc to NULL, no signal is connected, rather than
           the default signal handler being used */
	gtk_toolbar_append_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None) {
		tmp_list = g_list_last(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))));
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_prepend_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	if (!PyArg_ParseTuple(args, "O!zzzO!O|gtk_toolbar_prepend_item",
			&PyGtk_Type, &t, &text, &tooltip, &tip_private,
			&PyGtk_Type, &icon, &callback))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_prepend_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL);
	if (callback != Py_None)
		gtk_signal_connect(GTK_OBJECT(gtk_container_children(
			GTK_CONTAINER(PyGtk_Get(t)))->data), "clicked", NULL,
			callback);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__toolbar_insert_item(PyObject *self, PyObject *args) {
	PyGtk_Object *t, *icon;
	char *text, *tooltip, *tip_private;
	PyObject *callback;
	int pos;
	GList *tmp_list;
	if (!PyArg_ParseTuple(args, "O!zzzO!Oi|gtk_toolbar_insert_item",
			&PyGtk_Type, &t, &text, &tooltip, &tip_private,
			&PyGtk_Type, &icon, &callback, &pos))
		return NULL;
	if (!PyCallable_Check(callback) && callback != Py_None) {
		PyErr_SetString(PyExc_TypeError,"sixth argument not callable");
		return NULL;
	}
	Py_INCREF(callback);
	gtk_toolbar_insert_item(GTK_TOOLBAR(PyGtk_Get(t)), text, tooltip,
		tip_private, GTK_WIDGET(PyGtk_Get(icon)), NULL, NULL, pos);
	if (callback != Py_None) {
		tmp_list = g_list_nth(gtk_container_children(GTK_CONTAINER(
			PyGtk_Get(t))), pos);
		gtk_signal_connect(GTK_OBJECT(tmp_list->data), "clicked", NULL,
			callback);
	}
	Py_INCREF(Py_None);
	return Py_None;
}

#define gtk_tree_get_selection(t) ((t)->selection)

static PyObject *gtk__window_set_icon(PyObject *self, PyObject *args) {
	PyGtk_Object *o, *pix, *mask;
        GtkWidget *win;
	if (!PyArg_ParseTuple(args, "O!O!O!:gtk_window_set_icon", &PyGtk_Type,
			&o, &PyGdkWindow_Type, &pix, &PyGdkWindow_Type, &mask))
		return NULL;
	win = GTK_WIDGET(PyGtk_Get(o));
	gtk_widget_realize(win);
	gdk_window_set_icon(win->window, NULL, PyGdkWindow_Get(pix),
			    PyGdkWindow_Get(mask));
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *gtk__window_set_icon_name(PyObject *self, PyObject *args) {
	PyGtk_Object *o;
	char *name;
	if (!PyArg_ParseTuple(args, "O!s:gtk_window_set_icon_name",
			&PyGtk_Type, &o, &name))
		return NULL;
	gdk_window_set_icon_name(GTK_WIDGET(PyGtk_Get(o))->window, name);
	Py_INCREF(Py_None);
	return Py_None;
}
static PyObject *_wrap_gtk_signal_disconnect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_signal_disconnect",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_signal_disconnect(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_disconnect_by_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_signal_disconnect_by_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  _arg1 = _obj1;
}
    gtk_signal_disconnect_by_data(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_handler_block(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_signal_handler_block",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_signal_handler_block(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_handler_block_by_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_signal_handler_block_by_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  _arg1 = _obj1;
}
    gtk_signal_handler_block_by_data(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_handler_unblock(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_signal_handler_unblock",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_signal_handler_unblock(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_handler_unblock_by_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_signal_handler_unblock_by_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  _arg1 = _obj1;
}
    gtk_signal_handler_unblock_by_data(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_handlers_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_signal_handlers_destroy",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_signal_handlers_destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_signal_emit_stop_by_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_signal_emit_stop_by_name",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_signal_emit_stop_by_name(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_exit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_exit",&_arg0)) 
        return NULL;
    gtk_exit(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_main(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_main")) 
        return NULL;
    gtk_main();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_main_quit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_main_quit")) 
        return NULL;
    gtk_main_quit();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_main_iteration(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    int  _arg0 = 1;

    self = self;
    if(!PyArg_ParseTuple(args,"|i:gtk_main_iteration",&_arg0)) 
        return NULL;
    _result = (int )gtk_main_iteration_do(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_grab_add(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_grab_add",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_grab_add(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_grab_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_grab_remove",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_grab_remove(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_timeout_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_timeout_remove",&_arg0)) 
        return NULL;
    gtk_timeout_remove(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_idle_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_idle_remove",&_arg0)) 
        return NULL;
    gtk_idle_remove(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_idle_remove_function(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_idle_remove_function",&_obj0)) 
        return NULL;
{
  _arg0 = _obj0;
}
    gtk_idle_remove_by_data(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_quit_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_quit_remove",&_arg0)) 
        return NULL;
    gtk_quit_remove(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_quit_remove_function(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_quit_remove_function",&_obj0)) 
        return NULL;
{
  _arg0 = _obj0;
}
    gtk_quit_remove_by_data(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_quit_add_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    GtkObject * _arg1;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"iO:gtk_quit_add_destroy",&_arg0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_OBJECT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_quit_add_destroy(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_input_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_input_remove",&_arg0)) 
        return NULL;
    gtk_input_remove(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_init(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_rc_init")) 
        return NULL;
    gtk_rc_init();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_parse(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_rc_parse",&_arg0)) 
        return NULL;
    gtk_rc_parse(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_parse_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_rc_parse_string",&_arg0)) 
        return NULL;
    gtk_rc_parse_string(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_get_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_rc_get_style",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkStyle *)gtk_rc_get_style(_arg0);
{
        _resultobj = PyGtkStyle_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_add_widget_name_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_rc_add_widget_name_style",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtkStyle_Check(_obj0))
            _arg0 = PyGtkStyle_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a style object");
            return NULL;
        }
    }
    gtk_rc_add_widget_name_style(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_rc_add_widget_class_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_rc_add_widget_class_style",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtkStyle_Check(_obj0))
            _arg0 = PyGtkStyle_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a style object");
            return NULL;
        }
    }
    gtk_rc_add_widget_class_style(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_font_load(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gdk_font_load",&_arg0)) 
        return NULL;
    _result = (GdkFont *)gdk_font_load(_arg0);
{
        _resultobj = PyGdkFont_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gdk_fontset_load(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkFont * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gdk_fontset_load",&_arg0)) 
        return NULL;
    _result = (GdkFont *)gdk_fontset_load(_arg0);
{
        _resultobj = PyGdkFont_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gdk_draw_point",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_point(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_line(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiii:gdk_draw_line",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_line(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_rectangle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiii:gdk_draw_rectangle",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_rectangle(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_arc(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiiiii:gdk_draw_arc",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
    gdk_draw_arc(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gdk_draw_pixmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _arg0;
    GdkGC * _arg1;
    GdkWindow * _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOiiiiii:gdk_draw_pixmap",&_obj0,&_obj1,&_obj2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
{
  if (PyGdkGC_Check(_obj1))
    _arg1 = PyGdkGC_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkGC");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj2))
    _arg2 = PyGdkWindow_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkWindow");
    return NULL;
  }
}
    gdk_draw_pixmap(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_type_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_type_name",&_arg0)) 
        return NULL;
    _result = (char *)gtk_type_name(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_type_from_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_type_from_name",&_arg0)) 
        return NULL;
    _result = (int )gtk_type_from_name(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_OBJECT(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_OBJECT",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_OBJECT(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_OBJECT_FLAGS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_OBJECT_FLAGS",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_OBJECT_FLAGS(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_OBJECT_TYPE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_OBJECT_TYPE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_OBJECT_TYPE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_OBJECT_SET_FLAGS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:GTK_OBJECT_SET_FLAGS",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    GTK_OBJECT_SET_FLAGS(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_OBJECT_UNSET_FLAGS(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:GTK_OBJECT_UNSET_FLAGS",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    GTK_OBJECT_UNSET_FLAGS(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_object_remove_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_object_remove_data",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_object_remove_data(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_WIDGET(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_WIDGET",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_WIDGET(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_window(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GdkWindow * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_window",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GdkWindow *)gtk_widget_get_window(_arg0);
{
  if (_result == NULL) {
    Py_INCREF(Py_None);
    _resultobj = Py_None;
  } else
    _resultobj = PyGdkWindow_New(_result, "GdkWindow");
}
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_destroy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_destroy",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_destroy(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_unparent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_unparent",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_unparent(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_show(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_show",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_show(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_hide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_hide",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_hide(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_show_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_show_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_show_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_show_now(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_show_now",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_show_now(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_hide_all(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_hide_all",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_hide_all(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_map(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_map",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_map(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_unmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_unmap",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_unmap(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_realize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_realize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_realize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_unrealize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_unrealize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_unrealize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_queue_draw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_queue_draw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_queue_draw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_queue_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_queue_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_queue_resize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_draw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GdkRectangle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_draw",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        _arg1 = malloc(sizeof(GdkRectangle));
        if (!PyArg_ParseTuple(_obj1, "iiii", &(_arg1->x), &(_arg1->x), &(_arg1->width), &(_arg1->height))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_widget_draw(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_draw_focus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_draw_focus",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_draw_focus(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_draw_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_draw_default",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_draw_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_size_request(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkRequisition * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_size_request",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a tuple");
            return NULL;
        }
        _arg1 = malloc(sizeof(GtkRequisition));
        if (!PyArg_ParseTuple(_obj1, "ii", &(_arg1->width), &(_arg1->height))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_widget_size_request(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_size_allocate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkAllocation * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_size_allocate",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        _arg1 = malloc(sizeof(GtkAllocation));
        if (!PyArg_ParseTuple(_obj1, "iiii", &(_arg1->x), &(_arg1->x), &(_arg1->width), &(_arg1->height))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_widget_size_allocate(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_install_accelerator(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkAcceleratorTable * _arg1;
    char * _arg2;
    char  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOsci:gtk_widget_install_accelerator",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkAccelerator_Check(_obj1))
            _arg1 = PyGtkAccelerator_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_widget_install_accelerator(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_remove_accelerator(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkAcceleratorTable * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:gtk_widget_remove_accelerator",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkAccelerator_Check(_obj1))
            _arg1 = PyGtkAccelerator_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_widget_remove_accelerator(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_activate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_activate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_activate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_reparent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_reparent",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_reparent(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_popup(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_widget_popup",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_popup(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_intersect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GdkRectangle * _arg1;
    GdkRectangle * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
{
        _arg2 = malloc(sizeof(GdkRectangle));
    }
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_intersect",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        _arg1 = malloc(sizeof(GdkRectangle));
        if (!PyArg_ParseTuple(_obj1, "iiii", &(_arg1->x), &(_arg1->x), &(_arg1->width), &(_arg1->height))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_widget_intersect(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        _resultobj = Py_BuildValue("(iiii)", _arg2->x, _arg2->y,
                   _arg2->width, _arg2->height);
    }
{
        free(_arg1);
    }
{
        free(_arg2);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_basic(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_basic",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_basic(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_grab_focus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_grab_focus",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_grab_focus(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_grab_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_grab_default",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_grab_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_widget_set_name",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_name(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_name(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_name",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_widget_get_name(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_state(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_widget_set_state",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_state(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_sensitive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_widget_set_sensitive",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_sensitive(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_parent(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_set_parent",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_parent(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GtkStyle * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_set_style",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkStyle_Check(_obj1))
            _arg1 = PyGtkStyle_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a style object");
            return NULL;
        }
    }
    gtk_widget_set_style(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_rc_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_set_rc_style",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_rc_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_ensure_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_ensure_style",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_ensure_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_restore_default_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_restore_default_style",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_restore_default_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_propagate_default_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_widget_propagate_default_style")) 
        return NULL;
    gtk_widget_propagate_default_style();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_uposition(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_widget_set_uposition",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_uposition(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_usize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_widget_set_usize",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_usize(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_events(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_widget_set_events",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_events(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_extension_events(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_widget_set_extension_events",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_set_extension_events(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_toplevel(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_toplevel",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_widget_get_toplevel(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_ancestor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkWidget * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_widget_get_ancestor",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_widget_get_ancestor(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_style",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkStyle *)gtk_widget_get_style(_arg0);
{
        _resultobj = PyGtkStyle_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_events(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_events",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_widget_get_events(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_get_extension_events(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_get_extension_events",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_widget_get_extension_events(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_is_ancestor(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWidget * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_is_ancestor",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_widget_is_ancestor(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_is_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWidget * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_widget_is_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_widget_is_child(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_hide_on_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_hide_on_delete",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_widget_hide_on_delete(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_push_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_push_style",&_obj0)) 
        return NULL;
{
        if (PyGtkStyle_Check(_obj0))
            _arg0 = PyGtkStyle_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a style object");
            return NULL;
        }
    }
    gtk_widget_push_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_pop_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_widget_pop_style")) 
        return NULL;
    gtk_widget_pop_style();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_set_default_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStyle * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_set_default_style",&_obj0)) 
        return NULL;
{
        if (PyGtkStyle_Check(_obj0))
            _arg0 = PyGtkStyle_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a style object");
            return NULL;
        }
    }
    gtk_widget_set_default_style(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_shape_combine_mask(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    GdkBitmap * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_widget_shape_combine_mask",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_widget_shape_combine_mask(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_widget_dnd_drag_add(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_widget_dnd_drag_add",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WIDGET(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_widget_dnd_drag_add(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ADJUSTMENT(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ADJUSTMENT",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ADJUSTMENT(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    double  _arg5;

    self = self;
    if(!PyArg_ParseTuple(args,"dddddd:gtk_adjustment_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
    _result = (GtkObject *)gtk_adjustment_new(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_lower(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_lower",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_lower(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_upper(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_upper",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_upper(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_value(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_step_increment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_step_increment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_step_increment(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_page_increment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_page_increment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_page_increment(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_get_page_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkAdjustment * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_adjustment_get_page_size",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_adjustment_get_page_size(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_adjustment_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_set_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_adjustment_clamp_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_adjustment_clamp_page",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_adjustment_clamp_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ALIGNMENT(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ALIGNMENT",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ALIGNMENT(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_alignment_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    double  _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"dddd:gtk_alignment_new",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    _result = (GtkWidget *)gtk_alignment_new(_arg0,_arg1,_arg2,_arg3);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_alignment_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAlignment * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_alignment_set",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ALIGNMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_alignment_set(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ARROW(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ARROW",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ARROW(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_arrow_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_arrow_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_arrow_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_arrow_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkArrow * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_arrow_set",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ARROW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_arrow_set(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ASPECT_FRAME(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ASPECT_FRAME",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ASPECT_FRAME(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_aspect_frame_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    int  _arg4;

    self = self;
    if(!PyArg_ParseTuple(args,"sdddi:gtk_aspect_frame_new",&_arg0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
    _result = (GtkWidget *)gtk_aspect_frame_new(_arg0,_arg1,_arg2,_arg3,_arg4);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_aspect_frame_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAspectFrame * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddi:gtk_aspect_frame_set",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ASPECT_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_aspect_frame_set(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_BIN(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_BIN",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_BIN(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_start(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiii:gtk_box_pack_start",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_start(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_end(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiii:gtk_box_pack_end",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_end(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_start_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_box_pack_start_defaults",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_start_defaults(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_pack_end_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_box_pack_end_defaults",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_pack_end_defaults(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_set_homogeneous(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_box_set_homogeneous",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_set_homogeneous(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_set_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_box_set_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_set_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_box_reorder_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkBox * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_box_reorder_child",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_box_reorder_child(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_BUTTON(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_BUTTON",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_BUTTON(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_button_pressed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_pressed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_pressed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_released(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_released",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_released(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_enter(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_enter",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_enter(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_leave(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_leave",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_leave(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_BUTTON_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_BUTTON_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_BUTTON_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_size_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_button_box_set_child_size_default",&_arg0,&_arg1)) 
        return NULL;
    gtk_button_box_set_child_size_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_ipadding_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_button_box_set_child_ipadding_default",&_arg0,&_arg1)) 
        return NULL;
    gtk_button_box_set_child_ipadding_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_get_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkButtonBox * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_box_get_spacing",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_button_box_get_spacing(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_get_layout(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkButtonBox * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_button_box_get_layout",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_button_box_get_layout(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_button_box_set_spacing",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_spacing(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_layout(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_button_box_set_layout",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_layout(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_button_box_set_child_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_child_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_button_box_set_child_ipadding(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkButtonBox * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_button_box_set_child_ipadding",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_BUTTON_BOX(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_button_box_set_child_ipadding(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_CHECK_BUTTON(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_CHECK_BUTTON",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_CHECK_BUTTON(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_check_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_check_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_check_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_check_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_CHECK_MENU_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_CHECK_MENU_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_CHECK_MENU_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_check_menu_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_check_menu_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_check_menu_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_check_menu_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_set_state(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_check_menu_item_set_state",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_set_state(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_toggled(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_check_menu_item_toggled",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_toggled(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_set_show_toggle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCheckMenuItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_check_menu_item_set_show_toggle",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_check_menu_item_set_show_toggle(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_check_menu_item_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCheckMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_check_menu_item_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CHECK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_check_menu_item_get_active(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_CLIST(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_CLIST",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_CLIST(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_clist_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_clist_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_row_is_visible(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_row_is_visible",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_clist_row_is_visible(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_get_cell_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_get_cell_type",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_clist_get_cell_type(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_set_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_set_policy",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_policy(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_show(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_show",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_show(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_hide(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_hide",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_hide(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_title_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_column_title_active",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_title_active(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_title_passive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_column_title_passive",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_title_passive(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_active(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_column_titles_passive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_column_titles_passive",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_column_titles_passive(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gtk_clist_set_column_title",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_title(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_column_widget",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_widget(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_justification(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_set_column_justification",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_justification(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_column_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_set_column_width",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_column_width(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_row_height(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_set_row_height",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_row_height(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_moveto(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiidd:gtk_clist_moveto",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_moveto(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiis:gtk_clist_set_text",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_text(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_pixmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    GdkPixmap * _arg3;
    GdkBitmap * _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj3 = 0;
    PyObject * _obj4 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiiOO:gtk_clist_set_pixmap",&_obj0,&_arg1,&_arg2,&_obj3,&_obj4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj3))
    _arg3 = PyGdkWindow_Get(_obj3);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj4))
    _arg4 = PyGdkWindow_Get(_obj4);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_clist_set_pixmap(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_pixtext(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    char * _arg3;
    int  _arg4;
    GdkPixmap * _arg5;
    GdkBitmap * _arg6;
    PyObject * _obj0 = 0;
    PyObject * _obj5 = 0;
    PyObject * _obj6 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiisiOO:gtk_clist_set_pixtext",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4,&_obj5,&_obj6)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj5))
    _arg5 = PyGdkWindow_Get(_obj5);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj6))
    _arg6 = PyGdkWindow_Get(_obj6);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_clist_set_pixtext(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_foreground(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_foreground",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGdkColor_Check(_obj2))
            _arg2 = PyGdkColor_Get(_obj2);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
    gtk_clist_set_foreground(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_background(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OiO:gtk_clist_set_background",&_obj0,&_arg1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGdkColor_Check(_obj2))
            _arg2 = PyGdkColor_Get(_obj2);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
    gtk_clist_set_background(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_set_selection_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_selection_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_set_shift(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiiii:gtk_clist_set_shift",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_set_shift(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_remove",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_remove(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_select_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_select_row",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_select_row(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_unselect_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_clist_unselect_row",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_unselect_row(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_clear(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_clist_clear",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_clist_clear(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_get_row_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    PyObject * _result;
    GtkCList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_clist_get_row_data",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (PyObject *)gtk_clist_get_row_data(_arg0,_arg1);
{
  Py_INCREF(_result);
  _resultobj = _result;
}
    return _resultobj;
}

static PyObject *_wrap_gtk_clist_find_row_from_data(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkCList * _arg0;
    PyObject * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_clist_find_row_from_data",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CLIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  _arg1 = _obj1;
}
    _result = (int )gtk_clist_find_row_from_data(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_COLOR_SELECTION(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_COLOR_SELECTION",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_COLOR_SELECTION(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_COLOR_SELECTION_DIALOG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_COLOR_SELECTION_DIALOG",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_COLOR_SELECTION_DIALOG(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_color_selection_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_color_selection_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_color_selection_set_update_policy",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_color_selection_set_update_policy(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_opacity(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_color_selection_set_opacity",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_color_selection_set_opacity(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_set_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    gdouble * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_color_selection_set_color",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (!PyTuple_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "not a tuple");
            return NULL;
        }
        _arg1 = malloc(3 * sizeof(gdouble));
	if (!PyArg_ParseTuple(_obj1, "ddd", &(_arg1[0]), &(_arg1[1]), &(_arg1[2]))) {
            free(_arg1);
            return NULL;
        }
    }
    gtk_color_selection_set_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_get_color(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkColorSelection * _arg0;
    gdouble * _arg1;
    PyObject * _obj0 = 0;

    self = self;
{
        _arg1 = malloc(3 * sizeof(gdouble));
    }
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_get_color",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_color_selection_get_color(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        _resultobj = Py_BuildValue("(ddd)", _arg1[0], _arg1[1], _arg1[2]);
    }
{
        free(_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_color_selection_dialog_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_color_selection_dialog_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_colorsel(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_colorsel",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_colorsel(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_main_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_main_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_main_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_ok_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_ok_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_ok_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_reset_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_reset_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_reset_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_cancel_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_cancel_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_cancel_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_color_selection_dialog_get_help_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkColorSelectionDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_color_selection_dialog_get_help_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COLOR_SELECTION_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_color_selection_dialog_get_help_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_COMBO(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_COMBO",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_COMBO(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_combo_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_combo_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_value_in_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_combo_set_value_in_list",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_value_in_list(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_use_arrows(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_use_arrows",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_use_arrows(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_use_arrows_always(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_use_arrows_always",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_use_arrows_always(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_case_sensitive(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_combo_set_case_sensitive",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_case_sensitive(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_set_item_string(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    GtkItem * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:gtk_combo_set_item_string",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ITEM(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_set_item_string(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_get_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_get_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_combo_get_entry(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_get_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_get_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_combo_get_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_combo_disable_activate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCombo * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_combo_disable_activate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_COMBO(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_combo_disable_activate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_CONTAINER(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_CONTAINER",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_CONTAINER(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_container_border_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_container_border_width",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_border_width(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_add(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_container_add",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_add(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_container_remove",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_remove(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_disable_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_disable_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_disable_resize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_enable_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_enable_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_enable_resize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_block_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_block_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_block_resize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_unblock_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_unblock_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_unblock_resize(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_need_resize(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_need_resize",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_container_need_resize(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_container_focus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkContainer * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_container_focus",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_container_focus(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_container_set_focus_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_container_set_focus_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_set_focus_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_set_focus_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_container_set_focus_vadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_set_focus_vadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_set_focus_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkContainer * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_container_set_focus_hadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_container_set_focus_hadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_container_children(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GList * _result;
    GtkContainer * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_container_children",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CONTAINER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GList *)gtk_container_children(_arg0);
{
	GList *t;
        _resultobj = PyList_New(0);
        for (t = _result; t != NULL; t = t->next)
            PyList_Append(_resultobj, PyGtk_New(GTK_OBJECT(t->data)));
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_CURVE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_CURVE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_CURVE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_curve_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_curve_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_reset(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_curve_reset",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_reset(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_gamma(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_curve_set_gamma",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_set_gamma(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_curve_set_range",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_set_range(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_curve_set_curve_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkCurve * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_curve_set_curve_type",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_CURVE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_curve_set_curve_type(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_DATA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_DATA",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_DATA(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_DIALOG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_DIALOG",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_DIALOG(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_dialog_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_dialog_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_get_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dialog_get_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_dialog_get_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_dialog_get_action_area(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkDialog * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_dialog_get_action_area",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DIALOG(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_dialog_get_action_area(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_DRAWING_AREA(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_DRAWING_AREA",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_DRAWING_AREA(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_drawing_area_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_drawing_area_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_drawing_area_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_drawing_area_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkDrawingArea * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_drawing_area_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_DRAWING_AREA(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_drawing_area_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_EDITABLE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_EDITABLE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_EDITABLE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_select_region(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_select_region",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_select_region(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_delete_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_delete_text",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_delete_text(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_get_chars(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_get_chars",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_editable_get_chars(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_cut_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_editable_cut_clipboard",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_cut_clipboard(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_copy_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_editable_copy_clipboard",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_copy_clipboard(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_paste_clipboard(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_editable_paste_clipboard",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_paste_clipboard(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_claim_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_editable_claim_selection",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_claim_selection(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_delete_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_delete_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_delete_selection(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_editable_changed(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEditable * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_editable_changed",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_EDITABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_editable_changed(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ENTRY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ENTRY",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ENTRY(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_entry_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_entry_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_new_with_max_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_entry_new_with_max_length",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_entry_new_with_max_length(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_set_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_append_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_append_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_append_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_prepend_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_entry_prepend_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_prepend_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_position",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_position(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_get_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkEntry * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_entry_get_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_entry_get_text(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_select_region(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_entry_select_region",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_select_region(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_visibility(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_visibility",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_visibility(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_editable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_editable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_editable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_entry_set_max_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkEntry * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_entry_set_max_length",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ENTRY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_entry_set_max_length(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_EVENT_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_EVENT_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_EVENT_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_event_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_event_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_event_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_dir_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_dir_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_dir_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_file_list(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_file_list",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_file_list(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_selection_entry(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_selection_entry",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_selection_entry(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_selection_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_selection_text",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_selection_text(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_main_vbox(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_main_vbox",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_main_vbox(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_ok_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_ok_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_ok_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_cancel_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_cancel_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_cancel_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_help_button(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_help_button",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_file_selection_get_help_button(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_FILE_SELECTION(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_FILE_SELECTION",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_FILE_SELECTION(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_file_selection_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_file_selection_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_set_filename(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFileSelection * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_file_selection_set_filename",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_file_selection_set_filename(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_file_selection_get_filename(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    char * _result;
    GtkFileSelection * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_file_selection_get_filename",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FILE_SELECTION(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (char *)gtk_file_selection_get_filename(_arg0);
    _resultobj = Py_BuildValue("s", _result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_FIXED(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_FIXED",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_FIXED(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_fixed_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_fixed_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_put(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFixed * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_fixed_put",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FIXED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_fixed_put(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_fixed_move(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFixed * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOii:gtk_fixed_move",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FIXED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_fixed_move(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_FRAME(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_FRAME",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_FRAME(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_frame_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_frame_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_frame_set_label",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_frame_set_label(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_label_align(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_frame_set_label_align",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_frame_set_label_align(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_frame_set_shadow_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkFrame * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_frame_set_shadow_type",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_FRAME(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_frame_set_shadow_type(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_GAMMA_CURVE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_GAMMA_CURVE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_GAMMA_CURVE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_gamma_curve_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_gamma_curve_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_gamma_curve_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HANDLE_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HANDLE_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HANDLE_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_handle_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_handle_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_handle_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HBOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HBOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HBOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbox_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_hbox_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_hbox_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HBUTTON_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HBUTTON_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HBUTTON_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hbutton_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_get_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_get_spacing_default")) 
        return NULL;
    _result = (int )gtk_hbutton_box_get_spacing_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_get_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hbutton_box_get_layout_default")) 
        return NULL;
    _result = (int )gtk_hbutton_box_get_layout_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_set_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_hbutton_box_set_spacing_default",&_arg0)) 
        return NULL;
    gtk_hbutton_box_set_spacing_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_hbutton_box_set_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_hbutton_box_set_layout_default",&_arg0)) 
        return NULL;
    gtk_hbutton_box_set_layout_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HPANED(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HPANED",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HPANED(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hpaned_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hpaned_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hpaned_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HRULER(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HRULER",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HRULER(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hruler_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hruler_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hruler_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HSCALE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HSCALE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HSCALE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hscale_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_hscale_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_hscale_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HSCROLLBAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HSCROLLBAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HSCROLLBAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hscrollbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_hscrollbar_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_hscrollbar_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_HSEPARATOR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_HSEPARATOR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_HSEPARATOR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_hseparator_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_hseparator_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_hseparator_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_IMAGE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_IMAGE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_IMAGE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_INPUT_DIALOG(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_INPUT_DIALOG",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_INPUT_DIALOG(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_input_dialog_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_input_dialog_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_input_dialog_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_item_toggle(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_item_toggle",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_item_toggle(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_LABEL(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_LABEL",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_LABEL(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_label_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_label_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_label_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_label_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_label_set",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_label_set(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_label_get(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    char ** _arg1;
    PyObject * _obj0 = 0;

    self = self;
{
        *_arg1 = NULL;
    }
    if(!PyArg_ParseTuple(args,"O:gtk_label_get",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_label_get(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
{
        _resultobj = PyString_FromString(*_arg1);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_label_set_justify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkLabel * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_label_set_justify",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LABEL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_label_set_justify(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_LIST(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_LIST",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_LIST(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_list_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_get_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GList * _result;
    GtkList * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_get_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GList *)gtk_list_get_selection(_arg0);
{
	GList *t;
        _resultobj = PyList_New(0);
        for (t = _result; t != NULL; t = t->next)
            PyList_Append(_resultobj, PyGtk_New(GTK_OBJECT(t->data)));
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_insert_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_list_insert_items",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)(((PyGtk_Object *)item)->go));
        }
    }
    gtk_list_insert_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_append_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_append_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)(((PyGtk_Object *)item)->go));
        }
    }
    gtk_list_append_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_prepend_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_prepend_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)(((PyGtk_Object *)item)->go));
        }
    }
    gtk_list_prepend_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_remove_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_remove_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)(((PyGtk_Object *)item)->go));
        }
    }
    gtk_list_remove_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_clear_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_list_clear_items",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_clear_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_select_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_list_select_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_select_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_unselect_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_list_unselect_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_unselect_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_select_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_select_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_select_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_unselect_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_unselect_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_unselect_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_child_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkList * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_list_child_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_list_child_position(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkList * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_list_set_selection_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_set_selection_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_LIST_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_LIST_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_LIST_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_list_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_list_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_list_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_list_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkListItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_list_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkListItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_list_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_LIST_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_list_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_MENU(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_MENU",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_MENU(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_popdown(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_popdown",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_popdown(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_menu_get_active(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_set_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_menu_set_active",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_set_active(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_set_accelerator_table(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    GtkAcceleratorTable * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_set_accelerator_table",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkAccelerator_Check(_obj1))
            _arg1 = PyGtkAccelerator_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_menu_set_accelerator_table(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_get_attach_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_get_attach_widget",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_menu_get_attach_widget(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_detach(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_detach",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_detach(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_MENU_BAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_MENU_BAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_MENU_BAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_bar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_bar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_bar_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_bar_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_bar_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuBar * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_bar_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_bar_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_MENU_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_MENU_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_MENU_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_menu_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_menu_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_menu_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_set_submenu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_item_set_submenu",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_set_submenu(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_remove_submenu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_remove_submenu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_remove_submenu(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_set_placement(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_menu_item_set_placement",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_set_placement(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_accelerator_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_accelerator_size",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_accelerator_size(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_accelerator_text(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_menu_item_accelerator_text",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_accelerator_text(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_configure(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_menu_item_configure",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_configure(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_activate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_activate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_activate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_item_right_justify(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_item_right_justify",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_item_right_justify(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_MENU_SHELL(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_MENU_SHELL",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_MENU_SHELL(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_shell_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_menu_shell_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_menu_shell_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_menu_shell_deactivate(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMenuShell * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_menu_shell_deactivate",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MENU_SHELL(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_menu_shell_deactivate(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_MISC(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_MISC",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_MISC(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_misc_set_alignment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMisc * _arg0;
    double  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odd:gtk_misc_set_alignment",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MISC(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_misc_set_alignment(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_misc_set_padding(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkMisc * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_misc_set_padding",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_MISC(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_misc_set_padding(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_NOTEBOOK(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_NOTEBOOK",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_NOTEBOOK(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_notebook_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_notebook_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_append_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_notebook_append_page",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_append_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_append_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOO:gtk_notebook_append_page_menu",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_append_page_menu(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prepend_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_notebook_prepend_page",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prepend_page(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prepend_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOO:gtk_notebook_prepend_page_menu",&_obj0,&_obj1,&_obj2,&_obj3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prepend_page_menu(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_insert_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOi:gtk_notebook_insert_page",&_obj0,&_obj1,&_obj2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_insert_page(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_insert_page_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    GtkWidget * _arg1;
    GtkWidget * _arg2;
    GtkWidget * _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOi:gtk_notebook_insert_page_menu",&_obj0,&_obj1,&_obj2,&_obj3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_WIDGET(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj3))
            _arg3 = GTK_WIDGET(PyGtk_Get(_obj3));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_insert_page_menu(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_remove_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_remove_page",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_remove_page(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_current_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_current_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_notebook_current_page(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_page",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_page(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_next_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_next_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_next_page(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_prev_page(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_prev_page",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_prev_page(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_tab_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_tab_pos",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_tab_pos(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_show_tabs(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_show_tabs",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_show_tabs(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_show_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_show_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_show_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_scrollable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_scrollable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_scrollable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_set_tab_border(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_notebook_set_tab_border",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_set_tab_border(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_popup_enable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_popup_enable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_popup_enable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_notebook_popup_disable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkNotebook * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_notebook_popup_disable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_NOTEBOOK(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_notebook_popup_disable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_OPTION_MENU(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_OPTION_MENU",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_OPTION_MENU(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_option_menu_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_option_menu_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_get_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkOptionMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_option_menu_get_menu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_option_menu_get_menu(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_set_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_option_menu_set_menu",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_set_menu(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_remove_menu(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_option_menu_remove_menu",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_remove_menu(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_option_menu_set_history(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkOptionMenu * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_option_menu_set_history",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OPTION_MENU(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_option_menu_set_history(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_PANED(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_PANED",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_PANED(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_add1(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_paned_add1",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_add1(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_add2(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_paned_add2",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_add2(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_handle_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_paned_handle_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_handle_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_paned_gutter_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPaned * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_paned_gutter_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PANED(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_paned_gutter_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_PIXMAP(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_PIXMAP",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_PIXMAP(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_pixmap_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GdkPixmap * _arg0;
    GdkBitmap * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_pixmap_new",&_obj0,&_obj1)) 
        return NULL;
{
  if (PyGdkWindow_Check(_obj0))
    _arg0 = PyGdkWindow_Get(_obj0);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    _result = (GtkWidget *)gtk_pixmap_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_pixmap_set(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPixmap * _arg0;
    GdkPixmap * _arg1;
    GdkBitmap * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_pixmap_set",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PIXMAP(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
  if (PyGdkWindow_Check(_obj1))
    _arg1 = PyGdkWindow_Get(_obj1);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkPixmap");
    return NULL;
  }
}
{
  if (PyGdkWindow_Check(_obj2))
    _arg2 = PyGdkWindow_Get(_obj2);
  else {
    PyErr_SetString(PyExc_TypeError, "object not a GdkBitmap");
    return NULL;
  }
}
    gtk_pixmap_set(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_PREVIEW(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_PREVIEW",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_PREVIEW(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_uninit(PyObject *self, PyObject *args) {
    PyObject * _resultobj;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_preview_uninit")) 
        return NULL;
    gtk_preview_uninit();
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_preview_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_preview_size",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_size(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_draw_row(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    char * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osiii:gtk_preview_draw_row",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_draw_row(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_expand(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkPreview * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_preview_set_expand",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PREVIEW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_preview_set_expand(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_gamma(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"d:gtk_preview_set_gamma",&_arg0)) 
        return NULL;
    gtk_preview_set_gamma(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_color_cube(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _arg0;
    unsigned int  _arg1;
    unsigned int  _arg2;
    unsigned int  _arg3;

    self = self;
    if(!PyArg_ParseTuple(args,"iiii:gtk_preview_set_color_cube",&_arg0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
    gtk_preview_set_color_cube(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_install_cmap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_set_install_cmap",&_arg0)) 
        return NULL;
    gtk_preview_set_install_cmap(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_preview_set_reserved(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_preview_set_reserved",&_arg0)) 
        return NULL;
    gtk_preview_set_reserved(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_PROGRESS_BAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_PROGRESS_BAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_PROGRESS_BAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_progress_bar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_progress_bar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_progress_bar_update(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkProgressBar * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_progress_bar_update",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_PROGRESS_BAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_progress_bar_update(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_RADIO_BUTTON(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_RADIO_BUTTON",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_RADIO_BUTTON(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_RADIO_MENU_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_RADIO_MENU_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_RADIO_MENU_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_RANGE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_RANGE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_RANGE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_range_get_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_get_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_range_get_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_range_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_range_set_update_policy",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_set_update_policy(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_range_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_background(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_background",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_background(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_trough(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_trough",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_trough(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_slider(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_slider",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_slider(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_step_forw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_step_forw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_step_forw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_draw_step_back(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_draw_step_back",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_draw_step_back(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_range_slider_update(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRange * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_range_slider_update",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RANGE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_range_slider_update(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_RULER(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_RULER",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_RULER(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_set_metric(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_ruler_set_metric",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_set_metric(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_set_range(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    double  _arg1;
    double  _arg2;
    double  _arg3;
    double  _arg4;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odddd:gtk_ruler_set_range",&_obj0,&_arg1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_set_range(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_draw_ticks(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_ruler_draw_ticks",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_draw_ticks(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_ruler_draw_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkRuler * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_ruler_draw_pos",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_RULER(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_ruler_draw_pos(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_SCALE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_SCALE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_SCALE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_digits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_digits",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_digits(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_draw_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_draw_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_draw_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_set_value_pos(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_scale_set_value_pos",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_set_value_pos(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_value_width(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkScale * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scale_value_width",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_scale_value_width(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scale_draw_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScale * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scale_draw_value",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCALE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scale_draw_value(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_SCROLLBAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_SCROLLBAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_SCROLLBAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_SCROLLED_WINDOW(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_SCROLLED_WINDOW",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_SCROLLED_WINDOW(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_scrolled_window_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_scrolled_window_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkScrolledWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scrolled_window_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_scrolled_window_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkScrolledWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_scrolled_window_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_scrolled_window_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_scrolled_window_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkScrolledWindow * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_scrolled_window_set_policy",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SCROLLED_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_scrolled_window_set_policy(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_SEPARATOR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_SEPARATOR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_SEPARATOR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_SPIN_BUTTON(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_SPIN_BUTTON",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_SPIN_BUTTON(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0;
    double  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Odi:gtk_spin_button_new",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_spin_button_new(_arg0,_arg1,_arg2);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_new_no_adj(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    double  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"di:gtk_spin_button_new_no_adj",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_spin_button_new_no_adj(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_spin_button_set_adjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_adjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_adjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_adjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_spin_button_get_adjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_digits(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_digits",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_digits(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_value_as_float(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    double  _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_value_as_float",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (double )gtk_spin_button_get_value_as_float(_arg0);
    _resultobj = Py_BuildValue("d",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_get_value_as_int(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkSpinButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_spin_button_get_value_as_int",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_spin_button_get_value_as_int(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_value(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    double  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Od:gtk_spin_button_set_value",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_value(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_update_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_update_policy",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_update_policy(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_numeric(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_numeric",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_numeric(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_spin(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    double  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oid:gtk_spin_button_spin",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_spin(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_spin_button_set_wrap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkSpinButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_spin_button_set_wrap",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_SPIN_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_spin_button_set_wrap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_STATUSBAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_STATUSBAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_STATUSBAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_statusbar_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_statusbar_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_get_context_id(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkStatusbar * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_statusbar_get_context_id",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_statusbar_get_context_id(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_push(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkStatusbar * _arg0;
    int  _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Ois:gtk_statusbar_push",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_statusbar_push(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_pop(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStatusbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_statusbar_pop",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_statusbar_pop(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_statusbar_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkStatusbar * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_statusbar_remove",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_STATUSBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_statusbar_remove(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TABLE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TABLE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TABLE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_table_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;
    int  _arg2;

    self = self;
    if(!PyArg_ParseTuple(args,"iii:gtk_table_new",&_arg0,&_arg1,&_arg2)) 
        return NULL;
    _result = (GtkWidget *)gtk_table_new(_arg0,_arg1,_arg2);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_table_attach(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    int  _arg6;
    int  _arg7;
    int  _arg8;
    int  _arg9;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiiiiiii:gtk_table_attach",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5,&_arg6,&_arg7,&_arg8,&_arg9)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_attach(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5,_arg6,_arg7,_arg8,_arg9);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_attach_defaults(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    int  _arg3;
    int  _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOiiii:gtk_table_attach_defaults",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4,&_arg5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_attach_defaults(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_row_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_table_set_row_spacing",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_row_spacing(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_col_spacing(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_table_set_col_spacing",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_col_spacing(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_row_spacings(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_row_spacings",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_row_spacings(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_col_spacings(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_col_spacings",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_col_spacings(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_table_set_homogeneous(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_table_set_homogeneous",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TABLE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_table_set_homogeneous(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TEXT(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TEXT",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TEXT(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_text_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_text_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_editable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_editable",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_editable(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_word_wrap(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_word_wrap",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_word_wrap(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_adjustments(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    GtkAdjustment * _arg1;
    GtkAdjustment * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_text_set_adjustments",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj2))
            _arg2 = GTK_ADJUSTMENT(PyGtk_Get(_obj2));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_adjustments(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_text_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_text_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_text_set_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_set_point",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_set_point(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_point(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_point",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (unsigned int )gtk_text_get_point(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_get_length(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    unsigned int  _result;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_get_length",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (unsigned int )gtk_text_get_length(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_freeze(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_freeze",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_freeze(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_thaw(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_text_thaw",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_text_thaw(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkText * _arg0;
    GdkFont * _arg1;
    GdkColor * _arg2;
    GdkColor * _arg3;
    char * _arg4;
    int  _arg5;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;
    PyObject * _obj3 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOOOsi:gtk_text_insert",&_obj0,&_obj1,&_obj2,&_obj3,&_arg4,&_arg5)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGdkFont_Check(_obj1))
            _arg1 = PyGdkFont_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkFont");
            return NULL;
        }
    }
{
        if (PyGdkColor_Check(_obj2))
            _arg2 = PyGdkColor_Get(_obj2);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
{
        if (PyGdkColor_Check(_obj3))
            _arg3 = PyGdkColor_Get(_obj3);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
    gtk_text_insert(_arg0,_arg1,_arg2,_arg3,_arg4,_arg5);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_text_backward_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_backward_delete",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_text_backward_delete(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_text_forward_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkText * _arg0;
    unsigned int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_text_forward_delete",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TEXT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_text_forward_delete(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TIPS_QUERY(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TIPS_QUERY",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TIPS_QUERY(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tips_query_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tips_query_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_start_query(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tips_query_start_query",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_start_query(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_stop_query(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tips_query_stop_query",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_stop_query(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_set_caller(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tips_query_set_caller",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_set_caller(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tips_query_set_labels(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTipsQuery * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:gtk_tips_query_set_labels",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TIPS_QUERY(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tips_query_set_labels(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TOGGLE_BUTTON(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TOGGLE_BUTTON",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TOGGLE_BUTTON(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_toggle_button_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_toggle_button_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_toggle_button_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_toggle_button_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_set_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toggle_button_set_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_set_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_set_state(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toggle_button_set_state",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_set_state(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_toggled(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToggleButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toggle_button_toggled",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toggle_button_toggled(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toggle_button_get_active(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkToggleButton * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toggle_button_get_active",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOGGLE_BUTTON(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_toggle_button_get_active(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TOOLBAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TOOLBAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TOOLBAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_toolbar_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_toolbar_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_append_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toolbar_append_space",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_append_space(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_prepend_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_toolbar_prepend_space",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_prepend_space(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_insert_space(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_insert_space",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_insert_space(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_append_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_toolbar_append_widget",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_append_widget(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_prepend_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_toolbar_prepend_widget",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_prepend_widget(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_insert_widget(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOssi:gtk_toolbar_insert_widget",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_insert_widget(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_orientation(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_orientation",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_orientation(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_style(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_style",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_style(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_space_size(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_space_size",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_space_size(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_toolbar_set_tooltips(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkToolbar * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_toolbar_set_tooltips",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLBAR(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_toolbar_set_tooltips(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TREE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TREE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TREE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_get_selection(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GList * _result;
    GtkTree * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_get_selection",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GList *)gtk_tree_get_selection(_arg0);
{
	GList *t;
        _resultobj = PyList_New(0);
        for (t = _result; t != NULL; t = t->next)
            PyList_Append(_resultobj, PyGtk_New(GTK_OBJECT(t->data)));
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_append(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_append",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_append(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_prepend(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_prepend",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_prepend(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_insert(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOi:gtk_tree_insert",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_insert(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_remove_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GList * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_remove_items",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        int len, i;
        PyObject *item;
        if (!PyList_Check(_obj1)) {
            PyErr_SetString(PyExc_TypeError, "argument not a list");
            return NULL;
        }
        _arg1 = NULL;
        len = PyList_Size(_obj1);
        for (i = 0; i < len; i++) {
            item = PyList_GetItem(_obj1, i);
            if (!PyGtk_Check(item)) {
                PyErr_SetString(PyExc_TypeError, "item not a GtkObject");
                g_list_free(_arg1);
                return NULL;
            }
            _arg1 = g_list_append(_arg1, (gpointer)(((PyGtk_Object *)item)->go));
        }
    }
    gtk_tree_remove_items(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_clear_items(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oii:gtk_tree_clear_items",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_clear_items(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_select_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_select_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_select_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_unselect_item(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_unselect_item",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_unselect_item(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_select_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_select_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_select_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_unselect_child(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_unselect_child",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_unselect_child(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_child_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkTree * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_child_position",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_tree_child_position(_arg0,_arg1);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_selection_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_set_selection_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_set_selection_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_view_mode(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_set_view_mode",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_set_view_mode(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_set_view_lines(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTree * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tree_set_view_lines",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_set_view_lines(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_TREE_ITEM(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_TREE_ITEM",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_TREE_ITEM(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tree_item_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_item_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_new_with_label(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    char * _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"s:gtk_tree_item_new_with_label",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_tree_item_new_with_label(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_set_subtree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_tree_item_set_subtree",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_set_subtree(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_select(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_select",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_select(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_deselect(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_deselect",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_deselect(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_expand(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_expand",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_expand(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_collapse(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_collapse",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_collapse(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tree_item_remove_subtree(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTreeItem * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tree_item_remove_subtree",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TREE_ITEM(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tree_item_remove_subtree(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VBOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VBOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VBOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbox_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;
    int  _arg1;

    self = self;
    if(!PyArg_ParseTuple(args,"ii:gtk_vbox_new",&_arg0,&_arg1)) 
        return NULL;
    _result = (GtkWidget *)gtk_vbox_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VBUTTON_BOX(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VBUTTON_BOX",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VBUTTON_BOX(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vbutton_box_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_get_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_get_spacing_default")) 
        return NULL;
    _result = (int )gtk_vbutton_box_get_spacing_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_set_spacing_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_vbutton_box_set_spacing_default",&_arg0)) 
        return NULL;
    gtk_vbutton_box_set_spacing_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_get_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vbutton_box_get_layout_default")) 
        return NULL;
    _result = (int )gtk_vbutton_box_get_layout_default();
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vbutton_box_set_layout_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_vbutton_box_set_layout_default",&_arg0)) 
        return NULL;
    gtk_vbutton_box_set_layout_default(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VIEWPORT(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VIEWPORT",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VIEWPORT(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    GtkAdjustment * _arg1 = NULL;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|OO:gtk_viewport_new",&_obj0,&_obj1)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    if (_obj1)
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_viewport_new(_arg0,_arg1);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_get_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkViewport * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_viewport_get_hadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_viewport_get_hadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_get_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAdjustment * _result;
    GtkViewport * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_viewport_get_vadjustment",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAdjustment *)gtk_viewport_get_vadjustment(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_hadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_viewport_set_hadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_viewport_set_hadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_vadjustment(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    GtkAdjustment * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_viewport_set_vadjustment",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_ADJUSTMENT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_viewport_set_vadjustment(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_viewport_set_shadow_type(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkViewport * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_viewport_set_shadow_type",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_VIEWPORT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_viewport_set_shadow_type(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VPANED(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VPANED",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VPANED(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vpaned_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vpaned_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vpaned_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VRULER(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VRULER",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VRULER(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vruler_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vruler_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vruler_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VSCALE(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VSCALE",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VSCALE(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vscale_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_vscale_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_vscale_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VSCROLLBAR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VSCROLLBAR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VSCROLLBAR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vscrollbar_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    GtkAdjustment * _arg0 = NULL;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"|O:gtk_vscrollbar_new",&_obj0)) 
        return NULL;
    if (_obj0)
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_ADJUSTMENT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkWidget *)gtk_vscrollbar_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_VSEPARATOR(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_VSEPARATOR",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_VSEPARATOR(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_vseparator_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_vseparator_new")) 
        return NULL;
    _result = (GtkWidget *)gtk_vseparator_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_GTK_IS_WINDOW(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:GTK_IS_WINDOW",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )GTK_IS_WINDOW(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_window_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWidget * _result;
    int  _arg0;

    self = self;
    if(!PyArg_ParseTuple(args,"i:gtk_window_new",&_arg0)) 
        return NULL;
    _result = (GtkWidget *)gtk_window_new(_arg0);
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_title(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    char * _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Os:gtk_window_set_title",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_title(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_wmclass(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    char * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oss:gtk_window_set_wmclass",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_wmclass(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_focus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_window_set_focus",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_focus(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    GtkWidget * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_window_set_default",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_default(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_set_policy(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    int  _arg1;
    int  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oiii:gtk_window_set_policy",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_set_policy(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_add_accelerator_table(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    GtkAcceleratorTable * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_window_add_accelerator_table",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkAccelerator_Check(_obj1))
            _arg1 = PyGtkAccelerator_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_window_add_accelerator_table(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_remove_accelerator_table(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    GtkAcceleratorTable * _arg1;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OO:gtk_window_remove_accelerator_table",&_obj0,&_obj1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtkAccelerator_Check(_obj1))
            _arg1 = PyGtkAccelerator_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_window_remove_accelerator_table(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_position(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkWindow * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_window_position",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_window_position(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_window_activate_focus(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_window_activate_focus",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_window_activate_focus(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_window_activate_default(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkWindow * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_window_activate_default",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_WINDOW(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (int )gtk_window_activate_default(_arg0);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAcceleratorTable * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_accelerator_table_new")) 
        return NULL;
    _result = (GtkAcceleratorTable *)gtk_accelerator_table_new();
{
        _resultobj = PyGtkAccelerator_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_find(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAcceleratorTable * _result;
    GtkObject * _arg0;
    char * _arg1;
    unsigned char  _arg2;
    int  _arg3;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Osbi:gtk_accelerator_table_find",&_obj0,&_arg1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    _result = (GtkAcceleratorTable *)gtk_accelerator_table_find(_arg0,_arg1,_arg2,_arg3);
{
        _resultobj = PyGtkAccelerator_New(_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_install(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAcceleratorTable * _arg0;
    GtkObject * _arg1;
    char * _arg2;
    unsigned char  _arg3;
    int  _arg4;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOsbi:gtk_accelerator_table_install",&_obj0,&_obj1,&_arg2,&_arg3,&_arg4)) 
        return NULL;
{
        if (PyGtkAccelerator_Check(_obj0))
            _arg0 = PyGtkAccelerator_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_OBJECT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_accelerator_table_install(_arg0,_arg1,_arg2,_arg3,_arg4);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_remove(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAcceleratorTable * _arg0;
    GtkObject * _arg1;
    char * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOs:gtk_accelerator_table_remove",&_obj0,&_obj1,&_arg2)) 
        return NULL;
{
        if (PyGtkAccelerator_Check(_obj0))
            _arg0 = PyGtkAccelerator_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_OBJECT(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_accelerator_table_remove(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_check(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    int  _result;
    GtkAcceleratorTable * _arg0;
    unsigned char  _arg1;
    int  _arg2;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Obi:gtk_accelerator_table_check",&_obj0,&_arg1,&_arg2)) 
        return NULL;
{
        if (PyGtkAccelerator_Check(_obj0))
            _arg0 = PyGtkAccelerator_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    _result = (int )gtk_accelerator_table_check(_arg0,_arg1,_arg2);
    _resultobj = Py_BuildValue("i",_result);
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_tables_delete(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkObject * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_accelerator_tables_delete",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_OBJECT(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_accelerator_tables_delete(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_accelerator_table_set_mod_mask(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkAcceleratorTable * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_accelerator_table_set_mod_mask",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtkAccelerator_Check(_obj0))
            _arg0 = PyGtkAccelerator_Get(_obj0);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a accelerator table");
            return NULL;
        }
    }
    gtk_accelerator_table_set_mod_mask(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_new(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _result;

    self = self;
    if(!PyArg_ParseTuple(args,":gtk_tooltips_new")) 
        return NULL;
    _result = (GtkTooltips *)gtk_tooltips_new();
{
        _resultobj = PyGtk_New((GtkObject *)_result);
    }
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_enable(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"O:gtk_tooltips_enable",&_obj0)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_enable(_arg0);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_delay(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    int  _arg1;
    PyObject * _obj0 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"Oi:gtk_tooltips_set_delay",&_obj0,&_arg1)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_set_delay(_arg0,_arg1);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_tip(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    GtkWidget * _arg1;
    char * _arg2;
    char * _arg3;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOss:gtk_tooltips_set_tip",&_obj0,&_obj1,&_arg2,&_arg3)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGtk_Check(_obj1))
            _arg1 = GTK_WIDGET(PyGtk_Get(_obj1));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
    gtk_tooltips_set_tip(_arg0,_arg1,_arg2,_arg3);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyObject *_wrap_gtk_tooltips_set_colors(PyObject *self, PyObject *args) {
    PyObject * _resultobj;
    GtkTooltips * _arg0;
    GdkColor * _arg1;
    GdkColor * _arg2;
    PyObject * _obj0 = 0;
    PyObject * _obj1 = 0;
    PyObject * _obj2 = 0;

    self = self;
    if(!PyArg_ParseTuple(args,"OOO:gtk_tooltips_set_colors",&_obj0,&_obj1,&_obj2)) 
        return NULL;
{
        if (PyGtk_Check(_obj0))
            _arg0 = GTK_TOOLTIPS(PyGtk_Get(_obj0));
        else {
            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");
            return NULL;
        }
    }
{
        if (PyGdkColor_Check(_obj1))
            _arg1 = PyGdkColor_Get(_obj1);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
{
        if (PyGdkColor_Check(_obj2))
            _arg2 = PyGdkColor_Get(_obj2);
        else {
            PyErr_SetString(PyExc_TypeError, "object not a GdkColor");
            return NULL;
        }
   }
    gtk_tooltips_set_colors(_arg0,_arg1,_arg2);
    Py_INCREF(Py_None);
    _resultobj = Py_None;
    return _resultobj;
}

static PyMethodDef gtkMethods[] = {
	 { "gtk_tooltips_set_colors", _wrap_gtk_tooltips_set_colors, 1 },
	 { "gtk_tooltips_set_tip", _wrap_gtk_tooltips_set_tip, 1 },
	 { "gtk_tooltips_set_delay", _wrap_gtk_tooltips_set_delay, 1 },
	 { "gtk_tooltips_enable", _wrap_gtk_tooltips_enable, 1 },
	 { "gtk_tooltips_new", _wrap_gtk_tooltips_new, 1 },
	 { "gtk_accelerator_table_set_mod_mask", _wrap_gtk_accelerator_table_set_mod_mask, 1 },
	 { "gtk_accelerator_tables_delete", _wrap_gtk_accelerator_tables_delete, 1 },
	 { "gtk_accelerator_table_check", _wrap_gtk_accelerator_table_check, 1 },
	 { "gtk_accelerator_table_remove", _wrap_gtk_accelerator_table_remove, 1 },
	 { "gtk_accelerator_table_install", _wrap_gtk_accelerator_table_install, 1 },
	 { "gtk_accelerator_table_find", _wrap_gtk_accelerator_table_find, 1 },
	 { "gtk_accelerator_table_new", _wrap_gtk_accelerator_table_new, 1 },
	 { "gtk_window_set_icon_name", gtk__window_set_icon_name, 1 },
	 { "gtk_window_set_icon", gtk__window_set_icon, 1 },
	 { "gtk_window_activate_default", _wrap_gtk_window_activate_default, 1 },
	 { "gtk_window_activate_focus", _wrap_gtk_window_activate_focus, 1 },
	 { "gtk_window_position", _wrap_gtk_window_position, 1 },
	 { "gtk_window_remove_accelerator_table", _wrap_gtk_window_remove_accelerator_table, 1 },
	 { "gtk_window_add_accelerator_table", _wrap_gtk_window_add_accelerator_table, 1 },
	 { "gtk_window_set_policy", _wrap_gtk_window_set_policy, 1 },
	 { "gtk_window_set_default", _wrap_gtk_window_set_default, 1 },
	 { "gtk_window_set_focus", _wrap_gtk_window_set_focus, 1 },
	 { "gtk_window_set_wmclass", _wrap_gtk_window_set_wmclass, 1 },
	 { "gtk_window_set_title", _wrap_gtk_window_set_title, 1 },
	 { "gtk_window_new", _wrap_gtk_window_new, 1 },
	 { "GTK_IS_WINDOW", _wrap_GTK_IS_WINDOW, 1 },
	 { "gtk_vseparator_new", _wrap_gtk_vseparator_new, 1 },
	 { "GTK_IS_VSEPARATOR", _wrap_GTK_IS_VSEPARATOR, 1 },
	 { "gtk_vscrollbar_new", _wrap_gtk_vscrollbar_new, 1 },
	 { "GTK_IS_VSCROLLBAR", _wrap_GTK_IS_VSCROLLBAR, 1 },
	 { "gtk_vscale_new", _wrap_gtk_vscale_new, 1 },
	 { "GTK_IS_VSCALE", _wrap_GTK_IS_VSCALE, 1 },
	 { "gtk_vruler_new", _wrap_gtk_vruler_new, 1 },
	 { "GTK_IS_VRULER", _wrap_GTK_IS_VRULER, 1 },
	 { "gtk_vpaned_new", _wrap_gtk_vpaned_new, 1 },
	 { "GTK_IS_VPANED", _wrap_GTK_IS_VPANED, 1 },
	 { "gtk_viewport_set_shadow_type", _wrap_gtk_viewport_set_shadow_type, 1 },
	 { "gtk_viewport_set_vadjustment", _wrap_gtk_viewport_set_vadjustment, 1 },
	 { "gtk_viewport_set_hadjustment", _wrap_gtk_viewport_set_hadjustment, 1 },
	 { "gtk_viewport_get_vadjustment", _wrap_gtk_viewport_get_vadjustment, 1 },
	 { "gtk_viewport_get_hadjustment", _wrap_gtk_viewport_get_hadjustment, 1 },
	 { "gtk_viewport_new", _wrap_gtk_viewport_new, 1 },
	 { "GTK_IS_VIEWPORT", _wrap_GTK_IS_VIEWPORT, 1 },
	 { "gtk_vbutton_box_set_layout_default", _wrap_gtk_vbutton_box_set_layout_default, 1 },
	 { "gtk_vbutton_box_get_layout_default", _wrap_gtk_vbutton_box_get_layout_default, 1 },
	 { "gtk_vbutton_box_set_spacing_default", _wrap_gtk_vbutton_box_set_spacing_default, 1 },
	 { "gtk_vbutton_box_get_spacing_default", _wrap_gtk_vbutton_box_get_spacing_default, 1 },
	 { "gtk_vbutton_box_new", _wrap_gtk_vbutton_box_new, 1 },
	 { "GTK_IS_VBUTTON_BOX", _wrap_GTK_IS_VBUTTON_BOX, 1 },
	 { "gtk_vbox_new", _wrap_gtk_vbox_new, 1 },
	 { "GTK_IS_VBOX", _wrap_GTK_IS_VBOX, 1 },
	 { "gtk_tree_item_remove_subtree", _wrap_gtk_tree_item_remove_subtree, 1 },
	 { "gtk_tree_item_collapse", _wrap_gtk_tree_item_collapse, 1 },
	 { "gtk_tree_item_expand", _wrap_gtk_tree_item_expand, 1 },
	 { "gtk_tree_item_deselect", _wrap_gtk_tree_item_deselect, 1 },
	 { "gtk_tree_item_select", _wrap_gtk_tree_item_select, 1 },
	 { "gtk_tree_item_set_subtree", _wrap_gtk_tree_item_set_subtree, 1 },
	 { "gtk_tree_item_new_with_label", _wrap_gtk_tree_item_new_with_label, 1 },
	 { "gtk_tree_item_new", _wrap_gtk_tree_item_new, 1 },
	 { "GTK_IS_TREE_ITEM", _wrap_GTK_IS_TREE_ITEM, 1 },
	 { "gtk_tree_set_view_lines", _wrap_gtk_tree_set_view_lines, 1 },
	 { "gtk_tree_set_view_mode", _wrap_gtk_tree_set_view_mode, 1 },
	 { "gtk_tree_set_selection_mode", _wrap_gtk_tree_set_selection_mode, 1 },
	 { "gtk_tree_child_position", _wrap_gtk_tree_child_position, 1 },
	 { "gtk_tree_unselect_child", _wrap_gtk_tree_unselect_child, 1 },
	 { "gtk_tree_select_child", _wrap_gtk_tree_select_child, 1 },
	 { "gtk_tree_unselect_item", _wrap_gtk_tree_unselect_item, 1 },
	 { "gtk_tree_select_item", _wrap_gtk_tree_select_item, 1 },
	 { "gtk_tree_clear_items", _wrap_gtk_tree_clear_items, 1 },
	 { "gtk_tree_remove_items", _wrap_gtk_tree_remove_items, 1 },
	 { "gtk_tree_insert", _wrap_gtk_tree_insert, 1 },
	 { "gtk_tree_prepend", _wrap_gtk_tree_prepend, 1 },
	 { "gtk_tree_append", _wrap_gtk_tree_append, 1 },
	 { "gtk_tree_get_selection", _wrap_gtk_tree_get_selection, 1 },
	 { "gtk_tree_new", _wrap_gtk_tree_new, 1 },
	 { "GTK_IS_TREE", _wrap_GTK_IS_TREE, 1 },
	 { "gtk_toolbar_set_tooltips", _wrap_gtk_toolbar_set_tooltips, 1 },
	 { "gtk_toolbar_set_space_size", _wrap_gtk_toolbar_set_space_size, 1 },
	 { "gtk_toolbar_set_style", _wrap_gtk_toolbar_set_style, 1 },
	 { "gtk_toolbar_set_orientation", _wrap_gtk_toolbar_set_orientation, 1 },
	 { "gtk_toolbar_insert_widget", _wrap_gtk_toolbar_insert_widget, 1 },
	 { "gtk_toolbar_prepend_widget", _wrap_gtk_toolbar_prepend_widget, 1 },
	 { "gtk_toolbar_append_widget", _wrap_gtk_toolbar_append_widget, 1 },
	 { "gtk_toolbar_insert_space", _wrap_gtk_toolbar_insert_space, 1 },
	 { "gtk_toolbar_prepend_space", _wrap_gtk_toolbar_prepend_space, 1 },
	 { "gtk_toolbar_append_space", _wrap_gtk_toolbar_append_space, 1 },
	 { "gtk_toolbar_insert_item", gtk__toolbar_insert_item, 1 },
	 { "gtk_toolbar_prepend_item", gtk__toolbar_prepend_item, 1 },
	 { "gtk_toolbar_append_item", gtk__toolbar_append_item, 1 },
	 { "gtk_toolbar_new", _wrap_gtk_toolbar_new, 1 },
	 { "GTK_IS_TOOLBAR", _wrap_GTK_IS_TOOLBAR, 1 },
	 { "gtk_toggle_button_get_active", _wrap_gtk_toggle_button_get_active, 1 },
	 { "gtk_toggle_button_toggled", _wrap_gtk_toggle_button_toggled, 1 },
	 { "gtk_toggle_button_set_state", _wrap_gtk_toggle_button_set_state, 1 },
	 { "gtk_toggle_button_set_mode", _wrap_gtk_toggle_button_set_mode, 1 },
	 { "gtk_toggle_button_new_with_label", _wrap_gtk_toggle_button_new_with_label, 1 },
	 { "gtk_toggle_button_new", _wrap_gtk_toggle_button_new, 1 },
	 { "GTK_IS_TOGGLE_BUTTON", _wrap_GTK_IS_TOGGLE_BUTTON, 1 },
	 { "gtk_tips_query_set_labels", _wrap_gtk_tips_query_set_labels, 1 },
	 { "gtk_tips_query_set_caller", _wrap_gtk_tips_query_set_caller, 1 },
	 { "gtk_tips_query_stop_query", _wrap_gtk_tips_query_stop_query, 1 },
	 { "gtk_tips_query_start_query", _wrap_gtk_tips_query_start_query, 1 },
	 { "gtk_tips_query_new", _wrap_gtk_tips_query_new, 1 },
	 { "GTK_IS_TIPS_QUERY", _wrap_GTK_IS_TIPS_QUERY, 1 },
	 { "gtk_text_insert_defaults", gtk__text_insert_defaults, 1 },
	 { "gtk_text_forward_delete", _wrap_gtk_text_forward_delete, 1 },
	 { "gtk_text_backward_delete", _wrap_gtk_text_backward_delete, 1 },
	 { "gtk_text_insert", _wrap_gtk_text_insert, 1 },
	 { "gtk_text_thaw", _wrap_gtk_text_thaw, 1 },
	 { "gtk_text_freeze", _wrap_gtk_text_freeze, 1 },
	 { "gtk_text_get_length", _wrap_gtk_text_get_length, 1 },
	 { "gtk_text_get_point", _wrap_gtk_text_get_point, 1 },
	 { "gtk_text_set_point", _wrap_gtk_text_set_point, 1 },
	 { "gtk_text_get_vadjustment", _wrap_gtk_text_get_vadjustment, 1 },
	 { "gtk_text_get_hadjustment", _wrap_gtk_text_get_hadjustment, 1 },
	 { "gtk_text_set_adjustments", _wrap_gtk_text_set_adjustments, 1 },
	 { "gtk_text_set_word_wrap", _wrap_gtk_text_set_word_wrap, 1 },
	 { "gtk_text_set_editable", _wrap_gtk_text_set_editable, 1 },
	 { "gtk_text_new", _wrap_gtk_text_new, 1 },
	 { "GTK_IS_TEXT", _wrap_GTK_IS_TEXT, 1 },
	 { "gtk_table_set_homogeneous", _wrap_gtk_table_set_homogeneous, 1 },
	 { "gtk_table_set_col_spacings", _wrap_gtk_table_set_col_spacings, 1 },
	 { "gtk_table_set_row_spacings", _wrap_gtk_table_set_row_spacings, 1 },
	 { "gtk_table_set_col_spacing", _wrap_gtk_table_set_col_spacing, 1 },
	 { "gtk_table_set_row_spacing", _wrap_gtk_table_set_row_spacing, 1 },
	 { "gtk_table_attach_defaults", _wrap_gtk_table_attach_defaults, 1 },
	 { "gtk_table_attach", _wrap_gtk_table_attach, 1 },
	 { "gtk_table_new", _wrap_gtk_table_new, 1 },
	 { "GTK_IS_TABLE", _wrap_GTK_IS_TABLE, 1 },
	 { "gtk_statusbar_remove", _wrap_gtk_statusbar_remove, 1 },
	 { "gtk_statusbar_pop", _wrap_gtk_statusbar_pop, 1 },
	 { "gtk_statusbar_push", _wrap_gtk_statusbar_push, 1 },
	 { "gtk_statusbar_get_context_id", _wrap_gtk_statusbar_get_context_id, 1 },
	 { "gtk_statusbar_new", _wrap_gtk_statusbar_new, 1 },
	 { "GTK_IS_STATUSBAR", _wrap_GTK_IS_STATUSBAR, 1 },
	 { "gtk_spin_button_set_wrap", _wrap_gtk_spin_button_set_wrap, 1 },
	 { "gtk_spin_button_spin", _wrap_gtk_spin_button_spin, 1 },
	 { "gtk_spin_button_set_numeric", _wrap_gtk_spin_button_set_numeric, 1 },
	 { "gtk_spin_button_set_update_policy", _wrap_gtk_spin_button_set_update_policy, 1 },
	 { "gtk_spin_button_set_value", _wrap_gtk_spin_button_set_value, 1 },
	 { "gtk_spin_button_get_value_as_int", _wrap_gtk_spin_button_get_value_as_int, 1 },
	 { "gtk_spin_button_get_value_as_float", _wrap_gtk_spin_button_get_value_as_float, 1 },
	 { "gtk_spin_button_set_digits", _wrap_gtk_spin_button_set_digits, 1 },
	 { "gtk_spin_button_get_adjustment", _wrap_gtk_spin_button_get_adjustment, 1 },
	 { "gtk_spin_button_set_adjustment", _wrap_gtk_spin_button_set_adjustment, 1 },
	 { "gtk_spin_button_new_no_adj", _wrap_gtk_spin_button_new_no_adj, 1 },
	 { "gtk_spin_button_new", _wrap_gtk_spin_button_new, 1 },
	 { "GTK_IS_SPIN_BUTTON", _wrap_GTK_IS_SPIN_BUTTON, 1 },
	 { "GTK_IS_SEPARATOR", _wrap_GTK_IS_SEPARATOR, 1 },
	 { "gtk_scrolled_window_set_policy", _wrap_gtk_scrolled_window_set_policy, 1 },
	 { "gtk_scrolled_window_get_vadjustment", _wrap_gtk_scrolled_window_get_vadjustment, 1 },
	 { "gtk_scrolled_window_get_hadjustment", _wrap_gtk_scrolled_window_get_hadjustment, 1 },
	 { "gtk_scrolled_window_new", _wrap_gtk_scrolled_window_new, 1 },
	 { "GTK_IS_SCROLLED_WINDOW", _wrap_GTK_IS_SCROLLED_WINDOW, 1 },
	 { "GTK_IS_SCROLLBAR", _wrap_GTK_IS_SCROLLBAR, 1 },
	 { "gtk_scale_draw_value", _wrap_gtk_scale_draw_value, 1 },
	 { "gtk_scale_value_width", _wrap_gtk_scale_value_width, 1 },
	 { "gtk_scale_set_value_pos", _wrap_gtk_scale_set_value_pos, 1 },
	 { "gtk_scale_set_draw_value", _wrap_gtk_scale_set_draw_value, 1 },
	 { "gtk_scale_set_digits", _wrap_gtk_scale_set_digits, 1 },
	 { "GTK_IS_SCALE", _wrap_GTK_IS_SCALE, 1 },
	 { "gtk_ruler_draw_pos", _wrap_gtk_ruler_draw_pos, 1 },
	 { "gtk_ruler_draw_ticks", _wrap_gtk_ruler_draw_ticks, 1 },
	 { "gtk_ruler_set_range", _wrap_gtk_ruler_set_range, 1 },
	 { "gtk_ruler_set_metric", _wrap_gtk_ruler_set_metric, 1 },
	 { "GTK_IS_RULER", _wrap_GTK_IS_RULER, 1 },
	 { "gtk_range_slider_update", _wrap_gtk_range_slider_update, 1 },
	 { "gtk_range_draw_step_back", _wrap_gtk_range_draw_step_back, 1 },
	 { "gtk_range_draw_step_forw", _wrap_gtk_range_draw_step_forw, 1 },
	 { "gtk_range_draw_slider", _wrap_gtk_range_draw_slider, 1 },
	 { "gtk_range_draw_trough", _wrap_gtk_range_draw_trough, 1 },
	 { "gtk_range_draw_background", _wrap_gtk_range_draw_background, 1 },
	 { "gtk_range_set_adjustment", _wrap_gtk_range_set_adjustment, 1 },
	 { "gtk_range_set_update_policy", _wrap_gtk_range_set_update_policy, 1 },
	 { "gtk_range_get_adjustment", _wrap_gtk_range_get_adjustment, 1 },
	 { "GTK_IS_RANGE", _wrap_GTK_IS_RANGE, 1 },
	 { "gtk_radio_menu_item_new_with_label", gtk__radio_menu_item_new_with_label, 1 },
	 { "gtk_radio_menu_item_new", gtk__radio_menu_item_new, 1 },
	 { "GTK_IS_RADIO_MENU_ITEM", _wrap_GTK_IS_RADIO_MENU_ITEM, 1 },
	 { "gtk_radio_button_new_with_label", gtk__radio_button_new_with_label, 1 },
	 { "gtk_radio_button_new", gtk__radio_button_new, 1 },
	 { "GTK_IS_RADIO_BUTTON", _wrap_GTK_IS_RADIO_BUTTON, 1 },
	 { "gtk_progress_bar_update", _wrap_gtk_progress_bar_update, 1 },
	 { "gtk_progress_bar_new", _wrap_gtk_progress_bar_new, 1 },
	 { "GTK_IS_PROGRESS_BAR", _wrap_GTK_IS_PROGRESS_BAR, 1 },
	 { "gtk_preview_set_reserved", _wrap_gtk_preview_set_reserved, 1 },
	 { "gtk_preview_set_install_cmap", _wrap_gtk_preview_set_install_cmap, 1 },
	 { "gtk_preview_set_color_cube", _wrap_gtk_preview_set_color_cube, 1 },
	 { "gtk_preview_set_gamma", _wrap_gtk_preview_set_gamma, 1 },
	 { "gtk_preview_set_expand", _wrap_gtk_preview_set_expand, 1 },
	 { "gtk_preview_draw_row", _wrap_gtk_preview_draw_row, 1 },
	 { "gtk_preview_size", _wrap_gtk_preview_size, 1 },
	 { "gtk_preview_new", _wrap_gtk_preview_new, 1 },
	 { "gtk_preview_uninit", _wrap_gtk_preview_uninit, 1 },
	 { "GTK_IS_PREVIEW", _wrap_GTK_IS_PREVIEW, 1 },
	 { "gtk_pixmap_get", gtk__pixmap_get, 1 },
	 { "gtk_pixmap_new_from_xpm", gtk__pixmap_new_from_xpm, 1 },
	 { "gtk_pixmap_set", _wrap_gtk_pixmap_set, 1 },
	 { "gtk_pixmap_new", _wrap_gtk_pixmap_new, 1 },
	 { "GTK_IS_PIXMAP", _wrap_GTK_IS_PIXMAP, 1 },
	 { "gtk_paned_gutter_size", _wrap_gtk_paned_gutter_size, 1 },
	 { "gtk_paned_handle_size", _wrap_gtk_paned_handle_size, 1 },
	 { "gtk_paned_add2", _wrap_gtk_paned_add2, 1 },
	 { "gtk_paned_add1", _wrap_gtk_paned_add1, 1 },
	 { "GTK_IS_PANED", _wrap_GTK_IS_PANED, 1 },
	 { "gtk_option_menu_set_history", _wrap_gtk_option_menu_set_history, 1 },
	 { "gtk_option_menu_remove_menu", _wrap_gtk_option_menu_remove_menu, 1 },
	 { "gtk_option_menu_set_menu", _wrap_gtk_option_menu_set_menu, 1 },
	 { "gtk_option_menu_get_menu", _wrap_gtk_option_menu_get_menu, 1 },
	 { "gtk_option_menu_new", _wrap_gtk_option_menu_new, 1 },
	 { "GTK_IS_OPTION_MENU", _wrap_GTK_IS_OPTION_MENU, 1 },
	 { "gtk_notebook_popup_disable", _wrap_gtk_notebook_popup_disable, 1 },
	 { "gtk_notebook_popup_enable", _wrap_gtk_notebook_popup_enable, 1 },
	 { "gtk_notebook_set_tab_border", _wrap_gtk_notebook_set_tab_border, 1 },
	 { "gtk_notebook_set_scrollable", _wrap_gtk_notebook_set_scrollable, 1 },
	 { "gtk_notebook_set_show_border", _wrap_gtk_notebook_set_show_border, 1 },
	 { "gtk_notebook_set_show_tabs", _wrap_gtk_notebook_set_show_tabs, 1 },
	 { "gtk_notebook_set_tab_pos", _wrap_gtk_notebook_set_tab_pos, 1 },
	 { "gtk_notebook_prev_page", _wrap_gtk_notebook_prev_page, 1 },
	 { "gtk_notebook_next_page", _wrap_gtk_notebook_next_page, 1 },
	 { "gtk_notebook_set_page", _wrap_gtk_notebook_set_page, 1 },
	 { "gtk_notebook_current_page", _wrap_gtk_notebook_current_page, 1 },
	 { "gtk_notebook_remove_page", _wrap_gtk_notebook_remove_page, 1 },
	 { "gtk_notebook_insert_page_menu", _wrap_gtk_notebook_insert_page_menu, 1 },
	 { "gtk_notebook_insert_page", _wrap_gtk_notebook_insert_page, 1 },
	 { "gtk_notebook_prepend_page_menu", _wrap_gtk_notebook_prepend_page_menu, 1 },
	 { "gtk_notebook_prepend_page", _wrap_gtk_notebook_prepend_page, 1 },
	 { "gtk_notebook_append_page_menu", _wrap_gtk_notebook_append_page_menu, 1 },
	 { "gtk_notebook_append_page", _wrap_gtk_notebook_append_page, 1 },
	 { "gtk_notebook_new", _wrap_gtk_notebook_new, 1 },
	 { "GTK_IS_NOTEBOOK", _wrap_GTK_IS_NOTEBOOK, 1 },
	 { "gtk_misc_set_padding", _wrap_gtk_misc_set_padding, 1 },
	 { "gtk_misc_set_alignment", _wrap_gtk_misc_set_alignment, 1 },
	 { "GTK_IS_MISC", _wrap_GTK_IS_MISC, 1 },
	 { "gtk_menu_shell_deactivate", _wrap_gtk_menu_shell_deactivate, 1 },
	 { "gtk_menu_shell_insert", _wrap_gtk_menu_shell_insert, 1 },
	 { "gtk_menu_shell_prepend", _wrap_gtk_menu_shell_prepend, 1 },
	 { "gtk_menu_shell_append", _wrap_gtk_menu_shell_append, 1 },
	 { "GTK_IS_MENU_SHELL", _wrap_GTK_IS_MENU_SHELL, 1 },
	 { "gtk_menu_item_right_justify", _wrap_gtk_menu_item_right_justify, 1 },
	 { "gtk_menu_item_activate", _wrap_gtk_menu_item_activate, 1 },
	 { "gtk_menu_item_deselect", _wrap_gtk_menu_item_deselect, 1 },
	 { "gtk_menu_item_select", _wrap_gtk_menu_item_select, 1 },
	 { "gtk_menu_item_configure", _wrap_gtk_menu_item_configure, 1 },
	 { "gtk_menu_item_accelerator_text", _wrap_gtk_menu_item_accelerator_text, 1 },
	 { "gtk_menu_item_accelerator_size", _wrap_gtk_menu_item_accelerator_size, 1 },
	 { "gtk_menu_item_set_placement", _wrap_gtk_menu_item_set_placement, 1 },
	 { "gtk_menu_item_remove_submenu", _wrap_gtk_menu_item_remove_submenu, 1 },
	 { "gtk_menu_item_set_submenu", _wrap_gtk_menu_item_set_submenu, 1 },
	 { "gtk_menu_item_new_with_label", _wrap_gtk_menu_item_new_with_label, 1 },
	 { "gtk_menu_item_new", _wrap_gtk_menu_item_new, 1 },
	 { "GTK_IS_MENU_ITEM", _wrap_GTK_IS_MENU_ITEM, 1 },
	 { "gtk_menu_bar_insert", _wrap_gtk_menu_bar_insert, 1 },
	 { "gtk_menu_bar_prepend", _wrap_gtk_menu_bar_prepend, 1 },
	 { "gtk_menu_bar_append", _wrap_gtk_menu_bar_append, 1 },
	 { "gtk_menu_bar_new", _wrap_gtk_menu_bar_new, 1 },
	 { "GTK_IS_MENU_BAR", _wrap_GTK_IS_MENU_BAR, 1 },
	 { "gtk_menu_detach", _wrap_gtk_menu_detach, 1 },
	 { "gtk_menu_get_attach_widget", _wrap_gtk_menu_get_attach_widget, 1 },
	 { "gtk_menu_set_accelerator_table", _wrap_gtk_menu_set_accelerator_table, 1 },
	 { "gtk_menu_set_active", _wrap_gtk_menu_set_active, 1 },
	 { "gtk_menu_get_active", _wrap_gtk_menu_get_active, 1 },
	 { "gtk_menu_popdown", _wrap_gtk_menu_popdown, 1 },
	 { "gtk_menu_popup", gtk__menu_popup, 1 },
	 { "gtk_menu_insert", _wrap_gtk_menu_insert, 1 },
	 { "gtk_menu_prepend", _wrap_gtk_menu_prepend, 1 },
	 { "gtk_menu_append", _wrap_gtk_menu_append, 1 },
	 { "gtk_menu_new", _wrap_gtk_menu_new, 1 },
	 { "GTK_IS_MENU", _wrap_GTK_IS_MENU, 1 },
	 { "gtk_list_item_deselect", _wrap_gtk_list_item_deselect, 1 },
	 { "gtk_list_item_select", _wrap_gtk_list_item_select, 1 },
	 { "gtk_list_item_new_with_label", _wrap_gtk_list_item_new_with_label, 1 },
	 { "gtk_list_item_new", _wrap_gtk_list_item_new, 1 },
	 { "GTK_IS_LIST_ITEM", _wrap_GTK_IS_LIST_ITEM, 1 },
	 { "gtk_list_set_selection_mode", _wrap_gtk_list_set_selection_mode, 1 },
	 { "gtk_list_child_position", _wrap_gtk_list_child_position, 1 },
	 { "gtk_list_unselect_child", _wrap_gtk_list_unselect_child, 1 },
	 { "gtk_list_select_child", _wrap_gtk_list_select_child, 1 },
	 { "gtk_list_unselect_item", _wrap_gtk_list_unselect_item, 1 },
	 { "gtk_list_select_item", _wrap_gtk_list_select_item, 1 },
	 { "gtk_list_clear_items", _wrap_gtk_list_clear_items, 1 },
	 { "gtk_list_remove_items", _wrap_gtk_list_remove_items, 1 },
	 { "gtk_list_prepend_items", _wrap_gtk_list_prepend_items, 1 },
	 { "gtk_list_append_items", _wrap_gtk_list_append_items, 1 },
	 { "gtk_list_insert_items", _wrap_gtk_list_insert_items, 1 },
	 { "gtk_list_get_selection", _wrap_gtk_list_get_selection, 1 },
	 { "gtk_list_new", _wrap_gtk_list_new, 1 },
	 { "GTK_IS_LIST", _wrap_GTK_IS_LIST, 1 },
	 { "gtk_label_set_justify", _wrap_gtk_label_set_justify, 1 },
	 { "gtk_label_get", _wrap_gtk_label_get, 1 },
	 { "gtk_label_set", _wrap_gtk_label_set, 1 },
	 { "gtk_label_new", _wrap_gtk_label_new, 1 },
	 { "GTK_IS_LABEL", _wrap_GTK_IS_LABEL, 1 },
	 { "gtk_item_toggle", _wrap_gtk_item_toggle, 1 },
	 { "gtk_item_deselect", _wrap_gtk_item_deselect, 1 },
	 { "gtk_item_select", _wrap_gtk_item_select, 1 },
	 { "GTK_IS_ITEM", _wrap_GTK_IS_ITEM, 1 },
	 { "gtk_input_dialog_new", _wrap_gtk_input_dialog_new, 1 },
	 { "GTK_IS_INPUT_DIALOG", _wrap_GTK_IS_INPUT_DIALOG, 1 },
	 { "GTK_IS_IMAGE", _wrap_GTK_IS_IMAGE, 1 },
	 { "gtk_hseparator_new", _wrap_gtk_hseparator_new, 1 },
	 { "GTK_IS_HSEPARATOR", _wrap_GTK_IS_HSEPARATOR, 1 },
	 { "gtk_hscrollbar_new", _wrap_gtk_hscrollbar_new, 1 },
	 { "GTK_IS_HSCROLLBAR", _wrap_GTK_IS_HSCROLLBAR, 1 },
	 { "gtk_hscale_new", _wrap_gtk_hscale_new, 1 },
	 { "GTK_IS_HSCALE", _wrap_GTK_IS_HSCALE, 1 },
	 { "gtk_hruler_new", _wrap_gtk_hruler_new, 1 },
	 { "GTK_IS_HRULER", _wrap_GTK_IS_HRULER, 1 },
	 { "gtk_hpaned_new", _wrap_gtk_hpaned_new, 1 },
	 { "GTK_IS_HPANED", _wrap_GTK_IS_HPANED, 1 },
	 { "gtk_hbutton_box_set_layout_default", _wrap_gtk_hbutton_box_set_layout_default, 1 },
	 { "gtk_hbutton_box_set_spacing_default", _wrap_gtk_hbutton_box_set_spacing_default, 1 },
	 { "gtk_hbutton_box_get_layout_default", _wrap_gtk_hbutton_box_get_layout_default, 1 },
	 { "gtk_hbutton_box_get_spacing_default", _wrap_gtk_hbutton_box_get_spacing_default, 1 },
	 { "gtk_hbutton_box_new", _wrap_gtk_hbutton_box_new, 1 },
	 { "GTK_IS_HBUTTON_BOX", _wrap_GTK_IS_HBUTTON_BOX, 1 },
	 { "gtk_hbox_new", _wrap_gtk_hbox_new, 1 },
	 { "GTK_IS_HBOX", _wrap_GTK_IS_HBOX, 1 },
	 { "gtk_handle_box_new", _wrap_gtk_handle_box_new, 1 },
	 { "GTK_IS_HANDLE_BOX", _wrap_GTK_IS_HANDLE_BOX, 1 },
	 { "gtk_gamma_curve_new", _wrap_gtk_gamma_curve_new, 1 },
	 { "GTK_IS_GAMMA_CURVE", _wrap_GTK_IS_GAMMA_CURVE, 1 },
	 { "gtk_frame_set_shadow_type", _wrap_gtk_frame_set_shadow_type, 1 },
	 { "gtk_frame_set_label_align", _wrap_gtk_frame_set_label_align, 1 },
	 { "gtk_frame_set_label", _wrap_gtk_frame_set_label, 1 },
	 { "gtk_frame_new", _wrap_gtk_frame_new, 1 },
	 { "GTK_IS_FRAME", _wrap_GTK_IS_FRAME, 1 },
	 { "gtk_fixed_move", _wrap_gtk_fixed_move, 1 },
	 { "gtk_fixed_put", _wrap_gtk_fixed_put, 1 },
	 { "gtk_fixed_new", _wrap_gtk_fixed_new, 1 },
	 { "GTK_IS_FIXED", _wrap_GTK_IS_FIXED, 1 },
	 { "gtk_file_selection_get_filename", _wrap_gtk_file_selection_get_filename, 1 },
	 { "gtk_file_selection_set_filename", _wrap_gtk_file_selection_set_filename, 1 },
	 { "gtk_file_selection_new", _wrap_gtk_file_selection_new, 1 },
	 { "GTK_IS_FILE_SELECTION", _wrap_GTK_IS_FILE_SELECTION, 1 },
	 { "gtk_file_selection_get_help_button", _wrap_gtk_file_selection_get_help_button, 1 },
	 { "gtk_file_selection_get_cancel_button", _wrap_gtk_file_selection_get_cancel_button, 1 },
	 { "gtk_file_selection_get_ok_button", _wrap_gtk_file_selection_get_ok_button, 1 },
	 { "gtk_file_selection_get_main_vbox", _wrap_gtk_file_selection_get_main_vbox, 1 },
	 { "gtk_file_selection_get_selection_text", _wrap_gtk_file_selection_get_selection_text, 1 },
	 { "gtk_file_selection_get_selection_entry", _wrap_gtk_file_selection_get_selection_entry, 1 },
	 { "gtk_file_selection_get_file_list", _wrap_gtk_file_selection_get_file_list, 1 },
	 { "gtk_file_selection_get_dir_list", _wrap_gtk_file_selection_get_dir_list, 1 },
	 { "gtk_event_box_new", _wrap_gtk_event_box_new, 1 },
	 { "GTK_IS_EVENT_BOX", _wrap_GTK_IS_EVENT_BOX, 1 },
	 { "gtk_entry_set_max_length", _wrap_gtk_entry_set_max_length, 1 },
	 { "gtk_entry_set_editable", _wrap_gtk_entry_set_editable, 1 },
	 { "gtk_entry_set_visibility", _wrap_gtk_entry_set_visibility, 1 },
	 { "gtk_entry_select_region", _wrap_gtk_entry_select_region, 1 },
	 { "gtk_entry_get_text", _wrap_gtk_entry_get_text, 1 },
	 { "gtk_entry_set_position", _wrap_gtk_entry_set_position, 1 },
	 { "gtk_entry_prepend_text", _wrap_gtk_entry_prepend_text, 1 },
	 { "gtk_entry_append_text", _wrap_gtk_entry_append_text, 1 },
	 { "gtk_entry_set_text", _wrap_gtk_entry_set_text, 1 },
	 { "gtk_entry_new_with_max_length", _wrap_gtk_entry_new_with_max_length, 1 },
	 { "gtk_entry_new", _wrap_gtk_entry_new, 1 },
	 { "GTK_IS_ENTRY", _wrap_GTK_IS_ENTRY, 1 },
	 { "gtk_editable_changed", _wrap_gtk_editable_changed, 1 },
	 { "gtk_editable_delete_selection", _wrap_gtk_editable_delete_selection, 1 },
	 { "gtk_editable_claim_selection", _wrap_gtk_editable_claim_selection, 1 },
	 { "gtk_editable_paste_clipboard", _wrap_gtk_editable_paste_clipboard, 1 },
	 { "gtk_editable_copy_clipboard", _wrap_gtk_editable_copy_clipboard, 1 },
	 { "gtk_editable_cut_clipboard", _wrap_gtk_editable_cut_clipboard, 1 },
	 { "gtk_editable_get_chars", _wrap_gtk_editable_get_chars, 1 },
	 { "gtk_editable_delete_text", _wrap_gtk_editable_delete_text, 1 },
	 { "gtk_editable_insert_text", gtk__editable_insert_text, 1 },
	 { "gtk_editable_select_region", _wrap_gtk_editable_select_region, 1 },
	 { "GTK_IS_EDITABLE", _wrap_GTK_IS_EDITABLE, 1 },
	 { "gtk_drawing_area_size", _wrap_gtk_drawing_area_size, 1 },
	 { "gtk_drawing_area_new", _wrap_gtk_drawing_area_new, 1 },
	 { "GTK_IS_DRAWING_AREA", _wrap_GTK_IS_DRAWING_AREA, 1 },
	 { "gtk_dialog_get_action_area", _wrap_gtk_dialog_get_action_area, 1 },
	 { "gtk_dialog_get_vbox", _wrap_gtk_dialog_get_vbox, 1 },
	 { "gtk_dialog_new", _wrap_gtk_dialog_new, 1 },
	 { "GTK_IS_DIALOG", _wrap_GTK_IS_DIALOG, 1 },
	 { "GTK_IS_DATA", _wrap_GTK_IS_DATA, 1 },
	 { "gtk_curve_set_curve_type", _wrap_gtk_curve_set_curve_type, 1 },
	 { "gtk_curve_set_vector", gtk__curve_set_vector, 1 },
	 { "gtk_curve_get_vector", gtk__curve_get_vector, 1 },
	 { "gtk_curve_set_range", _wrap_gtk_curve_set_range, 1 },
	 { "gtk_curve_set_gamma", _wrap_gtk_curve_set_gamma, 1 },
	 { "gtk_curve_reset", _wrap_gtk_curve_reset, 1 },
	 { "gtk_curve_new", _wrap_gtk_curve_new, 1 },
	 { "GTK_IS_CURVE", _wrap_GTK_IS_CURVE, 1 },
	 { "gtk_container_children", _wrap_gtk_container_children, 1 },
	 { "gtk_container_set_focus_hadjustment", _wrap_gtk_container_set_focus_hadjustment, 1 },
	 { "gtk_container_set_focus_vadjustment", _wrap_gtk_container_set_focus_vadjustment, 1 },
	 { "gtk_container_set_focus_child", _wrap_gtk_container_set_focus_child, 1 },
	 { "gtk_container_focus", _wrap_gtk_container_focus, 1 },
	 { "gtk_container_need_resize", _wrap_gtk_container_need_resize, 1 },
	 { "gtk_container_unblock_resize", _wrap_gtk_container_unblock_resize, 1 },
	 { "gtk_container_block_resize", _wrap_gtk_container_block_resize, 1 },
	 { "gtk_container_enable_resize", _wrap_gtk_container_enable_resize, 1 },
	 { "gtk_container_disable_resize", _wrap_gtk_container_disable_resize, 1 },
	 { "gtk_container_remove", _wrap_gtk_container_remove, 1 },
	 { "gtk_container_add", _wrap_gtk_container_add, 1 },
	 { "gtk_container_border_width", _wrap_gtk_container_border_width, 1 },
	 { "GTK_IS_CONTAINER", _wrap_GTK_IS_CONTAINER, 1 },
	 { "gtk_combo_disable_activate", _wrap_gtk_combo_disable_activate, 1 },
	 { "gtk_combo_get_list", _wrap_gtk_combo_get_list, 1 },
	 { "gtk_combo_get_entry", _wrap_gtk_combo_get_entry, 1 },
	 { "gtk_combo_set_item_string", _wrap_gtk_combo_set_item_string, 1 },
	 { "gtk_combo_set_case_sensitive", _wrap_gtk_combo_set_case_sensitive, 1 },
	 { "gtk_combo_set_use_arrows_always", _wrap_gtk_combo_set_use_arrows_always, 1 },
	 { "gtk_combo_set_use_arrows", _wrap_gtk_combo_set_use_arrows, 1 },
	 { "gtk_combo_set_value_in_list", _wrap_gtk_combo_set_value_in_list, 1 },
	 { "gtk_combo_new", _wrap_gtk_combo_new, 1 },
	 { "GTK_IS_COMBO", _wrap_GTK_IS_COMBO, 1 },
	 { "gtk_color_selection_dialog_get_help_button", _wrap_gtk_color_selection_dialog_get_help_button, 1 },
	 { "gtk_color_selection_dialog_get_cancel_button", _wrap_gtk_color_selection_dialog_get_cancel_button, 1 },
	 { "gtk_color_selection_dialog_get_reset_button", _wrap_gtk_color_selection_dialog_get_reset_button, 1 },
	 { "gtk_color_selection_dialog_get_ok_button", _wrap_gtk_color_selection_dialog_get_ok_button, 1 },
	 { "gtk_color_selection_dialog_get_main_vbox", _wrap_gtk_color_selection_dialog_get_main_vbox, 1 },
	 { "gtk_color_selection_dialog_get_colorsel", _wrap_gtk_color_selection_dialog_get_colorsel, 1 },
	 { "gtk_color_selection_dialog_new", _wrap_gtk_color_selection_dialog_new, 1 },
	 { "gtk_color_selection_get_color", _wrap_gtk_color_selection_get_color, 1 },
	 { "gtk_color_selection_set_color", _wrap_gtk_color_selection_set_color, 1 },
	 { "gtk_color_selection_set_opacity", _wrap_gtk_color_selection_set_opacity, 1 },
	 { "gtk_color_selection_set_update_policy", _wrap_gtk_color_selection_set_update_policy, 1 },
	 { "gtk_color_selection_new", _wrap_gtk_color_selection_new, 1 },
	 { "GTK_IS_COLOR_SELECTION_DIALOG", _wrap_GTK_IS_COLOR_SELECTION_DIALOG, 1 },
	 { "GTK_IS_COLOR_SELECTION", _wrap_GTK_IS_COLOR_SELECTION, 1 },
	 { "gtk_clist_find_row_from_data", _wrap_gtk_clist_find_row_from_data, 1 },
	 { "gtk_clist_get_row_data", _wrap_gtk_clist_get_row_data, 1 },
	 { "gtk_clist_set_row_data", gtk__clist_set_row_data, 1 },
	 { "gtk_clist_clear", _wrap_gtk_clist_clear, 1 },
	 { "gtk_clist_unselect_row", _wrap_gtk_clist_unselect_row, 1 },
	 { "gtk_clist_select_row", _wrap_gtk_clist_select_row, 1 },
	 { "gtk_clist_remove", _wrap_gtk_clist_remove, 1 },
	 { "gtk_clist_insert", gtk__clist_insert, 1 },
	 { "gtk_clist_append", gtk__clist_append, 1 },
	 { "gtk_clist_set_shift", _wrap_gtk_clist_set_shift, 1 },
	 { "gtk_clist_set_selection_mode", _wrap_gtk_clist_set_selection_mode, 1 },
	 { "gtk_clist_set_background", _wrap_gtk_clist_set_background, 1 },
	 { "gtk_clist_set_foreground", _wrap_gtk_clist_set_foreground, 1 },
	 { "gtk_clist_get_pixtext", gtk__clist_get_pixtext, 1 },
	 { "gtk_clist_get_pixmap", gtk__clist_get_pixmap, 1 },
	 { "gtk_clist_get_text", gtk__clist_get_text, 1 },
	 { "gtk_clist_set_pixtext", _wrap_gtk_clist_set_pixtext, 1 },
	 { "gtk_clist_set_pixmap", _wrap_gtk_clist_set_pixmap, 1 },
	 { "gtk_clist_set_text", _wrap_gtk_clist_set_text, 1 },
	 { "gtk_clist_moveto", _wrap_gtk_clist_moveto, 1 },
	 { "gtk_clist_set_row_height", _wrap_gtk_clist_set_row_height, 1 },
	 { "gtk_clist_set_column_width", _wrap_gtk_clist_set_column_width, 1 },
	 { "gtk_clist_set_column_justification", _wrap_gtk_clist_set_column_justification, 1 },
	 { "gtk_clist_set_column_widget", _wrap_gtk_clist_set_column_widget, 1 },
	 { "gtk_clist_set_column_title", _wrap_gtk_clist_set_column_title, 1 },
	 { "gtk_clist_column_titles_passive", _wrap_gtk_clist_column_titles_passive, 1 },
	 { "gtk_clist_column_titles_active", _wrap_gtk_clist_column_titles_active, 1 },
	 { "gtk_clist_column_title_passive", _wrap_gtk_clist_column_title_passive, 1 },
	 { "gtk_clist_column_title_active", _wrap_gtk_clist_column_title_active, 1 },
	 { "gtk_clist_column_titles_hide", _wrap_gtk_clist_column_titles_hide, 1 },
	 { "gtk_clist_column_titles_show", _wrap_gtk_clist_column_titles_show, 1 },
	 { "gtk_clist_thaw", _wrap_gtk_clist_thaw, 1 },
	 { "gtk_clist_freeze", _wrap_gtk_clist_freeze, 1 },
	 { "gtk_clist_set_policy", _wrap_gtk_clist_set_policy, 1 },
	 { "gtk_clist_set_border", _wrap_gtk_clist_set_border, 1 },
	 { "gtk_clist_get_cell_type", _wrap_gtk_clist_get_cell_type, 1 },
	 { "gtk_clist_row_is_visible", _wrap_gtk_clist_row_is_visible, 1 },
	 { "gtk_clist_new_with_titles", gtk__clist_new_with_titles, 1 },
	 { "gtk_clist_new", _wrap_gtk_clist_new, 1 },
	 { "GTK_IS_CLIST", _wrap_GTK_IS_CLIST, 1 },
	 { "gtk_check_menu_item_get_active", _wrap_gtk_check_menu_item_get_active, 1 },
	 { "gtk_check_menu_item_set_show_toggle", _wrap_gtk_check_menu_item_set_show_toggle, 1 },
	 { "gtk_check_menu_item_toggled", _wrap_gtk_check_menu_item_toggled, 1 },
	 { "gtk_check_menu_item_set_state", _wrap_gtk_check_menu_item_set_state, 1 },
	 { "gtk_check_menu_item_new_with_label", _wrap_gtk_check_menu_item_new_with_label, 1 },
	 { "gtk_check_menu_item_new", _wrap_gtk_check_menu_item_new, 1 },
	 { "GTK_IS_CHECK_MENU_ITEM", _wrap_GTK_IS_CHECK_MENU_ITEM, 1 },
	 { "gtk_check_button_new_with_label", _wrap_gtk_check_button_new_with_label, 1 },
	 { "gtk_check_button_new", _wrap_gtk_check_button_new, 1 },
	 { "GTK_IS_CHECK_BUTTON", _wrap_GTK_IS_CHECK_BUTTON, 1 },
	 { "gtk_button_box_set_child_ipadding", _wrap_gtk_button_box_set_child_ipadding, 1 },
	 { "gtk_button_box_set_child_size", _wrap_gtk_button_box_set_child_size, 1 },
	 { "gtk_button_box_set_layout", _wrap_gtk_button_box_set_layout, 1 },
	 { "gtk_button_box_set_spacing", _wrap_gtk_button_box_set_spacing, 1 },
	 { "gtk_button_box_get_child_ipadding", gtk__button_box_get_child_ipadding_, 1 },
	 { "gtk_button_box_get_child_size", gtk__button_box_get_child_size, 1 },
	 { "gtk_button_box_get_layout", _wrap_gtk_button_box_get_layout, 1 },
	 { "gtk_button_box_get_spacing", _wrap_gtk_button_box_get_spacing, 1 },
	 { "gtk_button_box_set_child_ipadding_default", _wrap_gtk_button_box_set_child_ipadding_default, 1 },
	 { "gtk_button_box_set_child_size_default", _wrap_gtk_button_box_set_child_size_default, 1 },
	 { "gtk_button_box_get_ipadding_default", gtk__button_box_get_child_ipadding_default, 1 },
	 { "gtk_button_box_get_child_size_default", gtk__button_box_get_child_size_default, 1 },
	 { "GTK_IS_BUTTON_BOX", _wrap_GTK_IS_BUTTON_BOX, 1 },
	 { "gtk_button_leave", _wrap_gtk_button_leave, 1 },
	 { "gtk_button_enter", _wrap_gtk_button_enter, 1 },
	 { "gtk_button_released", _wrap_gtk_button_released, 1 },
	 { "gtk_button_pressed", _wrap_gtk_button_pressed, 1 },
	 { "gtk_button_new_with_label", _wrap_gtk_button_new_with_label, 1 },
	 { "gtk_button_new", _wrap_gtk_button_new, 1 },
	 { "GTK_IS_BUTTON", _wrap_GTK_IS_BUTTON, 1 },
	 { "gtk_box_reorder_child", _wrap_gtk_box_reorder_child, 1 },
	 { "gtk_box_set_spacing", _wrap_gtk_box_set_spacing, 1 },
	 { "gtk_box_set_homogeneous", _wrap_gtk_box_set_homogeneous, 1 },
	 { "gtk_box_pack_end_defaults", _wrap_gtk_box_pack_end_defaults, 1 },
	 { "gtk_box_pack_start_defaults", _wrap_gtk_box_pack_start_defaults, 1 },
	 { "gtk_box_pack_end", _wrap_gtk_box_pack_end, 1 },
	 { "gtk_box_pack_start", _wrap_gtk_box_pack_start, 1 },
	 { "GTK_IS_BOX", _wrap_GTK_IS_BOX, 1 },
	 { "GTK_IS_BIN", _wrap_GTK_IS_BIN, 1 },
	 { "gtk_aspect_frame_set", _wrap_gtk_aspect_frame_set, 1 },
	 { "gtk_aspect_frame_new", _wrap_gtk_aspect_frame_new, 1 },
	 { "GTK_IS_ASPECT_FRAME", _wrap_GTK_IS_ASPECT_FRAME, 1 },
	 { "gtk_arrow_set", _wrap_gtk_arrow_set, 1 },
	 { "gtk_arrow_new", _wrap_gtk_arrow_new, 1 },
	 { "GTK_IS_ARROW", _wrap_GTK_IS_ARROW, 1 },
	 { "gtk_alignment_set", _wrap_gtk_alignment_set, 1 },
	 { "gtk_alignment_new", _wrap_gtk_alignment_new, 1 },
	 { "GTK_IS_ALIGNMENT", _wrap_GTK_IS_ALIGNMENT, 1 },
	 { "gtk_adjustment_clamp_page", _wrap_gtk_adjustment_clamp_page, 1 },
	 { "gtk_adjustment_set_value", _wrap_gtk_adjustment_set_value, 1 },
	 { "gtk_adjustment_get_page_size", _wrap_gtk_adjustment_get_page_size, 1 },
	 { "gtk_adjustment_get_page_increment", _wrap_gtk_adjustment_get_page_increment, 1 },
	 { "gtk_adjustment_get_step_increment", _wrap_gtk_adjustment_get_step_increment, 1 },
	 { "gtk_adjustment_get_value", _wrap_gtk_adjustment_get_value, 1 },
	 { "gtk_adjustment_get_upper", _wrap_gtk_adjustment_get_upper, 1 },
	 { "gtk_adjustment_get_lower", _wrap_gtk_adjustment_get_lower, 1 },
	 { "gtk_adjustment_new", _wrap_gtk_adjustment_new, 1 },
	 { "GTK_IS_ADJUSTMENT", _wrap_GTK_IS_ADJUSTMENT, 1 },
	 { "gtk_widget_dnd_data_set", gtk__widget_dnd_data_set, 1 },
	 { "gtk_widget_dnd_drop_set", gtk__widget_dnd_drop_set, 1 },
	 { "gtk_widget_dnd_drag_set", gtk__widget_dnd_drag_set, 1 },
	 { "gtk_widget_dnd_drag_add", _wrap_gtk_widget_dnd_drag_add, 1 },
	 { "gtk_widget_shape_combine_mask", _wrap_gtk_widget_shape_combine_mask, 1 },
	 { "gtk_widget_set_default_style", _wrap_gtk_widget_set_default_style, 1 },
	 { "gtk_widget_pop_style", _wrap_gtk_widget_pop_style, 1 },
	 { "gtk_widget_push_style", _wrap_gtk_widget_push_style, 1 },
	 { "gtk_widget_hide_on_delete", _wrap_gtk_widget_hide_on_delete, 1 },
	 { "gtk_widget_is_child", _wrap_gtk_widget_is_child, 1 },
	 { "gtk_widget_is_ancestor", _wrap_gtk_widget_is_ancestor, 1 },
	 { "gtk_widget_get_pointer", gtk_widget__get_pointer, 1 },
	 { "gtk_widget_get_extension_events", _wrap_gtk_widget_get_extension_events, 1 },
	 { "gtk_widget_get_events", _wrap_gtk_widget_get_events, 1 },
	 { "gtk_widget_get_style", _wrap_gtk_widget_get_style, 1 },
	 { "gtk_widget_get_ancestor", _wrap_gtk_widget_get_ancestor, 1 },
	 { "gtk_widget_get_toplevel", _wrap_gtk_widget_get_toplevel, 1 },
	 { "gtk_widget_set_extension_events", _wrap_gtk_widget_set_extension_events, 1 },
	 { "gtk_widget_set_events", _wrap_gtk_widget_set_events, 1 },
	 { "gtk_widget_set_usize", _wrap_gtk_widget_set_usize, 1 },
	 { "gtk_widget_set_uposition", _wrap_gtk_widget_set_uposition, 1 },
	 { "gtk_widget_propagate_default_style", _wrap_gtk_widget_propagate_default_style, 1 },
	 { "gtk_widget_restore_default_style", _wrap_gtk_widget_restore_default_style, 1 },
	 { "gtk_widget_ensure_style", _wrap_gtk_widget_ensure_style, 1 },
	 { "gtk_widget_set_rc_style", _wrap_gtk_widget_set_rc_style, 1 },
	 { "gtk_widget_set_style", _wrap_gtk_widget_set_style, 1 },
	 { "gtk_widget_set_parent", _wrap_gtk_widget_set_parent, 1 },
	 { "gtk_widget_set_sensitive", _wrap_gtk_widget_set_sensitive, 1 },
	 { "gtk_widget_set_state", _wrap_gtk_widget_set_state, 1 },
	 { "gtk_widget_get_name", _wrap_gtk_widget_get_name, 1 },
	 { "gtk_widget_set_name", _wrap_gtk_widget_set_name, 1 },
	 { "gtk_widget_grab_default", _wrap_gtk_widget_grab_default, 1 },
	 { "gtk_widget_grab_focus", _wrap_gtk_widget_grab_focus, 1 },
	 { "gtk_widget_basic", _wrap_gtk_widget_basic, 1 },
	 { "gtk_widget_intersect", _wrap_gtk_widget_intersect, 1 },
	 { "gtk_widget_popup", _wrap_gtk_widget_popup, 1 },
	 { "gtk_widget_reparent", _wrap_gtk_widget_reparent, 1 },
	 { "gtk_widget_activate", _wrap_gtk_widget_activate, 1 },
	 { "gtk_widget_remove_accelerator", _wrap_gtk_widget_remove_accelerator, 1 },
	 { "gtk_widget_install_accelerator", _wrap_gtk_widget_install_accelerator, 1 },
	 { "gtk_widget_size_allocate", _wrap_gtk_widget_size_allocate, 1 },
	 { "gtk_widget_size_request", _wrap_gtk_widget_size_request, 1 },
	 { "gtk_widget_draw_default", _wrap_gtk_widget_draw_default, 1 },
	 { "gtk_widget_draw_focus", _wrap_gtk_widget_draw_focus, 1 },
	 { "gtk_widget_draw", _wrap_gtk_widget_draw, 1 },
	 { "gtk_widget_queue_resize", _wrap_gtk_widget_queue_resize, 1 },
	 { "gtk_widget_queue_draw", _wrap_gtk_widget_queue_draw, 1 },
	 { "gtk_widget_unrealize", _wrap_gtk_widget_unrealize, 1 },
	 { "gtk_widget_realize", _wrap_gtk_widget_realize, 1 },
	 { "gtk_widget_unmap", _wrap_gtk_widget_unmap, 1 },
	 { "gtk_widget_map", _wrap_gtk_widget_map, 1 },
	 { "gtk_widget_hide_all", _wrap_gtk_widget_hide_all, 1 },
	 { "gtk_widget_show_now", _wrap_gtk_widget_show_now, 1 },
	 { "gtk_widget_show_all", _wrap_gtk_widget_show_all, 1 },
	 { "gtk_widget_hide", _wrap_gtk_widget_hide, 1 },
	 { "gtk_widget_show", _wrap_gtk_widget_show, 1 },
	 { "gtk_widget_unparent", _wrap_gtk_widget_unparent, 1 },
	 { "gtk_widget_destroy", _wrap_gtk_widget_destroy, 1 },
	 { "gtk_widget_get_window", _wrap_gtk_widget_get_window, 1 },
	 { "GTK_IS_WIDGET", _wrap_GTK_IS_WIDGET, 1 },
	 { "gtk_object_remove_data", _wrap_gtk_object_remove_data, 1 },
	 { "gtk_object_get_data", gtk__object_get_data, 1 },
	 { "gtk_object_set_data", gtk__object_set_data, 1 },
	 { "GTK_OBJECT_UNSET_FLAGS", _wrap_GTK_OBJECT_UNSET_FLAGS, 1 },
	 { "GTK_OBJECT_SET_FLAGS", _wrap_GTK_OBJECT_SET_FLAGS, 1 },
	 { "GTK_OBJECT_TYPE", _wrap_GTK_OBJECT_TYPE, 1 },
	 { "GTK_OBJECT_FLAGS", _wrap_GTK_OBJECT_FLAGS, 1 },
	 { "GTK_IS_OBJECT", _wrap_GTK_IS_OBJECT, 1 },
	 { "gtk_type_from_name", _wrap_gtk_type_from_name, 1 },
	 { "gtk_type_name", _wrap_gtk_type_name, 1 },
	 { "gdk_color_alloc", gdk__color_alloc, 1 },
	 { "gdk_draw_lines", gdk__draw_lines, 1 },
	 { "gdk_draw_segments", gdk__draw_segments, 1 },
	 { "gdk_draw_points", gdk__draw_points, 1 },
	 { "gdk_draw_text", gdk__draw_text, 1 },
	 { "gdk_draw_string", gdk__draw_text, 1 },
	 { "gdk_draw_polygon", gdk__draw_polygon, 1 },
	 { "gdk_draw_pixmap", _wrap_gdk_draw_pixmap, 1 },
	 { "gdk_draw_arc", _wrap_gdk_draw_arc, 1 },
	 { "gdk_draw_rectangle", _wrap_gdk_draw_rectangle, 1 },
	 { "gdk_draw_line", _wrap_gdk_draw_line, 1 },
	 { "gdk_draw_point", _wrap_gdk_draw_point, 1 },
	 { "gdk_pixmap_create_from_xpm", gdk__pixmap_create_from_xpm, 1 },
	 { "gdk_pixmap_new", gdk__pixmap_new, 1 },
	 { "gdk_fontset_load", _wrap_gdk_fontset_load, 1 },
	 { "gdk_font_load", _wrap_gdk_font_load, 1 },
	 { "gtk_object_get", gtk__object_get, 1 },
	 { "gtk_object_new", gtk__object_new, 1 },
	 { "gtk_object_set", gtk__object_set, 1 },
	 { "_get_types", PyGtk_get_types, 1 },
	 { "gtk_rc_add_widget_class_style", _wrap_gtk_rc_add_widget_class_style, 1 },
	 { "gtk_rc_add_widget_name_style", _wrap_gtk_rc_add_widget_name_style, 1 },
	 { "gtk_rc_get_style", _wrap_gtk_rc_get_style, 1 },
	 { "gtk_rc_parse_string", _wrap_gtk_rc_parse_string, 1 },
	 { "gtk_rc_parse", _wrap_gtk_rc_parse, 1 },
	 { "gtk_rc_init", _wrap_gtk_rc_init, 1 },
	 { "gtk_input_remove", _wrap_gtk_input_remove, 1 },
	 { "gtk_input_add", gtk__input_add, 1 },
	 { "gtk_quit_add_destroy", _wrap_gtk_quit_add_destroy, 1 },
	 { "gtk_quit_remove_function", _wrap_gtk_quit_remove_function, 1 },
	 { "gtk_quit_remove", _wrap_gtk_quit_remove, 1 },
	 { "gtk_quit_add", gtk__quit_add, 1 },
	 { "gtk_idle_remove_function", _wrap_gtk_idle_remove_function, 1 },
	 { "gtk_idle_remove", _wrap_gtk_idle_remove, 1 },
	 { "gtk_idle_add_priority", gtk__idle_add_priority, 1 },
	 { "gtk_idle_add", gtk__idle_add, 1 },
	 { "gtk_timeout_remove", _wrap_gtk_timeout_remove, 1 },
	 { "gtk_timeout_add", gtk__timeout_add, 1 },
	 { "gtk_grab_remove", _wrap_gtk_grab_remove, 1 },
	 { "gtk_grab_add", _wrap_gtk_grab_add, 1 },
	 { "gtk_main_iteration", _wrap_gtk_main_iteration, 1 },
	 { "gtk_main_quit", _wrap_gtk_main_quit, 1 },
	 { "gtk_main", _wrap_gtk_main, 1 },
	 { "gtk_exit", _wrap_gtk_exit, 1 },
	 { "gtk_init", gtk__init, 1 },
	 { "gtk_signal_emit_stop_by_name", _wrap_gtk_signal_emit_stop_by_name, 1 },
	 { "gtk_signal_handlers_destroy", _wrap_gtk_signal_handlers_destroy, 1 },
	 { "gtk_signal_handler_unblock_by_data", _wrap_gtk_signal_handler_unblock_by_data, 1 },
	 { "gtk_signal_handler_unblock", _wrap_gtk_signal_handler_unblock, 1 },
	 { "gtk_signal_handler_block_by_data", _wrap_gtk_signal_handler_block_by_data, 1 },
	 { "gtk_signal_handler_block", _wrap_gtk_signal_handler_block, 1 },
	 { "gtk_signal_disconnect_by_data", _wrap_gtk_signal_disconnect_by_data, 1 },
	 { "gtk_signal_disconnect", _wrap_gtk_signal_disconnect, 1 },
	 { "gtk_signal_connect_after", gtk__signal_connect_after, 1 },
	 { "gtk_signal_connect", gtk__signal_connect, 1 },
	 { NULL, NULL }
};
static PyObject *SWIG_globals;
#ifdef __cplusplus
extern "C" 
#endif
SWIGEXPORT(void,initgtk)() {
	 PyObject *m, *d;
	 SWIG_globals = SWIG_newvarlink();
	 m = Py_InitModule("gtk", gtkMethods);
	 d = PyModule_GetDict(m);
/*
 * These are the pointer type-equivalency mappings. 
 * (Used by the SWIG pointer type-checker).
 */
	 SWIG_RegisterMapping("_signed_long","_long",0);
	 SWIG_RegisterMapping("_long","_unsigned_long",0);
	 SWIG_RegisterMapping("_long","_signed_long",0);
	 SWIG_RegisterMapping("_unsigned_long","_long",0);
	 SWIG_RegisterMapping("_signed_int","_int",0);
	 SWIG_RegisterMapping("_unsigned_short","_short",0);
	 SWIG_RegisterMapping("_signed_short","_short",0);
	 SWIG_RegisterMapping("_unsigned_int","_int",0);
	 SWIG_RegisterMapping("_short","_unsigned_short",0);
	 SWIG_RegisterMapping("_short","_signed_short",0);
	 SWIG_RegisterMapping("_int","_unsigned_int",0);
	 SWIG_RegisterMapping("_int","_signed_int",0);
}
