#!/usr/local/bin/swig -python -o gtkmodule.c
#
# SWIG wrapper for Gtk-Python

%module gtk

%{
#include <gtk/gtk.h>
%}

%include gtkobject.i
%include obj_tmpl.i
%include gdk_typemap.i
%include gtk_typemap.i

// signal handler
%include gtksignal.i

// gtk object general new/set routines
%include gtknewset.i

// main loop handler
%include gtkmain.i

char *gtk_type_name(int tp);
int gtk_type_from_name(char *name);

int GTK_IS_OBJECT(GtkObject *o);
int GTK_OBJECT_FLAGS(GtkObject *o);
int GTK_OBJECT_TYPE(GtkObject *o);
int GTK_IS_WIDGET(GtkObject *o);
void gtk_widget_destroy(GtkWidget *w);
void gtk_widget_unparent(GtkWidget *w);
void gtk_widget_show(GtkWidget *w);
void gtk_widget_hide(GtkWidget *w);
void gtk_widget_map(GtkWidget *w);
void gtk_widget_unmap(GtkWidget *w);
void gtk_widget_realize(GtkWidget *w);
void gtk_widget_unrealize(GtkWidget *w);
void gtk_widget_draw(GtkWidget *w, GdkRectangle *a);
void gtk_widget_draw_focus(GtkWidget *w);
void gtk_widget_draw_default(GtkWidget *w);
void gtk_widget_size_request(GtkWidget *w, GtkRequisition *r);
void gtk_widget_size_allocate(GtkWidget *w, GtkAllocation *a);
// gtk_widget_install_accelerator
// gtk_widget_remove_accelerator
void gtk_widget_activate(GtkWidget *w);
void gtk_widget_reparent(GtkWidget *w, GtkWidget *p);
void gtk_widget_popup(GtkWidget *w, int x, int y);
void gtk_widget_intersect(GtkWidget *w, GdkRectangle *a, GdkRectangle *out);
void gtk_widget_basic(GtkWidget *w);
void gtk_widget_grab_focus(GtkWidget *w);
void gtk_widget_grab_default(GtkWidget *w);
void gtk_widget_restore_state(GtkWidget *w);
void gtk_widget_set_name(GtkWidget *w, char *name);
char *gtk_widget_get_name(GtkWidget *w);
void gtk_widget_set_state(GtkWidget *w, int state);
void gtk_widget_set_sensitive(GtkWidget *w, int s);
void gtk_widget_set_parent(GtkWidget *w, GtkWidget *p);
// gtk_widget_set_style
void gtk_widget_set_uposition(GtkWidget *w, int x, int y);
void gtk_widget_set_usize(GtkWidget *w, int w, int h);
void gtk_widget_set_events(GtkWidget *w, int e);
GtkWidget *gtk_widget_get_toplevel(GtkWidget *w);
GtkWidget *gtk_widget_get_ancestor(GtkWidget *w, int t);
// gtk_widget_get_colormap
// gtk_widget_get_visual
// gtk_widget_get_style
int gtk_widget_get_events(GtkWidget *w);
%{
static PyObject *gtk_widget__get_pointer(PyObject *self, PyObject *args) {
  int x, y;
  PyGtk_Object *w;
  if (!PyArg_ParseTuple(args, "O!:gtk_widget_get_pointer", &PyGtk_Type, &w))
    return NULL;
  gtk_widget_get_pointer(GTK_WIDGET(w->go), &x, &y);
  return Py_BuildValue("(ii)", x, y);
}
%}
%native(gtk_widget_get_pointer) PyObject *gtk_widget__get_pointer(PyObject
                                                    *self, PyObject *args);

// gtk_widget_push_colormap
// gtk_widget_push_visual
// gtk_widget_push_style
// gtk_widget_pop_colormap
// gtk_widget_pop_visual
// gtk_widget_pop_style
// gtk_widget_set_default_colormap
// gtk_widget_set_default_visual
// gtk_widget_set_default_style
// gtk_widget_get_default_colormap
// gtk_widget_get_default_visual
// gtk_widget_get_default_style

int GTK_IS_ADJUSTMENT(GtkObject *o);
GtkObject *gtk_adjustment_new(double v, double l, double u, double si,
                                                 double pi, double ps);
int GTK_IS_ALIGNMENT(GtkObject *o);
GtkWidget *gtk_alignment_new(double xa, double ya, double xs, double ys);
void gtk_alignment_set(GtkAlignment *a, double xa, double ya, double xs,
                                                              double ys);
int GTK_IS_ARROW(GtkObject *o);
GtkWidget *gtk_arrow_new(int at, int st);
void gtk_arrow_set(GtkArrow *a, int at, int st);
int GTK_IS_ASPECT_FRAME(GtkObject *o);
GtkWidget *gtk_aspect_frame_new(char *label, double xa, double ya,
                                     double ratio, int obey_child);
void gtk_aspect_frame_set(GtkAspectFrame *a, double xa, double ya,
                                     double ratio, int obey_child);
int GTK_IS_BIN(GtkObject *o);
int GTK_IS_BOX(GtkObject *o);
void gtk_box_pack_start(GtkBox *b, GtkWidget *w, int e, int f, int p);
void gtk_box_pack_end(GtkBox *b, GtkWidget *w, int e, int f, int p);
void gtk_box_pack_start_defaults(GtkBox *b, GtkWidget *w);
void gtk_box_pack_end_defaults(GtkBox *b, GtkWidget *w);
void gtk_box_set_homogeneous(GtkBox *b, int h);
void gtk_box_set_spacing(GtkBox *b, int s);
int GTK_IS_BUTTON(GtkObject *o);
GtkWidget *gtk_button_new();
GtkWidget *gtk_button_new_with_label(char *l);
void gtk_button_pressed(GtkButton *b);
void gtk_button_released(GtkButton *b);
void gtk_button_enter(GtkButton *b);
void gtk_button_leave(GtkButton *b);
int GTK_IS_BUTTON_BOX(GtkObject *o);
%{
static PyObject *
gtk__button_box_get_child_size_default(PyObject *self, PyObject *args) {
    int mw, mh;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_size_default"))
        return NULL;
    gtk_button_box_get_child_size_default(&mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args) {
    int ipx, ipy;
    if (!PyArg_ParseTuple(args, ":gtk_button_box_get_child_ipadding_default"))
        return NULL;
    gtk_button_box_get_child_ipadding_default(&ipx, &ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
static PyObject *
gtk__button_box_get_child_size(PyObject *self, PyObject *args) {
    int mw, mh;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_size",
            &PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_size(GTK_BUTTON_BOX(PyGtk_Get(o)), &mw, &mh);
    return Py_BuildValue("(ii)", mw, mh);
}
static PyObject *
gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args) {
    int ipx, ipy;
    PyGtk_Object *o;
    if (!PyArg_ParseTuple(args, "O!:gtk_button_box_get_child_ipadding",
            &PyGtk_Type, &o))
        return NULL;
    gtk_button_box_get_child_ipadding(GTK_BUTTON_BOX(PyGtk_Get(o)),&ipx,&ipy);
    return Py_BuildValue("(ii)", ipx, ipy);
}
%}
%native(gtk_button_box_get_child_size_default) PyObject *
    gtk__button_box_get_child_size_default(PyObject *self, PyObject *args);
%native(gtk_button_box_get_ipadding_default) PyObject *
    gtk__button_box_get_child_ipadding_default(PyObject *self, PyObject *args);
void gtk_button_box_set_child_size_default(int mw, int mh);
void gtk_button_box_set_child_ipadding_default(int ipx, int ipy);
int gtk_button_box_get_spacing(GtkButtonBox *w);
int gtk_button_box_get_layout(GtkButtonBox *w);
%native(gtk_button_box_get_child_size) PyObject *
    gtk__button_box_get_child_size(PyObject *self, PyObject *args);
%native(gtk_button_box_get_child_ipadding) PyObject *
    gtk__button_box_get_child_ipadding_(PyObject *self, PyObject *args);
void gtk_button_box_set_spacing(GtkButtonBox *w, int s);
void gtk_button_box_set_layout(GtkButtonBox *w, int l);
void gtk_button_box_set_child_size(GtkButtonBox *w, int mw, int mh);
void gtk_button_box_set_child_ipadding(GtkButtonBox *w, int ipx, int ipy);
int GTK_IS_CHECK_BUTTON(GtkObject *o);
GtkWidget *gtk_check_button_new();
GtkWidget *gtk_check_button_new_with_label(char *l);
int GTK_IS_CHECK_MENU_ITEM(GtkObject *o);
GtkWidget *gtk_check_menu_item_new();
GtkWidget *gtk_check_menu_item_new_with_label(char *l);
void gtk_check_menu_item_set_state(GtkCheckMenuItem *c, int s);
void gtk_check_menu_item_toggled(GtkCheckMenuItem *c);
int GTK_IS_COLOR_SELECTION(GtkObject *o);
int GTK_IS_COLOR_SELECTION_DIALOG(GtkObject *o);
void gtk_color_selection_init(GtkColorSelection *c);
GtkWidget *gtk_color_selection_new();
void gtk_color_selection_set_update_policy(GtkColorSelection *c, int p);
void gtk_color_selection_set_opacity(GtkColorSelection *c, int uo);
void gtk_color_selection_set_color(GtkColorSelection *c, gdouble *color);
void gtk_color_selection_get_color(GtkColorSelection *c, gdouble *ocolor);
void gtk_color_selection_dialog_init(GtkColorSelectionDialog *c);
GtkWidget *gtk_color_selection_dialog_new(char *title);
int GTK_IS_CONTAINER(GtkObject *o);
void gtk_container_border_width(GtkContainer *c, int bw);
void gtk_container_add(GtkContainer *c, GtkWidget *w);
void gtk_container_remove(GtkContainer *c, GtkWidget *w);
void gtk_container_disable_resize(GtkContainer *c);
void gtk_container_enable_resize(GtkContainer *c);
void gtk_container_block_resize(GtkContainer *c);
void gtk_container_unblock_resize(GtkContainer *c);
int gtk_container_need_resize(GtkContainer *c);
// -- seems to have been removed
// void gtk_container_check_resize(GtkContainer *c, GtkWidget *w);
// gtk_container_foreach
int gtk_container_focus(GtkContainer *c, int d);
GList *gtk_container_children(GtkContainer *c);
int GTK_IS_CURVE(GtkObject *o);
GtkWidget *gtk_curve_new();
void gtk_curve_reset(GtkCurve *c);
void gtk_curve_set_gamma(GtkCurve *c, double g);
void gtk_curve_set_range(GtkCurve *c, double min_x, double max_x,
                                      double min_y, double max_y);
// gtk_curve_get_vector
// gtk_curve_set_vector
void gtk_curve_set_curve_type(GtkCurve *c, int t);
int GTK_IS_DATA(GtkObject *o);
int GTK_IS_DIALOG(GtkObject *o);
GtkWidget *gtk_dialog_new();
int GTK_IS_DRAWING_AREA(GtkObject *o);
GtkWidget *gtk_drawing_area_new();
void gtk_drawing_area_size(GtkDrawingArea *d, int w, int h);
int GTK_IS_ENTRY(GtkObject *o);
GtkWidget *gtk_entry_new();
void gtk_entry_set_text(GtkEntry *e, char *t);
void gtk_entry_append_text(GtkEntry *e, char *t);
void gtk_entry_prepend_text(GtkEntry *e, char *t);
void gtk_entry_set_position(GtkEntry *e, int p);
char *gtk_entry_get_text(GtkEntry *e);
int GTK_IS_EVENT_BOX(GtkObject *o);
GtkWidget *gtk_event_box_new();
int GTK_IS_FILE_SELECTION(GtkObject *o);
GtkWidget *gtk_file_selection_new(char *title);
void gtk_file_selection_set_filename(GtkFileSelection *f, char *file);
char *gtk_file_selection_get_filename(GtkFileSelection *f);
int GTK_IS_FIXED(GtkObject *o);
GtkWidget *gtk_fixed_new();
void gtk_fixed_put(GtkFixed *fixed, GtkWidget *w, int x, int y);
void gtk_fixed_move(GtkFixed *fixed, GtkWidget *w, int x, int y);
int GTK_IS_FRAME(GtkObject *o);
GtkWidget *gtk_frame_new(char *label);
void gtk_frame_set_label(GtkFrame *f, char *label);
void gtk_frame_set_label_align(GtkFrame *f, double xa, double ya);
void gtk_frame_set_shadow_type(GtkFrame *f, int st);
int GTK_IS_GAMMA_CURVE(GtkObject *o);
GtkWidget *gtk_gamma_curve_new();
int GTK_IS_HBOX(GtkObject *o);
GtkWidget *gtk_hbox_new(int homogeneous, int spacing);
int GTK_IS_HBUTTON_BOX(GtkObject *o);
GtkWidget *gtk_hbutton_box_new();
int gtk_hbutton_box_get_spacing_default();
int gtk_hbutton_box_get_layout_default();
void gtk_hbutton_box_set_spacing_default(int s);
void gtk_hbutton_box_set_layout_default(int l);
int GTK_IS_HPANED(GtkObject *o);
GtkWidget *gtk_hpaned_new();
int GTK_IS_HRULER(GtkObject *o);
GtkWidget *gtk_hruler_new();
int GTK_IS_HSCALE(GtkObject *o);
GtkWidget *gtk_hscale_new(GtkAdjustment *adjustment);
int GTK_IS_HSCROLLBAR(GtkObject *o);
GtkWidget *gtk_hscrollbar_new(GtkAdjustment *adjustment);
int GTK_IS_HSEPARATOR(GtkObject *o);
GtkWidget *gtk_hseparator_new();
int GTK_IS_IMAGE(GtkObject *o);
// GtkWidget *gtk_image_new(GdkImage *val, GdkBitmap *mask);
// void gtk_image_set(GtkImage *i, GdkImage *val, GdkBitmap *mask);
// void gtk_image_get(GtkImage *i, GdkImage **val, GdkBitmap **mask);
int GTK_IS_INPUT_DIALOG(GtkObject *o);
GtkWidget *gtk_input_dialog_new();
int GTK_IS_ITEM(GtkObject *o);
void gtk_item_select(GtkItem *i);
void gtk_item_deselect(GtkItem *i);
void gtk_item_toggle(GtkItem *i);
int GTK_IS_LABEL(GtkObject *o);
GtkWidget *gtk_label_new(char *str);
void gtk_label_set(GtkLabel *l, char *str);
void gtk_label_get(GtkLabel *l, char **outstr);
int GTK_IS_LIST(GtkObject *o);
GtkWidget *gtk_list_new();
void gtk_list_insert_items(GtkList *l, GList *items, int position);
void gtk_list_append_items(GtkList *l, GList *items);
void gtk_list_prepend_items(GtkList *l, GList *items);
void gtk_list_remove_items(GtkList *l, GList *items);
void gtk_list_clear_items(GtkList *l, int start, int end);
void gtk_list_select_item(GtkList *l, int item);
void gtk_list_unselect_item(GtkList *l, int item);
void gtk_list_select_child(GtkList *l, GtkWidget *child);
void gtk_list_unselect_child(GtkList *l, GtkWidget *child);
int gtk_list_child_position(GtkList *l, GtkWidget *child);
void gtk_list_set_selection_mode(GtkList *l, int mode);
int GTK_IS_LIST_ITEM(GtkObject *o);
GtkWidget *gtk_list_item_new();
GtkWidget *gtk_list_item_new_with_label(char *label);
void gtk_list_item_select(GtkListItem *i);
void gtk_list_item_deselect(GtkListItem *i);
int GTK_IS_MENU(GtkObject *o);
GtkWidget *gtk_menu_new();
void gtk_menu_append(GtkMenu *m, GtkWidget *child);
void gtk_menu_prepend(GtkMenu *m, GtkWidget *child);
void gtk_menu_insert(GtkMenu *m, GtkWidget *child, int pos);
%{
static void PyGtk_MenuPosition(GtkMenu *menu, int *x, int *y, PyObject *func) {
    PyObject *ret;
    ret = PyObject_CallFunction(func, "(O)", PyGtk_New(GTK_OBJECT(menu)));
    if (ret == NULL || !PyArg_ParseTuple(ret, "ii", x, y)) {
        PyErr_Clear();
        fprintf(stderr, "Ignoring Exception\n");
        *x = 0;
        *y = 0;
    } else
        Py_DECREF(ret);
}
static PyObject *gtk__menu_popup(PyObject *self, PyObject *args) {
    PyGtk_Object *m, *pms, *pmi;
    PyObject *func;
    int button, time;
    if (!PyArg_ParseTuple(args, "O!O!O!Oii:gtk_menu_item", &PyGtk_Type, &m,
            &PyGtk_Type, &pms, &PyGtk_Type, &pmi, &func, &button, &time))
        return NULL;
    if (!PyCallable_Check(func)) {
        PyErr_SetString(PyExc_TypeError, "forth argument not callable");
        return NULL;
    }
    Py_INCREF(func);
    gtk_menu_popup(GTK_MENU(PyGtk_Get(m)), GTK_WIDGET(PyGtk_Get(pms)),
        GTK_WIDGET(PyGtk_Get(pmi)), (GtkMenuPositionFunc)PyGtk_MenuPosition,
        func, button, time);
    Py_INCREF(Py_None);
    return Py_None;
}
%}
%native(gtk_menu_popup) PyObject *gtk__menu_popup(PyObject *s,PyObject *args);
void gtk_menu_popdown(GtkMenu *m);
GtkWidget *gtk_menu_get_active(GtkMenu *m);
void gtk_menu_set_active(GtkMenu *m, int pos);
void gtk_menu_set_accelerator_table(GtkMenu *m, GtkAcceleratorTable *table);
int GTK_IS_MENU_BAR(GtkObject *o);
GtkWidget *gtk_menu_bar_new();
void gtk_menu_bar_append(GtkMenuBar *m, GtkWidget *child);
void gtk_menu_bar_prepend(GtkMenuBar *m, GtkWidget *child);
void gtk_menu_bar_insert(GtkMenuBar *m, GtkWidget *child, int pos);
int GTK_IS_MENU_ITEM(GtkObject *o);
GtkWidget *gtk_menu_item_new();
GtkWidget *gtk_menu_item_new_with_label(char *label);
void gtk_menu_item_set_submenu(GtkMenuItem *m, GtkWidget *submenu);
void gtk_menu_item_set_placement(GtkMenuItem *m, int placement);
void gtk_menu_item_accelerator_size(GtkMenuItem *m);
void gtk_menu_item_accelerator_text(GtkMenuItem *m, char *buffer);
void gtk_menu_item_configure(GtkMenuItem *m, int show_toggle, int show_sub);
void gtk_menu_item_select(GtkMenuItem *m);
void gtk_menu_item_deselect(GtkMenuItem *m);
void gtk_menu_item_activate(GtkMenuItem *m);
void gtk_menu_item_right_justify(GtkMenuItem *m);
int GTK_IS_MENU_SHELL(GtkObject *o);
void gtk_menu_shell_append(GtkMenuShell *m, GtkWidget *child);
void gtk_menu_shell_prepend(GtkMenuShell *m, GtkWidget *child);
void gtk_menu_shell_insert(GtkMenuShell *m, GtkWidget *child, int pos);
void gtk_menu_shell_deactivate(GtkMenuShell *m);
int GTK_IS_MISC(GtkObject *o);
void gtk_misc_set_alignment(GtkMisc *m, double xalign, double yalign);
void gtk_misc_set_padding(GtkMisc *m, int xpad, int ypad);
int GTK_IS_NOTEBOOK(GtkObject *o);
GtkWidget *gtk_notebook_new();
void gtk_notebook_append_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab);
void gtk_notebook_prepend_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab);
void gtk_notebook_insert_page(GtkNotebook *n, GtkWidget *c, GtkWidget *tab, int pos);
void gtk_notebook_remove_page(GtkNotebook *n, int pos);
int gtk_notebook_current_page(GtkNotebook *n);
void gtk_notebook_set_page(GtkNotebook *n, int pos);
void gtk_notebook_next_page(GtkNotebook *n);
void gtk_notebook_prev_page(GtkNotebook *n);
void gtk_notebook_set_tab_pos(GtkNotebook *n, int pos);
void gtk_notebook_set_show_tabs(GtkNotebook *n, int show);
void gtk_notebook_set_show_border(GtkNotebook *n, int show);
int GTK_IS_OPTION_MENU(GtkObject *o);
GtkWidget *gtk_option_menu_new();
GtkWidget *gtk_option_menu_get_menu(GtkOptionMenu *o);
void gtk_option_menu_set_menu(GtkOptionMenu *o, GtkWidget *m);
void gtk_option_menu_remove_menu(GtkOptionMenu *o);
void gtk_option_menu_set_history(GtkOptionMenu *o, int index);
int GTK_IS_PANED(GtkObject *o);
void gtk_paned_add1(GtkPaned *paned, GtkWidget *child);
void gtk_paned_add2(GtkPaned *paned, GtkWidget *child);
void gtk_paned_handle_size(GtkPaned *paned, int size);
void gtk_paned_gutter_size(GtkPaned *paned, int size);
int GTK_IS_PIXMAP(GtkObject *o);
%{
static PyObject *gtk__pixmap_new_from_xpm(PyObject *self, PyObject *args) {
    PyGtk_Object *win;
    PyGdkColor_Object *tc;
    char *name;
    GdkPixmap *pm;
    GdkBitmap *bm;

    if (!PyArg_ParseTuple(args, "O!O!s:gtk_pixmap_new_from_xpm", &PyGtk_Type,
            &win, &PyGdkColor_Type, &tc, &name))
        return NULL;
    pm = gdk_pixmap_create_from_xpm(GTK_WIDGET(PyGtk_Get(win))->window, &bm,
        PyGdkColor_Get(tc), name);
    return PyGtk_New(GTK_OBJECT(gtk_pixmap_new(pm, bm)));
}
%}
%native(gtk_pixmap_new_from_xpm) PyObject *gtk__pixmap_new_from_xpm(PyObject
    *self, PyObject *args);
// GtkWidget *gtk_pixmap_new(GdkPixmap *pixmap, GdkBitmap *mask);
// void gtk_pixmap_set(GtkPixmap *p, GdkPixmap *val, GdkBitmap *mask);
// void gtk_pixmap_get(GtkPixmap *p, GdkPixmap **val, GdkBitmap **mask);
int GTK_IS_PREVIEW(GtkObject *o);
void gtk_preview_uninit();
GtkWidget *gtk_preview_new(int preview_type);
void gtk_preview_size(GtkPreview *p, int w, int h);
// gtk_preview_put
// gtk_preview_put_row
// gtk_preview_draw_row
void gtk_preview_set_expand(GtkPreview *p, int expand);
void gtk_preview_set_gamma(double gamma);
void gtk_preview_set_color_cube(unsigned int nred, unsigned int ngreen,
                                unsigned int nblue, unsigned int ngrey);
void gtk_preview_set_install_cmap(int install);
void gtk_preview_set_reserved(int res);
// gtk_preview_get_visual
// gtk_preview_get_cmap
// gtk_preview_get_info
int GTK_IS_PROGRESS_BAR(GtkObject *o);
GtkWidget *gtk_progress_bar_new();
void gtk_progress_bar_update(GtkProgressBar *p, double percent);
int GTK_IS_RADIO_BUTTON(GtkObject *o);
%{
static PyObject *gtk__radio_button_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_button_new", &PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_button_group(GTK_RADIO_BUTTON(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_button_new(l)));
}
static PyObject *gtk__radio_button_new_with_label(PyObject *s,PyObject *args){
    PyGtk_Object *g = NULL;
    char *label;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!s:gtk_radio_button_new_with_label",
            &PyGtk_Type, &g, &label))
        return NULL;
    if (g)
        l = gtk_radio_button_group(GTK_RADIO_BUTTON(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_button_new_with_label(l, label)));
}
%}
%native(gtk_radio_button_new) PyObject *gtk__radio_button_new(PyObject *self,
    PyObject *args);
%native(gtk_radio_button_new_with_label) PyObject *
    gtk__radio_button_new_with_label(PyObject *s,PyObject *args);
int GTK_IS_RADIO_MENU_ITEM(GtkObject *o);
%{
static PyObject *gtk__radio_menu_item_new(PyObject *self, PyObject *args) {
    PyGtk_Object *g = NULL;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(args, "|O!:gtk_radio_menu_item_new",&PyGtk_Type, &g))
        return NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new(l)));
}
static PyObject *gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a) {
    PyGtk_Object *g = NULL;
    char *label;
    GSList *l = NULL;
    if (!PyArg_ParseTuple(a, "|O!s:gtk_radio_menu_item_new_with_label",
            &PyGtk_Type, &g, &label))
        return NULL;
    if (g)
        l = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(PyGtk_Get(g)));
    return PyGtk_New(GTK_OBJECT(gtk_radio_menu_item_new_with_label(l, label)));
}
%}
%native(gtk_radio_menu_item_new) PyObject *gtk__radio_menu_item_new(PyObject
    *self, PyObject *args);
%native(gtk_radio_menu_item_new_with_label) PyObject *
    gtk__radio_menu_item_new_with_label(PyObject *s,PyObject *a);
int GTK_IS_RANGE(GtkObject *o);
GtkAdjustment *gtk_range_get_adjustment(GtkRange *r);
void gtk_range_set_update_policy(GtkRange *r, int update);
void gtk_range_set_adjustment(GtkRange *r, GtkAdjustment *a);
void gtk_range_draw_background(GtkRange *r);
void gtk_range_draw_trough(GtkRange *r);
void gtk_range_draw_slider(GtkRange *r);
void gtk_range_draw_step_forw(GtkRange *r);
void gtk_range_draw_step_back(GtkRange *r);
void gtk_range_slider_update(GtkRange *r);
void gtk_range_trough_click(GtkRange *r, int x, int y);
void gtk_range_default_hslider_update(GtkRange *r);
void gtk_range_default_vslider_update(GtkRange *r);
void gtk_range_default_htrough_click(GtkRange *r, int x, int y);
void gtk_range_default_vtrough_click(GtkRange *r, int x, int y);
void gtk_range_default_hmotion(GtkRange *r, int x, int y);
void gtk_range_default_vmotion(GtkRange *r, int x, int y);
double gtk_range_calc_value(GtkRange *r, int pos);
int GTK_IS_RULER(GtkObject *o);
void gtk_ruler_set_metric(GtkRuler *r, int metric);
void gtk_ruler_set_range(GtkRuler *r, double lower, double upper, double pos,
                                                             double max_size);
void gtk_ruler_draw_ticks(GtkRuler *r);
void gtk_ruler_draw_pos(GtkRuler *r);
int GTK_IS_SCALE(GtkObject *o);
void gtk_scale_set_digits(GtkScale *s, int digits);
void gtk_scale_set_draw_value(GtkScale *s, int value);
void gtk_scale_set_value_pos(GtkScale *s, int pos);
int gtk_scale_value_width(GtkScale *s);
void gtk_scale_draw_value(GtkScale *s);
int GTK_IS_SCROLLBAR(GtkObject *o);
int GTK_IS_SCROLLED_WINDOW(GtkObject *o);
GtkWidget *gtk_scrolled_window_new(GtkAdjustment *h, GtkAdjustment *v);
GtkAdjustment *gtk_scrolled_window_get_hadjustment(GtkScrolledWindow *s);
GtkAdjustment *gtk_scrolled_window_get_vadjustment(GtkScrolledWindow *s);
void gtk_scrolled_window_set_policy(GtkScrolledWindow *s, int hp, int vp);
int GTK_IS_SEPARATOR(GtkObject *o);
int GTK_IS_TABLE(GtkObject *o);
GtkWidget *gtk_table_new(int rows, int cols, int homogeneous);
void gtk_table_attach(GtkTable *t, GtkWidget *child, int la, int ra, int ta,
                                     int ba, int xo, int yo, int xp, int yp);
void gtk_table_attach_defaults(GtkTable *t, GtkWidget *child, int la, int ra,
                                                              int ta, int ba);
void gtk_table_set_row_spacing(GtkTable *t, int row, int spacing);
void gtk_table_set_col_spacing(GtkTable *t, int col, int spacing);
void gtk_table_set_row_spacings(GtkTable *t, int spacing);
void gtk_table_set_col_spacings(GtkTable *t, int spacing);
int GTK_IS_TEXT(GtkObject *o);
GtkWidget *gtk_text_new(GtkAdjustment *ha, GtkAdjustment *va);
void gtk_text_set_editable(GtkText *t, int editable);
void gtk_text_set_adjustments(GtkText *t, GtkAdjustment *ha,GtkAdjustment *va);
void gtk_text_set_point(GtkText *t, unsigned int index);
unsigned int gtk_text_get_point(GtkText *t);
unsigned int gtk_text_get_length(GtkText *t);
void gtk_text_freeze(GtkText *t);
void gtk_text_thaw(GtkText *t);
// void gtk_text_insert(GtkText *t, GdkFont *f, GdkColor *fore, GdkColor *back, char *chars, int length);
int gtk_text_backward_delete(GtkText *t, unsigned int nchars);
int gtk_text_foreward_delete(GtkText *t, unsigned int nchars);
int GTK_IS_TOGGLE_BUTTON(GtkObject *o);
GtkWidget *gtk_toggle_button_new();
GtkWidget *gtk_toggle_button_new_with_label(char *label);
void gtk_toggle_button_set_mode(GtkToggleButton *t, int draw_i);
void gtk_toggle_button_set_state(GtkToggleButton *t, int s);
void gtk_toggle_button_toggled(GtkToggleButton *t);
int GTK_IS_TREE(GtkObject *o);
GtkWidget *gtk_tree_new();
void gtk_tree_append(GtkTree *t, GtkWidget *child);
void gtk_tree_prepend(GtkTree *t, GtkWidget *child);
void gtk_tree_insert(GtkTree *t, GtkWidget *child, int pos);
int GTK_IS_TREE_ITEM(GtkObject *o);
GtkWidget *gtk_tree_item_new();
GtkWidget *gtk_tree_item_new_with_label(char *label);
void gtk_tree_item_set_subtree(GtkTreeItem *t, GtkWidget *st);
void gtk_tree_item_select(GtkTreeItem *t);
void gtk_tree_item_deselect(GtkTreeItem *t);
void gtk_tree_item_expand(GtkTreeItem *t);
void gtk_tree_item_collapse(GtkTreeItem *t);
int GTK_IS_VBOX(GtkObject *o);
GtkWidget *gtk_vbox_new(int homogeneous, int spacing);
int GTK_IS_VBUTTON_BOX(GtkObject *o);
GtkWidget *gtk_vbutton_box_new();
int gtk_vbutton_box_get_spacing_default();
void gtk_vbutton_box_set_spacing_default(int s);
%{
gint gtk_vbutton_box_get_layout_default();
%}
int gtk_vbutton_box_get_layout_default();
void gtk_vbutton_box_set_layout_default(int l);
int GTK_IS_VIEWPORT(GtkObject *o);
GtkWidget *gtk_viewport_new(GtkAdjustment *ha, GtkAdjustment *va);
GtkAdjustment *gtk_viewport_get_hadjustment(GtkViewport *v);
GtkAdjustment *gtk_viewport_get_vadjustment(GtkViewport *v);
void gtk_viewport_set_hadjustment(GtkViewport *v, GtkAdjustment *ha);
void gtk_viewport_set_vadjustment(GtkViewport *v, GtkAdjustment *va);
void gtk_viewport_set_shadow_type(GtkViewport *v, int st);
int GTK_IS_VPANED(GtkObject *o);
GtkWidget *gtk_vpaned_new();
int GTK_IS_VRULER(GtkObject *o);
GtkWidget *gtk_vruler_new();
int GTK_IS_VSCALE(GtkObject *o);
GtkWidget *gtk_vscale_new(GtkAdjustment *a);
int GTK_IS_VSCROLLBAR(GtkObject *o);
GtkWidget *gtk_vscrollbar_new(GtkAdjustment *a);
int GTK_IS_VSEPARATOR(GtkObject *o);
GtkWidget *gtk_vseparator_new();
int GTK_IS_WINDOW(GtkObject *o);
GtkWidget *gtk_window_new(int wt);
void gtk_window_set_title(GtkWindow *w, char *title);
void gtk_window_set_focus(GtkWindow *w, GtkWidget *focus);
void gtk_window_set_default(GtkWindow *w, GtkWidget *default);
void gtk_window_set_policy(GtkWindow *w, int ashrink, int agrow, int auto_s);
void gtk_window_add_accelerator_table(GtkWindow *w, GtkAcceleratorTable *t);
void gtk_window_remove_accelerator_table(GtkWindow *w, GtkAcceleratorTable *t);
void gtk_window_position(GtkWindow *w, int pos);

// GtkAcceleratorTable Functions
GtkAcceleratorTable *gtk_accelerator_table_new();
GtkAcceleratorTable *gtk_accelerator_table_find(GtkObject *o, char *sig_name,
    unsigned char acc_key, int acc_mods);
void gtk_accelerator_table_install(GtkAcceleratorTable *t, GtkObject *o,
    char *sig_name, unsigned char acc_key, int acc_mods);
void gtk_accelerator_table_remove(GtkAcceleratorTable *t, GtkObject *o,
    char *signame);
int gtk_accelerator_table_check(GtkAcceleratorTable *t, unsigned char acc_key,
    int acc_mods);
void gtk_accelerator_table_set_mod_mask(GtkAcceleratorTable *t, int mod_mask);

// GtkTooltips Functions
GtkTooltips *gtk_tooltips_new();
void gtk_tooltips_enable(GtkTooltips *t);
void gtk_tooltips_set_delay(GtkTooltips *t, int delay);
void gtk_tooltips_set_tips(GtkTooltips *t, GtkWidget *w, char *tip);
// void gtk_tooltips_set_colors(GtkTooltips *t, GdkColor *b, GdkColor *f);

