/*
 * THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT. 
 */
#include <stdlib.h>
#include "hostproc.h"
#include "hostproc_mib.h"


static int
handle_hostprocUpTime(netsnmp_mib_handler *handler,
                      netsnmp_handler_registration *reginfo,
                      netsnmp_agent_request_info *reqinfo,
                      netsnmp_request_info *requests)
{
    uint32_t        val = agent_hostprocUpTime();

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_TIMETICKS,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostprocUpTime\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_processGroupModify(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *reqinfo,
                          netsnmp_request_info *requests)
{
    int             ret;
    char const     *val = "";

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_OCTET_STR,
                                     val, strlen(val));
        }
        break;

        /*
         * SET REQUEST
         *
         * multiple states in the transaction.  See:
         * http://www.net-snmp.org/tutorial-5/toolkit/mib_module/set-actions.jpg
         */
    case MODE_SET_RESERVE1:
        /*
         * or you could use netsnmp_check_vb_type_and_size instead 
         */
        ret = netsnmp_check_vb_type(requests->requestvb, ASN_OCTET_STR);
        if (ret != SNMP_ERR_NOERROR)
            netsnmp_set_request_error(reqinfo, requests, ret);
        break;

    case MODE_SET_RESERVE2:
        break;

    case MODE_SET_FREE:
        break;

    case MODE_SET_ACTION:
        ret = hostproc_group_mgmt_set(reginfo, reqinfo, requests);
        if (ret != SNMP_ERR_NOERROR)
            netsnmp_set_request_error(reqinfo, requests, ret);
        break;

    case MODE_SET_COMMIT:
        break;

    case MODE_SET_UNDO:
        break;

    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_processGroupModify\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_hostMemTotal(netsnmp_mib_handler *handler,
                    netsnmp_handler_registration *reginfo,
                    netsnmp_agent_request_info *reqinfo,
                    netsnmp_request_info *requests)
{
    uint32_t        val = meminfo_get(MEMINFO_MEM_TOTAL);

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostMemTotal\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_hostMemAvailable(netsnmp_mib_handler *handler,
                        netsnmp_handler_registration *reginfo,
                        netsnmp_agent_request_info *reqinfo,
                        netsnmp_request_info *requests)
{
    uint32_t        val = meminfo_get(MEMINFO_MEM_AVAILABLE);

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostMemAvailable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_hostMemFree(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
    uint32_t        val = meminfo_get(MEMINFO_MEM_FREE);

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostMemFree\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_hostSwapTotal(netsnmp_mib_handler *handler,
                     netsnmp_handler_registration *reginfo,
                     netsnmp_agent_request_info *reqinfo,
                     netsnmp_request_info *requests)
{
    uint32_t        val = meminfo_get(MEMINFO_SWAP_TOTAL);

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostSwapTotal\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}

static int
handle_hostSwapFree(netsnmp_mib_handler *handler,
                    netsnmp_handler_registration *reginfo,
                    netsnmp_agent_request_info *reqinfo,
                    netsnmp_request_info *requests)
{
    uint32_t        val = meminfo_get(MEMINFO_SWAP_FREE);

    switch (reqinfo->mode) {
    case MODE_GET:
        {
            snmp_set_var_typed_value(requests->requestvb, ASN_GAUGE,
                                     &val, sizeof(val));
        }
        break;


    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR, "unknown mode (%d) in handle_hostSwapFree\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;
    }

    return SNMP_ERR_NOERROR;
}



void
processTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *row;

    while ((row = netsnmp_tdata_row_first(table))) {
        processTable_entry_free(row->data);
        SNMP_FREE(row->data);
        netsnmp_tdata_remove_and_delete_row(table, row);
    }
}

/** handles requests for the processTable table */
static int
handle_table_processTable(netsnmp_mib_handler *handler,
                          netsnmp_handler_registration *reginfo,
                          netsnmp_agent_request_info *reqinfo,
                          netsnmp_request_info *requests)
{
    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct processTable_entry *table_entry;

    switch (reqinfo->mode) {
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct processTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);
            if (!table_info) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                return SNMP_ERR_NOERROR;
            }

            switch (table_info->colnum) {
            case COLUMN_PROCESSPID:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processPID);
                break;
            case COLUMN_PROCESSPPID:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processPPID);
                break;
            case COLUMN_PROCESSUID:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processUID);
                break;
            case COLUMN_PROCESSGID:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processGID);
                break;
            case COLUMN_PROCESSCPUAVG:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processCPUAvg);
                break;
            case COLUMN_PROCESSCPUINST:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processCPUInst);
                break;
            case COLUMN_PROCESSTIME:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb,
                                           ASN_TIMETICKS,
                                           table_entry->processTime);
                break;
            case COLUMN_PROCESSSTATE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processState,
                                         table_entry->processState_len);
                break;
            case COLUMN_PROCESSNICE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processNice);
                break;
            case COLUMN_PROCESSPRIORITY:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processPriority);
                break;
            case COLUMN_PROCESSVSZ:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processVSZ);
                break;
            case COLUMN_PROCESSRSS:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processRSS);
                break;
            case COLUMN_PROCESSCOMM:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processComm,
                                         table_entry->processComm_len);
                break;
            case COLUMN_PROCESSCMDLINE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processCmdline,
                                         table_entry->processCmdline_len);
                break;
            case COLUMN_PROCESSEXE:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processExe,
                                         table_entry->processExe_len);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;
    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_table_processTable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the processTable table by defining its contents and how it's structured */
static void
initialize_table_processTable(void)
{
    const oid       processTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 2 };
    const size_t    processTable_oid_len = OID_LENGTH(processTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;

    DEBUGMSGTL(("hostproc_mib", "initializing table processTable\n"));

    reg =
        netsnmp_create_handler_registration("processTable",
                                            handle_table_processTable,
                                            processTable_oid,
                                            processTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("processTable", 0);
    if (!table_data) {
        snmp_log(LOG_ERR, "error creating tdata table for processTable\n");
        return;
    }
    cache = netsnmp_cache_create(-1,
                                 processTable_load, processTable_free,
                                 processTable_oid, processTable_oid_len);
    if (!cache) {
        snmp_log(LOG_ERR, "error creating cache for processTable\n");
        abort();
    }
    cache->flags |=
        (NETSNMP_CACHE_DONT_AUTO_RELEASE | NETSNMP_CACHE_DONT_FREE_EXPIRED
         | NETSNMP_CACHE_DONT_FREE_BEFORE_LOAD |
         NETSNMP_CACHE_AUTO_RELOAD);

    cache->magic = (void *) table_data;
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    if (!table_info) {
        snmp_log(LOG_ERR, "error creating table info for processTable\n");
        return;
    }
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: processIndex */
                                     0);

    table_info->min_column = COLUMN_PROCESSPID;
    table_info->max_column = COLUMN_PROCESSEXE;

    netsnmp_tdata_register(reg, table_data, table_info);
    if (cache)
        netsnmp_inject_handler(reg, netsnmp_cache_handler_get(cache));
    /*
     * netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
     * TABLE_TDATA_NAME);
     */
}



void
processGroupTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *row;

    while ((row = netsnmp_tdata_row_first(table))) {
        processGroupTable_entry_free(row->data);
        SNMP_FREE(row->data);
        netsnmp_tdata_remove_and_delete_row(table, row);
    }
}

/** handles requests for the processGroupTable table */
static int
handle_table_processGroupTable(netsnmp_mib_handler *handler,
                               netsnmp_handler_registration *reginfo,
                               netsnmp_agent_request_info *reqinfo,
                               netsnmp_request_info *requests)
{
    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct processGroupTable_entry *table_entry;

    switch (reqinfo->mode) {
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct processGroupTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);
            if (!table_info) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                return SNMP_ERR_NOERROR;
            }

            switch (table_info->colnum) {
            case COLUMN_PROCESSGROUPNAME:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processGroupName,
                                         table_entry->
                                         processGroupName_len);
                break;
            case COLUMN_PROCESSGROUPPATTERN:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processGroupPattern,
                                         table_entry->
                                         processGroupPattern_len);
                break;
            case COLUMN_PROCESSGROUPFIELD:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processGroupField);
                break;
            case COLUMN_PROCESSGROUPMATCH:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processGroupMatch);
                break;
            case COLUMN_PROCESSGROUPOK:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processGroupOK);
                break;
            case COLUMN_PROCESSGROUPMINCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processGroupMinCount);
                break;
            case COLUMN_PROCESSGROUPMAXCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processGroupMaxCount);
                break;
            case COLUMN_PROCESSGROUPMAXVSZ:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupMaxVSZ);
                break;
            case COLUMN_PROCESSGROUPMAXRSS:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupMaxRSS);
                break;
            case COLUMN_PROCESSGROUPMAXCPU:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupMaxCPU);
                break;
            case COLUMN_PROCESSGROUPCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processGroupCount);
                break;
            case COLUMN_PROCESSGROUPCPUMAX:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupCPUMax);
                break;
            case COLUMN_PROCESSGROUPCPUAVG:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupCPUAvg);
                break;
            case COLUMN_PROCESSGROUPCPUINST:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processGroupCPUInst);
                break;
            case COLUMN_PROCESSGROUPVSZ:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processGroupVSZ);
                break;
            case COLUMN_PROCESSGROUPRSS:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->processGroupRSS);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;
    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_table_processGroupTable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the processGroupTable table by defining its contents and how it's structured */
static void
initialize_table_processGroupTable(void)
{
    const oid       processGroupTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 3 };
    const size_t    processGroupTable_oid_len =
        OID_LENGTH(processGroupTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;

    DEBUGMSGTL(("hostproc_mib", "initializing table processGroupTable\n"));

    reg =
        netsnmp_create_handler_registration("processGroupTable",
                                            handle_table_processGroupTable,
                                            processGroupTable_oid,
                                            processGroupTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("processGroupTable", 0);
    if (!table_data) {
        snmp_log(LOG_ERR,
                 "error creating tdata table for processGroupTable\n");
        return;
    }
    cache = netsnmp_cache_create(-1,
                                 processGroupTable_load,
                                 processGroupTable_free,
                                 processGroupTable_oid,
                                 processGroupTable_oid_len);
    if (!cache) {
        snmp_log(LOG_ERR, "error creating cache for processGroupTable\n");
        abort();
    }
    cache->flags |=
        (NETSNMP_CACHE_DONT_AUTO_RELEASE | NETSNMP_CACHE_DONT_FREE_EXPIRED
         | NETSNMP_CACHE_DONT_FREE_BEFORE_LOAD |
         NETSNMP_CACHE_AUTO_RELOAD);

    cache->magic = (void *) table_data;
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    if (!table_info) {
        snmp_log(LOG_ERR,
                 "error creating table info for processGroupTable\n");
        return;
    }
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: processGroupIndex */
                                     0);

    table_info->min_column = COLUMN_PROCESSGROUPNAME;
    table_info->max_column = COLUMN_PROCESSGROUPRSS;

    netsnmp_tdata_register(reg, table_data, table_info);
    if (cache)
        netsnmp_inject_handler(reg, netsnmp_cache_handler_get(cache));
    /*
     * netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
     * TABLE_TDATA_NAME);
     */
}



void
processExcludedTable_free(netsnmp_cache * cache, void *vmagic)
{
    netsnmp_tdata  *table = (netsnmp_tdata *) vmagic;
    netsnmp_tdata_row *row;

    while ((row = netsnmp_tdata_row_first(table))) {
        processExcludedTable_entry_free(row->data);
        SNMP_FREE(row->data);
        netsnmp_tdata_remove_and_delete_row(table, row);
    }
}

/** handles requests for the processExcludedTable table */
static int
handle_table_processExcludedTable(netsnmp_mib_handler *handler,
                                  netsnmp_handler_registration *reginfo,
                                  netsnmp_agent_request_info *reqinfo,
                                  netsnmp_request_info *requests)
{
    netsnmp_request_info *request;
    netsnmp_table_request_info *table_info;
    struct processExcludedTable_entry *table_entry;

    switch (reqinfo->mode) {
    case MODE_GET:
        for (request = requests; request; request = request->next) {
            table_entry = (struct processExcludedTable_entry *)
                netsnmp_tdata_extract_entry(request);
            table_info = netsnmp_extract_table_info(request);
            if (!table_info) {
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                return SNMP_ERR_NOERROR;
            }

            switch (table_info->colnum) {
            case COLUMN_PROCESSEXCLUDEDNAME:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->processExcludedName,
                                         table_entry->
                                         processExcludedName_len);
                break;
            case COLUMN_PROCESSEXCLUDEDPATTERN:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_value(request->requestvb, ASN_OCTET_STR,
                                         table_entry->
                                         processExcludedPattern,
                                         table_entry->
                                         processExcludedPattern_len);
                break;
            case COLUMN_PROCESSEXCLUDEDFIELD:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processExcludedField);
                break;
            case COLUMN_PROCESSEXCLUDEDMATCH:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processExcludedMatch);
                break;
            case COLUMN_PROCESSEXCLUDEDOK:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->processExcludedOK);
                break;
            case COLUMN_PROCESSEXCLUDEDMINCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processExcludedMinCount);
                break;
            case COLUMN_PROCESSEXCLUDEDMAXCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processExcludedMaxCount);
                break;
            case COLUMN_PROCESSEXCLUDEDMAXVSZ:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedMaxVSZ);
                break;
            case COLUMN_PROCESSEXCLUDEDMAXRSS:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedMaxRSS);
                break;
            case COLUMN_PROCESSEXCLUDEDMAXCPU:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedMaxCPU);
                break;
            case COLUMN_PROCESSEXCLUDEDCOUNT:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_INTEGER,
                                           table_entry->
                                           processExcludedCount);
                break;
            case COLUMN_PROCESSEXCLUDEDCPUMAX:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedCPUMax);
                break;
            case COLUMN_PROCESSEXCLUDEDCPUAVG:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedCPUAvg);
                break;
            case COLUMN_PROCESSEXCLUDEDCPUINST:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedCPUInst);
                break;
            case COLUMN_PROCESSEXCLUDEDVSZ:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedVSZ);
                break;
            case COLUMN_PROCESSEXCLUDEDRSS:
                if (!table_entry) {
                    netsnmp_set_request_error(reqinfo, request,
                                              SNMP_NOSUCHINSTANCE);
                    continue;
                }
                snmp_set_var_typed_integer(request->requestvb, ASN_GAUGE,
                                           table_entry->
                                           processExcludedRSS);
                break;
            default:
                netsnmp_set_request_error(reqinfo, request,
                                          SNMP_NOSUCHOBJECT);
                break;
            }
        }
        break;
    default:
        /*
         * we should never get here, so this is a really bad error 
         */
        snmp_log(LOG_ERR,
                 "unknown mode (%d) in handle_table_processExcludedTable\n",
                 reqinfo->mode);
        return SNMP_ERR_GENERR;

    }
    return SNMP_ERR_NOERROR;
}

/** Initialize the processExcludedTable table by defining its contents and how it's structured */
static void
initialize_table_processExcludedTable(void)
{
    const oid       processExcludedTable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 4 };
    const size_t    processExcludedTable_oid_len =
        OID_LENGTH(processExcludedTable_oid);
    netsnmp_handler_registration *reg;
    netsnmp_tdata  *table_data;
    netsnmp_table_registration_info *table_info;
    netsnmp_cache  *cache;

    DEBUGMSGTL(("hostproc_mib",
                "initializing table processExcludedTable\n"));

    reg =
        netsnmp_create_handler_registration("processExcludedTable",
                                            handle_table_processExcludedTable,
                                            processExcludedTable_oid,
                                            processExcludedTable_oid_len,
                                            HANDLER_CAN_RONLY);

    table_data = netsnmp_tdata_create_table("processExcludedTable", 0);
    if (!table_data) {
        snmp_log(LOG_ERR,
                 "error creating tdata table for processExcludedTable\n");
        return;
    }
    cache = netsnmp_cache_create(-1,
                                 processExcludedTable_load,
                                 processExcludedTable_free,
                                 processExcludedTable_oid,
                                 processExcludedTable_oid_len);
    if (!cache) {
        snmp_log(LOG_ERR,
                 "error creating cache for processExcludedTable\n");
        abort();
    }
    cache->flags |=
        (NETSNMP_CACHE_DONT_AUTO_RELEASE | NETSNMP_CACHE_DONT_FREE_EXPIRED
         | NETSNMP_CACHE_DONT_FREE_BEFORE_LOAD |
         NETSNMP_CACHE_AUTO_RELOAD);

    cache->magic = (void *) table_data;
    table_info = SNMP_MALLOC_TYPEDEF(netsnmp_table_registration_info);
    if (!table_info) {
        snmp_log(LOG_ERR,
                 "error creating table info for processExcludedTable\n");
        return;
    }
    netsnmp_table_helper_add_indexes(table_info, ASN_INTEGER,   /* index: processExcludedIndex */
                                     0);

    table_info->min_column = COLUMN_PROCESSEXCLUDEDNAME;
    table_info->max_column = COLUMN_PROCESSEXCLUDEDRSS;

    netsnmp_tdata_register(reg, table_data, table_info);
    if (cache)
        netsnmp_inject_handler(reg, netsnmp_cache_handler_get(cache));
    /*
     * netsnmp_inject_handler_before(reg, netsnmp_cache_handler_get(cache),
     * TABLE_TDATA_NAME);
     */
}


/** Initializes the hostproc_mib.c module */
void
hostproc_mib_init(void)
{

    const oid       hostprocUpTime_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 1, 1 };


    const oid       processGroupModify_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 1, 2 };


    const oid       hostMemTotal_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 5, 1 };


    const oid       hostMemAvailable_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 5, 2 };


    const oid       hostMemFree_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 5, 3 };


    const oid       hostSwapTotal_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 5, 4 };


    const oid       hostSwapFree_oid[] =
        { 1, 3, 6, 1, 4, 1, 9163, 104, 5, 5 };


    DEBUGMSGTL(("hostproc_mib", "Initializing\n"));

    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostprocUpTime", handle_hostprocUpTime,
                             hostprocUpTime_oid,
                             OID_LENGTH(hostprocUpTime_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("processGroupModify",
                             handle_processGroupModify,
                             processGroupModify_oid,
                             OID_LENGTH(processGroupModify_oid),
                             HANDLER_CAN_RWRITE));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostMemTotal", handle_hostMemTotal,
                             hostMemTotal_oid,
                             OID_LENGTH(hostMemTotal_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostMemAvailable", handle_hostMemAvailable,
                             hostMemAvailable_oid,
                             OID_LENGTH(hostMemAvailable_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostMemFree", handle_hostMemFree,
                             hostMemFree_oid, OID_LENGTH(hostMemFree_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostSwapTotal", handle_hostSwapTotal,
                             hostSwapTotal_oid,
                             OID_LENGTH(hostSwapTotal_oid),
                             HANDLER_CAN_RONLY));
    netsnmp_register_scalar(netsnmp_create_handler_registration
                            ("hostSwapFree", handle_hostSwapFree,
                             hostSwapFree_oid,
                             OID_LENGTH(hostSwapFree_oid),
                             HANDLER_CAN_RONLY));

    initialize_table_processTable();
    initialize_table_processGroupTable();
    initialize_table_processExcludedTable();
}

/*
 * Local variables:
 * buffer-read-only: t
 * End:
 * vi: set ro:
 */
