/* peggy -- a JPEG viewer for GGI
 *   Version 0.51
 *
 * Copyright 1997, 1998 Andreas Vogler
 * Completely re-written by Nathan Strong (gblues@gstis.net)
 *
 * This code is under GPL. Read LICENSE for more information
 * Some modifications (c) 1999 Andreas Beck [becka@ggi-project.org]
 */

#include "peggy.h"

/* The OPTIONS structure contains all settings that can be modified from
the command-line. (It also has some internal toggles that get set
automatically) It gets filled in by CheckCommandLine() in cmdline.c

Here we initialize it with program defaults:
	-640x480 resolution
	-0 second timeout (0 = wait for keypress)
	-no randomization (not re-implemented yet)
	-do not display version information
	-do not display help information
	-do not dither the image (this is set automatically if in 8bpp mode)
*/

struct OPTIONS Options = {GGI_AUTO, GGI_AUTO, 0, 0, 0, 0, 0};

ggi_visual_t *vis;
ggi_mode mode;

extern void CheckCommandLine(int *argc, char **argv);
extern int DoJpeg(char *filename);

void InitGraphics(void);
void PrintVersion(void);
void PrintHelp(void);
int GetOptimumX(int x);
int GetComplement(int y);

int main(int argc, char **argv)
{
	int i;

	srand(time(NULL));

	CheckCommandLine(&argc, argv);

	if (Options.version)
		PrintVersion();
	else if (Options.help)
		PrintHelp();

	if (Options.rnd) 
		for(i=argc-1;i>=0;i--) {
			char *hlp=argv[i];
			int x;
			x=rand()%(i+1);
			argv[i]=argv[x];
			argv[x]=hlp;
		}

	InitGraphics();

	for (i=0; i<argc; i++) {
		if (DoJpeg(strdup(argv[i])))
			i=argc;
		ggiFlush(vis);
	}

	ggiClose(vis);
	ggiExit();
	exit(0);

}

/* PrintVersion() -- displays version information, then exits */
void PrintVersion(void) {

	printf("Peggy -- a simple JPEG viewer for GGI\n");
	printf("Version 0.52\n");
	exit(0);

}

/* PrintHelp() -- displays help information, then exits */
void PrintHelp(void) {

	printf("Peggy -- a simple JPEG viewer for GGI\n");
	printf("USAGE:\npeggy [options] filename1 [filename2 ...]\n");
	printf("Options:\n");
	printf("\t--random: show files in a random order\t[default: disabled]\n");
	printf("\t--time=N: set time delay to N seconds\t[default: 0]\n");
	printf("\t--geometry=MxN: force MxN resolution\t[default: 320x200]\n");
	printf("\t--version: displays version information\n");
	printf("\t--help: this screen\n");
	exit(0);

}

/* InitGraphics() -- Sets the visual to the requested (or autodetected)
 * resolution. If the display is palettized, dithering is automatically 
 * enabled. 
 */
void InitGraphics(void) {

	int x = Options.xsize;
	int y = Options.ysize;

	ggiInit();

	vis = ggiOpen(NULL);
	ggiSetFlags(vis,GGIFLAG_ASYNC);

	if ( ggiCheckGraphMode(vis, x, y, x, y, GT_AUTO, &mode) ) {
		ggiClose(vis);
		ggiExit();
		printf("Could not open visual at %dx%d.\n", x, y);
		exit(1);
	} else {
		fprintf(stderr,"Suggested mode ");
		ggiFPrintMode(stderr,&mode);
		fprintf(stderr,"\n");
		ggiSetMode(vis,&mode);   /* now try it. it *should* work! */

	        if (GT_SCHEME(mode.graphtype) == GT_PALETTE) {
			Options.dither = 1;
		}
		Options.xsize=mode.visible.x;
		Options.ysize=mode.visible.y;
	}
}
