/* Portions of this code based on peggy 0.3 by Andreas Vogler.
 * this code is under the GPL -- see COPYING for details.
 * jpeg.c -- this is the part that decodes and displays the JPEG
 * onto the screen. This code is still a little messy, but not too
 * bad.
 * Some modifications (c) 1999 Andreas Beck [becka@ggi-project.org]
 */

#include "peggy.h"

extern ggi_visual_t *vis;
extern struct OPTIONS Options;

struct jpeg_decompress_struct image;
struct jpeg_error_mgr jerr;
static FILE *infile;

int DoJpeg(char *filename);
void OpenFile(char *filename);
void InitScreen(char *text);

/* DoJpeg -- opens the file (specified by *filename) and attempts to
 * decode it and display it on the screen. Still pretty messy.
 */
int DoJpeg(char *filename) {

	ggi_color color = {0x0000, 0x0000, 0x0000};
	struct timeval tv;
	int i, startx, starty, rc;
	unsigned char *buff = NULL;

	OpenFile(filename);

	image.err = jpeg_std_error(&jerr);
	jpeg_create_decompress(&image);
	jpeg_stdio_src(&image, infile);
	jpeg_read_header(&image, TRUE);

#ifdef DEBUG
	printf("Width: %d\tHeight: %d\n", image.image_width, image.image_height);
	printf("num_components: %d colorspace: %d\n", image.num_components,
	image.jpeg_color_space);
#endif

	if (Options.dither) {
		image.quantize_colors = TRUE;
		image.dither_mode = JDITHER_FS;
		image.desired_number_of_colors = 255;
	}

	jpeg_calc_output_dimensions(&image);

	while ( (image.output_width > Options.xsize) ||
		(image.output_height > Options.ysize) ) {

		image.scale_denom++;
		jpeg_calc_output_dimensions(&image);
	}

	buff = (unsigned char *)malloc(image.output_width * image.output_components);

#ifdef DEBUG
	printf("output_components: %d\n", image.output_components);
#endif
	if (!buff) {
		jpeg_destroy_decompress(&image);
		ggiPanic("Could not allocate memory!\n");
		exit(1);
	}

	startx = (Options.xsize - image.output_width) / 2;
	starty = (Options.ysize - image.output_height) / 2;
	jpeg_start_decompress(&image);

	if (Options.dither) {
		ggi_color palette[image.actual_number_of_colors];
		for (i=0; i < image.actual_number_of_colors; i++) {
			palette[i].r = image.colormap[0][i] << 8;
			palette[i].g = image.colormap[1][i] << 8;
			palette[i].b = image.colormap[2][i] << 8;
		}
		ggiSetPalette(vis, 0, image.actual_number_of_colors, palette);
		InitScreen(filename);
		while (image.output_scanline < image.output_height) {
			jpeg_read_scanlines(&image, &buff, 1);
			for(i = 0; i < image.output_width; i++) {
				ggiSetGCForeground(vis, buff[i]);
				ggiDrawPixel(vis, startx+i,
					starty+image.output_scanline);
			}
		}
	} else {
		InitScreen(filename);
		while (image.output_scanline < image.output_height) {
		 	jpeg_read_scanlines(&image, &buff, 1);
			for (i = 0; i < image.output_width; i++) {
				color.r = buff[i*image.output_components] << 8;
				if (image.output_components ^ 1) {
					color.g = buff[(i*image.output_components)+1] << 8;
					color.b = buff[(i*image.output_components)+2] << 8;
				} else color.g = color.b = color.r;

				ggiSetGCForeground(vis, ggiMapColor(vis, &color));
				ggiDrawPixel(vis, startx+i, starty+image.output_scanline);
			}
		}
	}
	ggiFlush(vis);
	jpeg_finish_decompress(&image);
	jpeg_destroy_decompress(&image);

	tv.tv_sec =Options.timeout;
	tv.tv_usec=0;
	rc=0;
	if (Options.timeout==0 || ggiEventPoll(vis,emKeyPress,&tv))
	{
		ggi_event ev;
		ggiEventRead(vis,&ev,emKeyPress);
		if (ev.key.sym==GIIUC_Escape ||
		    ev.key.sym=='q' )
			rc=1;
	}
	fclose(infile);
	free(buff);
	return rc;
}

/* OpenFile() -- actually does the opening of the file, and kills the
 * program if it can't open the file. */
void OpenFile(char *filename) {
	infile = fopen(filename, "rb");
	if (!infile) {
		ggiPanic("Error opening file: %s\n", filename);
		exit(1);
	}
}

/* InitScreen() -- clears the screen, and writes the text specified in
 * *text in the upper-left hand corner of the screen. This was mainly
 * done so that you can easily tell that yes, it is running in the
 * resolution you specified :-)
 */
void InitScreen(char *text) {
	ggi_color color = {0x0000, 0x0000, 0x0000};
	ggiSetGCForeground(vis, ggiMapColor(vis, &color));
	//ggiFillscreen(vis);
	color.r = 0xFFFF; color.g = 0xFFFF; color.b = 0xFFFF;
	ggiSetGCForeground(vis, ggiMapColor(vis, &color));
	ggiPuts(vis, 0, 0, text);
}
