/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
int view_file(char *filename);

/* Private */
static int on_screen(char *bitmap, GBM *gbm, GBMRGB gbmrgb[]);
static int display(char *work_bitmap, int top, int left, int bitmap_width, int lines);


int view_file(char *filename)
{
	int key;
	int quit=0;

	int fd;
	int ft;
	int rc;
	int cb;

	unsigned char *bitmap=NULL;
	unsigned char *new_bitmap=NULL;

	GBM     gbm;
	GBMRGB  gbmrgb[256];

	gbm_init();

	if( (rc=gbm_guess_filetype(filename, &ft)) == GBM_ERR_OK)
		{
		if( (fd = gbm_io_open(filename, O_RDONLY)) == -1 )
			{
			fprintf(stderr,"Can't open file %s\n",filename);
			gbm_deinit();
			return 1;
			}

		if( (rc = gbm_read_header(filename, fd, ft, &gbm, "\0")) != GBM_ERR_OK )
			{
			fprintf(stderr,"Can't read header of %s: %s", filename, gbm_err(rc));
			gbm_io_close(fd);
			gbm_deinit();
			return 1;
			}

		if( (rc = gbm_read_palette(fd, ft, &gbm, gbmrgb)) != GBM_ERR_OK )
			{
			fprintf(stderr,"Can't read palette of %s: %s", filename, gbm_err(rc));
			gbm_io_close(fd);
			gbm_deinit();
			return 1;
			}

		cb=gbm.h * ( ( ( gbm.w * gbm.bpp + 31 ) /32 ) * 4 );
		if(NULL == (bitmap=calloc(1,cb)) )
			{
			fprintf(stderr,"Failed to calloc %d\n",cb);
			gbm_io_close(fd);
			gbm_deinit();
			return 1;
			}

		if( (rc = gbm_read_data(fd, ft, &gbm, bitmap)) != GBM_ERR_OK )
			{
			fprintf(stderr,"Can't read bitmap data of %s: %s", filename, gbm_err(rc));
			if(NULL != bitmap) free(bitmap); bitmap=NULL;
			gbm_io_close(fd);
			gbm_deinit();
			return 1;
			}

		gbm_io_close(fd);
		}
	else /* Possibly a JPEG */
		{
		rc=get_imagetype(filename);
		switch(rc)
			{
			case GGV_JPEG:
				bitmap=read_jpeg_file(filename,&gbm,gbmrgb);
				break;
			default:
				fprintf(stderr,"Can't guess image format of %s\n",filename);
				gbm_deinit();
				return 1;
				break;
			}
		}

    /* Expand to 24bit first thing, then manipulate as needed */
	expand_to_24bit(&gbm,gbmrgb,&bitmap);

	/* If the image is bigger than view screen, resize */
	if( gbm.w > cfg.default_width || gbm.h > cfg.default_height)
		{
		new_bitmap=scale(bitmap,&gbm,cfg.default_width,cfg.default_height);
		if(NULL==new_bitmap)
			{
			fprintf(stderr,"Failed to scale image.\n");		
			if(NULL != bitmap) free(bitmap); bitmap=NULL;
			gbm_deinit();
			return 1;
			}
		if(NULL != bitmap) free(bitmap); bitmap=NULL;
		bitmap=new_bitmap;
		new_bitmap=NULL;
		}

	/* Convert to lesser bpp if needed */
	new_bitmap=transform(bitmap,&gbm,gbmrgb);

	if(NULL == new_bitmap)
		{
		fprintf(stderr,"Failed to transform image.\n");
		if(NULL != bitmap) free(bitmap); bitmap=NULL;
		gbm_deinit();
		return 1;
		}
	else
		{
		if(NULL != bitmap) free(bitmap); bitmap=NULL;
		}

	on_screen(new_bitmap,&gbm,gbmrgb);

	while(!quit)
		{
		key=ggiGetc(vis);
		switch(GII_KTYP(key))
			{
			case GII_KT_LATIN1:
				switch(GII_KVAL(key))
					{
					case 'f':
						if( gbm_ref_horz(&gbm, new_bitmap))
							on_screen(new_bitmap,&gbm,gbmrgb);
						quit=0;
						break;
					case 'm':
						if( gbm_ref_vert(&gbm, new_bitmap))
							on_screen(new_bitmap,&gbm,gbmrgb);
						quit=0;
						break;
					default:
						quit=1;
						break;
					}
				break;
			default:
				quit=1;
				break;
			}
		}
		
	if(NULL != new_bitmap) free(new_bitmap); new_bitmap=NULL;
	if(NULL != bitmap) free(bitmap); bitmap=NULL;

	gbm_deinit();

return 0;
}

#define MAGIC_6    0x0410

static int on_screen(char *bitmap, GBM *gbm, GBMRGB gbmrgb[])
{
	int bitmap_width;
	int colors;
	int local;
	ggi_color clr;

	unsigned char *work_bitmap;

	bitmap_width = get_bitmap_width(gbm);

	/*
	** calculate the "start-point" within the bitmap. this point is at the
	** end of the allocated space, because bitmaps are stored botton line
	** up.....
	*/

	work_bitmap  = bitmap + (gbm->h * bitmap_width);
	work_bitmap  = work_bitmap - ((0 + 1) * bitmap_width) + 0;

	/* display the bitmap..... */

	ggiFlush(vis);
    ggiSetGCBackground(vis,idx_black);
    ggiSetGCForeground(vis,idx_black);
    ggiFillscreen(vis);

	colors = ( (1 << gbm->bpp) & 0x1ff );
	for (local=0;local<colors;local++)
		{
		clr.r=(gbmrgb[local].r / 4) * MAGIC_6;
		clr.g=(gbmrgb[local].g / 4) * MAGIC_6;
		clr.b=(gbmrgb[local].b / 4) * MAGIC_6;
		ggiSetPalette(vis,local,1,&clr);
		}

	display(work_bitmap,((cfg.default_height - gbm->h)/2),((cfg.default_width - gbm->w)/2), bitmap_width, gbm->h);

	ggiFlush(vis);

return 0;
}

static int display(char *work_bitmap, int top, int left, int bitmap_width, int lines)
{
	int  local=0;

	for(local=1;local<lines;local++)
		{
		ggiPutHLine(vis, 0 + left, local + top, bitmap_width, work_bitmap);
		work_bitmap = work_bitmap - bitmap_width;
		}

return 0;
}
