/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

static struct imagetypes itypes[]= {
{0  ,"\x89PNG"  ,GGV_PNG  },
{6  ,"JFIF"     ,GGV_JPEG }
};

#define ITYPES (sizeof(itypes)/sizeof(itypes[0]))

/* Public */
int get_imagetype(char *filename);

/* Private */
static int check_header(struct imagetypes thistype, char *header);

int get_imagetype(char *filename)
{
	FILE *fp;
	int n, i, rc;
	char header[1024];

	memset(header, 0, sizeof (header));
	if( NULL == (fp=fopen(filename, "rb")) )
		return GGV_ERROR;
	n=fread(header, 1, 1023, fp);
	fclose(fp);
	if(n <= 0)
		return GGV_ERROR;
	for(i = 0; i < ITYPES; i++)
		{
		rc = check_header(itypes[i], header);
		if(GGV_UNKNOWN !=rc)
			return rc;
		}
return rc;
}

static int check_header(struct imagetypes thistype, char *header)
{
	char *p;
	char magic[25];
	int length;

	p=header;
	p=p+thistype.offset;
	sprintf(magic,"%s",thistype.magic);
	length=strlen(magic);

	if( strncmp(p,magic,length) )
		return GGV_UNKNOWN;

return thistype.type;
}
