/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
unsigned char *transform(unsigned char *bitmap, GBM *gbm, GBMRGB gbmrgb[]);

/* Private */
static unsigned char *do_24bpp_to_8bpp(unsigned char *bitmap, GBM *gbm, GBMRGB gbmrgb[]);
static unsigned char *do_24bpp_to_15bpp(unsigned char *bitmap, GBM *gbm);
static unsigned char *do_24bpp_to_16bpp(unsigned char *bitmap, GBM *gbm);

#define MAKE_15_BIT(RED,GREEN,BLUE) (((RED>>3)<<10)|((GREEN>>3)<<5)|(BLUE>>3))
#define MAKE_16_BIT(RED,GREEN,BLUE) (((RED>>3)<<11)|((GREEN>>2)<<5)|(BLUE>>3))


unsigned char *transform(unsigned char *bitmap, GBM *gbm, GBMRGB gbmrgb[])
{
	unsigned char *new_bitmap;

	new_bitmap = NULL;

	if(gbm->bpp == 24)
		{
		switch(cfg.default_bpp)
			{
			case GT_8BIT:
				new_bitmap = do_24bpp_to_8bpp(bitmap, gbm, gbmrgb);
				break;
			case GT_15BIT:
				new_bitmap = do_24bpp_to_15bpp(bitmap, gbm);
				break;
			case GT_16BIT:
				new_bitmap = do_24bpp_to_16bpp(bitmap, gbm);
				break;
			default:
				new_bitmap=bitmap;
			}
		}

return new_bitmap;
}

static unsigned char *do_24bpp_to_8bpp(unsigned char *bitmap, GBM *gbm, GBMRGB gbmrgb[])
{
	int  new_size;
   
	unsigned char *new_bitmap;

	/* first calculate the size of the new bitmap... */

	new_size = gbm->h * (((gbm->w * 8 + 31) / 32) * 4);

	/* allocate memory for the bitmap... */
    
	if ((new_bitmap = malloc((int) new_size)) == NULL)
		return NULL;
   
	/* initialize the bitmap */
    
	memset(new_bitmap, 0, new_size);
   
	/* and do the transform.... */
    
	gbm->bpp   = 8;

	gbm_hist(gbm, bitmap, gbmrgb, new_bitmap, 256, 255, 255, 255);
   
return new_bitmap;
}

static unsigned char *do_24bpp_to_16bpp(unsigned char *bitmap, GBM *gbm)
{
	int  new_size;
	int  old_width;
	int  new_width;
	int  lines;
	int  cols;
	GBM  temp_gbm;
   
	unsigned char  *new_bitmap;
	unsigned char  *old_work_bitmap;
	unsigned char  *new_work_bitmap;   
	unsigned short *temp_field;

	/* save the current GBM-Structure.... */

	temp_gbm.w    = gbm->w;
	temp_gbm.h    = gbm->h;
	temp_gbm.bpp  = gbm->bpp;

	/* first calculate the size of the new bitmap... */

	new_size = temp_gbm.h * (((temp_gbm.w * 24 + 31) / 32) * 4);

	/* allocate memory for the bitmap... */
    
	if ((new_bitmap = malloc((int) new_size)) == NULL)
		return NULL;
   
	/* initialize the bitmap */
    
	memset(new_bitmap, 0, new_size);
   
	/* and do the transform.... */

	old_width       = get_bitmap_width(gbm);
	new_width       = get_bitmap_width(&temp_gbm);
	old_work_bitmap = bitmap;
	new_work_bitmap = new_bitmap;
   
	for (lines = 0; lines < gbm->h; lines++)
		{
		temp_field = (unsigned short *) new_work_bitmap;
		for (cols = 0; cols < gbm->w * 3; cols = cols + 3)
			{
			*temp_field = MAKE_16_BIT(old_work_bitmap[cols + 2],
							old_work_bitmap[cols + 1],
							old_work_bitmap[cols]);
			temp_field++;
			}
		old_work_bitmap = old_work_bitmap + old_width;
		new_work_bitmap = new_bitmap + ((lines + 1) * new_width);
		}

return new_bitmap;
}

static unsigned char *do_24bpp_to_15bpp(unsigned char *bitmap, GBM *gbm)
{
	int  new_size;
	int  old_width;
	int  new_width;
	int  lines;
	int  cols;
	GBM  temp_gbm;
   
	unsigned char  *new_bitmap;
	unsigned char  *old_work_bitmap;
	unsigned char  *new_work_bitmap;   
	unsigned short *temp_field;

	/* save the current GBM-Structure.... */

	temp_gbm.w    = gbm->w;
	temp_gbm.h    = gbm->h;
	temp_gbm.bpp  = gbm->bpp;

	/* first calculate the size of the new bitmap... */

	new_size = temp_gbm.h * (((temp_gbm.w * 24 + 31) / 32) * 4);

	/* allocate memory for the bitmap... */
    
	if ((new_bitmap = malloc((int) new_size)) == NULL)
		return NULL;
   
	/* initialize the bitmap */
    
	memset(new_bitmap, 0, new_size);
   
	/* and do the transform.... */

	old_width       = get_bitmap_width(gbm);
	new_width       = get_bitmap_width(&temp_gbm);
	old_work_bitmap = bitmap;
	new_work_bitmap = new_bitmap;
   
	for (lines = 0; lines < gbm->h; lines++)
		{
		temp_field = (unsigned short *) new_work_bitmap;
		for (cols = 0; cols < gbm->w * 3; cols = cols + 3)
			{
			*temp_field = MAKE_15_BIT(old_work_bitmap[cols + 2],
								old_work_bitmap[cols + 1],
								old_work_bitmap[cols]);
			temp_field++;
			}
		old_work_bitmap = old_work_bitmap + old_width;
		new_work_bitmap = new_bitmap + ((lines + 1) * new_width);
		}

return new_bitmap;
}
