/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
int drawtext3d(int x,int y,int s,char *str,int isout,int lite,int dark,int txt);
int undrawtext3d(int x,int y,int s,char *str);
int draw3dbox(int x1,int y1,int x2,int y2,int depth,int isout,int lite,int dark);
int undraw3dbox(int x1,int y1,int x2,int y2,int depth);
int msgbox(int ttyfd,char *message,int replytype,int lite,int dark,int txt);

int drawtext3d(int x,int y,int s,char *str,int isout,int lite,int dark,int txt)
{
	ggiSetGCForeground(vis,isout?lite:dark);
	vgadrawtext(x-1,y-1,s,str);
	ggiSetGCForeground(vis,isout?dark:lite);
	vgadrawtext(x+1,y+1,s,str);
	ggiSetGCForeground(vis,txt);
	vgadrawtext(x,y,s,str);

return 0;
}

int undrawtext3d(int x,int y,int s,char *str)
{
	ggiSetGCForeground(vis,idx_medium);
	vgadrawtext(x-1,y-1,s,str);
	vgadrawtext(x+1,y+1,s,str);
	vgadrawtext(x,y,s,str);

return 0;
}

int draw3dbox(int x1,int y1,int x2,int y2,int depth,int isout,int lite,int dark)
{
	int f;

	for(f=0;f<depth;f++)
	{
	ggiSetGCForeground(vis,isout?lite:dark);
	ggiDrawLine(vis,x1+f,y2-f,x1+f,y1+f);
	ggiDrawLine(vis,x1+f,y1+f,x2-f,y1+f);
	ggiSetGCForeground(vis,isout?dark:lite);
	ggiDrawLine(vis,x2-f,y1+f,x2-f,y2-f);
	ggiDrawLine(vis,x2-f,y2-f,x1+f,y2-f);
	}

return 0;
}

int undraw3dbox(int x1,int y1,int x2,int y2,int depth)
{
	int f;

	ggiSetGCForeground(vis,idx_medium);

	for(f=0;f<depth;f++)
	{
	ggiDrawLine(vis,x1+f,y2-f,x1+f,y1+f);
	ggiDrawLine(vis,x1+f,y1+f,x2-f,y1+f);
	ggiDrawLine(vis,x2-f,y1+f,x2-f,y2-f);
	ggiDrawLine(vis,x2-f,y2-f,x1+f,y2-f);
	}

return 0;
}

/* this blasts whatever is 'under' it - you have to save or redraw it */
int msgbox(int ttyfd,char *message,int replytype,int lite,int dark,int txt)
{
	int f,x1,y1,x2,y2,wide,high,key;
	ggi_mode	mode;

	ggiGetMode(vis,&mode);

	high=90;
	wide=vgatextsize(3,message)+60;

	x1=((mode.visible.x-wide)>>1);
	y1=((mode.visible.y-high)>>1);
	x2=((mode.visible.x+wide)>>1);
	y2=((mode.visible.y+high)>>1);

	ggiSetGCForeground(vis,idx_medium);
	for(f=y1;f<y2;f++)
		ggiDrawLine(vis,x1,f,x2,f);

	/* draw outer box */
	draw3dbox(x1 ,y1  ,x2  ,y2  ,2,1, lite,dark);
	draw3dbox(x1+9,y1+9,x2-9,y2-9,1,0, lite,dark);

	/* a box with a single 'OK' button, for warnings, errors, etc. */
	/* draw 'button' */
	draw3dbox((mode.visible.x-40)>>1,y2-45,
		(mode.visible.x+40)>>1,y2-20, 1,1, lite,dark);

	ggiSetGCForeground(vis,txt);
	vgadrawtext(x1+30,y1+20,3,message);
	drawtext3d((mode.visible.x-15)>>1,y2-39,3,"OK",0,lite,dark,txt);
	do {
		usleep(10000);
		key=ggiGetc(vis);
	} while( (key &0xff) != 'y');

return 1;
}
