/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
unsigned char *scale(unsigned char *bitmap, GBM *gbm, int width, int height);

unsigned char *scale(unsigned char *bitmap, GBM *gbm, int width, int height)
{
	long new_bitmap_size;
	unsigned char *new_bitmap;
	int new_width;
	int new_height;

	/* calculate how to scale */

	new_width=width;
	new_height= (width*gbm->h)/gbm->w;
	if(new_height>height)
		{
		new_height=height;
		new_width= (height*gbm->w)/gbm->h;
		}

	/* calculate size of new bitmap... */
	new_bitmap_size = new_height * (((new_width * gbm->bpp + 31) / 32) * 4);

	/* request memory for new bitmap */

	if ((new_bitmap = malloc((int) new_bitmap_size)) == NULL)
		return NULL;

	/* initialize the bitmap */

	memset(new_bitmap, 0, new_bitmap_size);

	if (gbm_simple_scale(bitmap, gbm->w, gbm->h,
			new_bitmap, new_width, new_height, gbm->bpp) != GBM_ERR_OK)
		return NULL;

	gbm->w    = new_width;
	gbm->h    = new_height;

return new_bitmap;
}
