/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <setjmp.h>
#include <string.h>
#include <jpeglib.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
unsigned char *read_jpeg_file(char *filename,GBM *gbm,GBMRGB gbmrgb[]);

/* Private */
static void my_error_exit (j_common_ptr cinfo);
static void jpeg_warning(j_common_ptr cinfo);


struct my_error_mgr {
	struct jpeg_error_mgr pub;
	jmp_buf setjmp_buffer;
};
typedef struct my_error_mgr * my_error_ptr;

static void my_error_exit (j_common_ptr cinfo)
{
	my_error_ptr myerr = (my_error_ptr) cinfo->err;
	char buf[JMSG_LENGTH_MAX];
	(*cinfo->err->format_message)(cinfo,buf);
	fprintf(stderr,"%s\n",buf);
	longjmp(myerr->setjmp_buffer, 1);
}

/* We want no warning messages */
static void jpeg_warning(j_common_ptr cinfo)
{;}
              
unsigned char *read_jpeg_file(char *filename,GBM *gbm,GBMRGB gbmrgb[])
{
	struct jpeg_decompress_struct cinfo;
	struct my_error_mgr jerr;
	long   bitmap_size;
	int    bitmap_width;
	int    row_stride;    
	int    local;
	int    tmp;
	unsigned char *bitmap;
	unsigned char *work_bitmap;
	unsigned char *temp_ptr;
	FILE          *jpg_file;
	JSAMPARRAY    buffer;

	/* first we have to open the file for reading only. */

	if ((jpg_file = fopen(filename, "rb")) == NULL )
		return NULL;

	/* Step 1: allocate and initialize JPEG decompression object. */

	bitmap                  = NULL;
	bitmap_size             = 0L;
	cinfo.err               = jpeg_std_error(&jerr.pub);
	jerr.pub.error_exit     = my_error_exit;
	jerr.pub.output_message = jpeg_warning;

	/* Establish the setjmp return context for my_error_exit to use. */
   
	if (setjmp(jerr.setjmp_buffer))
		{
/*
		if (bitmap_size != 0)
			free(bitmap);
*/
		jpeg_destroy_decompress(&cinfo);
		fclose(jpg_file);
		return NULL;
		}

	/* Now we can initialize the JPEG decompression object. */
   
	jpeg_create_decompress(&cinfo);
                                    
	/* Step 2: specify data source (eg, a file) */
  
	jpeg_stdio_src(&cinfo, jpg_file);
  
	/* Step 3: read file parameters with jpeg_read_header() */
  
	(void) jpeg_read_header(&cinfo, TRUE);

	/* Step 4: set parameters for decompression */
  
	/* we don't need to change any of the defaults */

	/* check if we need a 8bit bitmap returned or a 24bit bitmap... */

	gbm->bpp = 24; /* Always try for a 24bit image */
    
	/* check if the current JPEG is a grayscale-image */

	if(cinfo.jpeg_color_space == JCS_GRAYSCALE)
		{
		cinfo.out_color_space          = JCS_GRAYSCALE;
		cinfo.desired_number_of_colors = 256;
		cinfo.quantize_colors          = FALSE;
		cinfo.two_pass_quantize        = FALSE;
		gbm->bpp                       = 8;
      
		for(local=0; local<256; local++)
			{
			gbmrgb[local].r = local;
			gbmrgb[local].g = local;
			gbmrgb[local].b = local;
			}
		}
                    
	/* Step 5: Start decompressor */
  
	jpeg_start_decompress(&cinfo);

	gbm->w   = cinfo.output_width;
	gbm->h   = cinfo.output_height;

	/* store the palette in GBMRGB..... */

	if(cinfo.jpeg_color_space != JCS_GRAYSCALE)   
		{
		for (local=0; local<cinfo.actual_number_of_colors; local++)
			{
			gbmrgb[local].r = cinfo.colormap[0][local];
			gbmrgb[local].g = cinfo.colormap[1][local];
			gbmrgb[local].b = cinfo.colormap[2][local];            
			}
		}
   
	/* JSAMPLEs per row in output buffer */
   
	row_stride = cinfo.output_width * cinfo.output_components;
   
	/* Make a one-row-high sample array that will go away when done with image */
      
	buffer = (*cinfo.mem->alloc_sarray)
            ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
                                          
    
	/* calculate size of bitmap and allocate memory and initialize */
    
	bitmap_size  = gbm->h * (((gbm->w * gbm->bpp + 31) / 32) * 4);

	if ((bitmap = malloc((int) bitmap_size)) == NULL)
		{
		jpeg_destroy_decompress(&cinfo);
		fclose(jpg_file);
		return NULL;
		}
                     
	memset(bitmap, 0, bitmap_size);

	/*
	** now we will do a loop until all scanlines of the JPEG-File 
	** are returned from JPGELIB....
	*/
    
	bitmap_width = get_bitmap_width(gbm);
	work_bitmap  = bitmap + bitmap_size - bitmap_width;

	while (cinfo.output_scanline < cinfo.output_height)
		{
		(void) jpeg_read_scanlines(&cinfo, &work_bitmap, 1);
		temp_ptr = work_bitmap;

		if (gbm->bpp == 24)
			{
			for(local=0; local<cinfo.output_width; local++)
				{
				tmp            = work_bitmap[0];
				work_bitmap[0] = work_bitmap[2];
				work_bitmap[2] = tmp;
				work_bitmap    = work_bitmap + 3;
				}
			}
		work_bitmap = temp_ptr - bitmap_width;
		}
      
	/* now we have finished.... */

	jpeg_finish_decompress(&cinfo);
	jpeg_destroy_decompress(&cinfo);

	fclose(jpg_file);
    
return bitmap;
}
