/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
int get_bitmap_width(GBM *gbm);
void rgb_to_bgr(const byte *p, byte *q, int n);
void bgr_to_rgb(const byte *p, byte *q, int n);
void expand_to_24bit(GBM *gbm, GBMRGB *gbmrgb, byte **data);

int get_bitmap_width(GBM *gbm)
{
	switch (gbm->bpp)
		{
		case 24: return((((gbm->w * 3) + 3) / 4) * 4);
			break;
		case 8:  return(((gbm->w + 3) / 4) * 4);
			break;
		case 4:  return((((gbm->w / 2) + 3) / 4) * 4);
			break;
		case 1:  return(((((gbm->w + 7) / 8) + 3) / 4) * 4);
			break;
		}

return 0;
}

void rgb_to_bgr(const byte *p, byte *q, int n)
{
	while ( n-- )
		{
		byte    r = *p++;
		byte    g = *p++;
		byte    b = *p++;

		*q++ = b;
		*q++ = g;
		*q++ = r;
		}
}

void bgr_to_rgb(const byte *p, byte *q, int n)
{
	while ( n-- )
		{
		byte    b = *p++;
		byte    g = *p++;
		byte    r = *p++;

		*q++ = r;
		*q++ = g;
		*q++ = b;
		}
}

void expand_to_24bit(GBM *gbm, GBMRGB *gbmrgb, byte **data)
{
	int stride = ((gbm->w * gbm->bpp + 31)/32) * 4;
	int new_stride = ((gbm->w * 3 + 3) & ~3);
	int bytes, y;
	byte *new_data;

	if ( gbm->bpp == 24 )
		return;

	bytes = new_stride * gbm->h;
	if ( (new_data = malloc((size_t) bytes)) == NULL )
		{
		fprintf(stderr,"out of memory allocating %d bytes", bytes);
		return;
		}

	for ( y = 0; y < gbm->h; y++ )
		{
		byte    *src = *data + y * stride;
		byte    *dest = new_data + y * new_stride;
		int x;

		switch ( gbm->bpp )
			{
			case 1:
				{
				byte c=0;
				for ( x = 0; x < gbm->w; x++ )
					{
					if ( (x & 7) == 0 )
						c = *src++;
					else
						c <<= 1;

					*dest++ = gbmrgb[c >> 7].b;
					*dest++ = gbmrgb[c >> 7].g;
					*dest++ = gbmrgb[c >> 7].r;
					}
				}
				break;
			case 4:
				for ( x = 0; x + 1 < gbm->w; x += 2 )
					{
					byte    c = *src++;

					*dest++ = gbmrgb[c >> 4].b;
					*dest++ = gbmrgb[c >> 4].g;
					*dest++ = gbmrgb[c >> 4].r;
					*dest++ = gbmrgb[c & 15].b;
					*dest++ = gbmrgb[c & 15].g;
					*dest++ = gbmrgb[c & 15].r;
					}
				if ( x < gbm->w )
					{
					byte    c = *src;

					*dest++ = gbmrgb[c >> 4].b;
					*dest++ = gbmrgb[c >> 4].g;
					*dest++ = gbmrgb[c >> 4].r;
					}
				break;
			case 8:
				for ( x = 0; x < gbm->w; x++ )
					{
					byte    c = *src++;
	
					*dest++ = gbmrgb[c].b;
					*dest++ = gbmrgb[c].g;
					*dest++ = gbmrgb[c].r;
					}
				break;
			}
		}

	free(*data);
	*data = new_data;
	gbm->bpp = 24;
}
