#ifndef GGV_H
#define GGV_H

#define GGV_VERSION "0.2.9"

ggi_visual_t vis;

int idx_light;
int idx_medium;
int idx_dark;
int idx_black;
int idx_marked;

ggi_color default_pal[256];

struct config {
	int default_width;
	int default_height;
	int default_bpp;
	int select_fullscreen;
	char color_light[45];
	char color_medium[45];
	char color_dark[45];
	char color_black[45];
	char color_marked[45];
} cfg;

struct filelist {
	char name[FILENAME_MAX];
	int isdir;
	int xvw,xvh;
	int marked;
	struct filelist *next;
};
struct filelist *first_file;

struct imagetypes {
	long offset;
	char magic[25];
	int  type;
};

enum {
	/* Errors */
    GGV_NOERROR,
    GGV_ERROR,
	/* Image Types */
    GGV_UNKNOWN,
    GGV_PNG,
    GGV_JPEG
};

/* total images */
int totalpics;

/* height of cursor */
int barheight;

/* offset of selection bit */
int yofs;

#define MAKE332COL(r,g,b) (((r)>>3)*32+((g)>>3)*4+((b)>>4))

#define GDFSIZ   3
#define BARWIDTH 134
#define BAR_RESTRICT_WIDTH  BARWIDTH-6

/* selector left margin */
#define LMARGIN  36

/* selector right margin */
#define RMARGIN  (cfg.default_width - LMARGIN)

/* number of files in one column of the selector */
#define YSIZ  ((cfg.default_height - yofs - 85)/barheight)

#define fwinxpos(f) (LMARGIN+(((f)-1)/YSIZ)*BARWIDTH)
#define fwinypos(f) (yofs+70+barheight*(((f)-1)%YSIZ))

#define NO_CLIP_FONT  0x7FFFFFFF

/* screen.c */
#define MSGBOXTYPE_OK       1        /* will always cause return of 1 */
#define MSGBOXTYPE_YESNO    2        /* causes return of 1=yes, 0=no */
#define MSGBOXTYPE_OKCANCEL 3        /* similar to YESNO */

extern int drawtext3d(int x,int y,int s,char *str,int isout,int lite,int dark,int txt);
extern int undrawtext3d(int x,int y,int s,char *str);
extern int draw3dbox(int x1,int y1,int x2,int y2,int depth,int isout,int lite,int dark);
extern int undraw3dbox(int x1,int y1,int x2,int y2,int depth);
extern int msgbox(int ttyfd,char *message,int replytype,int lite,int dark,int txt);

/* font.c */
extern int vgadrawtext(int x,int y,int siz,char *str);
extern int vgatextsize(int sizearg, char *str);
extern int set_max_text_width(int width);

/* config.c */
extern int read_config(void);

/* view.c */
extern int view_file(char *filename);

/* transform.c */
extern unsigned char *transform(unsigned char *bitmap,
                                GBM *gbm, GBMRGB gbmrgb[]);

/* scale.c */
extern unsigned char *scale(unsigned char *bitmap,GBM *gbm,
                            int width, int height);

/* misc.c */
extern int get_bitmap_width(GBM *gbm);
extern void rgb_to_bgr(const byte *p, byte *q, int n);
extern void bgr_to_rgb(const byte *p, byte *q, int n);
extern void expand_to_24bit(GBM *gbm, GBMRGB *gbmrgb, byte **data);

/* type.c */
extern int get_imagetype(char *filename);

/* readjpeg.c */
extern unsigned char *read_jpeg_file(char *filename,GBM *gbm,GBMRGB gbmrgb[]);

/* collage.c */
extern int collage(void);

#endif /* GGV_H */
