/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

/* Public */
int vgadrawtext(int x,int y,int siz,char *str);
int vgatextsize(int sizearg, char *str);
int set_max_text_width(int width);

/* Private */
static int fontcircle(int x,int y,int r);
static int fontc_l(int x,int y,int r);
static int fontc_u(int x,int y,int r);
static int fontc_r(int x,int y,int r);
static int fontc_left(int x,int y,int r);
static int fontc_ul(int x,int y,int r);
static int fontc_ur(int x,int y,int r);
static int fontc_ll(int x,int y,int r);
static int fontc_lr(int x,int y,int r);


#define TABSIZE  64                         /* size of a tab, in pixels */
static int go_through_the_motions=0;        /* if 1, we don't draw it   */
static int stop_after_this_x=NO_CLIP_FONT;

/* this gets how wide text will be */
int vgatextsize(int sizearg, char *str)
{
	int r;

	go_through_the_motions=1;
	r=vgadrawtext(0,0,sizearg,str);
	go_through_the_motions=0;

return r;
}

int set_max_text_width(int width)
{
	stop_after_this_x=width;

return 0;
}

int vgadrawtext(int x,int y,int siz,char *str)
{
	int f,a,b,c,s1,s2,s3,s4,s5,s6,gap;

	b=y;
	a=x;
	s1=siz; s2=s1<<1; s3=s1+s2; s4=s2<<1; s5=s4+s1; s6=s3<<1;
	gap=s1; if(gap==0) gap=1;

	for(f=0;f<strlen(str);f++)
		{
		/* s3+s4 is the size that an ellipsis will take up (s3), plus the
		** widest possible letter (M = s4).
		*/
		if(a-x>stop_after_this_x-s3-s4)
			{
			int tmp;
    
			/* print an ellipsis... well, three dots :) */
			/* blast the width restriction to stop possible infinite recursion */
			tmp=stop_after_this_x;
			set_max_text_width(NO_CLIP_FONT);
			vgadrawtext(a,y,siz,"...");
			stop_after_this_x=tmp;
			/* now give up */
			break;
			}
		c=str[f];
  
		/*** 1st step: cover some common occurances ***/

		if(!go_through_the_motions)
			if(index("abdgopq68",c)!=NULL)   /* common circle position */
				fontcircle(a+s1,b+s3,siz);
			else
				{ /* common part-circle positions */
				if(index("cehmnrs",c)!=NULL)
					fontc_ul(a+s1,b+s3,siz);
				if(index("ehmnrBS35",c)!=NULL)
					fontc_ur(a+s1,b+s3,siz);
				if(index("cetuyCGJOQSUl035",c)!=NULL)
					fontc_ll(a+s1,b+s3,siz);
				if(index("suyBCDGJOQSU035",c)!=NULL)
					fontc_lr(a+s1,b+s3,siz);
				/* common line */
				if(index("BDEFHKLMNPR",c)!=NULL)
					ggiDrawLine(vis,a,b,a,b+s4);
				}


		/*** 2nd step: fill in rest ***/
  
		if(!go_through_the_motions)
			switch(c)
				{
				/*** 2a: lowercase letters ***/

				case 'a':
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s4);
					break;
				case 'b':
					ggiDrawLine(vis,a,b,a,b+s4);
					break;
				case 'c':
					ggiDrawLine(vis,a+s1,b+s2,a+s2,b+s2);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b+s4);
					break;
				case 'd':
					ggiDrawLine(vis,a+s2,b,a+s2,b+s4);
					break;
				case 'e':
					ggiDrawLine(vis,a,b+s3,a+s2,b+s3);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b+s4);
					break;
				case 'f':
					fontc_ul(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s4);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case 'g':
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s5);
					fontc_l(a+s1,b+s5,siz);
					break;
				case 'h':
					ggiDrawLine(vis,a,b,a,b+s4);
					ggiDrawLine(vis,a+s2,b+s3,a+s2,b+s4);
					break;
				case 'i':
					ggiDrawPixel(vis,a,b+s1);
					ggiDrawLine(vis,a,b+s2,a,b+s4);
					a+=-s1+1;
					break;
				case 'j':
					ggiDrawLine(vis,a+s1,b+s2,a+s1,b+s5);
					fontc_lr(a,b+s5,siz);
					ggiDrawPixel(vis,a+s1,b+s1);
					break;
				case 'k':
					ggiDrawLine(vis,a,b,a,b+s4);
					ggiDrawLine(vis,a,b+s3,a+s1,b+s2);
					ggiDrawLine(vis,a,b+s3,a+s1,b+s4);
					break;
				case 'l':
					ggiDrawLine(vis,a,b,a,b+s3);
					break;
				case 'm':
					ggiDrawLine(vis,a,b+s2,a,b+s4);
					ggiDrawLine(vis,a+s2,b+s3,a+s2,b+s4);
					ggiDrawLine(vis,a+s4,b+s3,a+s4,b+s4);
					fontc_u(a+s3,b+s3,siz);
					break;
				case 'n':
					ggiDrawLine(vis,a,b+s2,a,b+s4);
					ggiDrawLine(vis,a+s2,b+s3,a+s2,b+s4);
					break;
				case 'p':
					ggiDrawLine(vis,a,b+s2,a,b+s6);
					break;
				case 'q':
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s6);
					break;
				case 'r':
					ggiDrawLine(vis,a,b+s2,a,b+s4);
					break;
				case 's':
					ggiDrawLine(vis,a,b+s3,a+s2,b+s3);
					ggiDrawLine(vis,a+s1,b+s2,a+s2,b+s2);
					ggiDrawLine(vis,a,b+s4,a+s1,b+s4);
					break;
				case 't':
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case 'u':
					ggiDrawLine(vis,a,b+s2,a,b+s3);
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s4);
					break;
				case 'v':
					ggiDrawLine(vis,a,b+s2,a+s1,b+s4);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b+s2);
					break;
				case 'w':
					ggiDrawLine(vis,a,b+s2,a+s1,b+s4);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b+s3);
					ggiDrawLine(vis,a+s2,b+s3,a+s3,b+s4);
					ggiDrawLine(vis,a+s3,b+s4,a+s4,b+s2);
					break;
				case 'x':
					ggiDrawLine(vis,a,b+s2,a+s2,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s2);
					break;
				case 'y':
					ggiDrawLine(vis,a,b+s2,a,b+s3);
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s5);
					fontc_l(a+s1,b+s5,siz);
					break;
				case 'z':
					ggiDrawLine(vis,a,b+s2,a+s2,b+s2);
					ggiDrawLine(vis,a+s2,b+s2,a,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
     
				/*** 2b: uppercase letters ***/
  
				case 'A':
					ggiDrawLine(vis,a,b+s4,a+s1,b);
					ggiDrawLine(vis,a+s1,b,a+s2,b+s4);
					ggiDrawLine(vis,a+(s1>>1),b+s2,a+s2-(s1>>1),b+s2);
					break;
				case 'B':
					fontc_r(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b,a+s1,b);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					ggiDrawLine(vis,a,b+s4,a+s1,b+s4);
					break;
				case 'C':
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					break;
				case 'D':
					ggiDrawLine(vis,a,b,a+s1,b);
					ggiDrawLine(vis,a,b+s4,a+s1,b+s4);
					fontc_ur(a+s1,b+s1,siz);
					ggiDrawLine(vis,a+s2,b+s1,a+s2,b+s3);
					break;
				case 'E':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
				case 'F':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case 'G':
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					ggiDrawLine(vis,a+s1,b+s2,a+s2,b+s2);
					ggiDrawLine(vis,a+s2,b+s2,a+s2,b+s3);
					break;
				case 'H':
					ggiDrawLine(vis,a,b+s2,a+s2,b+s2);
					ggiDrawLine(vis,a+s2,b,a+s2,b+s4);
					break;
				case 'I':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a+s1,b,a+s1,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
				case 'J':
					ggiDrawLine(vis,a+s2,b,a+s2,b+s3);
					break;
				case 'K':
					ggiDrawLine(vis,a+s2,b,a,b+s2);
					ggiDrawLine(vis,a,b+s2,a+s2,b+s4);
					break;
				case 'L':
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
				case 'M':
					ggiDrawLine(vis,a,b,a+s1+(s1>>1),b+s2);
					ggiDrawLine(vis,a+s1+(s1>>1),b+s2,a+s3,b);
					ggiDrawLine(vis,a+s3,b,a+s3,b+s4); a-=s1;
					break;
				case 'N':
					ggiDrawLine(vis,a,b,a+s2,b+s4);
					ggiDrawLine(vis,a+s2,b+s4,a+s2,b);
					break;
				case 'Q':
					ggiDrawLine(vis,a+s1,b+s3,a+s2,b+s4);
					/* FALLS THROUGH and adds an O, finishing the Q */
				case 'O':
				case '0':   /* all other numbers done later */
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					ggiDrawLine(vis,a+s2,b+s1,a+s2,b+s3);
					break;
				case 'R':
					ggiDrawLine(vis,a+s1,b+s2,a+s2,b+s4);
					/* FALLS THROUGH and adds a P, finishing the R */
				case 'P':
					fontc_r(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b,a+s1,b);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case 'S':
					fontc_left(a+s1,b+s1,siz);
					fontc_ur(a+s1,b+s1,siz);
					break;
				case 'T':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a+s1,b,a+s1,b+s4);
					break;
				case 'U':
					ggiDrawLine(vis,a,b,a,b+s3);
					ggiDrawLine(vis,a+s2,b,a+s2,b+s3);
					break;
				case 'V':
					ggiDrawLine(vis,a,b,a+s1,b+s4);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b);
					break;
				case 'W':
					ggiDrawLine(vis,a,b,a+s1,b+s4);
					ggiDrawLine(vis,a+s1,b+s4,a+s2,b+s2);
					ggiDrawLine(vis,a+s2,b+s2,a+s3,b+s4);
					ggiDrawLine(vis,a+s3,b+s4,a+s4,b);
					break;
				case 'X':
					ggiDrawLine(vis,a,b,a+s2,b+s4);
					ggiDrawLine(vis,a+s2,b,a,b+s4);
					break;
				case 'Y':
					ggiDrawLine(vis,a,b,a+s1,b+s2);
					ggiDrawLine(vis,a+s2,b,a+s1,b+s2);
					ggiDrawLine(vis,a+s1,b+s2,a+s1,b+s4);
					break;
				case 'Z':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a+s2,b,a,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
     
				/*** 2c: numbers ***/
    
				/* 0 already done */
				case '1':
					ggiDrawLine(vis,a,b+s1,a+s1,b);
					ggiDrawLine(vis,a+s1,b,a+s1,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
				case '2':
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a+s2,b+s1,a,b+s4);
					ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
					break;
				case '3':
					fontc_u(a+s1,b+s1,siz);
					fontc_lr(a+s1,b+s1,siz);
					break;
				case '4':
					ggiDrawLine(vis,a+s1,b+s4,a+s1,b);
					ggiDrawLine(vis,a+s1,b,a,b+s2);
					ggiDrawLine(vis,a,b+s2,a+s2,b+s2);
					break;
				case '5':
					ggiDrawLine(vis,a+s2,b,a,b);
					ggiDrawLine(vis,a,b,a,b+s2);
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case '6':
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					break;
				case '7':
					ggiDrawLine(vis,a,b,a+s2,b);
					ggiDrawLine(vis,a+s2,b,a+s1,b+s4);
					break;
				case '9':
					ggiDrawLine(vis,a+s2,b,a+s2,b+s4);
					/* FALLS THROUGH and does top circle of 8 to complete the 9 */
				case '8':
					fontcircle(a+s1,b+s1,siz);
					break;
      
				/* 2d: some punctuation (not much!) */
      
				case '-':
					ggiDrawLine(vis,a,b+s2,a+s1,b+s2);
					break;
				case '.':
					ggiDrawPixel(vis,a,b+s4);
					a+=-s1+1;
					break;
				case '(':
					fontc_ul(a+s1,b+s1,siz);
					fontc_ll(a+s1,b+s3,siz);
					ggiDrawLine(vis,a,b+s1,a,b+s3);
					break;
				case ')':
					fontc_ur(a,b+s1,siz);
					fontc_lr(a,b+s3,siz);
					ggiDrawLine(vis,a+s1,b+s1,a+s1,b+s3);
					break;
				case '%':
					ggiDrawPixel(vis,a,b);
					ggiDrawPixel(vis,a+s2,b+s4);
					/* FALLS THROUGH drawing the slash to finish the % */
				case '/':
					ggiDrawLine(vis,a,b+s4,a+s2,b);
					break;
				case '?':
					fontc_u(a+s1,b+s1,siz);
					ggiDrawLine(vis,a+s2,b+s1,a+s1,b+s2);
					ggiDrawLine(vis,a+s1,b+s2,a+s1,b+s3);
					ggiDrawPixel(vis,a+s1,b+s4);
					break;
				}

    
			/*** 3rd part: finally, move along for the next letter ***/
			/*** we do this even if go_through_the_motions is set */
			if(index("ltfijk-. ()",c)!=NULL)
				a+=s1;
			else
				{
				if(index("?/%abcdeghnopqrsuvxyzABCDEFGHIJKLNOPQRSTUVXYZ0123456789",c)!=NULL)
					a+=s2;
				else
					{
					if(index("mwMW",c)!=NULL)
						a+=s4;
					else
						{
						if(c==9)
							{
							/* congratulations madam, it's a tab */
							a=((a/TABSIZE)+1)*TABSIZE;
							}
						else
							{
							/* oh, don't know this one. do an underscore */
							/* (we don't if go_through_the_motions is set) */
							if(!go_through_the_motions)
								ggiDrawLine(vis,a,b+s4,a+s2,b+s4);
							a+=s2;
							}
						}
					}
				}
		a+=gap;   /* and add a gap */
		}

return(a-x);
}

static int fontcircle(int x,int y,int r)
{
	fontc_u(x,y,r);
	fontc_l(x,y,r);

return 0;
}

static int fontc_l(int x,int y,int r)
{
	fontc_ll(x,y,r);
	fontc_lr(x,y,r);

return 0;
}

static int fontc_u(int x,int y,int r)
{
	fontc_ul(x,y,r);
	fontc_ur(x,y,r);

return 0;
}

static int fontc_r(int x,int y,int r)
{
	fontc_ur(x,y,r);
	fontc_lr(x,y,r);

return 0;
}

static int fontc_left(int x,int y,int r)
{
	fontc_ul(x,y,r);
	fontc_ll(x,y,r);

return 0;
}

static int fontc_ul(int x,int y,int r)
{
	int r34;

	if(go_through_the_motions)
		return 0;
	r34=((r*3)>>2);
	ggiDrawLine(vis,x-r,y,x-r34,y-r34);
	ggiDrawLine(vis,x-r34,y-r34,x,y-r);

return 0;
}

static int fontc_ur(int x,int y,int r)
{
	int r34;

	if(go_through_the_motions)
		return 0;
	r34=((r*3)>>2);
	ggiDrawLine(vis,x+r,y,x+r34,y-r34);
	ggiDrawLine(vis,x+r34,y-r34,x,y-r);

return 0;
}

static int fontc_ll(int x,int y,int r)
{
	int r34;

	if(go_through_the_motions)
		return 0;
	r34=((r*3)>>2);
	ggiDrawLine(vis,x-r,y,x-r34,y+r34);
	ggiDrawLine(vis,x-r34,y+r34,x,y+r);

return 0;
}

static int fontc_lr(int x,int y,int r)
{
	int r34;

	if(go_through_the_motions)
		return 0;
	r34=((r*3)>>2);
	ggiDrawLine(vis,x+r,y,x+r34,y+r34);
	ggiDrawLine(vis,x+r34,y+r34,x,y+r);

return 0;
}
