/* Tab=4, Linewrap=off */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include <jpeglib.h>
#include <ggi/ggi.h>

#include "gbm.h"
#include "ggv.h"

#include "font2.h"

/* Public */
int collage(void);

/* Private */
static void addpic(byte *data_src, const GBM *gbm,
                   byte *data_dst, int xsiz, int ysiz,
                   int xoffset, int yoffset);
static void addtext(int xpos, int ypos, char *str, int xsiz);
static void write_JPEG_file(char *filename, int outwidth, int outheight, int quality);

#define PICS_ACROSS 5                       /* Number of thumbnails across */
#define TEXTHI 22                           /* Thumbnail text height       */
#define SCRNWIDE 128                        /* Thumbnail image width       */
#define SCRNHIGH 96                         /* Thumbnail image height      */

unsigned char *outimage;

int collage(void)
{
	div_t cxy;
	int cx;
	int cy;
	int xsiz;                               /* Total output image xsize    */
	int ysiz;                               /* Total output image ysize    */
	int y=0;

	struct filelist *current_file, *next_file;

	int fd;
	int ft;
	int rc;
	int cb;

	unsigned char *bitmap=NULL;
	unsigned char *new_bitmap=NULL;

	GBM     gbm;
	GBMRGB  gbmrgb[256];

	int xpoint;
	int ypoint;

	char textstr[1024];

	/* Do some calculations */
	cxy=div(totalpics,PICS_ACROSS);
	cx=cxy.rem;
	xsiz=((cxy.quot+1)==1) ? cx*SCRNWIDE : (PICS_ACROSS*SCRNWIDE);
	if(totalpics>1)
		cxy=div(totalpics-1,PICS_ACROSS);
	ysiz=(cy=cxy.quot+1)*(SCRNHIGH+TEXTHI);

	/* Calloc memory to hold thumbnail index file */
	if( NULL == (outimage=calloc(1,xsiz*ysiz*3)) )
		{
		fprintf(stderr,"calloc: Error.\n");
		return GGV_ERROR;
		}

	gbm_init();

	/* The big loop */
	current_file=first_file;
	while(NULL != current_file)
		{
		next_file=current_file->next;
		cxy=div(y,PICS_ACROSS);
		y++;
		if(!current_file->isdir)
			{
			if( (rc=gbm_guess_filetype(current_file->name, &ft)) == GBM_ERR_OK)
				{
				if( (fd = gbm_io_open(current_file->name, O_RDONLY)) == -1 )
					{
					fprintf(stderr,"Can't open file %s\n",current_file->name);
					gbm_deinit();
					return 1;
					}
		
				if( (rc = gbm_read_header(current_file->name, fd, ft, &gbm, "\0")) != GBM_ERR_OK )
					{
					fprintf(stderr,"Can't read header of %s: %s", current_file->name, gbm_err(rc));
					gbm_io_close(fd);
					gbm_deinit();
					return 1;
					}
		
				if( (rc = gbm_read_palette(fd, ft, &gbm, gbmrgb)) != GBM_ERR_OK )
					{
					fprintf(stderr,"Can't read palette of %s: %s", current_file->name, gbm_err(rc));
					gbm_io_close(fd);
					gbm_deinit();
					return 1;
					}
		
				cb=gbm.h * ( ( ( gbm.w * gbm.bpp + 31 ) /32 ) * 4 );
				if(NULL == (bitmap=calloc(1,cb)) )
					{
					fprintf(stderr,"Failed to calloc %d\n",cb);
					gbm_io_close(fd);
					gbm_deinit();
					return 1;
					}

				if( (rc = gbm_read_data(fd, ft, &gbm, bitmap)) != GBM_ERR_OK )
					{
					fprintf(stderr,"Can't read bitmap data of %s: %s", current_file->name, gbm_err(rc));
					if(NULL != bitmap) free(bitmap); bitmap=NULL;
					gbm_io_close(fd);
					gbm_deinit();
					return 1;
					}

				gbm_io_close(fd);
				}
			else /* Possibly a JPEG */
				{
				rc=get_imagetype(current_file->name);
				switch(rc)
					{
					case GGV_JPEG:
						bitmap=read_jpeg_file(current_file->name,&gbm,gbmrgb);
						break;
					default:
						fprintf(stderr,"Can't guess image format of %s\n",current_file->name);
						gbm_deinit();
						return 1;
						break;
					}
				}

			/* Expand to 24bit */
			expand_to_24bit(&gbm, gbmrgb, &bitmap);

			/* If the image is too big */

			if( gbm.w > SCRNWIDE || gbm.h > SCRNHIGH)
				{
				new_bitmap=scale(bitmap,&gbm,SCRNWIDE,SCRNHIGH);
				if(NULL==new_bitmap)
					{
					fprintf(stderr,"Failed to scale image.\n");		
					if(NULL != bitmap) free(bitmap); bitmap=NULL;
					gbm_deinit();
					return 1;
					}
				if(NULL != bitmap) free(bitmap); bitmap=NULL;
				bitmap=new_bitmap;
				new_bitmap=NULL;
				}

			/* So now we have an image ready to go */
			xpoint=((cxy.rem)*SCRNWIDE);
			ypoint=((cxy.quot)*(SCRNHIGH+TEXTHI));

			addpic(bitmap, &gbm, outimage, xsiz, ysiz,xpoint,ypoint);

			/* xpoint stays the same */
			ypoint=(cxy.quot)*(SCRNHIGH+TEXTHI)+SCRNHIGH+3;

			strcpy(textstr,current_file->name);
			if(strlen(textstr)>16) textstr[16]=0;

			addtext(xpoint,ypoint,textstr,xsiz);

			/* Free everything up for next round */
			if(NULL != new_bitmap) free(new_bitmap); new_bitmap=NULL;
			if(NULL != bitmap) free(bitmap); bitmap=NULL;
			}
		current_file=next_file;
		}

	/* Write the jpeg out */
	write_JPEG_file("00_index.jpg",xsiz,ysiz,70);

	/* Free the outimage */
	free(outimage);

	gbm_deinit();

return GGV_NOERROR;
}

static void addpic(byte *data_src, const GBM *gbm,
                   byte *data_dst, int xsiz, int ysiz,
                   int xoffset, int yoffset)
{
	int x;
	int local;
	unsigned char *work_bitmap;
	int src_stride = ((gbm->w * gbm->bpp + 31) / 32) * 4;
	int dst_stride = ((xsiz * 24 + 31) / 32) * 4;
    unsigned char *p = data_src;

    for ( x = 0; x < gbm->h; x++, p += src_stride )
        bgr_to_rgb(p, p, gbm->w);

	work_bitmap  = data_src + (gbm->h * src_stride);
	work_bitmap  = work_bitmap - ((0 + 1) * src_stride) + 0;

	data_dst+=(xoffset*3) + (yoffset*dst_stride);

    for(local=1;local<gbm->h;local++)
        {
		memcpy(data_dst,work_bitmap,src_stride);
        work_bitmap = work_bitmap - src_stride;
		data_dst+=dst_stride;
        }
}


static void addtext(int xpos, int ypos, char *str, int xsiz)
{
	int a,b,c,f,x,loc;

	x=xpos;
	for(f=0;f<strlen(str);f++)
		{
		c=toupper(str[f])-32;
		if((c<0)||(c>63))
			c='_'-32;
		for(b=0;b<5;b++)
		for(a=0;a<imagefont[ILETTERSIZ*c];a++)
			if(imagefont[ILETTERSIZ*c+1+b*8+a]=='x')
				{
				loc=3*((ypos+b)*xsiz+x+a);
				outimage[loc  ]=255;
				outimage[loc+1]=255;
				outimage[loc+2]=255;
				}
		x+=imagefont[ILETTERSIZ*c]+1;
		}
}

static void write_JPEG_file(char *filename, int outwidth, int outheight, int quality)
{
	struct jpeg_compress_struct cinfo;
	struct jpeg_error_mgr jerr;
	FILE *out;
	JSAMPROW row_pointer[1];
	int row_stride;

	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_compress(&cinfo);

	if((out=fopen(filename,"wb"))==NULL)
		{
		fprintf(stderr,"can't open %s\n",filename);
		exit(1);
		}
	jpeg_stdio_dest(&cinfo,out);

	cinfo.image_width = outwidth;
	cinfo.image_height = outheight;
	cinfo.input_components = 3;
	cinfo.in_color_space = JCS_RGB;
	jpeg_set_defaults(&cinfo);
	jpeg_set_quality(&cinfo,quality,FALSE);

	jpeg_start_compress(&cinfo,TRUE);

	row_stride=outwidth*3;

	while (cinfo.next_scanline < cinfo.image_height)
		{
		row_pointer[0]=&outimage[cinfo.next_scanline*row_stride];
		jpeg_write_scanlines(&cinfo,row_pointer,1);
		}

	jpeg_finish_compress(&cinfo);
	fclose(out);
	jpeg_destroy_compress(&cinfo);
}
