/*
gbmhelp.h - Internal helpers for GBM file I/O stuff
*/

#ifndef GBMHELP_H
#define	GBMHELP_H

#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

extern GBM_BOOLEAN gbm_same(const char *s1, const char *s2, int n);
extern const char *gbm_find_word(const char *str, const char *substr);
extern const char *gbm_find_word_prefix(const char *str, const char *substr);

int  (*gbm_file_open  )(const char *fn, int mode);
int  (*gbm_file_create)(const char *fn, int mode);
void (*gbm_file_close )(int fd);
long (*gbm_file_lseek )(int fd, long pos, int whence);
int  (*gbm_file_read  )(int fd, void *buf, int len);
int  (*gbm_file_write )(int fd, const void *buf, int len);

typedef void AHEAD;
extern AHEAD *gbm_create_ahead(int fd);
extern void   gbm_destroy_ahead(AHEAD *ahead);
extern int    gbm_read_ahead(AHEAD *ahead);

#endif /* GBMHELP_H */
