#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <ggi/ggi.h>
#include <sys/ioctl.h>
#include <linux/videodev.h>
#include <errno.h>
#include <string.h>
#include <sys/mman.h>

#include "frequencies.h"
#include "channel.h"
#include "grab.h"

//#define DEBUG

/* extern */
int debug;
char v4l_conf[] = "";

/* fbtv */
int cur_color;
int cur_bright;
int cur_hue;
int cur_contrast;
int cur_capture;

int cur_mute   = 0;
int cur_volume = 65535;

struct STRTAB *cmenu = NULL;

/* GGI */
static ggi_visual_t vis = NULL;
static ggi_visual_t memvis = NULL;

static ggi_directbuffer *dbuf;

int gt2video (int f) {
	switch (f) {
		case GT_24BIT:	return VIDEO_RGB24;
		case GT_16BIT:	return VIDEO_RGB16_LE;
		case GT_15BIT:	return VIDEO_RGB15_LE;
		case GT_8BIT:	return VIDEO_RGB08;
		default:	return 0;
	}
}

void set_capture(int capture)
{
	ggi_mode m;
    	int gt, w, h, l;
    /* off */
    switch (cur_capture) {
    case CAPTURE_GRABDISPLAY:
	if (grabber->grab_cleanup)
	    grabber->grab_cleanup();
	break;
    }

    cur_capture = capture;

    /* on */
    switch (cur_capture) {
    case CAPTURE_GRABDISPLAY:
    	
    	ggiGetMode(vis,&m);
	
	w = m.virt.x;
	h = m.virt.y;
	l = m.visible.x;
	
/* wir machen kein overlay */
	if ((gt = gt2video(m.graphtype))) {
		grabber_setparams(gt, &w, &h, &l, 0);
	} else {
		return ;
	}
	break;
    }
}

void set_norm(int j)
{
    cur_norm = j;

    grabber->grab_input(-1,cur_norm);
}

void set_source(int j)
{
    cur_input = j;
    
    grabber->grab_input(cur_input,-1);
}

void
set_picparams(int color, int bright, int hue, int contrast)
{
    if (color != -1)
	cur_color = color;
    if (bright != -1)
	cur_bright = bright;
    if (hue != -1)
	cur_hue = hue;
    if (contrast != -1)
	cur_contrast = contrast;
    grabber->grab_picture(cur_color,cur_bright,cur_hue,cur_contrast);
}

void
set_channel(struct CHANNEL *channel)
{
    /* image parameters */
    set_picparams(channel->color, channel->bright,
		  channel->hue, channel->contrast);

    /* input source */
    if (cur_input   != channel->source)
	set_source(channel->source);
    if (cur_norm    != channel->norm)
	set_norm(channel->norm);

    /* station */
    cur_channel  = channel->channel;
    cur_fine     = channel->fine;
    grabber->grab_tune(channel->freq);

    set_capture(channel->capture);
}

void
channel_menu()
{
    int  i,max,len;
    char key[32],ctrl[16];

    cmenu = malloc((count+1)*sizeof(struct STRTAB));
    memset(cmenu,0,(count+1)*sizeof(struct STRTAB));
    for (i = 0, max = 0; i < count; i++) {
	len = strlen(channels[i]->name);
	if (max < len)
	    max = len;
    }
    for (i = 0; i < count; i++) {
	cmenu[i].nr      = i+1;
	cmenu[i].str     = channels[i]->name;
	if (channels[i]->key) {
	    if (2 != sscanf(channels[i]->key,"%15[A-Za-z0-9_]+%31[A-Za-z0-9_]",
			    ctrl,key))
		strcpy(key,channels[i]->key);
	}
    }
}


int video_init() {
	int gt, w, h, l;
	ggi_mode m;
	
	ggiGetMode(vis,&m);
	
	w = m.virt.x;
	h = m.virt.y;
	l = m.visible.x;
	
/* wir machen kein overlay */
	grabber_open( 0,0,0,0,0 );
	if ((gt = gt2video(m.graphtype))) {
		grabber_setparams(gt, &w, &h, &l, 0);
	} else {
		return -1;
	}
	
	read_config();
	channel_menu();
	if (count) {
		if ((cur_sender < 0) || (cur_sender >= count))
		    cur_sender = 0;
		set_channel(channels[cur_sender]);
	    } else {
		set_channel(&defaults);
	    }
	return 0;
}

void video_done() {
	grabber->grab_close();
}

int video_get_pic() {
	
	grabber_capture(dbuf->write,0,0);
	return 0;
}

int graphic_init () {
	ggiInit();
	
	if ((vis = ggiOpen(NULL))) {
		ggi_mode m2;
		
		if (ggiSetSimpleMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_AUTO)) {
			fprintf(stderr, "Can't set default mode\n");
			return -1;
		}
		ggiGetMode(vis,&m2);
		if (GT_SCHEME(m2.graphtype) == GT_PALETTE) {
			ggiSetColorfulPalette(vis);
		}
		ggiSetFlags(vis, GGIFLAG_ASYNC);
		
		if (!(dbuf = ggiDBGetBuffer(vis,0))) {
			fprintf(stderr, "No DirectBuffer available\n");
			return -1;
		}
		if (!(dbuf->type & GGI_DB_SIMPLE_PLB)) {
			fprintf(stderr, "No DirectBuffer available\n");
			return -1;
		}
		if (ggiResourceAcquire(dbuf->resource,GGI_ACTYPE_WRITE)) {
			fprintf(stderr, "Can't acquire DirectBuffer\n");
			return -1;
		}

#ifdef DEBUG		
		ggiPrintMode(&m2);
		printf("\n");
#endif
		return 0;
	}
	return -1;
}

void graphic_done () {
	ggiResourceRelease(dbuf->resource);
	
	ggiExit();
}

int main (int argc, char **argv) {
	int freq;
	int quit = 0;
	
	if (graphic_init()) {
		printf("Graphic_init failed\n");
		return -1;
	}
		
	if (video_init()) {
		printf("Video_init failed\n");
		video_done();
		graphic_done();
		return -1;
	}
		
	while (!quit) {
		int n;
		gii_event ev;
		struct timeval tv = {0,40000};
			
		ggiEventPoll(vis,emAll,&tv);
		n = ggiEventsQueued(vis,emAll);
		while (n && !quit) {
			ggiEventRead(vis,&ev,emAll);
			if (ev.any.type == evKeyPress) {
				switch (ev.key.sym) {
				case GIIUC_X:
				case GIIUC_x:
			    	case GIIUC_Escape:
					quit = 1;
					break;
				case GIIK_PageUp:
					cur_sender = (cur_sender+1)%count;
					set_channel(channels[cur_sender]);
					break;
				case GIIK_PageDown:
					cur_sender = (cur_sender+count-1)%count;
					set_channel(channels[cur_sender]);
					break;
				case GIIK_Up:
					cur_channel = (cur_channel+1) % chancount;
					cur_fine = 0;
					cur_sender = -1;
					freq = get_freq(cur_channel)+cur_fine;
					grabber->grab_tune(freq);
					break;
				case GIIK_Down:
					cur_channel = (cur_channel+chancount-1) % chancount;
					cur_fine = 0;
					cur_sender = -1;
					freq = get_freq(cur_channel)+cur_fine;
					grabber->grab_tune(freq);
					break;
				case GIIK_Left:
					cur_fine--;
					cur_sender = -1;
					freq = get_freq(cur_channel)+cur_fine;
					grabber->grab_tune(freq);
					break;
				case GIIK_Right:
					cur_fine++;
					cur_sender = -1;
					freq = get_freq(cur_channel)+cur_fine;
					grabber->grab_tune(freq);
					break;
				}
			}
			n--;
		}
		
		video_get_pic();
		
		ggiFlush(vis);
	}

#ifdef DEBUG		
	printf("----> Finished <----\n");
#endif

	video_done();
	graphic_done();
	
	return 0;
}