typedef void (*color_conv)(unsigned char *d, unsigned char *s, int p);

void lut_init(unsigned long red_mask, unsigned long green_mask,
	      unsigned long blue_mask, int depth, int swap);

void rgb24_to_lut2(unsigned char *dest, unsigned char *src, int p);
void bgr24_to_lut2(unsigned char *dest, unsigned char *src, int p);
void rgb32_to_lut2(unsigned char *dest, unsigned char *src, int p);
void bgr32_to_lut2(unsigned char *dest, unsigned char *src, int p);
void gray_to_lut2(unsigned char *dest, unsigned char *src, int p);

void rgb24_to_lut4(unsigned char *dest, unsigned char *src, int p);
void bgr24_to_lut4(unsigned char *dest, unsigned char *src, int p);
void rgb32_to_lut4(unsigned char *dest, unsigned char *src, int p);
void bgr32_to_lut4(unsigned char *dest, unsigned char *src, int p);
void gray_to_lut4(unsigned char *dest, unsigned char *src, int p);

/* ------------------------------------------------------------------- */
/* RGB conversions                                                     */

void swap_rgb24(char *mem, int n);
void rgb24_to_bgr24(unsigned char *dest, unsigned char *src, int p);
void bgr24_to_bgr32(unsigned char *dest, unsigned char *src, int p);
void bgr24_to_rgb32(unsigned char *dest, unsigned char *src, int p);
void rgb32_to_rgb24(unsigned char *dest, unsigned char *src, int p);
void rgb32_to_bgr24(unsigned char *dest, unsigned char *src, int p);
void byteswap_short(unsigned char *dest, unsigned char *src, int p);

/* ------------------------------------------------------------------- */
/* color => grayscale                                                  */

void rgb15_native_gray(unsigned char *dest, unsigned char *src, int p);
void rgb15_be_gray(unsigned char *dest, unsigned char *src, int p);
void rgb15_le_gray(unsigned char *dest, unsigned char *src, int p);

/* ------------------------------------------------------------------- */
/* YUV conversions                                                     */

void packed422_to_planar422(unsigned char *d, unsigned char *s, int w, int h);
void packed422_to_planar411(unsigned char *d, unsigned char *s, int w, int h);
