#define CAPTURE_OFF          0
#define CAPTURE_OVERLAY      1
#define CAPTURE_GRABDISPLAY  2
#define CAPTURE_ON           9

struct CHANNEL {
    char  *name;
    char  *key;

    char  *cname;     /* name of the channel  */
    int   channel;    /* index into tvtuner[] */
    int   fine;
    int   freq;

    int   capture;
    int   source;
    int   norm;

    int   color;
    int   bright;
    int   hue;
    int   contrast;

    int ckey;
};

extern struct CHANNEL  defaults;
extern struct CHANNEL  **channels;
extern int             count;
extern int             have_mixer;

extern int have_config;
extern int jpeg_quality;
extern int fs_width,fs_height,fs_xoff,fs_yoff,pix_width,pix_height;
extern int last_sender, cur_sender;
extern int cur_channel, cur_fine, cur_norm, cur_input;

int  lookup_channel(char *channel);
int  get_freq(int i);
int  cf2freq(char *name, int fine);

struct CHANNEL* add_channel(char *name);
void hotkey_channel(struct CHANNEL *channel);
void configure_channel(struct CHANNEL *channel);
void del_channel(int nr);
void calc_frequencies();

void read_config();
void save_config();

/* ----------------------------------------------------------------------- */

struct LAUCH {
    char *name;
    char *key;
    char *cmdline;
};

extern struct LAUCH *lauch;
extern int nlauch;

/* ----------------------------------------------------------------------- */

extern struct STRTAB booltab[];
extern struct STRTAB normtab[];
extern struct STRTAB srctab[];

int str_to_int(char *str, struct STRTAB *tab);
char* int_to_str(int n, struct STRTAB *tab);
char** split_cmdline(char *line, int *count);

