/* ------------------------------------------------------------------------
 *	stringbox.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_SBOX_H
#define _DOWNSCRIPT_SBOX_H

#include "list.h"
#include "output.h"
#include "stringbox.h"


typedef struct string_box
{
	/* private */

	Node n;

	/* public */

	int x;
	int y;
	int width;
	
	int font_height;
	int font_width;
	int font_style;

	char *text;

	int dist_to_next;

} string_box;


extern string_box *new_string_box(int x, int y, int width,
				  int font_width, int font_height, 
				  int font_style, char *text);

extern void free_string_box(string_box *sb);

extern void set_word_gap(string_box *L, string_box *R, int xfudge);
extern void set_super_and_subscript(string_box *sb, int base_y);

extern int word_abuts(string_box *L, string_box *R, int xfudge);


#define CALC_FUDGE(val,fudge)  ((val) * (fudge) / 100)


#endif  /* _DOWNSCRIPT_SBOX_H */
