/* ------------------------------------------------------------------------
 *	sort.c  -  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdlib.h>

#include "list.h"
#include "sort.h"


void merge_sort(List *L, comparer_t comparer)
{
	/* A rather humble but effective implementation of the merge
	 * sort algorithm. The compare function is like strcmp(): it
	 * returns < 0 if A is less than B, 0 if A equals B, and > 0
	 * if A is greater than B.
	 */

	List L2;

	Node *cur;


	if ((L->head == NULL) || (L->head->succ == NULL)) {

		/* the list has < 2 members, so nothing to do */

		return;
	}


	/* Firstly, split the list into two, by removing every second
	 * node from L and adding it to L2.
	 */

	init_list(&L2);

	cur = L->head;

	while ((cur != NULL) && (cur->succ != NULL)) {

		add_to_tail(&L2, remove_node(L, cur->succ));

		cur = cur->succ;
	}


	/* Secondly, recursively sort each half.
	 */

	merge_sort(L,   comparer);
	merge_sort(&L2, comparer);


	/* Thirdly, merge two halves back into the one list. This is where
	 * the real sorting work gets done.
	 */

	cur = L->head;

	while (L2.head != NULL)
	{
		if (cur == NULL) {
			add_to_tail(L, remove_node(&L2, L2.head));

		} else if ((* comparer)(L2.head, cur) <= 0) {
			insert_node_before(L, remove_node(&L2, L2.head), cur);

		} else {
			cur = cur->succ;
		}
	}
}
