/* ------------------------------------------------------------------------
 *	rawout.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_RAWOUT_H
#define _DOWNSCRIPT_RAWOUT_H

#include <stdio.h>


#define MAXIMUM_RAW_WORD  1024


typedef struct rawout_info
{
	/* public */

	FILE *fp;

	int x_pos;
	int chop_pos;

	int word_len;  /* zero means: no current word */

	char word_buf[MAXIMUM_RAW_WORD];

} rawout_info;


extern rawout_info *new_rawout(FILE *fp, int width);
extern void free_rawout(rawout_info *raw);

extern void raw_output(rawout_info *raw, char *str);
extern void raw_flush (rawout_info *raw);

extern void raw_add_to_word(rawout_info *raw, char *str);
extern void raw_flush_word (rawout_info *raw);
extern void raw_add_token  (rawout_info *raw, char *str);

extern char *lookup_escape_char(char **escapes, char c);


#endif  /* _DOWNSCRIPT_RAWOUT_H */
