/* ------------------------------------------------------------------------
 *	rawout.c  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (C) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "memory.h"
#include "rawout.h"


rawout_info *new_rawout(FILE *fp, int width)
{
	rawout_info *result;

	result = (rawout_info *) safe_malloc(sizeof(rawout_info));

	result->fp = fp;

	result->x_pos    = 0;
	result->chop_pos = width;
	result->word_len = 0;

	return result;
}

void free_rawout(rawout_info *raw)
{
	/* flush any remaining text and tidy up */

	raw_flush_word(raw);
		
	if (raw->x_pos > 0) {
		raw_output(raw, "\n");
	}

	safe_free(raw);
}

void raw_flush(rawout_info *raw)
{
	raw_flush_word(raw);

	fflush(raw->fp);
}

void raw_output(rawout_info *raw, char *str)
{
	for (; *str; str++) {

		if (*str == '\n') {
			raw->x_pos = 0;
			
		} else if ((*str == '\b') && (raw->x_pos > 0)) {
			raw->x_pos--;

		} else {
			raw->x_pos++;
		}

		fputc(*str, raw->fp);
	}
}

void raw_flush_word(rawout_info *raw)
{
	if (raw->x_pos + raw->word_len + 1 >= raw->chop_pos) {
		raw_output(raw, "\n");
	}
	
	if (raw->word_len > 0) {
		raw_output(raw, raw->word_buf);
	}

	raw->word_len = 0;
}

void raw_add_token(rawout_info *raw, char *str)
{
	int len = strlen(str);

	raw_flush_word(raw);

	if (raw->x_pos + len >= raw->chop_pos) {
		raw_output(raw, "\n");
	}
		
	raw_output(raw, str);
}

void raw_add_to_word(rawout_info *raw, char *str)
{
	int len = strlen(str);

	if (raw->word_len + len + 1 >= MAXIMUM_RAW_WORD) {
		fprintf(stderr, "WARNING: word buffer overflow !\n");
		return;
	}

	strncpy(raw->word_buf + raw->word_len, str, len+1);

	raw->word_len += len;
}

char *lookup_escape_char(char **escapes, char c)
{
	for (; *escapes; escapes++) {

		if (**escapes == c) {
			return (*escapes + 1);
		}
	}

	return NULL;
}
