/* ------------------------------------------------------------------------
 *	parse.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_PARSE_H
#define _DOWNSCRIPT_PARSE_H

#include <stdio.h>


extern int read_one_line(FILE *fp, char *buf, int max);

extern char *skip_spaces(char *s);
extern char *parse_word(char *dest, int max, char *src);
extern char *parse_number(int *value, char *src);
extern char *parse_string(char *dest, int max, char *src);

extern int match_string(char *big, char *small);
extern int match_extension(char *filename, char *ext);


#endif  /* _DOWNSCRIPT_PARSE_H */
