/* ------------------------------------------------------------------------
 *	parse.c  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (C) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "parse.h"


int read_one_line(FILE *fp, char *buf, int max)
{
	for (;;) {
		int c = fgetc(fp);

		if (c == EOF) {
			*buf = 0;
			return -1;
		}
		
		if (c == '\n') {
			break;
		}

		if (max > 1) {
			*buf++ = c; 
			max--;
		}
	}

	*buf = 0;

	return 0;
}

char *skip_spaces(char *s)
{
	for (; *s && isspace(*s); s++) {
	}

	return s;
}

char *parse_word(char *dest, int max, char *src)
{
	for (; *src && ! isspace(*src); src++) {

		if (max > 1) {
			*dest++ = *src; 
			max--;
		}
	}

	*dest = 0;

	return src;
}

char *parse_number(int *value, char *src)
{
	char numbuf[32];

	src = skip_spaces(src);
	src = parse_word(numbuf, 32, src);

	*value = atoi(numbuf);

	return src;
}

char *parse_string(char *dest, int max, char *src)
{
	src = skip_spaces(src);

	if (*src != '(') {
		fprintf(stderr, "Bad input: STRING EXPECTED.");
		exit(1);
	}

	src++;

	while (*src != ')') {
		
		if (*src == 0) {
			fprintf(stderr, "Bad input: UNEXPECTED EOLN.");
			exit(1);
		}

		if (max < 2) {
			src++;
			continue;
		}

		if (*src == '\\') {
			src++;

			if (! isdigit(*src)) {
				*dest++ = *src++;
				max--;
				continue;
			}

			*dest++ = (src[0] - '0') * 64 +
			          (src[1] - '0') * 8 +
			          (src[2] - '0');
			src += 3;
			max--;
			continue;
		}

		*dest++ = *src++;
		max--;
	}

	src++;

	*dest = 0;

	return src;
}

int match_string(char *big, char *small)
{
	/* NOTE: rather crap implementation */

	int len = strlen(small);

	for (; *big; big++) {

		if (strncasecmp(big, small, len) == 0)
			return 1;
	}

	return 0;
}

int match_extension(char *filename, char *ext)
{
	int len1 = strlen(filename);
	int len2 = strlen(ext);

	if (len2 >= len1) {
		return 0;
	}

	return (strncmp(filename + len1-len2, ext, len2) == 0);
}
