/* ------------------------------------------------------------------------
 *	parabox.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_PARABOX_H
#define _DOWNSCRIPT_PARABOX_H

#include "math.h"
#include "list.h"
#include "stringbox.h"


typedef struct para_box
{
	/* public */

	Node n;

	int x;
	int y;
	int x2;
	int y2;
	
	/* private */

	int join_x2;

} para_box;


extern para_box *new_para_box(int x, int y, int x2, int y2, int join_x2);
extern void free_para_box(para_box *para);

extern void add_stringbox_to_paralist(List *plist, string_box *sb,
					int xfudge, int yfudge);

extern int test_sbox_inside_parabox(para_box *para, string_box *sb);

extern void horizontal_aggregation(List *plist, int x_divide);


#endif  /* _DOWNSCRIPT_PARABOX_H */
