/* ------------------------------------------------------------------------
 *	page.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_PAGE_H
#define _DOWNSCRIPT_PAGE_H

#include "list.h"
#include "stringbox.h"
#include "parabox.h"
#include "graphics.h"
#include "output.h"


#define INCH_UNIT  720   /* 720 units per inch */


typedef struct page_info
{
	/* public */

	Node n;

	int page_num;

	int page_width;
	int page_height;

	/* private */

	List /* of string_box */ boxes;
	List /* of para_box */ paras;
	List /* of line_box */ lboxes;

	int x_divide;  /* separator between sides */
	int y_divide;  /* separator between chapters */

	int xfudge;
	int yfudge;

	int minimum_y;
	int maximum_y;

	int locked;
	int no_horiz_aggregation;

} page_info;


typedef struct view_info
{
	/* private */

	int xpos, ypos;   /* current top-left of screen */
	int scale;        /* units per pixel */
	
	gfx_info *gfx;

	int show_line_flags;

} view_info;


extern page_info *new_page(int width, int height, int no_HA);
extern void free_page(page_info *pg);

extern void add_string_box(page_info *pg, string_box *sb);

extern void change_fudging(page_info *pg, int xfudge, int yfudge);
extern void change_y_bounds(page_info *pg, int ymin, int ymax);

extern view_info *new_view(gfx_info *display, int normal_width, 
			   int normal_height);
extern void free_view(view_info *view);

extern int change_position(view_info *view, int xperc, int yperc);
extern int change_scale(view_info *view, int delta);

extern void draw_page(page_info *pg, view_info *view);

extern void set_pagelock(page_info *pg, int on_off);
extern int test_pagelock(page_info *pg);

extern void set_divider(page_info *pg, int on_off);
extern int test_divider(page_info *pg);

extern void set_chapter_break(page_info *pg, int on_off);
extern int test_chapter_break(page_info *pg);

extern void set_paralist(page_info *pg, int on_off);
extern int test_paralist(page_info *pg);

extern void set_showflags(view_info *view, int on_off);
extern int test_showflags(view_info *view);

extern page_info *split_page_into_two(page_info *pg);

extern void calc_relative_sizes(page_info *pg, int height_normal);
extern void calc_lineboxes(page_info *pg);

extern void output_page(page_info *pg, output_info *outp);


#endif  /* _DOWNSCRIPT_PAGE_H */
