/* ------------------------------------------------------------------------
 *	output.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_OUTPUT_H
#define _DOWNSCRIPT_OUTPUT_H

#include <stdio.h>

#include "fonts.h"
#include "rawout.h"


#define MAX_NR_MARKUP		16
#define MAX_NR_STYLE		24


#define MARKUP_DOCUMENT		0
#define MARKUP_CHAPTER		1
#define MARKUP_PAGE		2
#define MARKUP_PARAGRAPH	3
#define MARKUP_TITLE		4


typedef struct lowlevel_info
{
	/* private except to driver */
	
	rawout_info *raw;

	/* private to driver */
	
	void *priv;
	
} lowlevel_info;


typedef struct output_info
{
	/* private */

	int is_stdout;

	int cur_markup;
	int cur_style;
	
	char *buffered_word;
	int   buffered_style;
	int   buffered_break;

	/* low-level output driver */

	lowlevel_info *driver;

	void (* init_f) (lowlevel_info *lowlev);
	void (* exit_f) (lowlevel_info *lowlev);
	void (* flush_f)(lowlevel_info *lowlev);

	void (* begin_markup_f)(lowlevel_info *lowlev, int markup);
	void (* end_markup_f)  (lowlevel_info *lowlev, int markup);
	void (* change_style_f)(lowlevel_info *lowlev, 
				int style, int old_style);

	void (* output_word_f)(lowlevel_info *lowlev, char *word);
	void (* word_break_f) (lowlevel_info *lowlev, int size);
	void (* line_break_f) (lowlevel_info *lowlev);

} output_info;


extern char *autodetect_type(char *filename);

extern output_info *new_output(char *filename, char *type, int width);
extern void free_output(output_info *outp);

extern void begin_markup(output_info *outp, int markup);
extern void end_markup(output_info *outp, int markup);

extern void output_word(output_info *outp, char *word, int style);
extern void output_word_break(output_info *outp, int size);
extern void output_line_break(output_info *outp);

extern void flush_output(output_info *outp);


#endif  /* _DOWNSCRIPT_OUTPUT_H */
