/* ------------------------------------------------------------------------
 *	nroff.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_NROFF_H
#define _DOWNSCRIPT_NROFF_H

#include <stdio.h>

#include "output.h"


typedef struct nroff_priv
{
	int in_title;
	
} nroff_priv;

#define NROFF_PRIV(lowlev)  ((nroff_priv *) (lowlev)->priv)


extern void nroff_init (lowlevel_info *lowlev);
extern void nroff_exit (lowlevel_info *lowlev);
extern void nroff_flush(lowlevel_info *lowlev);

extern void nroff_begin_markup(lowlevel_info *lowlev, int markup);
extern void nroff_end_markup  (lowlevel_info *lowlev, int markup);
extern void nroff_change_style(lowlevel_info *lowlev, 
				int style, int old_style);

extern void nroff_output_word(lowlevel_info *lowlev, char *word);
extern void nroff_word_break (lowlevel_info *lowlev, int size);
extern void nroff_line_break (lowlevel_info *lowlev);


#endif  /* _DOWNSCRIPT_NROFF_H */
