/* ------------------------------------------------------------------------
 *	memory.c  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (C) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "memory.h"


#define TEST_MEMORY  1	 /* make `0' to turn off memory testing */


#if TEST_MEMORY

static size_t total;

void init_memory(void)
{
	total = 0;
}

void exit_memory(void)
{
	if (total != 0) {
		fprintf(stderr, "\nMEMORY LEAK DETECTED: %d bytes\n\n",
			total);
	}
}

void *safe_malloc(size_t size)
{
	size_t *result;

	result = (size_t *) malloc(size + sizeof(size_t));

	if (! result) {
		fprintf(stderr, "Out of memory !\n");
		exit(5);
	}
	
	total += size;

	*result++ = size;
	
	return (void *) result;
}

void safe_free(void *ptr)
{
	size_t *real_ptr;

	if (! ptr) {
		fprintf(stderr, "\nFREEING VOID POINTER !\n\n");
		exit(5);
	}

	real_ptr = (size_t *) ptr;
	real_ptr--;

	total -= *real_ptr;
	
	free(real_ptr);
}

#else /* TEST_MEMORY */

void init_memory(void)
{
}

void exit_memory(void)
{
}

void *safe_malloc(size_t size)
{
	return malloc(size);
}

void safe_free(void *ptr)
{
	free(ptr);
}

#endif /* TEST_MEMORY */


char *safe_strdup(char *str)
{
	int len = 1 + strlen(str);

	char *result = safe_malloc(len);

	memcpy(result, str, len);

	return result;
}

char *safe_strconcat(char *s1, char *s2)
{
	int len1 = strlen(s1);
	int len2 = strlen(s2);

	char *result = safe_malloc(len1 + len2 + 1);

	memcpy(result,      s1, len1);
	memcpy(result+len1, s2, len2 + 1);

	return result;
}
