/* ------------------------------------------------------------------------
 *	list.h  -  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_LIST_H
#define _DOWNSCRIPT_LIST_H


typedef struct generic_node
{
	struct generic_node *succ;
	struct generic_node *pred;
} Node;


typedef struct generic_list
{
	Node *head;
	Node *tail;
} List;


typedef void (* free_node_t)(Node *N);

#define FREE_NODE  (free_node_t)


extern void init_list(List *L);
extern void free_list(List *L, void (* freefunc)(Node *N));

extern Node *new_node(int size);
extern void free_node(Node *N);

extern void add_to_head(List *L, Node *N);
extern void add_to_tail(List *L, Node *N);
extern Node *remove_node(List *L, Node *N);

extern void insert_node_before(List *L, Node *N, Node *next);
extern void insert_node_after (List *L, Node *N, Node *previous);
extern void concat_list_after(List *L, List *old);
extern void concat_list_before(List *L, List *old);

extern Node *find_nth_node(List *L, int n);
extern Node *find_node(List *L, void *data,
		      int (* searchfunc)(Node *N, void *data));

extern int list_empty(List *L);
extern int count_nodes(List *L);
extern void update_list(List *L, void *data,
			void (* updatefunc)(Node *N, void *data));


#endif  /* _DOWNSCRIPT_LIST_H */
