/* ------------------------------------------------------------------------
 *	linebox.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_LINEBOX_H
#define _DOWNSCRIPT_LINEBOX_H

#include "list.h"
#include "stringbox.h"
#include "parabox.h"


typedef struct line_string
{
	/* private except to page */

	Node n;

	List /* of (ordered) string_box */ words;
	
	int flags;
	int base_line;

} line_string;

#define LINEFLAG_INDENTED	0x01
#define LINEFLAG_GAP_AT_END	0x02
#define LINEFLAG_DOTTY		0x04


typedef struct line_box
{
	/* private except to page */

	Node n;

	para_box *outline;

	List /* of (ordered) line_string */ lines;

	int paragraph_type;

} line_box;

#define PARAGRAPH_SHORT		0x01
#define PARAGRAPH_NORMAL	0x02
#define PARAGRAPH_ABNORMAL	0x03
#define PARAGRAPH_UNEVEN_ENDED	0x04


extern line_box *new_line_box(para_box *para);
extern void free_line_box(line_box *lbox);

extern void create_and_add_lboxes(List /* of line_box */ *lboxes, 
			  para_box *para, List /* of string_box */ *sboxes);

extern void output_paragraph(line_box *lbox, output_info *outp, int xfudge);


#endif  /* _DOWNSCRIPT_LINEBOX_H */
