/* ------------------------------------------------------------------------
 *	html.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_HTML_H
#define _DOWNSCRIPT_HTML_H

#include <stdio.h>

#include "output.h"


extern void html_init(lowlevel_info *lowlev);
extern void html_exit(lowlevel_info *lowlev);
extern void html_flush(lowlevel_info *lowlev);

extern void html_begin_markup(lowlevel_info *lowlev, int markup);
extern void html_end_markup(lowlevel_info *lowlev, int markup);
extern void html_change_style(lowlevel_info *lowlev, 
				int style, int old_style);

extern void html_output_word(lowlevel_info *lowlev, char *word);
extern void html_word_break(lowlevel_info *lowlev, int size);
extern void html_line_break(lowlevel_info *lowlev);


#endif  /* _DOWNSCRIPT_HTML_H */
