/* ------------------------------------------------------------------------
 *	graphics.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_GRAPHICS_H
#define _DOWNSCRIPT_GRAPHICS_H

#include <ggi/ggi.h>

#include "list.h"
#include "stringbox.h"


#define COLOR_BLACK	0
#define COLOR_WHITE	1
#define COLOR_BLUE	2
#define COLOR_RED	3
#define COLOR_YELLOW	4
#define COLOR_GREEN	5
#define COLOR_CYAN	6
#define COLOR_ORANGE	7


typedef struct gfx_info
{
	/* public */

	int width;
	int height;

	int ch_width;
	int ch_height;

	/* private */
	
	ggi_visual_t vis;

	ggi_mode mode;

	ggi_pixel colors[8];

} gfx_info;


extern gfx_info *init_graphics(char *targetstr, char *modestr);
extern void exit_graphics(gfx_info *gfx);

extern void draw_box(gfx_info *gfx,  int x, int y, int x2, int y2, int col);
extern void draw_line(gfx_info *gfx, int x, int y, int x2, int y2, int col);

extern void draw_string(gfx_info *gfx, int x, int y, int fg, int bg, 
			char *str);
extern void draw_n_string(gfx_info *gfx, int x, int y, int fg, int bg, 
			  char *str, int max);

extern void frame_hide(gfx_info *gfx);
extern void frame_show(gfx_info *gfx);

extern unsigned int get_keypress(gfx_info *gfx);


#endif  /* _DOWNSCRIPT_GRAPHICS_H */
