/* ------------------------------------------------------------------------
 *	fonts.h  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (c) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#ifndef _DOWNSCRIPT_FONTS_H
#define _DOWNSCRIPT_FONTS_H


#define STYLE_N_BOLD		0
#define STYLE_N_ITALIC		1
#define STYLE_N_UNDERLINE	2
#define STYLE_N_COMPRESSED	3
#define STYLE_N_EXPANDED	4
#define STYLE_N_TINY		5
#define STYLE_N_SMALL		6
#define STYLE_N_LARGE		7
#define STYLE_N_HUGE		8	
#define STYLE_N_SUPERSCRIPT	9
#define STYLE_N_SUBSCRIPT	10
#define STYLE_N_TIMES		11
#define STYLE_N_COURIER		12
#define STYLE_N_HELVETICA	13
#define STYLE_N_SYMBOL		14

#define STYLE_BOLD		(1 << STYLE_N_BOLD)
#define STYLE_ITALIC		(1 << STYLE_N_ITALIC)
#define STYLE_UNDERLINE		(1 << STYLE_N_UNDERLINE)
#define STYLE_SUPERSCRIPT	(1 << STYLE_N_SUPERSCRIPT)
#define STYLE_SUBSCRIPT		(1 << STYLE_N_SUBSCRIPT)
#define STYLE_COMPRESSED	(1 << STYLE_N_COMPRESSED)
#define STYLE_EXPANDED		(1 << STYLE_N_EXPANDED)
#define STYLE_TINY		(1 << STYLE_N_TINY)
#define STYLE_SMALL		(1 << STYLE_N_SMALL)
#define STYLE_LARGE		(1 << STYLE_N_LARGE)
#define STYLE_HUGE		(1 << STYLE_N_HUGE)
#define STYLE_TIMES		(1 << STYLE_N_TIMES)
#define STYLE_COURIER		(1 << STYLE_N_COURIER)
#define STYLE_HELVETICA		(1 << STYLE_N_HELVETICA)
#define STYLE_SYMBOL		(1 << STYLE_N_SYMBOL)


#define DEFAULT_FONT_HEIGHT	100
#define DEFAULT_FONT_WIDTH	100
#define DEFAULT_FONT_STYLE	0


extern int font_name_to_style(char *name, int width, int height);


#endif  /* _DOWNSCRIPT_FONTS_H */
