/* ------------------------------------------------------------------------
 *	fonts.c  --  part of DownScript
 * ------------------------------------------------------------------------
 *
 *	Copyright (C) 1998-1999  Andrew Apted  <ajapted@netspace.net.au>
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation; either version 2, or
 *	(at your option) any later version.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; see the file COPYING.  If
 *	not, write to the Free Software Foundation, Inc., 59 Temple
 *	Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * ------------------------------------------------------------------------
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "parse.h"
#include "fonts.h"


#define MATCH_FONT(string, result)  \
	(match_string(name, (string)) ? (result) : 0)

int font_name_to_style(char *name, int width, int height)
{
	int style = 0;

	style |= MATCH_FONT("bold",     STYLE_BOLD)    |
		 MATCH_FONT("heavy",    STYLE_BOLD)    |
		 MATCH_FONT("italic",   STYLE_ITALIC)  |
		 MATCH_FONT("oblique",  STYLE_ITALIC);

	if (width < (height*4/5)) {
		style |= STYLE_COMPRESSED;
	}

	if (width > (height*5/4)) {
		style |= STYLE_EXPANDED;
	}

	style |= MATCH_FONT("cour",     STYLE_COURIER)    |
		 MATCH_FONT("monosp",   STYLE_COURIER)    |
		 MATCH_FONT("typewr",   STYLE_COURIER)    |
		 MATCH_FONT("arial",    STYLE_HELVETICA)  |
		 MATCH_FONT("geneva",   STYLE_HELVETICA)  |
		 MATCH_FONT("helv",     STYLE_HELVETICA)  |
		 MATCH_FONT("minion",   STYLE_HELVETICA)  |
		 MATCH_FONT("sans",     STYLE_HELVETICA)  |
		 MATCH_FONT("swiss",    STYLE_HELVETICA)  |
		 MATCH_FONT("roman",    STYLE_TIMES)      |
		 MATCH_FONT("newyork",  STYLE_TIMES)      |
		 MATCH_FONT("times",    STYLE_TIMES)      |
		 MATCH_FONT("symbol",   STYLE_SYMBOL);

	return style;
}
